/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.defense;

import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.util.Time;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.ui.Bar;
import mindustry.world.blocks.defense.Wall;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;
import mindustryX.features.StatExt;
import mindustryX.features.ui.FormatDefault;

public class ShieldWall
extends Wall {
    public float shieldHealth = 900.0f;
    public float breakCooldown = 600.0f;
    public float regenSpeed = 2.0f;
    public Color glowColor = Color.valueOf((String)"ff7531").a(0.5f);
    public float glowMag = 0.6f;
    public float glowScl = 8.0f;
    public TextureRegion glowRegion;

    public ShieldWall(String name) {
        super(name);
        this.update = true;
    }

    public void setStats() {
        super.setStats();
        this.stats.add(Stat.shieldHealth, this.shieldHealth);
        this.stats.add(Stat.cooldownTime, this.breakCooldown / 60.0f, StatUnit.seconds);
        this.stats.add(StatExt.regenSpeed, this.regenSpeed * 60.0f, StatUnit.perSecond);
    }

    public void setBars() {
        super.setBars();
        this.addBar("charge", entity -> new Bar(() -> "\ue84d " + FormatDefault.percent(entity.shield, this.shieldHealth), () -> Pal.shield, () -> entity.shield / this.shieldHealth));
    }

    public class ShieldWallBuild
    extends Wall.WallBuild {
        public float shield;
        public float shieldRadius;
        public float breakTimer;

        public ShieldWallBuild() {
            super((Wall)ShieldWall.this);
            this.shield = ShieldWall.this.shieldHealth;
            this.shieldRadius = 0.0f;
        }

        public void draw() {
            Draw.rect((TextureRegion)this.block.region, (float)this.x, (float)this.y);
            if (this.shieldRadius > 0.0f) {
                float radius = this.shieldRadius * 8.0f * (float)ShieldWall.this.size / 2.0f;
                Draw.z((float)125.0f);
                Draw.color((Color)this.team.color, (Color)Color.white, (float)Mathf.clamp((float)this.hit));
                if (Vars.renderer.animateShields) {
                    Fill.square((float)this.x, (float)this.y, (float)radius);
                } else {
                    Lines.stroke(1.5f);
                    Draw.alpha((float)(0.09f + Mathf.clamp((float)(0.08f * this.hit))));
                    Fill.square((float)this.x, (float)this.y, (float)radius);
                    Draw.alpha((float)1.0f);
                    Lines.poly(this.x, this.y, 4, radius, 45.0f);
                    Draw.reset();
                }
                Draw.reset();
                Drawf.additive((TextureRegion)ShieldWall.this.glowRegion, (Color)ShieldWall.this.glowColor, (float)((1.0f - ShieldWall.this.glowMag + Mathf.absin((float)ShieldWall.this.glowScl, (float)ShieldWall.this.glowMag)) * this.shieldRadius), (float)this.x, (float)this.y, (float)0.0f, (float)31.0f);
            }
        }

        public void updateTile() {
            if (this.breakTimer > 0.0f) {
                this.breakTimer -= Time.delta;
            } else {
                this.shield = Mathf.clamp((float)(this.shield + ShieldWall.this.regenSpeed * this.edelta()), (float)0.0f, (float)ShieldWall.this.shieldHealth);
            }
            if (this.hit > 0.0f) {
                this.hit -= Time.delta / 10.0f;
                this.hit = Math.max(this.hit, 0.0f);
            }
            this.shieldRadius = Mathf.lerpDelta((float)this.shieldRadius, (float)(this.broken() ? 0.0f : 1.0f), (float)0.12f);
        }

        public boolean broken() {
            return this.breakTimer > 0.0f || !this.canConsume();
        }

        public void pickedUp() {
            this.shieldRadius = 0.0f;
        }

        public void damage(float damage) {
            float shieldTaken = this.broken() ? 0.0f : Math.min(this.shield, damage);
            this.shield -= shieldTaken;
            if (shieldTaken > 0.0f) {
                this.hit = 1.0f;
            }
            if (this.shield <= 1.0E-5f && shieldTaken > 0.0f) {
                this.breakTimer = ShieldWall.this.breakCooldown;
            }
            if (damage - shieldTaken > 0.0f) {
                super.damage(damage - shieldTaken);
            }
        }

        public void write(Writes write) {
            super.write(write);
            write.f(this.shield);
        }

        public void read(Reads read, byte revision) {
            super.read(read, revision);
            this.shield = read.f();
            if (this.shield > 0.0f) {
                this.shieldRadius = 1.0f;
            }
        }
    }
}

