/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.defense.turrets;

import arc.audio.Sound;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Angles;
import arc.math.Mathf;
import arc.math.geom.Position;
import arc.math.geom.Vec2;
import arc.util.Nullable;
import arc.util.Tmp;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.entities.Effect;
import mindustry.gen.Bullet;
import mindustry.gen.Sounds;
import mindustry.graphics.Drawf;
import mindustry.type.weapons.PointDefenseWeapon;
import mindustry.world.blocks.defense.turrets.ReloadTurret;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;

public class PointDefenseTurret
extends ReloadTurret {
    public final int timerTarget;
    public float retargetTime;
    public TextureRegion baseRegion;
    public Color color;
    public Effect beamEffect;
    public Effect hitEffect;
    public Effect shootEffect;
    public Sound shootSound;
    public float shootCone;
    public float bulletDamage;
    public float shootLength;

    public PointDefenseTurret(String name) {
        super(name);
        this.timerTarget = this.timers++;
        this.retargetTime = 5.0f;
        this.color = Color.white;
        this.beamEffect = Fx.pointBeam;
        this.hitEffect = Fx.pointHit;
        this.shootEffect = Fx.sparkShoot;
        this.shootSound = Sounds.shootSegment;
        this.shootCone = 5.0f;
        this.bulletDamage = 10.0f;
        this.shootLength = 3.0f;
        this.rotateSpeed = 20.0f;
        this.reload = 30.0f;
        this.coolantMultiplier = 2.0f;
    }

    public TextureRegion[] icons() {
        return new TextureRegion[]{this.baseRegion, this.region};
    }

    @Override
    public void setStats() {
        super.setStats();
        this.stats.add(Stat.reload, 60.0f / this.reload, StatUnit.perSecond);
        this.stats.add(Stat.damage, this.bulletDamage);
    }

    public class PointDefenseBuild
    extends ReloadTurret.ReloadTurretBuild {
        @Nullable
        public Bullet target;

        public PointDefenseBuild() {
            super(PointDefenseTurret.this);
        }

        public void updateTile() {
            if (this.timer(PointDefenseTurret.this.timerTarget, PointDefenseTurret.this.retargetTime)) {
                this.target = PointDefenseWeapon.findEnemyBullet(this.team, this.x, this.y, PointDefenseTurret.this.range);
            }
            if (this.target != null && !this.target.isAdded()) {
                this.target = null;
            }
            if (PointDefenseTurret.this.coolant != null) {
                this.updateCooling();
            }
            if (this.target != null && this.target.within((Position)this, PointDefenseTurret.this.range) && this.target.team != this.team && this.target.type() != null && this.target.type().hittable) {
                float dest = this.angleTo((Position)this.target);
                this.rotation = Angles.moveToward((float)this.rotation, (float)dest, (float)(PointDefenseTurret.this.rotateSpeed * this.edelta()));
                this.reloadCounter += this.edelta();
                if (Angles.within((float)this.rotation, (float)dest, (float)PointDefenseTurret.this.shootCone) && this.reloadCounter >= PointDefenseTurret.this.reload) {
                    float realDamage = PointDefenseTurret.this.bulletDamage * Vars.state.rules.blockDamage(this.team);
                    if (this.target.damage() > realDamage) {
                        this.target.damage(this.target.damage() - realDamage);
                    } else {
                        this.target.remove();
                    }
                    Tmp.v1.trns(this.rotation, PointDefenseTurret.this.shootLength);
                    PointDefenseTurret.this.beamEffect.at(this.x + Tmp.v1.x, this.y + Tmp.v1.y, this.rotation, PointDefenseTurret.this.color, (Object)new Vec2().set((Position)this.target));
                    PointDefenseTurret.this.shootEffect.at(this.x + Tmp.v1.x, this.y + Tmp.v1.y, this.rotation, PointDefenseTurret.this.color);
                    PointDefenseTurret.this.hitEffect.at(this.target.x, this.target.y, PointDefenseTurret.this.color);
                    PointDefenseTurret.this.shootSound.at(this.x + Tmp.v1.x, this.y + Tmp.v1.y, Mathf.random((float)0.9f, (float)1.1f));
                    this.reloadCounter = 0.0f;
                }
            }
        }

        public boolean shouldConsume() {
            return super.shouldConsume() && this.target != null;
        }

        public void draw() {
            Draw.rect((TextureRegion)PointDefenseTurret.this.baseRegion, (float)this.x, (float)this.y);
            Drawf.shadow((TextureRegion)PointDefenseTurret.this.region, (float)(this.x - (float)PointDefenseTurret.this.size / 2.0f), (float)(this.y - (float)PointDefenseTurret.this.size / 2.0f), (float)(this.rotation - 90.0f));
            Draw.rect((TextureRegion)PointDefenseTurret.this.region, (float)this.x, (float)this.y, (float)(this.rotation - 90.0f));
        }

        public void write(Writes write) {
            super.write(write);
            write.f(this.rotation);
        }

        public void read(Reads read, byte revision) {
            super.read(read, revision);
            this.rotation = read.f();
        }
    }
}

