/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.defense.turrets;

import arc.Core;
import arc.func.Boolf;
import arc.math.Mathf;
import arc.scene.Element;
import arc.scene.ui.layout.Table;
import mindustry.gen.Building;
import mindustry.graphics.Pal;
import mindustry.type.Liquid;
import mindustry.ui.Bar;
import mindustry.world.blocks.defense.turrets.BaseTurret;
import mindustry.world.consumers.ConsumeLiquidBase;
import mindustry.world.consumers.ConsumeLiquidFilter;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatValues;

public class ReloadTurret
extends BaseTurret {
    public float reload = 10.0f;

    public ReloadTurret(String name) {
        super(name);
    }

    public void setStats() {
        super.setStats();
        if (this.coolant != null) {
            this.stats.replace(Stat.booster, StatValues.boosters(this.reload, this.coolant.amount, this.coolantMultiplier, true, (Boolf<Liquid>)((Boolf)arg_0 -> ((ConsumeLiquidBase)this.coolant).consumes(arg_0))));
        }
    }

    public class ReloadTurretBuild
    extends BaseTurret.BaseTurretBuild {
        public float reloadCounter;

        public ReloadTurretBuild() {
            super((BaseTurret)ReloadTurret.this);
        }

        protected void updateCooling() {
            if (this.reloadCounter < ReloadTurret.this.reload && ReloadTurret.this.coolant != null && ReloadTurret.this.coolant.efficiency((Building)((Object)this)) > 0.0f && this.efficiency > 0.0f) {
                float f;
                ConsumeLiquidBase consumeLiquidBase = ReloadTurret.this.coolant;
                if (consumeLiquidBase instanceof ConsumeLiquidFilter) {
                    ConsumeLiquidFilter filter = (ConsumeLiquidFilter)consumeLiquidBase;
                    f = filter.getConsumed((Building)((Object)this)).heatCapacity;
                } else {
                    f = ReloadTurret.this.coolant.consumes(this.liquids.current()) ? this.liquids.current().heatCapacity : 0.4f;
                }
                float capacity = f;
                float amount = ReloadTurret.this.coolant.amount * ReloadTurret.this.coolant.efficiency((Building)((Object)this));
                ReloadTurret.this.coolant.update((Building)((Object)this));
                this.reloadCounter += amount * this.edelta() * capacity * ReloadTurret.this.coolantMultiplier * this.ammoReloadMultiplier();
                if (Mathf.chance((double)(0.06 * (double)amount))) {
                    ReloadTurret.this.coolEffect.at(this.x + Mathf.range((float)((float)(ReloadTurret.this.size * 8) / 2.0f)), this.y + Mathf.range((float)((float)(ReloadTurret.this.size * 8) / 2.0f)));
                }
            }
        }

        protected float ammoReloadMultiplier() {
            return 1.0f;
        }

        protected float baseReloadSpeed() {
            return this.efficiency;
        }

        public void displayBars(Table bars) {
            super.displayBars(bars);
            bars.add((Element)new Bar(() -> Core.bundle.format("bar.reloadDetail", new Object[]{(int)(this.reloadCounter * 100.0f / ReloadTurret.this.reload)}), () -> Pal.ammo, () -> this.reloadCounter / ReloadTurret.this.reload));
            bars.row();
        }
    }
}

