/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.defense.turrets;

import arc.Core;
import arc.Events;
import arc.audio.Sound;
import arc.func.Boolf;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.math.Angles;
import arc.math.Mathf;
import arc.math.geom.Position;
import arc.math.geom.Vec2;
import arc.scene.Element;
import arc.scene.ui.layout.Table;
import arc.struct.Seq;
import arc.util.Eachable;
import arc.util.Nullable;
import arc.util.Time;
import arc.util.Tmp;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.audio.SoundLoop;
import mindustry.content.Fx;
import mindustry.content.UnitTypes;
import mindustry.core.World;
import mindustry.entities.Effect;
import mindustry.entities.Mover;
import mindustry.entities.Predict;
import mindustry.entities.Sized;
import mindustry.entities.UnitSorts;
import mindustry.entities.Units;
import mindustry.entities.bullet.BulletType;
import mindustry.entities.pattern.ShootPattern;
import mindustry.entities.units.BuildPlan;
import mindustry.game.EventType;
import mindustry.game.Team;
import mindustry.gen.BlockUnitc;
import mindustry.gen.Building;
import mindustry.gen.Bullet;
import mindustry.gen.Entityc;
import mindustry.gen.Hitboxc;
import mindustry.gen.Posc;
import mindustry.gen.Sounds;
import mindustry.gen.TimedKillc;
import mindustry.gen.Unit;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.logic.LAccess;
import mindustry.type.Liquid;
import mindustry.ui.Bar;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.blocks.ControlBlock;
import mindustry.world.blocks.defense.turrets.ReloadTurret;
import mindustry.world.draw.DrawBlock;
import mindustry.world.draw.DrawTurret;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;
import mindustryX.VarsX;
import mindustryX.features.ArcBuilds;

public class Turret
extends ReloadTurret {
    public static final float logicControlCooldown = 120.0f;
    public final int timerTarget;
    public float targetInterval;
    public float newTargetInterval;
    public int maxAmmo;
    public int ammoPerShot;
    public boolean consumeAmmoOnce;
    public float heatRequirement;
    public float maxHeatEfficiency;
    public float inaccuracy;
    public float velocityRnd;
    public float scaleLifetimeOffset;
    public float shootCone;
    public float shootX;
    public float shootY;
    public float xRand;
    public boolean drawMinRange;
    public float trackingRange;
    public float minRange;
    public float minWarmup;
    public boolean accurateDelay;
    public boolean moveWhileCharging;
    public boolean reloadWhileCharging;
    public float warmupMaintainTime;
    public ShootPattern shoot;
    public boolean targetAir;
    public boolean targetGround;
    public boolean targetBlocks;
    public boolean targetHealing;
    public boolean playerControllable;
    public boolean displayAmmoMultiplier;
    public boolean targetUnderBlocks;
    public boolean alwaysShooting;
    public boolean predictTarget;
    public Units.Sortf unitSort;
    public Boolf<Unit> unitFilter;
    public Boolf<Building> buildingFilter;
    public Color heatColor;
    @Nullable
    public Effect shootEffect;
    @Nullable
    public Effect smokeEffect;
    public Effect ammoUseEffect;
    public Sound shootSound;
    public float shootSoundVolume;
    public Sound chargeSound;
    public Sound loopSound;
    public float loopSoundVolume;
    public float soundPitchMin;
    public float soundPitchMax;
    public float ammoEjectBack;
    public float shootWarmupSpeed;
    public boolean linearWarmup;
    public float recoil;
    public int recoils;
    public float recoilTime;
    public float recoilPow;
    public float cooldownTime;
    public float elevation;
    public float shake;
    public DrawBlock drawer;

    public Turret(String name) {
        super(name);
        this.timerTarget = this.timers++;
        this.targetInterval = 20.0f;
        this.newTargetInterval = -1.0f;
        this.maxAmmo = 30;
        this.ammoPerShot = 1;
        this.consumeAmmoOnce = true;
        this.heatRequirement = -1.0f;
        this.maxHeatEfficiency = 3.0f;
        this.inaccuracy = 0.0f;
        this.velocityRnd = 0.0f;
        this.scaleLifetimeOffset = 0.0f;
        this.shootCone = 8.0f;
        this.shootX = 0.0f;
        this.shootY = Float.NEGATIVE_INFINITY;
        this.xRand = 0.0f;
        this.trackingRange = 0.0f;
        this.minRange = 0.0f;
        this.minWarmup = 0.0f;
        this.accurateDelay = true;
        this.moveWhileCharging = true;
        this.reloadWhileCharging = true;
        this.warmupMaintainTime = 0.0f;
        this.shoot = new ShootPattern();
        this.targetAir = true;
        this.targetGround = true;
        this.targetBlocks = true;
        this.targetHealing = false;
        this.playerControllable = true;
        this.displayAmmoMultiplier = true;
        this.targetUnderBlocks = true;
        this.alwaysShooting = false;
        this.predictTarget = true;
        this.unitSort = UnitSorts.closest;
        this.unitFilter = u -> true;
        this.buildingFilter = b -> this.targetUnderBlocks || !b.block.underBullets;
        this.heatColor = Pal.turretHeat;
        this.ammoUseEffect = Fx.none;
        this.shootSound = Sounds.shootDuo;
        this.shootSoundVolume = 1.0f;
        this.chargeSound = Sounds.none;
        this.loopSound = Sounds.none;
        this.loopSoundVolume = 0.5f;
        this.soundPitchMin = 0.9f;
        this.soundPitchMax = 1.1f;
        this.ammoEjectBack = 1.0f;
        this.shootWarmupSpeed = 0.1f;
        this.linearWarmup = false;
        this.recoil = 1.0f;
        this.recoils = -1;
        this.recoilTime = -1.0f;
        this.recoilPow = 1.8f;
        this.cooldownTime = 20.0f;
        this.elevation = -1.0f;
        this.shake = 0.0f;
        this.drawer = new DrawTurret();
        this.outlinedIcon = 1;
        this.drawLiquidLight = false;
        this.sync = true;
        this.rotate = true;
        this.quickRotate = false;
        this.drawArrow = false;
        this.ignoreLineRotation = true;
        this.rotateDrawEditor = false;
        this.visualRotationOffset = -90.0f;
        this.regionRotated1 = 1;
        this.regionRotated2 = 2;
    }

    public boolean outputsItems() {
        return false;
    }

    @Override
    public void setStats() {
        super.setStats();
        this.stats.add(Stat.inaccuracy, (float)((int)this.inaccuracy), StatUnit.degrees);
        this.stats.add(Stat.reload, 60.0f / (this.reload + (!this.reloadWhileCharging ? this.shoot.firstShotDelay : 0.0f)) * (float)this.shoot.shots, StatUnit.perSecond);
        this.stats.add(Stat.targetsAir, this.targetAir);
        this.stats.add(Stat.targetsGround, this.targetGround);
        if (this.ammoPerShot != 1) {
            this.stats.add(Stat.ammoUse, (float)this.ammoPerShot, StatUnit.perShot);
        }
        if (this.heatRequirement > 0.0f) {
            this.stats.add(Stat.input, this.heatRequirement, StatUnit.heatUnits);
        }
    }

    public void setBars() {
        super.setBars();
        if (this.heatRequirement > 0.0f) {
            this.addBar("heat", entity -> new Bar(() -> Core.bundle.format("bar.heatpercent", new Object[]{(int)entity.heatReq, (int)(Math.min(entity.heatReq / this.heatRequirement, this.maxHeatEfficiency) * 100.0f)}), () -> Pal.lightOrange, () -> entity.heatReq / this.heatRequirement));
        }
    }

    public void init() {
        if (this.shootY == Float.NEGATIVE_INFINITY) {
            this.shootY = (float)(this.size * 8) / 2.0f;
        }
        if (this.elevation < 0.0f) {
            this.elevation = (float)this.size / 2.0f;
        }
        if (this.recoilTime < 0.0f) {
            this.recoilTime = this.reload;
        }
        if (this.cooldownTime < 0.0f) {
            this.cooldownTime = this.reload;
        }
        if (this.newTargetInterval <= 0.0f) {
            this.newTargetInterval = this.targetInterval;
        }
        if (!this.targetGround) {
            this.disableOverlapCheck = true;
        }
        super.init();
        this.trackingRange = Math.max(this.range, this.trackingRange);
    }

    public void load() {
        super.load();
        this.drawer.load((Block)((Object)this));
    }

    public void drawPlanRegion(BuildPlan plan, Eachable<BuildPlan> list) {
        this.drawer.drawPlan((Block)((Object)this), plan, list);
    }

    public TextureRegion[] icons() {
        return this.drawer.finalIcons((Block)((Object)this));
    }

    public void getRegionsToOutline(Seq<TextureRegion> out) {
        this.drawer.getRegionsToOutline((Block)((Object)this), out);
    }

    public void limitRange(BulletType bullet, float margin) {
        float realRange = bullet.rangeChange + this.range;
        bullet.lifetime = (realRange + margin + bullet.extraRangeMargin + 10.0f) / bullet.speed;
    }

    public void drawPlace(int x, int y, int rotation, boolean valid) {
        super.drawPlace(x, y, rotation, valid);
        if (this.drawMinRange) {
            Drawf.dashCircle((float)((float)(x * 8) + this.offset), (float)((float)(y * 8) + this.offset), (float)this.minRange, (Color)Pal.placing);
        }
        if (Vars.state.rules.placeRangeCheck && ((Boolean)VarsX.arcTurretShowPlaceRange.get()).booleanValue()) {
            Draw.alpha((float)0.5f);
            Drawf.dashCircle((float)((float)(x * 8) + this.offset), (float)((float)(y * 8) + this.offset), (float)this.placeOverlapRange, (Color)Pal.remove);
        }
        if (((Boolean)VarsX.arcTurretShowAmmoRange.get()).booleanValue()) {
            ArcBuilds.turretPlaceDraw((float)(x * 8) + this.offset, (float)(y * 8) + this.offset, this);
        }
    }

    public void placeEnded(Tile tile, @Nullable Unit builder, int rotation, @Nullable Object config) {
        Building building;
        super.placeEnded(tile, builder, rotation, config);
        if (this.rotate && (building = tile.build) instanceof TurretBuild) {
            TurretBuild turret = (TurretBuild)((Object)building);
            turret.rotation = tile.build.rotdeg();
        }
    }

    public class TurretBuild
    extends ReloadTurret.ReloadTurretBuild
    implements ControlBlock {
        public Vec2 recoilOffset = new Vec2();
        public Seq<AmmoEntry> ammo = new Seq();
        public int totalAmmo;
        public float curRecoil;
        public float heat;
        public float logicControlTime = -1.0f;
        @Nullable
        public float[] curRecoils;
        public float shootWarmup;
        public float charge;
        public float warmupHold = 0.0f;
        public int totalShots;
        public int barrelCounter;
        public boolean logicShooting = false;
        @Nullable
        public Posc target;
        public Vec2 targetPos = new Vec2();
        public BlockUnitc unit = (BlockUnitc)UnitTypes.block.create(this.team);
        public boolean wasShooting;
        public int queuedBullets = 0;
        public float heatReq;
        public float[] sideHeat = new float[4];
        @Nullable
        public SoundLoop soundLoop;
        float lastRangeChange;

        public TurretBuild() {
            this.soundLoop = Turret.this.loopSound == Sounds.none ? null : new SoundLoop(Turret.this.loopSound, Turret.this.loopSoundVolume);
        }

        public void remove() {
            super.remove();
            if (this.soundLoop != null) {
                this.soundLoop.stop();
            }
        }

        public void onDestroyed() {
            super.onDestroyed();
            if (this.soundLoop != null) {
                this.soundLoop.stop();
            }
        }

        public float estimateDps() {
            if (!this.hasAmmo()) {
                return 0.0f;
            }
            return (float)Turret.this.shoot.shots / Turret.this.reload * 60.0f * (this.peekAmmo() == null ? 0.0f : this.peekAmmo().estimateDPS()) * this.potentialEfficiency * this.timeScale;
        }

        public float minRange() {
            if (this.peekAmmo() != null) {
                return Turret.this.minRange + this.peekAmmo().minRangeChange;
            }
            return Turret.this.minRange;
        }

        public float range() {
            if (this.peekAmmo() != null) {
                return Turret.this.range + this.peekAmmo().rangeChange;
            }
            return Turret.this.range;
        }

        public float trackingRange() {
            return this.range() + Turret.this.trackingRange - Turret.this.range;
        }

        public float warmup() {
            return this.shootWarmup;
        }

        public float drawrot() {
            return this.rotation - 90.0f;
        }

        public boolean shouldConsume() {
            return this.isShooting() || this.reloadCounter < Turret.this.reload;
        }

        public boolean canControl() {
            return Turret.this.playerControllable;
        }

        public void control(LAccess type, double p1, double p2, double p3, double p4) {
            if (type == LAccess.shoot && !this.unit.isPlayer()) {
                this.targetPos.set(World.unconv((float)p1), World.unconv((float)p2));
                this.logicControlTime = 120.0f;
                this.logicShooting = !Mathf.zero((double)p3);
            }
            super.control(type, p1, p2, p3, p4);
        }

        public void control(LAccess type, Object p1, double p2, double p3, double p4) {
            if (!(type != LAccess.shootp || this.unit != null && this.unit.isPlayer())) {
                this.logicControlTime = 120.0f;
                boolean bl = this.logicShooting = !Mathf.zero((double)p2);
                if (p1 instanceof Posc) {
                    Posc pos = (Posc)p1;
                    this.targetPosition(pos);
                }
            }
            super.control(type, p1, p2, p3, p4);
        }

        public double sense(LAccess sensor) {
            double d;
            switch (sensor) {
                case ammo: {
                    d = this.totalAmmo;
                    break;
                }
                case ammoCapacity: {
                    d = Turret.this.maxAmmo;
                    break;
                }
                case rotation: {
                    d = this.rotation;
                    break;
                }
                case shootX: {
                    d = World.conv(this.targetPos.x);
                    break;
                }
                case shootY: {
                    d = World.conv(this.targetPos.y);
                    break;
                }
                case shooting: {
                    if (this.isShooting()) {
                        d = 1.0;
                        break;
                    }
                    d = 0.0;
                    break;
                }
                case progress: {
                    d = this.progress();
                    break;
                }
                default: {
                    d = super.sense(sensor);
                }
            }
            return d;
        }

        public float fogRadius() {
            return (Turret.this.range + (this.hasAmmo() ? this.peekAmmo().rangeChange : 0.0f)) / 8.0f * Turret.this.fogRadiusMultiplier;
        }

        public float progress() {
            return Mathf.clamp((float)(this.reloadCounter / Turret.this.reload));
        }

        public boolean isShooting() {
            return Turret.this.alwaysShooting || (this.isControlled() ? this.unit.isShooting() : (this.logicControlled() ? this.logicShooting : this.target != null));
        }

        public Unit unit() {
            this.unit.tile((Building)((Object)this));
            this.unit.team(this.team);
            return (Unit)this.unit;
        }

        public boolean logicControlled() {
            return this.logicControlTime > 0.0f;
        }

        public boolean isActive() {
            return (this.target != null || this.wasShooting) && this.enabled;
        }

        public void targetPosition(Posc pos) {
            if (!this.hasAmmo() || pos == null) {
                return;
            }
            BulletType bullet = this.peekAmmo();
            Vec2 offset = Tmp.v1.setZero();
            if (Turret.this.accurateDelay && !Turret.this.moveWhileCharging && pos instanceof Hitboxc) {
                Hitboxc h = (Hitboxc)pos;
                offset.set(h.deltaX(), h.deltaY()).scl(Turret.this.shoot.firstShotDelay / Time.delta);
            }
            if (Turret.this.predictTarget && bullet.speed >= 0.01f) {
                this.targetPos.set(Predict.intercept((Position)this, (Position)pos, (float)offset.x, (float)offset.y, (float)bullet.speed));
            } else {
                this.targetPos.set((Position)pos);
            }
            if (this.targetPos.isZero()) {
                this.targetPos.set((Position)pos);
            }
        }

        public void draw() {
            Turret.this.drawer.draw((Building)((Object)this));
        }

        public void drawSelect() {
            super.drawSelect();
            if (Turret.this.drawMinRange) {
                Drawf.dashCircle((float)this.x, (float)this.y, (float)this.minRange(), (Color)this.team.color);
            }
            if (ArcBuilds.blockWeaponTargetLine && !this.targetPos.isZero() && this.dst((Position)this.targetPos) < Turret.this.range * 5.0f) {
                Lines.stroke(1.0f);
                Lines.dashLine(this.x, this.y, this.targetPos.x, this.targetPos.y, (int)(Mathf.len((float)(this.targetPos.x - this.x), (float)(this.targetPos.y - this.y)) / 8.0f));
                Lines.dashCircle(this.targetPos.x, this.targetPos.y, 8.0f);
                Draw.reset();
            }
            if (((Boolean)VarsX.arcTurretShowAmmoRange.get()).booleanValue()) {
                ArcBuilds.turretSelectDraw(this);
            }
        }

        public void updateTile() {
            float warmupTarget;
            if (!this.validateTarget()) {
                this.target = null;
            }
            if (this.soundLoop != null) {
                this.soundLoop.update(this.x, this.y, this.shouldActiveSound(), this.activeSoundVolume());
            }
            float f = warmupTarget = this.isShooting() && this.canConsume() || this.charging() ? 1.0f : 0.0f;
            if (warmupTarget > 0.0f && !this.isControlled()) {
                this.warmupHold = 1.0f;
            }
            if (this.warmupHold > 0.0f) {
                this.warmupHold -= Time.delta / Turret.this.warmupMaintainTime;
                warmupTarget = 1.0f;
            }
            this.shootWarmup = Turret.this.linearWarmup ? Mathf.approachDelta((float)this.shootWarmup, (float)warmupTarget, (float)(Turret.this.shootWarmupSpeed * (warmupTarget > 0.0f ? this.efficiency : 1.0f))) : Mathf.lerpDelta((float)this.shootWarmup, (float)warmupTarget, (float)(Turret.this.shootWarmupSpeed * (warmupTarget > 0.0f ? this.efficiency : 1.0f)));
            this.wasShooting = false;
            this.curRecoil = Mathf.approachDelta((float)this.curRecoil, (float)0.0f, (float)(1.0f / Turret.this.recoilTime));
            if (Turret.this.recoils > 0) {
                if (this.curRecoils == null) {
                    this.curRecoils = new float[Turret.this.recoils];
                }
                for (int i = 0; i < Turret.this.recoils; ++i) {
                    this.curRecoils[i] = Mathf.approachDelta((float)this.curRecoils[i], (float)0.0f, (float)(1.0f / Turret.this.recoilTime));
                }
            }
            this.heat = Mathf.approachDelta((float)this.heat, (float)0.0f, (float)(1.0f / Turret.this.cooldownTime));
            this.charge = this.charging() ? Mathf.approachDelta((float)this.charge, (float)1.0f, (float)(1.0f / Turret.this.shoot.firstShotDelay)) : 0.0f;
            this.unit.tile((Building)((Object)this));
            this.unit.rotation(this.rotation);
            this.unit.team(this.team);
            this.recoilOffset.trns(this.rotation, -Mathf.pow((float)this.curRecoil, (float)Turret.this.recoilPow) * Turret.this.recoil);
            if (this.logicControlTime > 0.0f) {
                this.logicControlTime -= Time.delta;
            }
            if (Turret.this.heatRequirement > 0.0f) {
                this.heatReq = this.calculateHeat(this.sideHeat);
            }
            if (Turret.this.rotate) {
                ((Building)((Object)this)).rotation = Mathf.mod((int)Mathf.round((float)(this.rotation / 90.0f)), (int)4);
            }
            if (Turret.this.reloadWhileCharging || !this.charging()) {
                this.updateReload();
                this.updateCooling();
            }
            if (Vars.state.rules.fog) {
                float newRange;
                float f2 = newRange = this.hasAmmo() ? this.peekAmmo().rangeChange : 0.0f;
                if (newRange != this.lastRangeChange) {
                    this.lastRangeChange = newRange;
                    Vars.fogControl.forceUpdate(this.team, (Building)((Object)this));
                }
            }
            if (this.hasAmmo()) {
                if (Float.isNaN(this.reloadCounter)) {
                    this.reloadCounter = 0.0f;
                }
                if (this.timer(Turret.this.timerTarget, this.target != null ? Turret.this.newTargetInterval : Turret.this.targetInterval)) {
                    this.findTarget();
                }
                if (this.validateTarget()) {
                    boolean canShoot;
                    if (this.isControlled()) {
                        this.targetPos.set(this.unit.aimX(), this.unit.aimY());
                        canShoot = this.unit.isShooting();
                    } else if (this.logicControlled()) {
                        canShoot = this.logicShooting;
                    } else {
                        float f3;
                        this.targetPosition(this.target);
                        if (Float.isNaN(this.rotation)) {
                            this.rotation = 0.0f;
                        }
                        float f4 = this.range();
                        Posc posc = this.target;
                        if (posc instanceof Sized) {
                            Sized hb = (Sized)posc;
                            f3 = hb.hitSize() / 1.9f;
                        } else {
                            f3 = 0.0f;
                        }
                        canShoot = this.within((Position)this.target, f4 + f3);
                    }
                    if (!this.isControlled()) {
                        this.unit.aimX(this.targetPos.x);
                        this.unit.aimY(this.targetPos.y);
                    }
                    float targetRot = this.angleTo((Position)this.targetPos);
                    if (this.shouldTurn()) {
                        this.turnToTarget(targetRot);
                    }
                    if (!Turret.this.alwaysShooting && Angles.angleDist((float)this.rotation, (float)targetRot) < Turret.this.shootCone && canShoot) {
                        this.wasShooting = true;
                        this.updateShooting();
                    }
                } else {
                    this.target = null;
                }
                if (Turret.this.alwaysShooting) {
                    this.wasShooting = true;
                    this.updateShooting();
                }
            }
        }

        public void handleLiquid(Building source, Liquid liquid, float amount) {
            if (Turret.this.coolant != null && this.liquids.currentAmount() <= 0.001f) {
                Events.fire((Enum)EventType.Trigger.turretCool);
            }
            super.handleLiquid(source, liquid, amount);
        }

        public boolean canConsume() {
            if (Turret.this.heatRequirement > 0.0f && this.heatReq <= 0.0f) {
                return false;
            }
            return super.canConsume();
        }

        protected boolean validateTarget() {
            return !Units.invalidateTarget(this.target, this.canHeal() ? Team.derelict : this.team, this.x, this.y) || this.isControlled() || this.logicControlled();
        }

        protected boolean canHeal() {
            return Turret.this.targetHealing && this.hasAmmo() && this.peekAmmo().collidesTeam && this.peekAmmo().heals();
        }

        protected Posc findEnemy(float range) {
            if (Turret.this.targetAir && !Turret.this.targetGround) {
                return Units.bestEnemy(this.team, this.x, this.y, range, (Boolf<Unit>)((Boolf)e -> !e.dead() && !e.isGrounded() && Turret.this.unitFilter.get(e)), Turret.this.unitSort);
            }
            BulletType ammo = this.peekAmmo();
            boolean buildings = Turret.this.targetGround && Turret.this.targetBlocks && (ammo == null || ammo.targetBlocks);
            boolean missiles = ammo == null || ammo.targetMissiles;
            return Units.bestTarget(this.team, this.x, this.y, range, (Boolf<Unit>)((Boolf)e -> !(e.dead() || !Turret.this.unitFilter.get(e) || !e.isGrounded() && !Turret.this.targetAir || e.isGrounded() && !Turret.this.targetGround || !missiles && e instanceof TimedKillc)), (Boolf<Building>)((Boolf)b -> buildings && Turret.this.buildingFilter.get(b)), Turret.this.unitSort);
        }

        protected void findTarget() {
            float trackRange = this.trackingRange();
            float range = this.range();
            this.target = this.findEnemy(range);
            if (!Mathf.equal((float)trackRange, (float)range) && this.target == null) {
                this.target = this.findEnemy(trackRange);
            }
            if (this.target == null && this.canHeal()) {
                this.target = Units.findAllyTile(this.team, this.x, this.y, range, (Boolf<Building>)((Boolf)b -> b.damaged() && b != this));
            }
        }

        protected void turnToTarget(float targetRot) {
            this.rotation = Angles.moveToward((float)this.rotation, (float)targetRot, (float)(Turret.this.rotateSpeed * this.delta() * this.potentialEfficiency));
        }

        public boolean shouldTurn() {
            return Turret.this.moveWhileCharging || !this.charging();
        }

        public void updateEfficiencyMultiplier() {
            if (Turret.this.heatRequirement > 0.0f) {
                this.efficiency *= Math.min(Math.max(this.heatReq / Turret.this.heatRequirement, this.cheating() ? 1.0f : 0.0f), Turret.this.maxHeatEfficiency);
            }
        }

        public BulletType useAmmo() {
            if (this.cheating()) {
                return this.peekAmmo();
            }
            AmmoEntry entry = (AmmoEntry)this.ammo.peek();
            entry.amount -= Turret.this.ammoPerShot;
            if (entry.amount <= 0) {
                this.ammo.pop();
            }
            this.totalAmmo -= Turret.this.ammoPerShot;
            this.totalAmmo = Math.max(this.totalAmmo, 0);
            return entry.type();
        }

        @Nullable
        public BulletType peekAmmo() {
            return this.ammo.size == 0 ? null : ((AmmoEntry)this.ammo.peek()).type();
        }

        public boolean hasAmmo() {
            if (this.ammo.size >= 2 && ((AmmoEntry)this.ammo.peek()).amount < Turret.this.ammoPerShot && ((AmmoEntry)this.ammo.get((int)(this.ammo.size - 2))).amount >= Turret.this.ammoPerShot) {
                this.ammo.swap(this.ammo.size - 1, this.ammo.size - 2);
            }
            if (!this.canConsume()) {
                return false;
            }
            return this.ammo.size > 0 && (((AmmoEntry)this.ammo.peek()).amount >= Turret.this.ammoPerShot || this.cheating());
        }

        public boolean charging() {
            return this.queuedBullets > 0 && Turret.this.shoot.firstShotDelay > 0.0f;
        }

        protected void updateReload() {
            this.reloadCounter += this.delta() * this.ammoReloadMultiplier() * this.baseReloadSpeed();
            this.reloadCounter = Math.min(this.reloadCounter, Turret.this.reload);
        }

        @Override
        protected float ammoReloadMultiplier() {
            return this.hasAmmo() ? this.peekAmmo().reloadMultiplier : 1.0f;
        }

        protected void updateShooting() {
            if (this.reloadCounter >= Turret.this.reload && !this.charging() && this.shootWarmup >= Turret.this.minWarmup) {
                BulletType type = this.peekAmmo();
                this.shoot(type);
                this.reloadCounter %= Turret.this.reload;
            }
        }

        protected void shoot(BulletType type) {
            float bulletX = this.x + Angles.trnsx((float)(this.rotation - 90.0f), (float)Turret.this.shootX, (float)Turret.this.shootY);
            float bulletY = this.y + Angles.trnsy((float)(this.rotation - 90.0f), (float)Turret.this.shootX, (float)Turret.this.shootY);
            if (Turret.this.shoot.firstShotDelay > 0.0f) {
                Turret.this.chargeSound.at(bulletX, bulletY, Mathf.random((float)Turret.this.soundPitchMin, (float)Turret.this.soundPitchMax));
                type.chargeEffect.at(bulletX, bulletY, this.rotation);
            }
            ShootPattern pattern = type.shootPattern != null ? type.shootPattern : Turret.this.shoot;
            pattern.shoot(this.barrelCounter, (xOffset, yOffset, angle, delay, mover) -> {
                ++this.queuedBullets;
                int barrel = this.barrelCounter;
                if (delay > 0.0f) {
                    Time.run((float)delay, () -> {
                        int prev = this.barrelCounter;
                        this.barrelCounter = barrel;
                        this.bullet(type, xOffset, yOffset, angle, mover);
                        this.barrelCounter = prev;
                    });
                } else {
                    this.bullet(type, xOffset, yOffset, angle, mover);
                }
            }, () -> ++this.barrelCounter);
            if (Turret.this.consumeAmmoOnce) {
                this.useAmmo();
            }
        }

        protected void bullet(BulletType type, float xOffset, float yOffset, float angleOffset, Mover mover) {
            --this.queuedBullets;
            if (this.dead || !Turret.this.consumeAmmoOnce && !this.hasAmmo()) {
                return;
            }
            float xSpread = Mathf.range((float)Turret.this.xRand);
            float bulletX = this.x + Angles.trnsx((float)(this.rotation - 90.0f), (float)(Turret.this.shootX + xOffset + xSpread), (float)(Turret.this.shootY + yOffset));
            float bulletY = this.y + Angles.trnsy((float)(this.rotation - 90.0f), (float)(Turret.this.shootX + xOffset + xSpread), (float)(Turret.this.shootY + yOffset));
            float shootAngle = this.rotation + angleOffset + Mathf.range((float)(Turret.this.inaccuracy + type.inaccuracy));
            float lifeScl = type.scaleLife ? Mathf.clamp((float)((1.0f + Turret.this.scaleLifetimeOffset) * Mathf.dst((float)bulletX, (float)bulletY, (float)this.targetPos.x, (float)this.targetPos.y) / type.range), (float)(this.minRange() / type.range), (float)(this.range() / type.range)) : 1.0f;
            this.handleBullet(type.create((Entityc)this, this.team, bulletX, bulletY, shootAngle, -1.0f, 1.0f - Turret.this.velocityRnd + Mathf.random((float)Turret.this.velocityRnd), lifeScl, null, mover, this.targetPos.x, this.targetPos.y), xOffset, yOffset, shootAngle - this.rotation);
            (Turret.this.shootEffect == null ? type.shootEffect : Turret.this.shootEffect).at(bulletX, bulletY, this.rotation + angleOffset, type.hitColor);
            (Turret.this.smokeEffect == null ? type.smokeEffect : Turret.this.smokeEffect).at(bulletX, bulletY, this.rotation + angleOffset, type.hitColor);
            (type.shootSound != Sounds.none ? type.shootSound : Turret.this.shootSound).at(bulletX, bulletY, Mathf.random((float)Turret.this.soundPitchMin, (float)Turret.this.soundPitchMax), Turret.this.shootSoundVolume);
            Turret.this.ammoUseEffect.at(this.x - Angles.trnsx((float)this.rotation, (float)Turret.this.ammoEjectBack), this.y - Angles.trnsy((float)this.rotation, (float)Turret.this.ammoEjectBack), this.rotation * (float)Mathf.sign((float)xOffset));
            if (Turret.this.shake > 0.0f) {
                Effect.shake((float)Turret.this.shake, (float)Turret.this.shake, (Position)this);
            }
            this.curRecoil = 1.0f;
            if (Turret.this.recoils > 0) {
                this.curRecoils[this.barrelCounter % Turret.this.recoils] = 1.0f;
            }
            this.heat = 1.0f;
            ++this.totalShots;
            if (!Turret.this.consumeAmmoOnce) {
                this.useAmmo();
            }
        }

        protected void handleBullet(@Nullable Bullet bullet, float offsetX, float offsetY, float angleOffset) {
        }

        public float activeSoundVolume() {
            return this.shootWarmup;
        }

        public boolean shouldActiveSound() {
            return this.shootWarmup > 0.01f && Turret.this.loopSound != Sounds.none;
        }

        public void write(Writes write) {
            super.write(write);
            write.f(this.reloadCounter);
            write.f(this.rotation);
        }

        public void read(Reads read, byte revision) {
            super.read(read, revision);
            if (revision >= 1) {
                this.reloadCounter = read.f();
                this.rotation = read.f();
            }
        }

        public byte version() {
            return 1;
        }

        public void readSync(Reads read, byte revision) {
            float oldRot = this.rotation;
            float oldReload = this.reloadCounter;
            this.readAll(read, revision);
            this.rotation = oldRot;
            this.reloadCounter = oldReload;
        }

        @Override
        public void displayBars(Table bars) {
            super.displayBars(bars);
            if (Turret.this.minWarmup > 0.0f) {
                bars.add((Element)new Bar(() -> Core.bundle.format("bar.warmupDetail", new Object[]{(int)(this.shootWarmup * 100.0f / Turret.this.minWarmup)}), () -> Pal.ammo, () -> this.shootWarmup / Turret.this.minWarmup)).row();
            }
        }
    }

    public static class BulletEntry {
        public Bullet bullet;
        public float x;
        public float y;
        public float rotation;
        public float life;

        public BulletEntry(Bullet bullet, float x, float y, float rotation, float life) {
            this.bullet = bullet;
            this.x = x;
            this.y = y;
            this.rotation = rotation;
            this.life = life;
        }
    }

    public static abstract class AmmoEntry {
        public int amount;

        public abstract BulletType type();
    }
}

