/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.distribution;

import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.scene.ui.layout.Table;
import arc.util.Eachable;
import arc.util.Nullable;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.entities.units.BuildPlan;
import mindustry.gen.Building;
import mindustry.gen.Teamc;
import mindustry.type.Item;
import mindustry.world.Block;
import mindustry.world.Edges;
import mindustry.world.Tile;
import mindustry.world.blocks.ItemSelection;
import mindustry.world.meta.BlockGroup;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;
import mindustryX.features.RenderExt;

public class DuctRouter
extends Block {
    public float speed = 5.0f;
    public TextureRegion topRegion;

    public DuctRouter(String name) {
        super(name);
        this.group = BlockGroup.transportation;
        this.update = true;
        this.solid = false;
        this.hasItems = true;
        this.unloadable = false;
        this.itemCapacity = 1;
        this.noUpdateDisabled = true;
        this.configurable = true;
        this.saveConfig = true;
        this.rotate = true;
        this.clearOnDoubleTap = true;
        this.underBullets = true;
        this.priority = -1.0f;
        this.envEnabled = 7;
        this.config(Item.class, (tile, item) -> {
            tile.sortItem = item;
        });
        this.configClear(tile -> {
            tile.sortItem = null;
        });
    }

    @Override
    public void setStats() {
        super.setStats();
        this.stats.add(Stat.itemsMoved, 60.0f / this.speed * (float)this.itemCapacity, StatUnit.itemsSecond);
    }

    @Override
    public TextureRegion[] icons() {
        return new TextureRegion[]{this.region, this.topRegion};
    }

    @Override
    public void drawPlanRegion(BuildPlan plan, Eachable<BuildPlan> list) {
        Draw.rect((TextureRegion)this.region, (float)plan.drawx(), (float)plan.drawy());
        Draw.rect((TextureRegion)this.topRegion, (float)plan.drawx(), (float)plan.drawy(), (float)(plan.rotation * 90));
    }

    @Override
    public int minimapColor(Tile tile) {
        DuctRouterBuild build = (DuctRouterBuild)tile.build;
        return build == null || build.sortItem == null ? 0 : build.sortItem.color.rgba();
    }

    @Override
    public boolean rotatedOutput(int x, int y) {
        return false;
    }

    public class DuctRouterBuild
    extends Building {
        @Nullable
        public Item sortItem;
        public float progress;
        @Nullable
        public Item current;

        @Override
        public void draw() {
            Draw.rect((TextureRegion)DuctRouter.this.region, (float)this.x, (float)this.y);
            if (this.sortItem != null) {
                Draw.color((Color)this.sortItem.color);
                Draw.rect((String)"center", (float)this.x, (float)this.y);
                Draw.color();
                if (RenderExt.arcChoiceUiIcon) {
                    Draw.rect((TextureRegion)this.sortItem.fullIcon, (float)this.x, (float)this.y, (float)4.0f, (float)4.0f);
                }
            } else {
                Draw.rect((TextureRegion)DuctRouter.this.topRegion, (float)this.x, (float)this.y, (float)this.rotdeg());
            }
        }

        @Override
        public void drawSelect() {
            super.drawSelect();
            this.drawItemSelection(this.sortItem);
        }

        @Override
        public void updateTile() {
            this.progress += this.edelta() / DuctRouter.this.speed * 2.0f;
            if (this.current != null) {
                Building target;
                if (this.progress >= 1.0f - 1.0f / DuctRouter.this.speed && (target = this.target()) != null) {
                    target.handleItem(this, this.current);
                    this.items.remove(this.current, 1);
                    this.current = null;
                    this.progress %= 1.0f - 1.0f / DuctRouter.this.speed;
                }
            } else {
                this.progress = 0.0f;
            }
            if (this.current == null && this.items.total() > 0) {
                this.current = this.items.first();
            }
        }

        @Override
        public void buildConfiguration(Table table2) {
            ItemSelection.buildTable(DuctRouter.this, table2, Vars.content.items(), () -> this.sortItem, this::configure);
        }

        @Nullable
        public Building target() {
            if (this.current == null) {
                return null;
            }
            int dump = this.cdump;
            for (int i = 0; i < this.proximity.size; ++i) {
                Building other = (Building)this.proximity.get((i + dump) % this.proximity.size);
                byte rel = this.relativeTo(other);
                if ((this.sortItem == null || this.current == this.sortItem == (rel == this.rotation)) && rel != (this.rotation + 2) % 4 && other.team == this.team && other.acceptItem(this, this.current)) {
                    this.incrementDump(this.proximity.size);
                    return other;
                }
                this.incrementDump(this.proximity.size);
            }
            return null;
        }

        @Override
        public boolean acceptItem(Building source, Item item) {
            return this.current == null && this.items.total() == 0 && Edges.getFacingEdge((Tile)source.tile, (Tile)this.tile).relativeTo(this.tile) == this.rotation;
        }

        @Override
        public int removeStack(Item item, int amount) {
            int removed = super.removeStack(item, amount);
            if (item == this.current) {
                this.current = null;
            }
            return removed;
        }

        @Override
        public void handleStack(Item item, int amount, Teamc source) {
            super.handleStack(item, amount, source);
            this.current = item;
        }

        @Override
        public void handleItem(Building source, Item item) {
            this.current = item;
            this.progress = -1.0f;
            this.items.add(item, 1);
            this.noSleep();
        }

        public Item config() {
            return this.sortItem;
        }

        @Override
        public byte version() {
            return 1;
        }

        @Override
        public void write(Writes write) {
            super.write(write);
            write.s(this.sortItem == null ? -1 : (int)this.sortItem.id);
        }

        @Override
        public void read(Reads read, byte revision) {
            super.read(read, revision);
            if (revision >= 1) {
                this.sortItem = Vars.content.item(read.s());
            }
        }
    }
}

