/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.distribution;

import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.scene.ui.layout.Table;
import arc.util.Eachable;
import arc.util.Nullable;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.entities.units.BuildPlan;
import mindustry.gen.Building;
import mindustry.gen.Unit;
import mindustry.type.Item;
import mindustry.world.Block;
import mindustry.world.DirectionalItemBuffer;
import mindustry.world.Tile;
import mindustry.world.blocks.ItemSelection;
import mindustry.world.meta.BlockGroup;
import mindustryX.features.RenderExt;

public class Sorter
extends Block {
    public TextureRegion cross;
    public boolean invert;

    public Sorter(String name) {
        super(name);
        this.update = false;
        this.destructible = true;
        this.underBullets = true;
        this.instantTransfer = true;
        this.group = BlockGroup.transportation;
        this.configurable = true;
        this.unloadable = false;
        this.saveConfig = true;
        this.clearOnDoubleTap = true;
        this.config(Item.class, (tile, item) -> {
            tile.sortItem = item;
        });
        this.configClear(tile -> {
            tile.sortItem = null;
        });
    }

    @Override
    public void drawPlanConfig(BuildPlan plan, Eachable<BuildPlan> list) {
        this.drawPlanConfigCenter(plan, plan.config, "center", true);
    }

    @Override
    public boolean outputsItems() {
        return true;
    }

    @Override
    public int minimapColor(Tile tile) {
        SorterBuild build = (SorterBuild)tile.build;
        return build == null || build.sortItem == null ? 0 : build.sortItem.color.rgba();
    }

    @Override
    protected TextureRegion[] icons() {
        return new TextureRegion[]{Core.atlas.find("source-bottom"), this.region};
    }

    public class SorterBuild
    extends Building {
        @Nullable
        public Item sortItem;

        @Override
        public void configured(Unit player, Object value) {
            super.configured(player, value);
            if (!Vars.headless) {
                Vars.renderer.minimap.update(this.tile);
            }
        }

        @Override
        public void draw() {
            if (this.sortItem == null) {
                Draw.rect((TextureRegion)Sorter.this.cross, (float)this.x, (float)this.y);
            } else {
                Draw.color((Color)this.sortItem.color);
                Fill.square((float)this.x, (float)this.y, (float)3.99999f);
                Draw.color();
                if (RenderExt.arcChoiceUiIcon) {
                    Draw.rect((TextureRegion)this.sortItem.fullIcon, (float)this.x, (float)this.y, (float)4.0f, (float)4.0f);
                }
            }
            super.draw();
        }

        @Override
        public void drawSelect() {
            super.drawSelect();
            this.drawItemSelection(this.sortItem);
        }

        @Override
        public boolean acceptItem(Building source, Item item) {
            Building to = this.getTileTarget(item, source, false);
            return to != null && to.acceptItem(this, item) && to.team == this.team;
        }

        @Override
        public void handleItem(Building source, Item item) {
            this.getTileTarget(item, source, true).handleItem(this, item);
        }

        public boolean isSame(Building other) {
            return other != null && other.block.instantTransfer;
        }

        public Building getTileTarget(Item item, Building source, boolean flip) {
            Building to;
            byte dir = source.relativeTo(this.tile.x, this.tile.y);
            if (dir == -1) {
                return null;
            }
            if (item == this.sortItem != Sorter.this.invert == this.enabled) {
                if (this.isSame(source) && this.isSame(this.nearby(dir))) {
                    return null;
                }
                to = this.nearby(dir);
            } else {
                boolean bc;
                Building a = this.nearby(Mathf.mod((int)(dir - 1), (int)4));
                Building b = this.nearby(Mathf.mod((int)(dir + 1), (int)4));
                boolean ac = a != null && (!a.block.instantTransfer || !source.block.instantTransfer) && a.acceptItem(this, item);
                boolean bl = bc = b != null && (!b.block.instantTransfer || !source.block.instantTransfer) && b.acceptItem(this, item);
                if (ac && !bc) {
                    to = a;
                } else if (bc && !ac) {
                    to = b;
                } else {
                    if (!bc) {
                        return null;
                    }
                    Building building = to = (this.rotation & 1 << dir) == 0 ? a : b;
                    if (flip) {
                        this.rotation ^= 1 << dir;
                    }
                }
            }
            return to;
        }

        @Override
        public void buildConfiguration(Table table2) {
            ItemSelection.buildTable(Sorter.this, table2, Vars.content.items(), () -> this.sortItem, this::configure, Sorter.this.selectionRows, Sorter.this.selectionColumns);
        }

        public Item config() {
            return this.sortItem;
        }

        @Override
        public byte version() {
            return 2;
        }

        @Override
        public void write(Writes write) {
            super.write(write);
            write.s(this.sortItem == null ? -1 : (int)this.sortItem.id);
        }

        @Override
        public void read(Reads read, byte revision) {
            super.read(read, revision);
            this.sortItem = Vars.content.item(read.s());
            if (revision == 1) {
                new DirectionalItemBuffer(20).read(read);
            }
        }
    }
}

