/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.heat;

import arc.Core;
import arc.math.Mathf;
import arc.struct.EnumSet;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.graphics.Pal;
import mindustry.ui.Bar;
import mindustry.world.blocks.heat.HeatBlock;
import mindustry.world.blocks.production.GenericCrafter;
import mindustry.world.draw.DrawBlock;
import mindustry.world.draw.DrawDefault;
import mindustry.world.draw.DrawHeatOutput;
import mindustry.world.draw.DrawMulti;
import mindustry.world.meta.BlockFlag;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;
import mindustryX.features.ui.FormatDefault;

public class HeatProducer
extends GenericCrafter {
    public float heatOutput = 10.0f;
    public float warmupRate = 0.15f;

    public HeatProducer(String name) {
        super(name);
        this.drawer = new DrawMulti(new DrawBlock[]{new DrawDefault(), new DrawHeatOutput()});
        this.rotateDraw = false;
        this.rotate = true;
        this.canOverdrive = false;
        this.drawArrow = true;
        this.flags = EnumSet.of((Enum[])new BlockFlag[0]);
    }

    @Override
    public void setStats() {
        super.setStats();
        this.stats.add(Stat.output, this.heatOutput, StatUnit.heatUnits);
    }

    @Override
    public void setBars() {
        super.setBars();
        this.addBar("heat", entity -> new Bar(() -> Core.bundle.get("bar.heat") + " " + FormatDefault.percent(entity.heat, this.heatOutput), () -> Pal.lightOrange, () -> entity.heat / this.heatOutput));
    }

    public class HeatProducerBuild
    extends GenericCrafter.GenericCrafterBuild
    implements HeatBlock {
        public float heat;

        public HeatProducerBuild() {
            super(HeatProducer.this);
        }

        @Override
        public void updateTile() {
            super.updateTile();
            this.heat = Mathf.approachDelta((float)this.heat, (float)(HeatProducer.this.heatOutput * this.efficiency), (float)(HeatProducer.this.warmupRate * this.delta()));
        }

        public float heatFrac() {
            return this.heat / HeatProducer.this.heatOutput;
        }

        public float heat() {
            return this.heat;
        }

        @Override
        public void write(Writes write) {
            super.write(write);
            write.f(this.heat);
        }

        @Override
        public void read(Reads read, byte revision) {
            super.read(read, revision);
            this.heat = read.f();
        }
    }
}

