/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.logic;

import arc.scene.ui.layout.Table;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.gen.Building;
import mindustry.gen.Bullet;
import mindustry.logic.LAccess;
import mindustry.logic.LExecutor;
import mindustry.logic.LReadable;
import mindustry.logic.LVar;
import mindustry.logic.LWritable;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.meta.BlockGroup;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;
import mindustryX.features.RenderExt;
import mindustryX.features.ui.LogicSupport;

public class MemoryBlock
extends Block {
    public int memoryCapacity = 32;

    public MemoryBlock(String name) {
        super(name);
        this.destructible = true;
        this.solid = true;
        this.group = BlockGroup.logic;
        this.drawDisabled = false;
        this.envEnabled = -1;
        this.canOverdrive = false;
        this.configurable = true;
    }

    @Override
    public void setStats() {
        super.setStats();
        this.stats.add(Stat.memoryCapacity, (float)this.memoryCapacity, StatUnit.none);
    }

    public boolean accessible() {
        return !this.privileged || Vars.state.rules.editor || Vars.state.rules.allowEditWorldProcessors;
    }

    @Override
    public boolean canBreak(Tile tile) {
        return this.accessible();
    }

    public class MemoryBuild
    extends Building
    implements LReadable,
    LWritable {
        public double[] memory;

        public MemoryBuild() {
            this.memory = new double[MemoryBlock.this.memoryCapacity];
        }

        @Override
        public boolean canPickup() {
            return false;
        }

        @Override
        public boolean collide(Bullet other) {
            return !MemoryBlock.this.privileged;
        }

        public boolean displayable() {
            return MemoryBlock.this.accessible();
        }

        public boolean readable(LExecutor exec) {
            return this.isValid() && (exec.privileged || this.team == exec.team && !this.block.privileged);
        }

        public void read(LVar position, LVar output) {
            int address = position.numi();
            output.setnum(address < 0 || address >= this.memory.length ? Double.NaN : this.memory[address]);
        }

        public boolean writable(LExecutor exec) {
            return this.readable(exec);
        }

        public void write(LVar position, LVar value) {
            int address = position.numi();
            if (address < 0 || address >= this.memory.length) {
                return;
            }
            this.memory[address] = value.num();
        }

        @Override
        public double sense(LAccess sensor) {
            double d;
            switch (sensor) {
                case memoryCapacity: {
                    d = MemoryBlock.this.memoryCapacity;
                    break;
                }
                default: {
                    d = super.sense(sensor);
                }
            }
            return d;
        }

        @Override
        public void damage(float damage) {
            if (MemoryBlock.this.privileged) {
                return;
            }
            super.damage(damage);
        }

        @Override
        public void write(Writes write) {
            super.write(write);
            write.i(this.memory.length);
            for (double v : this.memory) {
                write.d(v);
            }
        }

        @Override
        public boolean onConfigureBuildTapped(Building other) {
            if (this == other || !MemoryBlock.this.accessible()) {
                this.deselect();
                return false;
            }
            return super.onConfigureBuildTapped(other);
        }

        @Override
        public void buildConfiguration(Table table2) {
            if (!RenderExt.showOtherInfo && !MemoryBlock.this.accessible()) {
                this.deselect();
                return;
            }
            LogicSupport.buildMemoryTools(table2, this);
        }

        @Override
        public void read(Reads read, byte revision) {
            super.read(read, revision);
            int amount = read.i();
            for (int i = 0; i < amount; ++i) {
                double val = read.d();
                if (i >= this.memory.length) continue;
                this.memory[i] = val;
            }
        }
    }
}

