/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.payloads;

import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.struct.ObjectMap;
import arc.util.Eachable;
import arc.util.Nullable;
import arc.util.Strings;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.entities.units.BuildPlan;
import mindustry.gen.Building;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.graphics.Shaders;
import mindustry.logic.LAccess;
import mindustry.type.Item;
import mindustry.type.ItemStack;
import mindustry.ui.Bar;
import mindustry.world.Block;
import mindustry.world.blocks.payloads.BuildPayload;
import mindustry.world.blocks.payloads.Payload;
import mindustry.world.blocks.payloads.PayloadBlock;
import mindustry.world.consumers.ConsumeItemDynamic;

public abstract class BlockProducer
extends PayloadBlock {
    public float buildSpeed = 0.4f;

    public BlockProducer(String name) {
        super(name);
        this.size = 3;
        this.update = true;
        this.outputsPayload = true;
        this.hasItems = true;
        this.solid = true;
        this.hasPower = true;
        this.acceptsUnitPayloads = false;
        this.rotate = true;
        this.regionRotated1 = 1;
        ObjectMap stacks = new ObjectMap();
        this.consume(new ConsumeItemDynamic(e -> {
            Block block = e.recipe();
            if (block != null) {
                ItemStack[] clone = (ItemStack[])stacks.get((Object)block, () -> ItemStack.copy((ItemStack[])block.requirements));
                for (int i = 0; i < clone.length; ++i) {
                    clone[i].amount = Mathf.ceil((float)((float)block.requirements[i].amount * Vars.state.rules.buildCostMultiplier));
                }
                return clone;
            }
            return ItemStack.empty;
        }));
    }

    public TextureRegion[] icons() {
        return new TextureRegion[]{this.region, this.outRegion, this.topRegion};
    }

    public void drawPlanRegion(BuildPlan plan, Eachable<BuildPlan> list) {
        Draw.rect((TextureRegion)this.region, (float)plan.drawx(), (float)plan.drawy());
        Draw.rect((TextureRegion)this.outRegion, (float)plan.drawx(), (float)plan.drawy(), (float)(plan.rotation * 90));
        Draw.rect((TextureRegion)this.topRegion, (float)plan.drawx(), (float)plan.drawy());
    }

    public void setBars() {
        super.setBars();
        this.addBar("progress", entity -> new Bar(() -> entity.recipe() == null ? "\ue830" : "\ue830 " + Strings.fixed((float)(entity.progress / entity.recipe().buildTime * 100.0f), (int)0) + " %", () -> Pal.ammo, () -> entity.recipe() == null ? 0.0f : entity.progress / entity.recipe().buildTime));
    }

    public abstract class BlockProducerBuild
    extends PayloadBlock.PayloadBlockBuild<BuildPayload> {
        public float progress;
        public float time;
        public float heat;

        public BlockProducerBuild() {
            super((PayloadBlock)BlockProducer.this);
        }

        @Nullable
        public abstract Block recipe();

        public boolean acceptItem(Building source, Item item) {
            return this.items.get(item) < this.getMaximumAccepted(item);
        }

        public int getMaximumAccepted(Item item) {
            if (this.recipe() == null) {
                return 0;
            }
            for (ItemStack stack : this.recipe().requirements) {
                if (stack.item != item) continue;
                return stack.amount * 2;
            }
            return 0;
        }

        public boolean acceptPayload(Building source, Payload payload) {
            return false;
        }

        public boolean shouldConsume() {
            return super.shouldConsume() && this.recipe() != null;
        }

        public void updateTile() {
            boolean produce;
            super.updateTile();
            Block recipe = this.recipe();
            boolean bl = produce = recipe != null && this.efficiency > 0.0f && this.payload == null;
            if (produce) {
                this.progress += BlockProducer.this.buildSpeed * this.edelta();
                if (this.progress >= recipe.buildTime) {
                    this.consume();
                    this.payload = new BuildPayload(recipe, this.team);
                    ((BuildPayload)this.payload).block().placeEffect.at(this.x, this.y, ((BuildPayload)this.payload).size() / 8.0f);
                    this.payVector.setZero();
                    this.progress %= 1.0f;
                }
            }
            this.heat = Mathf.lerpDelta((float)this.heat, (float)Mathf.num((boolean)produce), (float)0.15f);
            this.time += this.heat * this.delta();
            this.moveOutPayload();
        }

        public void draw() {
            Draw.rect((TextureRegion)BlockProducer.this.region, (float)this.x, (float)this.y);
            Draw.rect((TextureRegion)BlockProducer.this.outRegion, (float)this.x, (float)this.y, (float)this.rotdeg());
            Block recipe = this.recipe();
            if (recipe != null) {
                Drawf.shadow((float)this.x, (float)this.y, (float)((float)(recipe.size * 8) * 2.0f), (float)(this.progress / recipe.buildTime));
                Draw.draw((float)40.0f, () -> {
                    Draw.color((Color)Pal.accent);
                    TextureRegion[] textureRegionArray = recipe.getGeneratedIcons();
                    int n = textureRegionArray.length;
                    for (int i = 0; i < n; ++i) {
                        TextureRegion region;
                        Shaders.blockbuild.region = region = textureRegionArray[i];
                        Shaders.blockbuild.time = this.time;
                        Shaders.blockbuild.progress = this.progress / recipe.buildTime;
                        Draw.rect((TextureRegion)region, (float)this.x, (float)this.y, (float)(recipe.rotate ? this.rotdeg() : 0.0f));
                        Draw.flush();
                    }
                    Draw.color();
                });
                Draw.z((float)41.0f);
                Draw.color((Color)Pal.accent, (float)this.heat);
                Lines.lineAngleCenter(this.x + Mathf.sin((float)this.time, (float)10.0f, (float)(4.0f * (float)recipe.size + 1.0f)), this.y, 90.0f, (float)(recipe.size * 8) + 1.0f);
                Draw.reset();
            }
            this.drawPayload();
            Draw.z((float)41.1f);
            Draw.rect((TextureRegion)BlockProducer.this.topRegion, (float)this.x, (float)this.y);
        }

        public double sense(LAccess sensor) {
            if (sensor == LAccess.progress) {
                return this.progress;
            }
            return super.sense(sensor);
        }

        public void write(Writes write) {
            super.write(write);
            write.f(this.progress);
        }

        public void read(Reads read, byte revision) {
            super.read(read, revision);
            this.progress = read.f();
        }
    }
}

