/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.power;

import arc.Events;
import arc.math.Mathf;
import arc.struct.EnumSet;
import arc.util.Strings;
import arc.util.Time;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.content.Fx;
import mindustry.game.EventType;
import mindustry.gen.Building;
import mindustry.gen.Sounds;
import mindustry.graphics.Pal;
import mindustry.logic.LAccess;
import mindustry.ui.Bar;
import mindustry.world.blocks.power.PowerGenerator;
import mindustry.world.draw.DrawBlock;
import mindustry.world.draw.DrawDefault;
import mindustry.world.draw.DrawMulti;
import mindustry.world.draw.DrawPlasma;
import mindustry.world.draw.DrawRegion;
import mindustry.world.meta.BlockFlag;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;
import mindustryX.features.StatExt;

public class ImpactReactor
extends PowerGenerator {
    public final int timerUse;
    public float warmupSpeed;
    public float itemDuration;

    public ImpactReactor(String name) {
        super(name);
        this.timerUse = this.timers++;
        this.warmupSpeed = 0.001f;
        this.itemDuration = 60.0f;
        this.hasPower = true;
        this.hasLiquids = true;
        this.liquidCapacity = 30.0f;
        this.hasItems = true;
        this.consumesPower = true;
        this.outputsPower = true;
        this.flags = EnumSet.of((Enum[])new BlockFlag[]{BlockFlag.reactor, BlockFlag.generator});
        this.lightRadius = 115.0f;
        this.emitLight = true;
        this.envEnabled = -1;
        this.drawer = new DrawMulti(new DrawBlock[]{new DrawRegion("-bottom"), new DrawPlasma(), new DrawDefault()});
        this.explosionShake = 6.0f;
        this.explosionShakeDuration = 16.0f;
        this.explosionDamage = 7600;
        this.explosionMinWarmup = 0.3f;
        this.explodeEffect = Fx.impactReactorExplosion;
        this.explodeSound = Sounds.explosionReactor2;
    }

    private float warmupToTime(float warmup, float timeScale) {
        return Mathf.log((float)(1.0f - this.warmupSpeed * timeScale), (float)(1.0f - warmup));
    }

    private float timeToWarmup(float time, float timeScale) {
        return 1.0f - Mathf.pow((float)(1.0f - this.warmupSpeed * timeScale), (float)time);
    }

    @Override
    public void setBars() {
        super.setBars();
        this.addBar("power", entity -> new Bar(() -> entity.warmup() > 0.999f ? Strings.format((String)"\ue810@[lightgray](@%)[]", (Object[])new Object[]{Strings.autoFixed((float)((entity.getPowerProduction() - this.consPower.usage) * 60.0f * entity.timeScale()), (int)1), Strings.autoFixed((float)(entity.productionEfficiency * 100.0f), (int)1)}) : Strings.format((String)"\ue810@[lightgray](@%)[]|@s", (Object[])new Object[]{Strings.autoFixed((float)((entity.getPowerProduction() - this.consPower.usage) * 60.0f * entity.timeScale()), (int)1), Strings.autoFixed((float)(entity.productionEfficiency * 100.0f), (int)1), Strings.autoFixed((float)((this.warmupToTime(0.999f, entity.timeScale()) - this.warmupToTime(entity.warmup(), entity.timeScale())) / 60.0f), (int)1)}), () -> Pal.powerBar, () -> entity.productionEfficiency));
    }

    @Override
    public void setStats() {
        super.setStats();
        if (this.hasItems) {
            this.stats.add(Stat.productionTime, this.itemDuration / 60.0f, StatUnit.seconds);
        }
        float startTime = this.warmupToTime(Mathf.pow((float)(this.consPower.usage / this.powerProduction), (float)0.2f), 1.0f);
        this.stats.add(StatExt.warmupPartial, startTime / 60.0f, StatUnit.seconds);
        this.stats.add(StatExt.warmupTime, this.warmupToTime(0.999f, 1.0f) / 60.0f, StatUnit.seconds);
        float startConsPower = 0.0f;
        int tick = 1;
        while ((float)tick < startTime) {
            startConsPower += this.consPower.usage - Mathf.pow((float)this.timeToWarmup(tick, 1.0f), (float)5.0f) * this.powerProduction;
            ++tick;
        }
        this.stats.add(StatExt.warmupPower, (float)Mathf.ceil((float)(startConsPower / 50.0f)) * 50.0f, StatUnit.none);
    }

    public class ImpactReactorBuild
    extends PowerGenerator.GeneratorBuild {
        public float warmup;
        public float totalProgress;

        public ImpactReactorBuild() {
            super(ImpactReactor.this);
        }

        @Override
        public void updateTile() {
            if (this.efficiency >= 0.9999f && this.power.status >= 0.99f) {
                boolean prevOut = this.getPowerProduction() <= ImpactReactor.this.consPower.requestedPower((Building)this);
                this.warmup = Mathf.lerpDelta((float)this.warmup, (float)1.0f, (float)(ImpactReactor.this.warmupSpeed * this.timeScale));
                if (Mathf.equal((float)this.warmup, (float)1.0f, (float)0.001f)) {
                    this.warmup = 1.0f;
                }
                if (!prevOut && this.getPowerProduction() > ImpactReactor.this.consPower.requestedPower((Building)this)) {
                    Events.fire((Enum)EventType.Trigger.impactPower);
                }
                if (this.timer(ImpactReactor.this.timerUse, ImpactReactor.this.itemDuration / this.timeScale)) {
                    this.consume();
                }
            } else {
                this.warmup = Mathf.lerpDelta((float)this.warmup, (float)0.0f, (float)0.01f);
            }
            this.totalProgress += this.warmup * Time.delta;
            this.productionEfficiency = Mathf.pow((float)this.warmup, (float)5.0f);
        }

        @Override
        public float warmup() {
            return this.warmup;
        }

        @Override
        public float totalProgress() {
            return this.totalProgress;
        }

        @Override
        public float ambientVolume() {
            return this.warmup;
        }

        @Override
        public double sense(LAccess sensor) {
            if (sensor == LAccess.heat) {
                return this.warmup;
            }
            return super.sense(sensor);
        }

        @Override
        public void write(Writes write) {
            super.write(write);
            write.f(this.warmup);
        }

        @Override
        public void read(Reads read, byte revision) {
            super.read(read, revision);
            this.warmup = read.f();
        }
    }
}

