/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.production;

import arc.Core;
import arc.func.Boolf;
import arc.graphics.Blending;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.math.Angles;
import arc.math.Mathf;
import arc.math.Rand;
import arc.math.geom.Geometry;
import arc.math.geom.Point2;
import arc.struct.EnumSet;
import arc.struct.ObjectFloatMap;
import arc.struct.Seq;
import arc.util.Eachable;
import arc.util.Nullable;
import arc.util.Strings;
import arc.util.Time;
import arc.util.Tmp;
import arc.util.io.Reads;
import arc.util.io.Writes;
import java.lang.invoke.LambdaMetafactory;
import mindustry.Vars;
import mindustry.ctype.UnlockableContent;
import mindustry.entities.units.BuildPlan;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.gen.Sounds;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.type.Item;
import mindustry.type.Liquid;
import mindustry.ui.Bar;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.blocks.environment.Floor;
import mindustry.world.blocks.environment.StaticWall;
import mindustry.world.consumers.Consume;
import mindustry.world.consumers.ConsumeLiquid;
import mindustry.world.consumers.ConsumeLiquidBase;
import mindustry.world.meta.BlockFlag;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;
import mindustry.world.meta.StatValues;

public class BeamDrill
extends Block {
    protected Rand rand = new Rand();
    public TextureRegion laser;
    public TextureRegion laserEnd;
    public TextureRegion laserCenter;
    public TextureRegion laserBoost;
    public TextureRegion laserEndBoost;
    public TextureRegion laserCenterBoost;
    public TextureRegion topRegion;
    public TextureRegion glowRegion;
    public float drillTime = 200.0f;
    public int range = 5;
    public int tier = 1;
    public float laserWidth = 0.65f;
    public float optionalBoostIntensity = 2.5f;
    public ObjectFloatMap<Item> drillMultipliers = new ObjectFloatMap();
    @Nullable
    public Item blockedItem;
    @Nullable
    public Seq<Item> blockedItems;
    public Color sparkColor = Color.valueOf((String)"fd9e81");
    public Color glowColor = Color.white;
    public float glowIntensity = 0.2f;
    public float pulseIntensity = 0.07f;
    public float glowScl = 3.0f;
    public int sparks = 7;
    public float sparkRange = 10.0f;
    public float sparkLife = 27.0f;
    public float sparkRecurrence = 4.0f;
    public float sparkSpread = 45.0f;
    public float sparkSize = 3.5f;
    public Color boostHeatColor = Color.sky.cpy().mul(0.87f);
    public Color heatColor = new Color(1.0f, 0.35f, 0.35f, 0.9f);
    public float heatPulse = 0.3f;
    public float heatPulseScl = 7.0f;

    public BeamDrill(String name) {
        super(name);
        this.hasItems = true;
        this.rotate = true;
        this.update = true;
        this.solid = true;
        this.drawArrow = false;
        this.regionRotated1 = 1;
        this.ignoreLineRotation = true;
        this.ambientSoundVolume = 0.05f;
        this.ambientSound = Sounds.loopMineBeam;
        this.envEnabled |= 2;
        this.flags = EnumSet.of((Enum[])new BlockFlag[]{BlockFlag.drill});
    }

    @Override
    public void init() {
        this.updateClipRadius((this.range + 2) * 8);
        super.init();
        if (this.blockedItems == null && this.blockedItem != null) {
            this.blockedItems = Seq.with((Object[])new Item[]{this.blockedItem});
        }
    }

    @Override
    public void setBars() {
        super.setBars();
        this.addBar("drillspeed", e -> new Bar(() -> e.lastItem == null ? "\u6316\u6398\u901f\u5ea6\uff1a0.00/s" : e.lastItem.emoji() + " " + Strings.fixed((float)(e.lastDrillSpeed * 60.0f), (int)2) + "/s", () -> Pal.ammo, () -> e.warmup));
    }

    @Override
    public boolean outputsItems() {
        return true;
    }

    @Override
    public boolean rotatedOutput(int x, int y) {
        return false;
    }

    @Override
    public TextureRegion[] icons() {
        return new TextureRegion[]{this.region, this.topRegion};
    }

    @Override
    public void drawPlanRegion(BuildPlan plan, Eachable<BuildPlan> list) {
        Draw.rect((TextureRegion)this.region, (float)plan.drawx(), (float)plan.drawy());
        Draw.rect((TextureRegion)this.topRegion, (float)plan.drawx(), (float)plan.drawy(), (float)(plan.rotation * 90));
    }

    @Override
    public void setStats() {
        Object t;
        super.setStats();
        this.stats.add(Stat.drillTier, StatValues.drillables(this.drillTime, 0.0f, this.size, this.drillMultipliers, (Boolf<Block>)((Boolf)b -> {
            if (b instanceof Floor) {
                Floor f = (Floor)((Object)b);
                if (f.wallOre && f.itemDrop != null && f.itemDrop.hardness <= this.tier) {
                    if (this.blockedItems == null) return true;
                    if (!this.blockedItems.contains((Object)f.itemDrop)) return true;
                }
            }
            if (!(b instanceof StaticWall)) return false;
            StaticWall w = (StaticWall)b;
            if (w.itemDrop == null) return false;
            if (w.itemDrop.hardness > this.tier) return false;
            if (this.blockedItems == null) return true;
            if (this.blockedItems.contains((Object)w.itemDrop)) return false;
            return true;
        })));
        this.stats.add(Stat.drillSpeed, 60.0f / this.drillTime * (float)this.size, StatUnit.itemsSecond);
        if (this.optionalBoostIntensity != 1.0f && (t = this.findConsumer((Boolf<Consume>)((Boolf)f -> f instanceof ConsumeLiquidBase && f.booster))) instanceof ConsumeLiquidBase) {
            ConsumeLiquidBase consBase = (ConsumeLiquidBase)t;
            this.stats.remove(Stat.booster);
            this.stats.add(Stat.booster, StatValues.speedBoosters("{0}" + StatUnit.timesSpeed.localized(), consBase.amount, this.optionalBoostIntensity, false, (Boolf<Liquid>)((Boolf)l -> this.consumesLiquid((Liquid)((Object)l)) && (((Consume)this.findConsumer((Boolf<Consume>)(Boolf)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$setStats$6(mindustry.world.consumers.Consume ), (Lmindustry/world/consumers/Consume;)Z)())).booster || ((ConsumeLiquid)this.findConsumer((Boolf<Consume>)(Boolf)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$setStats$7(mindustry.world.consumers.Consume ), (Lmindustry/world/consumers/Consume;)Z)())).liquid != l))));
        }
    }

    @Override
    public void drawPlace(int x, int y, int rotation, boolean valid) {
        UnlockableContent item = null;
        Item invalidItem = null;
        boolean multiple = false;
        int count = 0;
        for (int i = 0; i < this.size; ++i) {
            int j;
            this.nearbySide(x, y, rotation, i, Tmp.p1);
            UnlockableContent found = null;
            for (j = 0; j < this.range; ++j) {
                int ry;
                int rx = Tmp.p1.x + Geometry.d4x((int)rotation) * j;
                Tile other = Vars.world.tile(rx, ry = Tmp.p1.y + Geometry.d4y((int)rotation) * j);
                if (other == null || !other.solid()) continue;
                Item drop = other.wallDrop();
                if (drop == null) break;
                if (!(drop.hardness > this.tier || this.blockedItems != null && this.blockedItems.contains((Object)drop))) {
                    found = drop;
                    ++count;
                    break;
                }
                invalidItem = drop;
                break;
            }
            if (found != null) {
                if (item != found && item != null) {
                    multiple = true;
                }
                item = found;
            }
            int len = Math.min(j, this.range - 1);
            Drawf.dashLine((Color)(found == null ? Pal.remove : Pal.placing), (float)(Tmp.p1.x * 8), (float)(Tmp.p1.y * 8), (float)((Tmp.p1.x + Geometry.d4x((int)rotation) * len) * 8), (float)((Tmp.p1.y + Geometry.d4y((int)rotation) * len) * 8));
        }
        if (item != null) {
            float speed = 60.0f / this.getDrillTime((Item)item) * (float)count;
            String msg = Strings.format((String)"@ [white]@@[] @[white]([cyan]@[])", (Object[])new Object[]{Character.valueOf('\ue85e'), item.emoji(), ((Item)item).localizedName, Strings.autoFixed((float)speed, (int)2), Strings.autoFixed((float)(speed * this.optionalBoostIntensity), (int)2)});
            this.drawPlaceText(msg, x, y, valid);
        } else if (invalidItem != null) {
            this.drawPlaceText(Core.bundle.get("bar.drilltierreq"), x, y, false);
        }
    }

    @Override
    public boolean canPlaceOn(Tile tile, Team team, int rotation) {
        block0: for (int i = 0; i < this.size; ++i) {
            this.nearbySide(tile.x, tile.y, rotation, i, Tmp.p1);
            for (int j = 0; j < this.range; ++j) {
                Tile other = Vars.world.tile(Tmp.p1.x + Geometry.d4x((int)rotation) * j, Tmp.p1.y + Geometry.d4y((int)rotation) * j);
                if (other == null || !other.solid()) continue;
                Item drop = other.wallDrop();
                if (drop == null || drop.hardness > this.tier || this.blockedItems != null && this.blockedItems.contains((Object)drop)) continue block0;
                return true;
            }
        }
        return false;
    }

    public float getDrillTime(Item item) {
        return this.drillTime / this.drillMultipliers.get((Object)item, 1.0f);
    }

    private static /* synthetic */ boolean lambda$setStats$7(Consume f) {
        return f instanceof ConsumeLiquid;
    }

    private static /* synthetic */ boolean lambda$setStats$6(Consume f) {
        return f instanceof ConsumeLiquid;
    }

    public class BeamDrillBuild
    extends Building {
        public Tile[] facing;
        public Point2[] lasers;
        @Nullable
        public Item lastItem;
        public float time;
        public float warmup;
        public float boostWarmup;
        public float lastDrillSpeed;
        public int facingAmount;

        public BeamDrillBuild() {
            this.facing = new Tile[BeamDrill.this.size];
            this.lasers = new Point2[BeamDrill.this.size];
        }

        @Override
        public void drawSelect() {
            this.drawItemSelection(this.lastItem);
        }

        @Override
        public void updateTile() {
            super.updateTile();
            if (this.lasers[0] == null) {
                this.updateLasers();
            }
            this.warmup = Mathf.approachDelta((float)this.warmup, (float)Mathf.num((this.efficiency > 0.0f ? 1 : 0) != 0), (float)0.016666668f);
            this.updateFacing();
            float multiplier = Mathf.lerp((float)1.0f, (float)BeamDrill.this.optionalBoostIntensity, (float)this.optionalEfficiency);
            float drillTime = BeamDrill.this.getDrillTime(this.lastItem);
            this.boostWarmup = Mathf.lerpDelta((float)this.boostWarmup, (float)this.optionalEfficiency, (float)0.1f);
            this.lastDrillSpeed = (float)this.facingAmount * multiplier * this.timeScale / drillTime;
            this.time += this.edelta() * multiplier;
            if (this.time >= drillTime) {
                for (Tile tile : this.facing) {
                    Item drop;
                    Item item = drop = tile == null ? null : tile.wallDrop();
                    if (this.items.total() >= BeamDrill.this.itemCapacity || drop == null) continue;
                    this.items.add(drop, 1);
                    this.produced(drop);
                }
                this.time %= drillTime;
            }
            if (this.timer(BeamDrill.this.timerDump, (float)BeamDrill.this.dumpTime / this.timeScale)) {
                this.dump();
            }
        }

        @Override
        public boolean shouldConsume() {
            return this.items.total() < BeamDrill.this.itemCapacity && this.facingAmount > 0 && this.enabled;
        }

        @Override
        public void draw() {
            Draw.rect((TextureRegion)this.block.region, (float)this.x, (float)this.y);
            Draw.rect((TextureRegion)BeamDrill.this.topRegion, (float)this.x, (float)this.y, (float)this.rotdeg());
            if (this.isPayload()) {
                return;
            }
            Point2 dir = Geometry.d4((int)this.rotation);
            int ddx = Geometry.d4x((int)(this.rotation + 1));
            int ddy = Geometry.d4y((int)(this.rotation + 1));
            for (int i = 0; i < BeamDrill.this.size; ++i) {
                Item drop;
                Tile face = this.facing[i];
                if (face == null || (drop = face.wallDrop()) == null) continue;
                Point2 p = this.lasers[i];
                float lx = face.worldx() - (float)dir.x / 2.0f * 8.0f;
                float ly = face.worldy() - (float)dir.y / 2.0f * 8.0f;
                float width = (BeamDrill.this.laserWidth + Mathf.absin((float)(Time.time + (float)(i * 5) + (float)(this.id % 9 * 9)), (float)BeamDrill.this.glowScl, (float)BeamDrill.this.pulseIntensity)) * this.warmup;
                Draw.z((float)69.0f);
                Draw.mixcol((Color)BeamDrill.this.glowColor, (float)Mathf.absin((float)(Time.time + (float)(i * 5) + (float)(this.id * 9)), (float)BeamDrill.this.glowScl, (float)BeamDrill.this.glowIntensity));
                if (Math.abs(p.x - face.x) + Math.abs(p.y - face.y) == 0) {
                    Draw.scl((float)width);
                    if (this.boostWarmup < 0.99f) {
                        Draw.alpha((float)(1.0f - this.boostWarmup));
                        Draw.rect((TextureRegion)BeamDrill.this.laserCenter, (float)lx, (float)ly);
                    }
                    if (this.boostWarmup > 0.01f) {
                        Draw.alpha((float)this.boostWarmup);
                        Draw.rect((TextureRegion)BeamDrill.this.laserCenterBoost, (float)lx, (float)ly);
                    }
                    Draw.scl();
                } else {
                    float lsx = ((float)p.x - (float)dir.x / 2.0f) * 8.0f;
                    float lsy = ((float)p.y - (float)dir.y / 2.0f) * 8.0f;
                    if (this.boostWarmup < 0.99f) {
                        Draw.alpha((float)(1.0f - this.boostWarmup));
                        Drawf.laser((TextureRegion)BeamDrill.this.laser, (TextureRegion)BeamDrill.this.laserEnd, (float)lsx, (float)lsy, (float)lx, (float)ly, (float)width);
                    }
                    if (this.boostWarmup > 0.001f) {
                        Draw.alpha((float)this.boostWarmup);
                        Drawf.laser((TextureRegion)BeamDrill.this.laserBoost, (TextureRegion)BeamDrill.this.laserEndBoost, (float)lsx, (float)lsy, (float)lx, (float)ly, (float)width);
                    }
                }
                Draw.color();
                Draw.mixcol();
                Draw.z((float)110.0f);
                Lines.stroke(this.warmup);
                BeamDrill.this.rand.setState((long)i, (long)this.id);
                Color col = drop.color;
                Color spark = Tmp.c3.set(BeamDrill.this.sparkColor).lerp(BeamDrill.this.boostHeatColor, this.boostWarmup);
                for (int j = 0; j < BeamDrill.this.sparks; ++j) {
                    float fin = (Time.time / BeamDrill.this.sparkLife + BeamDrill.this.rand.random(BeamDrill.this.sparkRecurrence + 1.0f)) % BeamDrill.this.sparkRecurrence;
                    float or = BeamDrill.this.rand.range(2.0f);
                    Tmp.v1.set(BeamDrill.this.sparkRange * fin, 0.0f).rotate(this.rotdeg() + BeamDrill.this.rand.range(BeamDrill.this.sparkSpread));
                    Draw.color((Color)spark, (Color)col, (float)fin);
                    float px = Tmp.v1.x;
                    float py = Tmp.v1.y;
                    if (!(fin <= 1.0f)) continue;
                    Lines.lineAngle(lx + px + or * (float)ddx, ly + py + or * (float)ddy, Angles.angle((float)px, (float)py), Mathf.slope((float)fin) * BeamDrill.this.sparkSize);
                }
                Draw.reset();
            }
            if (BeamDrill.this.glowRegion.found()) {
                Draw.z((float)31.0f);
                Draw.blend((Blending)Blending.additive);
                Draw.color((Color)Tmp.c1.set(BeamDrill.this.heatColor).lerp(BeamDrill.this.boostHeatColor, this.boostWarmup), (float)(this.warmup * (BeamDrill.this.heatColor.a * (1.0f - BeamDrill.this.heatPulse + Mathf.absin((float)BeamDrill.this.heatPulseScl, (float)BeamDrill.this.heatPulse)))));
                Draw.rect((TextureRegion)BeamDrill.this.glowRegion, (float)this.x, (float)this.y, (float)this.rotdeg());
                Draw.blend();
                Draw.color();
            }
            Draw.blend();
            Draw.reset();
        }

        @Override
        public void onProximityUpdate() {
            this.updateLasers();
            this.updateFacing();
        }

        protected void updateLasers() {
            for (int i = 0; i < BeamDrill.this.size; ++i) {
                if (this.lasers[i] == null) {
                    this.lasers[i] = new Point2();
                }
                BeamDrill.this.nearbySide(this.tileX(), this.tileY(), this.rotation, i, this.lasers[i]);
            }
        }

        protected void updateFacing() {
            this.lastItem = null;
            boolean multiple = false;
            int dx = Geometry.d4x((int)this.rotation);
            int dy = Geometry.d4y((int)this.rotation);
            this.facingAmount = 0;
            for (int p = 0; p < BeamDrill.this.size; ++p) {
                Point2 l = this.lasers[p];
                Tile dest = null;
                for (int i = 0; i < BeamDrill.this.range; ++i) {
                    int rx = l.x + dx * i;
                    int ry = l.y + dy * i;
                    Tile other = Vars.world.tile(rx, ry);
                    if (other == null || !other.solid()) continue;
                    Item drop = other.wallDrop();
                    if (drop == null || drop.hardness > BeamDrill.this.tier || BeamDrill.this.blockedItems != null && BeamDrill.this.blockedItems.contains((Object)drop)) break;
                    ++this.facingAmount;
                    if (this.lastItem != drop && this.lastItem != null) {
                        multiple = true;
                    }
                    this.lastItem = drop;
                    dest = other;
                    break;
                }
                this.facing[p] = dest;
            }
            if (multiple) {
                this.lastItem = null;
            }
        }

        @Override
        public byte version() {
            return 1;
        }

        @Override
        public void write(Writes write) {
            super.write(write);
            write.f(this.time);
            write.f(this.warmup);
        }

        @Override
        public void read(Reads read, byte revision) {
            super.read(read, revision);
            if (revision >= 1) {
                this.time = read.f();
                this.warmup = read.f();
            }
        }
    }
}

