/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.units;

import arc.Core;
import arc.Events;
import arc.audio.Sound;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.math.geom.Position;
import arc.math.geom.Vec2;
import arc.scene.Element;
import arc.scene.style.Drawable;
import arc.scene.style.TextureRegionDrawable;
import arc.scene.ui.ButtonGroup;
import arc.scene.ui.ImageButton;
import arc.scene.ui.layout.Table;
import arc.struct.Seq;
import arc.util.Eachable;
import arc.util.Nullable;
import arc.util.Scaling;
import arc.util.Strings;
import arc.util.Structs;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.ai.UnitCommand;
import mindustry.ctype.UnlockableContent;
import mindustry.entities.Units;
import mindustry.entities.units.BuildPlan;
import mindustry.game.EventType;
import mindustry.gen.Building;
import mindustry.gen.Icon;
import mindustry.gen.Sounds;
import mindustry.gen.Tex;
import mindustry.gen.Unit;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.io.TypeIO;
import mindustry.logic.LAccess;
import mindustry.type.Item;
import mindustry.type.ItemStack;
import mindustry.type.UnitType;
import mindustry.ui.Bar;
import mindustry.ui.Fonts;
import mindustry.ui.Styles;
import mindustry.world.Block;
import mindustry.world.blocks.ItemSelection;
import mindustry.world.blocks.payloads.Payload;
import mindustry.world.blocks.payloads.UnitPayload;
import mindustry.world.blocks.units.UnitBlock;
import mindustry.world.consumers.ConsumeItemDynamic;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatValues;

public class UnitFactory
extends UnitBlock {
    public int[] capacities = new int[0];
    public Seq<UnitPlan> plans = new Seq(4);
    public Sound createSound = Sounds.unitCreate;
    public float createSoundVolume = 1.0f;

    public UnitFactory(String name) {
        super(name);
        this.update = true;
        this.hasPower = true;
        this.hasItems = true;
        this.solid = true;
        this.configurable = true;
        this.clearOnDoubleTap = true;
        this.outputsPayload = true;
        this.rotate = true;
        this.regionRotated1 = 1;
        this.commandable = true;
        this.ambientSound = Sounds.loopUnitBuilding;
        this.ambientSoundVolume = 0.09f;
        this.config(Integer.class, (build, i) -> {
            if (!this.configurable) {
                return;
            }
            if (build.currentPlan == i) {
                return;
            }
            build.currentPlan = i < 0 || i >= this.plans.size ? -1 : i;
            build.progress = 0.0f;
            if (!(build.command == null || build.unit() != null && build.unit().commands.contains((Object)build.command))) {
                build.command = null;
            }
        });
        this.config(UnitType.class, (build, val) -> {
            if (!this.configurable) {
                return;
            }
            int next = this.plans.indexOf(p -> p.unit == val);
            if (build.currentPlan == next) {
                return;
            }
            build.currentPlan = next;
            build.progress = 0.0f;
            if (build.command != null && !val.commands.contains((Object)build.command)) {
                build.command = null;
            }
        });
        this.config(UnitCommand.class, (build, command) -> {
            build.command = command;
        });
        this.configClear(build -> {
            build.command = null;
        });
        this.consume(new ConsumeItemDynamic(e -> e.currentPlan != -1 ? ((UnitPlan)this.plans.get((int)Math.min((int)e.currentPlan, (int)(this.plans.size - 1)))).requirements : ItemStack.empty));
    }

    public void init() {
        this.initCapacities();
        super.init();
    }

    public void afterPatch() {
        this.initCapacities();
        super.afterPatch();
    }

    public void initCapacities() {
        this.capacities = new int[Vars.content.items().size];
        this.itemCapacity = 10;
        for (UnitPlan plan : this.plans) {
            for (ItemStack stack : plan.requirements) {
                this.capacities[stack.item.id] = Math.max(this.capacities[stack.item.id], stack.amount * 2);
                this.itemCapacity = Math.max(this.itemCapacity, stack.amount * 2);
            }
        }
        this.consumeBuilder.each(c -> {
            c.multiplier = b -> Vars.state.rules.unitCost(b.team);
        });
    }

    public void setBars() {
        super.setBars();
        this.addBar("progress", e -> new Bar(() -> e.currentPlan == -1 ? "\ue86d[red] \ue815" : "\ue86d " + Strings.fixed((float)(e.progress * 100.0f / ((UnitPlan)this.plans.get((int)e.currentPlan)).time), (int)0) + "% | " + Strings.fixed((float)((((UnitPlan)this.plans.get((int)e.currentPlan)).time - e.progress) / (60.0f * Vars.state.rules.unitBuildSpeed(e.team) * e.timeScale())), (int)0) + " s", () -> Pal.ammo, e::fraction));
        this.addBar("units", e -> new Bar(() -> e.unit() == null ? "[lightgray]\ue815" : Core.bundle.format("bar.unitcap", new Object[]{Fonts.getUnicodeStr(e.unit().name), e.team.data().countType(e.unit()), e.unit() == null ? Units.getStringCap(e.team) : (e.unit().useUnitCap ? Units.getStringCap(e.team) : "\u221e")}), () -> Pal.power, () -> e.unit() == null ? 0.0f : (e.unit().useUnitCap ? (float)e.team.data().countType(e.unit()) / (float)Units.getCap(e.team) : 1.0f)));
    }

    public boolean outputsItems() {
        return false;
    }

    public void setStats() {
        super.setStats();
        this.stats.remove(Stat.itemCapacity);
        this.stats.add(Stat.output, table2 -> {
            table2.row();
            for (UnitPlan plan : this.plans) {
                table2.table(Styles.grayPanel, t -> {
                    if (plan.unit.isBanned()) {
                        t.image((Drawable)Icon.cancel).color(Pal.remove).size(40.0f);
                        return;
                    }
                    if (plan.unit.unlockedNow()) {
                        t.image(plan.unit.uiIcon).size(40.0f).pad(10.0f).left().scaling(Scaling.fit).with(i -> StatValues.withTooltip(i, plan.unit));
                        t.table(info -> {
                            info.add((CharSequence)plan.unit.localizedName).left();
                            info.row();
                            info.add((CharSequence)(Strings.autoFixed((float)(plan.time / 60.0f), (int)1) + " " + Core.bundle.get("unit.seconds"))).color(Color.lightGray);
                        }).left();
                        t.table(req -> {
                            req.right();
                            for (int i = 0; i < plan.requirements.length; ++i) {
                                if (i % 6 == 0) {
                                    req.row();
                                }
                                ItemStack stack = plan.requirements[i];
                                req.add((Element)StatValues.displayItem(stack.item, stack.amount, plan.time, true)).pad(5.0f);
                            }
                        }).right().grow().pad(10.0f);
                    } else {
                        t.image((Drawable)Icon.lock).color(Pal.darkerGray).size(40.0f);
                    }
                }).growX().pad(5.0f);
                table2.row();
            }
        });
    }

    public TextureRegion[] icons() {
        return new TextureRegion[]{this.region, this.outRegion, this.topRegion};
    }

    public void drawPlanRegion(BuildPlan plan, Eachable<BuildPlan> list) {
        Draw.rect((TextureRegion)this.region, (float)plan.drawx(), (float)plan.drawy());
        Draw.rect((TextureRegion)this.outRegion, (float)plan.drawx(), (float)plan.drawy(), (float)(plan.rotation * 90));
        Draw.rect((TextureRegion)this.topRegion, (float)plan.drawx(), (float)plan.drawy());
    }

    public void getPlanConfigs(Seq<UnlockableContent> options) {
        for (UnitPlan plan : this.plans) {
            if (plan.unit.isBanned()) continue;
            options.add((Object)plan.unit);
        }
    }

    public static class UnitPlan {
        public UnitType unit;
        public ItemStack[] requirements;
        public float time;

        public UnitPlan(UnitType unit, float time, ItemStack[] requirements) {
            this.unit = unit;
            this.time = time;
            this.requirements = requirements;
        }

        UnitPlan() {
        }
    }

    public class UnitFactoryBuild
    extends UnitBlock.UnitBuild {
        @Nullable
        public Vec2 commandPos;
        @Nullable
        public UnitCommand command;
        public int currentPlan;

        public UnitFactoryBuild() {
            super((UnitBlock)UnitFactory.this);
            this.currentPlan = -1;
        }

        public float fraction() {
            return this.currentPlan == -1 ? 0.0f : this.progress / ((UnitPlan)UnitFactory.this.plans.get((int)this.currentPlan)).time;
        }

        public boolean canSetCommand() {
            UnitType output = this.unit();
            return output != null && output.commands.size > 1 && output.allowChangeCommands && (output.commands.size != 2 || output.commands.get(1) != UnitCommand.enterPayloadCommand);
        }

        public void created() {
            if (this.currentPlan == -1) {
                this.currentPlan = UnitFactory.this.plans.indexOf(u -> u.unit.unlockedNow());
            }
        }

        public void drawSelect() {
            super.drawSelect();
            if (UnitFactory.this.plans.size > 1 && this.currentPlan != -1 && this.currentPlan < UnitFactory.this.plans.size) {
                this.drawItemSelection(((UnitPlan)UnitFactory.this.plans.get((int)this.currentPlan)).unit);
            }
        }

        public Vec2 getCommandPosition() {
            return this.commandPos;
        }

        public void onCommand(Vec2 target) {
            this.commandPos = target;
        }

        public Object senseObject(LAccess sensor) {
            if (sensor == LAccess.config) {
                return this.currentPlan == -1 ? null : ((UnitPlan)UnitFactory.this.plans.get((int)this.currentPlan)).unit;
            }
            return super.senseObject(sensor);
        }

        public double sense(LAccess sensor) {
            if (sensor == LAccess.progress) {
                return Mathf.clamp((float)this.fraction());
            }
            if (sensor == LAccess.itemCapacity) {
                return Mathf.round((float)((float)UnitFactory.this.itemCapacity * Vars.state.rules.unitCost(this.team)));
            }
            return super.sense(sensor);
        }

        public void buildConfiguration(Table table2) {
            Seq units = Seq.with(UnitFactory.this.plans).map(u -> u.unit).retainAll(u -> u.unlockedNow() && !u.isBanned());
            if (units.any()) {
                ItemSelection.buildTable((Block)((Object)UnitFactory.this), table2, units, () -> this.currentPlan == -1 ? null : ((UnitPlan)UnitFactory.this.plans.get((int)this.currentPlan)).unit, unit -> this.configure(UnitFactory.this.plans.indexOf(u -> u.unit == unit)), UnitFactory.this.selectionRows, UnitFactory.this.selectionColumns);
                table2.row();
                Table commands = new Table();
                commands.top().left();
                Runnable rebuildCommands = () -> {
                    commands.clear();
                    commands.background(null);
                    UnitType unit = this.unit();
                    if (unit != null && this.canSetCommand()) {
                        commands.background(Styles.black6);
                        ButtonGroup group = new ButtonGroup();
                        group.setMinCheckCount(0);
                        int i = 0;
                        int columns = Mathf.clamp((int)units.size, (int)2, (int)UnitFactory.this.selectionColumns);
                        Seq<UnitCommand> list = unit.commands;
                        commands.image(Tex.whiteui, Pal.gray).height(4.0f).growX().colspan(columns).row();
                        for (UnitCommand item : list) {
                            ImageButton button2 = (ImageButton)commands.button((Drawable)item.getIcon(), Styles.clearNoneTogglei, 40.0f, () -> this.configure(item)).tooltip(item.localized()).group(group).get();
                            button2.update(() -> button2.setChecked(this.command == item || this.command == null && unit.defaultCommand == item));
                            if (++i % columns != 0) continue;
                            commands.row();
                        }
                        if (list.size < columns) {
                            for (int j = 0; j < columns - list.size; ++j) {
                                commands.add().size(40.0f);
                            }
                        }
                    }
                };
                rebuildCommands.run();
                table2.row();
                table2.add((Element)commands).fillX().left();
            } else {
                table2.table(Styles.black3, t -> t.add((CharSequence)"@none").color(Color.lightGray));
            }
        }

        public boolean acceptPayload(Building source, Payload payload) {
            return false;
        }

        public void display(Table table2) {
            super.display(table2);
            TextureRegionDrawable reg = new TextureRegionDrawable();
            table2.row();
            table2.table(t -> {
                t.left();
                t.image().update(i -> {
                    i.setDrawable((Drawable)(this.currentPlan == -1 ? Icon.cancel : reg.set(((UnitPlan)UnitFactory.this.plans.get((int)this.currentPlan)).unit.uiIcon)));
                    i.setScaling(Scaling.fit);
                    i.setColor(this.currentPlan == -1 ? Color.lightGray : Color.white);
                }).size(32.0f).padBottom(-4.0f).padRight(2.0f);
                t.label(() -> this.currentPlan == -1 ? "@none" : ((UnitPlan)UnitFactory.this.plans.get((int)this.currentPlan)).unit.localizedName).wrap().width(230.0f).color(Color.lightGray);
            }).left();
        }

        public Object config() {
            return this.currentPlan;
        }

        public void draw() {
            Draw.rect((TextureRegion)UnitFactory.this.region, (float)this.x, (float)this.y);
            Draw.rect((TextureRegion)UnitFactory.this.outRegion, (float)this.x, (float)this.y, (float)this.rotdeg());
            if (this.currentPlan != -1) {
                UnitPlan plan = (UnitPlan)UnitFactory.this.plans.get(this.currentPlan);
                Draw.draw((float)35.0f, () -> Drawf.construct((Building)((Object)this), (UnlockableContent)plan.unit, (float)(this.rotdeg() - 90.0f), (float)(this.progress / plan.time), (float)this.speedScl, (float)this.time));
            }
            Draw.z((float)35.0f);
            this.payRotation = this.rotdeg();
            this.drawPayload();
            Draw.z((float)35.1f);
            Draw.rect((TextureRegion)UnitFactory.this.topRegion, (float)this.x, (float)this.y);
        }

        public void updateTile() {
            if (!UnitFactory.this.configurable) {
                this.currentPlan = 0;
            }
            if (this.currentPlan < 0 || this.currentPlan >= UnitFactory.this.plans.size) {
                this.currentPlan = -1;
            }
            if (this.efficiency > 0.0f && this.currentPlan != -1) {
                this.time += this.edelta() * this.speedScl * Vars.state.rules.unitBuildSpeed(this.team);
                this.progress += this.edelta() * Vars.state.rules.unitBuildSpeed(this.team);
                this.speedScl = Mathf.lerpDelta((float)this.speedScl, (float)1.0f, (float)0.05f);
            } else {
                this.speedScl = Mathf.lerpDelta((float)this.speedScl, (float)0.0f, (float)0.05f);
            }
            this.moveOutPayload();
            if (this.currentPlan != -1 && this.payload == null) {
                UnitPlan plan = (UnitPlan)UnitFactory.this.plans.get(this.currentPlan);
                if (plan.unit.isBanned()) {
                    this.currentPlan = -1;
                    return;
                }
                if (this.progress >= plan.time) {
                    this.progress %= 1.0f;
                    Unit unit = plan.unit.create(this.team);
                    if (unit.isCommandable()) {
                        if (this.commandPos != null) {
                            unit.command().commandPosition(this.commandPos);
                        }
                        unit.command().command(this.command == null && unit.type.defaultCommand != null ? unit.type.defaultCommand : this.command);
                    }
                    UnitFactory.this.createSound.at((Position)this, 1.0f + Mathf.range((float)0.06f), UnitFactory.this.createSoundVolume);
                    this.payload = new UnitPayload(unit);
                    this.payVector.setZero();
                    this.consume();
                    Events.fire((Object)new EventType.UnitCreateEvent(((UnitPayload)this.payload).unit, (Building)((Object)this)));
                }
                this.progress = Mathf.clamp((float)this.progress, (float)0.0f, (float)plan.time);
            } else {
                this.progress = 0.0f;
            }
        }

        public boolean shouldConsume() {
            if (this.currentPlan == -1) {
                return false;
            }
            return this.enabled && this.payload == null;
        }

        public int getMaximumAccepted(Item item) {
            return Mathf.round((float)((float)UnitFactory.this.capacities[item.id] * Vars.state.rules.unitCost(this.team)));
        }

        public boolean acceptItem(Building source, Item item) {
            return this.currentPlan != -1 && this.items.get(item) < this.getMaximumAccepted(item) && Structs.contains((Object[])((UnitPlan)UnitFactory.this.plans.get((int)this.currentPlan)).requirements, stack -> stack.item == item);
        }

        @Nullable
        public UnitType unit() {
            return this.currentPlan == -1 ? null : ((UnitPlan)UnitFactory.this.plans.get((int)this.currentPlan)).unit;
        }

        public byte version() {
            return 3;
        }

        public void write(Writes write) {
            super.write(write);
            write.f(this.progress);
            write.s(this.currentPlan);
            TypeIO.writeVecNullable(write, this.commandPos);
            TypeIO.writeCommand(write, this.command);
        }

        public void read(Reads read, byte revision) {
            super.read(read, revision);
            this.progress = read.f();
            this.currentPlan = read.s();
            if (revision >= 2) {
                this.commandPos = TypeIO.readVecNullable(read);
            }
            if (revision >= 3) {
                this.command = TypeIO.readCommand(read);
            }
        }
    }
}

