/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.consumers;

import arc.func.Func;
import arc.scene.Element;
import arc.scene.ui.layout.Table;
import mindustry.ctype.UnlockableContent;
import mindustry.gen.Building;
import mindustry.type.ItemStack;
import mindustry.ui.ReqImage;
import mindustry.world.Block;
import mindustry.world.consumers.Consume;
import mindustry.world.meta.StatValues;

public class ConsumeItemDynamic
extends Consume {
    public final Func<Building, ItemStack[]> items;

    public <T extends Building> ConsumeItemDynamic(Func<T, ItemStack[]> items) {
        this.items = items;
    }

    public void apply(Block block) {
        block.hasItems = true;
        block.acceptsItems = true;
    }

    public void build(Building build, Table table2) {
        ItemStack[][] current = new ItemStack[][]{(ItemStack[])this.items.get((Object)build)};
        table2.table(cont -> {
            table2.update(() -> {
                if (current[0] != this.items.get((Object)build)) {
                    this.rebuild(build, (Table)cont);
                    current[0] = (ItemStack[])this.items.get((Object)build);
                }
            });
            this.rebuild(build, (Table)cont);
        });
    }

    private void rebuild(Building build, Table table2) {
        table2.clear();
        int i = 0;
        for (ItemStack stack : (ItemStack[])this.items.get((Object)build)) {
            table2.add((Element)new ReqImage((Element)StatValues.stack((UnlockableContent)stack.item, Math.round((float)stack.amount * this.multiplier.get((Object)build)), () -> build.items.get(stack.item)), () -> build.items != null && build.items.has(stack.item, Math.round((float)stack.amount * this.multiplier.get((Object)build))))).padRight(8.0f).left();
            if (++i % 4 != 0) continue;
            table2.row();
        }
    }

    public void trigger(Building build) {
        for (ItemStack stack : (ItemStack[])this.items.get((Object)build)) {
            build.items.remove(stack.item, Math.round((float)stack.amount * this.multiplier.get((Object)build)));
        }
    }

    public float efficiency(Building build) {
        return build.consumeTriggerValid() || build.items.has((ItemStack[])this.items.get((Object)build), this.multiplier.get((Object)build)) ? 1.0f : 0.0f;
    }
}

