/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.consumers;

import arc.scene.Element;
import arc.scene.ui.layout.Table;
import mindustry.ctype.UnlockableContent;
import mindustry.gen.Building;
import mindustry.type.ItemStack;
import mindustry.ui.ReqImage;
import mindustry.world.Block;
import mindustry.world.consumers.Consume;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatValues;
import mindustry.world.meta.Stats;

public class ConsumeItems
extends Consume {
    public final ItemStack[] items;

    public ConsumeItems(ItemStack[] items) {
        this.items = items;
    }

    protected ConsumeItems() {
        this(ItemStack.empty);
    }

    public void apply(Block block) {
        block.hasItems = true;
        block.acceptsItems = true;
        for (ItemStack stack : this.items) {
            block.itemFilter[stack.item.id] = true;
        }
    }

    public void build(Building build, Table table2) {
        table2.table(c -> {
            int i = 0;
            for (ItemStack stack : this.items) {
                c.add((Element)new ReqImage((Element)StatValues.stack((UnlockableContent)stack.item, Math.round((float)stack.amount * this.multiplier.get((Object)build)), () -> build.items.get(stack.item)), () -> build.items.has(stack.item, Math.round((float)stack.amount * this.multiplier.get((Object)build))))).padRight(8.0f);
                if (++i % 4 != 0) continue;
                c.row();
            }
        }).left();
    }

    public void trigger(Building build) {
        for (ItemStack stack : this.items) {
            build.items.remove(stack.item, Math.round((float)stack.amount * this.multiplier.get((Object)build)));
        }
    }

    public float efficiency(Building build) {
        return build.consumeTriggerValid() || build.items.has(this.items, this.multiplier.get((Object)build)) ? 1.0f : 0.0f;
    }

    public void display(Stats stats) {
        stats.add(this.booster ? Stat.booster : Stat.input, stats.timePeriod < 0.0f ? StatValues.items(this.items) : StatValues.items(stats.timePeriod, this.items));
    }
}

