/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.consumers;

import arc.func.Func;
import arc.scene.Element;
import arc.scene.ui.layout.Table;
import arc.struct.Seq;
import mindustry.gen.Building;
import mindustry.type.PayloadSeq;
import mindustry.type.PayloadStack;
import mindustry.ui.ReqImage;
import mindustry.world.consumers.Consume;
import mindustry.world.meta.StatValues;
import mindustry.world.meta.Stats;

public class ConsumePayloadDynamic
extends Consume {
    public final Func<Building, Seq<PayloadStack>> payloads;

    public <T extends Building> ConsumePayloadDynamic(Func<T, Seq<PayloadStack>> payloads) {
        this.payloads = payloads;
    }

    public float efficiency(Building build) {
        float mult = this.multiplier.get((Object)build);
        for (PayloadStack stack : (Seq)this.payloads.get((Object)build)) {
            if (build.getPayloads().contains(stack.item, Math.round((float)stack.amount * mult))) continue;
            return 0.0f;
        }
        return 1.0f;
    }

    public void trigger(Building build) {
        float mult = this.multiplier.get((Object)build);
        for (PayloadStack stack : (Seq)this.payloads.get((Object)build)) {
            build.getPayloads().remove(stack.item, Math.round((float)stack.amount * mult));
        }
    }

    public void display(Stats stats) {
    }

    public void build(Building build, Table table2) {
        Seq[] current = new Seq[]{(Seq)this.payloads.get((Object)build)};
        table2.table(cont -> {
            table2.update(() -> {
                if (current[0] != this.payloads.get((Object)build)) {
                    this.rebuild(build, (Table)cont);
                    current[0] = (Seq)this.payloads.get((Object)build);
                }
            });
            this.rebuild(build, (Table)cont);
        });
    }

    private void rebuild(Building build, Table table2) {
        PayloadSeq inv = build.getPayloads();
        Seq pay = (Seq)this.payloads.get((Object)build);
        table2.clear();
        table2.table(c -> {
            int i = 0;
            for (PayloadStack stack : pay) {
                c.add((Element)new ReqImage((Element)StatValues.stack(stack.item, Math.round((float)stack.amount * this.multiplier.get((Object)build)), () -> build.getPayloads().get(stack.item)), () -> inv.contains(stack.item, Math.round((float)stack.amount * this.multiplier.get((Object)build))))).padRight(8.0f);
                if (++i % 4 != 0) continue;
                c.row();
            }
        }).left();
    }
}

