/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.meta;

import arc.Core;
import arc.func.Boolf;
import arc.func.Cons;
import arc.func.Floatf;
import arc.func.Intp;
import arc.graphics.Color;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.scene.Element;
import arc.scene.event.EventListener;
import arc.scene.event.HandCursorListener;
import arc.scene.style.Drawable;
import arc.scene.style.Style;
import arc.scene.ui.Image;
import arc.scene.ui.Label;
import arc.scene.ui.Tooltip;
import arc.scene.ui.layout.Cell;
import arc.scene.ui.layout.Collapser;
import arc.scene.ui.layout.Stack;
import arc.scene.ui.layout.Table;
import arc.struct.ObjectFloatMap;
import arc.struct.ObjectMap;
import arc.struct.Seq;
import arc.util.Nullable;
import arc.util.Scaling;
import arc.util.Strings;
import mindustry.Vars;
import mindustry.content.StatusEffects;
import mindustry.core.UI;
import mindustry.ctype.UnlockableContent;
import mindustry.entities.abilities.Ability;
import mindustry.entities.bullet.BulletType;
import mindustry.entities.bullet.ContinuousFlameBulletType;
import mindustry.entities.bullet.ContinuousLaserBulletType;
import mindustry.entities.bullet.EmpBulletType;
import mindustry.entities.bullet.LaserBulletType;
import mindustry.entities.bullet.LightningBulletType;
import mindustry.entities.bullet.PointLaserBulletType;
import mindustry.entities.bullet.RailBulletType;
import mindustry.entities.bullet.ShrapnelBulletType;
import mindustry.gen.Icon;
import mindustry.maps.Map;
import mindustry.type.Item;
import mindustry.type.ItemStack;
import mindustry.type.Liquid;
import mindustry.type.LiquidStack;
import mindustry.type.PayloadStack;
import mindustry.type.StatusEffect;
import mindustry.type.UnitType;
import mindustry.type.Weapon;
import mindustry.ui.Styles;
import mindustry.world.Block;
import mindustry.world.blocks.defense.turrets.Turret;
import mindustry.world.blocks.environment.Floor;
import mindustry.world.meta.Attribute;
import mindustry.world.meta.StatUnit;
import mindustry.world.meta.StatValue;
import mindustryX.features.StatExt;

public class StatValues {
    public static StatValue string(String value, Object ... args) {
        String result = Strings.format((String)value, (Object[])args);
        return table2 -> table2.add((CharSequence)result);
    }

    public static StatValue bool(boolean value) {
        return table2 -> table2.add((CharSequence)(!value ? "@no" : "@yes"));
    }

    public static String fixValue(float value) {
        return Strings.autoFixed((float)value, (int)3);
    }

    public static StatValue squared(float value, StatUnit unit) {
        return table2 -> {
            String fixed = StatValues.fixValue(value);
            table2.add((CharSequence)(fixed + "x" + fixed));
            table2.add((CharSequence)((unit.space ? " " : "") + unit.localized()));
        };
    }

    public static StatValue number(float value, StatUnit unit, boolean merge) {
        return table2 -> {
            String l1 = (unit.icon == null ? "" : unit.icon + " ") + StatValues.fixValue(value);
            String l2 = (unit.space ? " " : "") + unit.localized();
            if (merge) {
                table2.add((CharSequence)(l1 + l2)).left();
            } else {
                table2.add((CharSequence)l1).left();
                table2.add((CharSequence)l2).left();
            }
        };
    }

    public static StatValue number(float value, StatUnit unit) {
        return StatValues.number(value, unit, false);
    }

    public static StatValue multiplierModifier(float value, StatUnit unit, boolean merge) {
        return table2 -> {
            String l1 = (unit.icon == null ? "" : unit.icon + " ") + StatValues.multStat(value);
            String l2 = (unit.space ? " " : "") + unit.localized();
            if (merge) {
                table2.add((CharSequence)(l1 + l2)).left();
            } else {
                table2.add((CharSequence)l1).left();
                table2.add((CharSequence)l2).left();
            }
        };
    }

    public static StatValue multiplierModifier(float value, StatUnit unit) {
        return StatValues.multiplierModifier(value, unit, true);
    }

    public static StatValue multiplierModifier(float value) {
        return StatValues.multiplierModifier(value, StatUnit.multiplier);
    }

    public static StatValue percentModifier(float value, StatUnit unit, boolean merge) {
        return table2 -> {
            String l1 = (unit.icon == null ? "" : unit.icon + " ") + StatValues.ammoStat((value - 1.0f) * 100.0f);
            String l2 = (unit.space ? " " : "") + unit.localized();
            if (merge) {
                table2.add((CharSequence)(l1 + l2)).left();
            } else {
                table2.add((CharSequence)l1).left();
                table2.add((CharSequence)l2).left();
            }
        };
    }

    public static StatValue percentModifier(float value, StatUnit unit) {
        return StatValues.percentModifier(value, unit, true);
    }

    public static StatValue percentModifier(float value) {
        return StatValues.percentModifier(value, StatUnit.percent);
    }

    public static StatValue liquid(Liquid liquid, float amount, boolean perSecond) {
        return table2 -> table2.add((Element)StatValues.displayLiquid(liquid, amount, perSecond)).left();
    }

    public static StatValue liquids(Boolf<Liquid> filter, float amount, boolean perSecond) {
        return table2 -> {
            Seq list = Vars.content.liquids().select(i -> filter.get((Object)i) && i.unlockedNow() && !i.isHidden());
            for (int i2 = 0; i2 < list.size; ++i2) {
                table2.add((Element)StatValues.displayLiquid((Liquid)((Object)((Object)list.get(i2))), amount, perSecond)).padRight(5.0f);
                if (i2 == list.size - 1) continue;
                table2.add((CharSequence)"/");
            }
        };
    }

    public static StatValue liquids(float timePeriod, LiquidStack ... stacks) {
        return StatValues.liquids(timePeriod, true, stacks);
    }

    public static StatValue liquids(float timePeriod, boolean perSecond, LiquidStack ... stacks) {
        return table2 -> {
            for (LiquidStack stack : stacks) {
                table2.add((Element)StatValues.displayLiquid(stack.liquid, stack.amount * (60.0f / timePeriod), perSecond)).padRight(5.0f);
            }
        };
    }

    public static StatValue items(ItemStack ... stacks) {
        return StatValues.items(true, stacks);
    }

    public static StatValue items(boolean displayName, ItemStack ... stacks) {
        return table2 -> {
            for (ItemStack stack : stacks) {
                table2.add((Element)StatValues.displayItem(stack.item, stack.amount, displayName)).padRight(5.0f);
            }
        };
    }

    public static StatValue items(float timePeriod, ItemStack ... stacks) {
        return table2 -> {
            for (ItemStack stack : stacks) {
                table2.add((Element)StatValues.displayItem(stack.item, stack.amount, timePeriod, true)).padRight(5.0f);
            }
        };
    }

    public static StatValue items(Boolf<Item> filter) {
        return StatValues.items(-1.0f, filter);
    }

    public static StatValue items(float timePeriod, Boolf<Item> filter) {
        return table2 -> {
            Seq list = Vars.content.items().select(i -> filter.get((Object)i) && i.unlockedNow() && !i.isHidden());
            for (int i2 = 0; i2 < list.size; ++i2) {
                Item item = (Item)((Object)((Object)list.get(i2)));
                table2.add((Element)(timePeriod <= 0.0f ? StatValues.displayItem(item) : StatValues.displayItem(item, 1, timePeriod, true))).padRight(5.0f);
                if (i2 == list.size - 1) continue;
                table2.add((CharSequence)"/");
            }
        };
    }

    public static Table displayLiquid(final Liquid liquid, final float amount, boolean perSecond) {
        Table t = new Table();
        t.add((Element)new Stack(){
            {
                this.add((Element)new Image(liquid.uiIcon).setScaling(Scaling.fit));
                if (amount != 0.0f) {
                    Table t = new Table().left().bottom();
                    t.add((CharSequence)Strings.autoFixed((float)amount, (int)3)).style((Style)Styles.outlineLabel);
                    this.add((Element)t);
                }
            }
        }).size(32.0f).padRight((float)(3 + (amount != 0.0f ? (Strings.autoFixed((float)amount, (int)3).length() - 1) * 10 : 0))).with(s -> StatValues.withTooltip(s, liquid, false));
        if (perSecond && amount != 0.0f) {
            t.add((CharSequence)StatUnit.perSecond.localized()).padLeft(2.0f).padRight(5.0f).color(Color.lightGray).style((Style)Styles.outlineLabel);
        }
        t.add((CharSequence)liquid.localizedName);
        return t;
    }

    public static <T extends Element> T withTooltip(T element, UnlockableContent content, boolean tooltip) {
        if (content != null) {
            if (!Vars.mobile) {
                if (tooltip) {
                    element.addListener((EventListener)Tooltip.Tooltips.getInstance().create(content.localizedName, Vars.mobile));
                }
                element.addListener((EventListener)new HandCursorListener(() -> !content.isHidden(), true));
            }
            element.clicked(() -> {
                if (!content.isHidden()) {
                    Vars.ui.content.show(content);
                }
            });
        }
        return element;
    }

    public static <T extends Element> T withTooltip(T element, UnlockableContent content) {
        return StatValues.withTooltip(element, content, false);
    }

    private static Stack stack(TextureRegion region, int amount, @Nullable UnlockableContent content, boolean tooltip) {
        Stack stack = new Stack();
        stack.add((Element)new Table(o -> {
            o.left();
            o.add((Element)new Image(region)).size(32.0f).scaling(Scaling.fit);
        }));
        if (amount != 0) {
            stack.add((Element)new Table(t -> {
                t.left().bottom();
                t.add((CharSequence)(amount >= 1000 ? UI.formatAmount(amount) : amount + "")).style((Style)Styles.outlineLabel);
                t.pack();
            }));
        }
        StatValues.withTooltip(stack, content, tooltip);
        return stack;
    }

    private static Stack stack(TextureRegion region, int amount, @Nullable UnlockableContent content) {
        return StatValues.stack(region, amount, content, true);
    }

    public static Stack stack(ItemStack stack) {
        return StatValues.stack(stack.item.uiIcon, stack.amount, stack.item);
    }

    public static Stack stack(UnlockableContent item, int amount) {
        return StatValues.stack(item.uiIcon, amount, item);
    }

    public static Stack stack(UnlockableContent item, int amount, Intp curAmount) {
        Stack stack = StatValues.stack(item.uiIcon, amount, item);
        stack.add((Element)new Table(t -> {
            t.left().top();
            ((Label)t.label(() -> String.valueOf(curAmount.get())).get()).setFontScale(0.6f);
            t.pack();
        }));
        return stack;
    }

    public static Stack stack(UnlockableContent item, int amount, boolean tooltip) {
        return StatValues.stack(item.uiIcon, amount, item, tooltip);
    }

    public static Stack stack(Item item) {
        return StatValues.stack(item.uiIcon, 0, item);
    }

    public static Stack stack(PayloadStack stack) {
        return StatValues.stack(stack.item.uiIcon, stack.amount, stack.item);
    }

    public static Table displayItem(Item item) {
        return StatValues.displayItem(item, 0);
    }

    public static Table displayItem(Item item, int amount, boolean showName) {
        Table t = new Table();
        t.add((Element)StatValues.stack((UnlockableContent)item, amount, !showName));
        if (showName) {
            t.add((CharSequence)item.localizedName).padLeft(4 + amount > 99 ? 4.0f : 0.0f);
        }
        return t;
    }

    public static Table displayItem(Item item, int amount) {
        return StatValues.displayItem(item, amount, true);
    }

    public static Table displayItem(Item item, int amount, float timePeriod, boolean showName) {
        Table t = new Table();
        t.add((Element)StatValues.stack((UnlockableContent)item, amount, !showName));
        t.add((CharSequence)((showName ? item.localizedName + "\n" : "") + "[lightgray]" + Strings.autoFixed((float)((float)amount / (timePeriod / 60.0f)), (int)3) + StatUnit.perSecond.localized())).padLeft(2.0f).padRight(5.0f).style((Style)Styles.outlineLabel);
        return t;
    }

    public static Table displayItemPercent(Item item, int percent, boolean showName) {
        Table t = new Table();
        t.add((Element)StatValues.stack((UnlockableContent)item, 0, !showName));
        t.add((CharSequence)((showName ? item.localizedName + "\n" : "") + "[lightgray]" + percent + "%")).padLeft(2.0f).padRight(5.0f).style((Style)Styles.outlineLabel);
        return t;
    }

    public static StatValue content(UnlockableContent content) {
        return table2 -> {
            table2.add((Element)new Image(content.uiIcon)).size(24.0f).padRight(3.0f);
            table2.add((CharSequence)content.localizedName).padRight(3.0f);
        };
    }

    public static StatValue blockEfficiency(Block floor, float multiplier, boolean startZero) {
        return table2 -> table2.stack(new Element[]{new Image(floor.uiIcon).setScaling(Scaling.fit), new Table(t -> t.top().right().add((CharSequence)((multiplier < 0.0f ? "[scarlet]" : (startZero ? "[accent]" : "[accent]+")) + (int)(multiplier * 100.0f) + "%")).style((Style)Styles.outlineLabel))}).maxSize(64.0f);
    }

    public static StatValue blocks(Attribute attr, boolean floating, float scale, boolean startZero) {
        return StatValues.blocks(attr, floating, scale, startZero, true);
    }

    public static StatValue blocks(Attribute attr, boolean floating, float scale, boolean startZero, boolean checkFloors) {
        return table2 -> table2.table(c -> {
            Runnable[] rebuild2 = new Runnable[]{null};
            Map[] lastMap = new Map[]{null};
            rebuild2[0] = () -> {
                c.clearChildren();
                c.left();
                if (Vars.state.isGame()) {
                    Seq blocks = Vars.content.blocks().select(block -> {
                        Floor f;
                        return !(checkFloors && !(block instanceof Floor) || block.attributes.get(attr) == 0.0f || block instanceof Floor && (f = (Floor)((Object)((Object)((Object)((Object)block))))).isDeep() && !floating);
                    }).with(s -> s.sort(f -> f.attributes.get(attr)));
                    if (blocks.any()) {
                        int i = 0;
                        for (Block block2 : blocks) {
                            StatValues.blockEfficiency(block2, block2.attributes.get(attr) * scale, startZero).display(c);
                            if (++i % 5 != 0) continue;
                            c.row();
                        }
                    } else {
                        c.add((CharSequence)"@none.inmap");
                    }
                } else {
                    c.add((CharSequence)"@stat.showinmap");
                }
            };
            rebuild2[0].run();
            c.update(() -> {
                Map current;
                Map map = current = Vars.state.isGame() ? Vars.state.map : null;
                if (current != lastMap[0]) {
                    rebuild2[0].run();
                    lastMap[0] = current;
                }
            });
        });
    }

    public static StatValue content(Seq<UnlockableContent> list) {
        return StatValues.content(list, i -> true);
    }

    public static <T extends UnlockableContent> StatValue content(Seq<T> list, Boolf<T> check) {
        return StatValues.content(list, check, "@none.inmap");
    }

    public static <T extends UnlockableContent> StatValue content(Seq<T> list, Boolf<T> check, String noneText) {
        return table2 -> table2.table(l -> {
            l.left();
            boolean any = false;
            for (int i = 0; i < list.size; ++i) {
                UnlockableContent item = (UnlockableContent)((Object)((Object)((Object)list.get(i))));
                if (!check.get((Object)item)) continue;
                any = true;
                if (item.uiIcon.found()) {
                    l.image(item.uiIcon).size(24.0f).scaling(Scaling.fit).padRight(2.0f).padLeft(2.0f).padTop(3.0f).padBottom(3.0f).with(img -> StatValues.withTooltip(img, item, false));
                }
                l.add((CharSequence)item.localizedName).left().padLeft(1.0f).padRight(4.0f).colspan(item.uiIcon.found() ? 1 : 2);
                if (i % 5 != 4) continue;
                l.row();
            }
            if (!any) {
                l.add((CharSequence)noneText);
            }
        });
    }

    public static StatValue blocks(Boolf<Block> pred) {
        return StatValues.content(Vars.content.blocks(), pred);
    }

    public static StatValue blocks(Seq<Block> list) {
        return StatValues.content((Seq<UnlockableContent>)list.as());
    }

    public static StatValue statusEffects(Seq<StatusEffect> list) {
        return StatValues.content(list.as(), t -> true, "@none");
    }

    public static StatValue drillables(float drillTime, float drillMultiplier, float size, ObjectFloatMap<Item> multipliers, Boolf<Block> filter) {
        return table2 -> {
            table2.row();
            table2.table(c -> {
                int i = 0;
                for (Block block : Vars.content.blocks()) {
                    if (!filter.get((Object)block)) continue;
                    c.table(Styles.grayPanel, b -> {
                        b.image(block.uiIcon).size(40.0f).pad(10.0f).left().scaling(Scaling.fit);
                        b.table(info -> {
                            info.left();
                            info.add((CharSequence)block.localizedName).left().row();
                            info.add((CharSequence)block.itemDrop.emoji()).with(l -> StatValues.withTooltip(l, block.itemDrop)).left();
                        }).grow();
                        float multiplier = multipliers == null ? 1.0f : multipliers.get((Object)block.itemDrop, 1.0f);
                        b.add((CharSequence)(Strings.autoFixed((float)(60.0f / (Math.max(drillTime + drillMultiplier * (float)block.itemDrop.hardness, drillTime) / multiplier) * size), (int)2) + StatUnit.perSecond.localized())).right().pad(10.0f).padRight(15.0f).color(Color.lightGray);
                    }).growX().pad(5.0f);
                    if (++i % 2 != 0) continue;
                    c.row();
                }
            }).growX().colspan(table2.getColumns());
        };
    }

    public static StatValue boosters(float reload, float maxUsed, float multiplier, boolean baseReload, Boolf<Liquid> filter) {
        return table2 -> {
            table2.row();
            table2.table(c -> {
                for (Liquid liquid : Vars.content.liquids()) {
                    if (!filter.get((Object)liquid)) continue;
                    c.table(Styles.grayPanel, b -> {
                        b.image(liquid.uiIcon).size(40.0f).pad(10.0f).left().scaling(Scaling.fit).with(i -> StatValues.withTooltip(i, liquid, false));
                        b.table(info -> {
                            info.add((CharSequence)liquid.localizedName).left().row();
                            info.add((CharSequence)(Strings.autoFixed((float)(maxUsed * 60.0f), (int)2) + StatUnit.perSecond.localized())).left().color(Color.lightGray);
                        });
                        b.table(bt -> {
                            bt.right().defaults().padRight(3.0f).left();
                            float reloadRate = (baseReload ? 1.0f : 0.0f) + maxUsed * multiplier * liquid.heatCapacity;
                            float standardReload = baseReload ? reload : reload / (maxUsed * multiplier * 0.4f);
                            float result = standardReload / (reload / reloadRate);
                            bt.add((CharSequence)Core.bundle.format("bullet.reload", new Object[]{Strings.autoFixed((float)(result * 100.0f), (int)2)})).pad(5.0f);
                        }).right().grow().pad(10.0f).padRight(15.0f);
                    }).growX().pad(5.0f).row();
                }
            }).growX().colspan(table2.getColumns());
            table2.row();
        };
    }

    public static StatValue itemEffMultiplier(Floatf<Item> efficiency, float timePeriod, Boolf<Item> filter) {
        return StatValues.itemEffMultiplier(efficiency, timePeriod, filter, null);
    }

    public static StatValue itemEffMultiplier(Floatf<Item> efficiency, float timePeriod, Boolf<Item> filter, @Nullable ObjectFloatMap<Item> itemDurationMultipliers) {
        return table2 -> {
            if (table2.getCells().size > 0) {
                ((Cell)table2.getCells().peek()).growX();
            }
            table2.row();
            table2.table(c -> {
                for (Item item : Vars.content.items().select(i -> filter.get((Object)i) && i.unlockedNow() && !i.isHidden())) {
                    float timeMultiplier = itemDurationMultipliers == null ? 1.0f : itemDurationMultipliers.get((Object)item, 1.0f);
                    float time = 1.0f / (timePeriod * timeMultiplier / 60.0f);
                    c.table(Styles.grayPanel, b -> {
                        b.image(item.uiIcon).size(40.0f).pad(10.0f).left().scaling(Scaling.fit);
                        b.add((CharSequence)(item.localizedName + (timePeriod > 0.0f ? "\n[lightgray]" + Strings.autoFixed((float)time, (int)(time < 0.01f ? 4 : 2)) + StatUnit.perSecond.localized() : ""))).left().grow();
                        b.add((CharSequence)Core.bundle.format("stat.efficiency", new Object[]{StatValues.fixValue(efficiency.get((Object)item) * 100.0f)})).right().pad(10.0f).padRight(15.0f);
                    }).growX().pad(5.0f).row();
                }
            }).growX().colspan(table2.getColumns()).row();
        };
    }

    public static StatValue liquidEffMultiplier(Floatf<Liquid> efficiency, float amount, Boolf<Liquid> filter) {
        return table2 -> {
            if (table2.getCells().size > 0) {
                ((Cell)table2.getCells().peek()).growX();
            }
            table2.row();
            table2.table(c -> {
                for (Liquid liquid : Vars.content.liquids().select(l -> filter.get((Object)l) && l.unlockedNow() && !l.isHidden())) {
                    c.table(Styles.grayPanel, b -> {
                        b.add((Element)StatValues.displayLiquid(liquid, amount, true)).pad(10.0f).left().grow();
                        b.add((CharSequence)Core.bundle.format("stat.efficiency", new Object[]{StatValues.fixValue(efficiency.get((Object)liquid) * 100.0f)})).right().pad(10.0f).padRight(15.0f);
                    }).growX().pad(5.0f).row();
                }
            }).growX().colspan(table2.getColumns()).row();
        };
    }

    public static StatValue speedBoosters(String unit, float amount, float speed, boolean strength, Boolf<Liquid> filter) {
        return table2 -> {
            table2.row();
            table2.table(c -> {
                for (Liquid liquid : Vars.content.liquids()) {
                    if (!filter.get((Object)liquid)) continue;
                    c.table(Styles.grayPanel, b -> {
                        b.image(liquid.uiIcon).size(40.0f).pad(10.0f).left().scaling(Scaling.fit).with(i -> StatValues.withTooltip(i, liquid, false));
                        b.table(info -> {
                            info.add((CharSequence)liquid.localizedName).left().row();
                            info.add((CharSequence)(Strings.autoFixed((float)(amount * 60.0f), (int)2) + StatUnit.perSecond.localized())).left().color(Color.lightGray);
                        });
                        b.table(bt -> {
                            bt.right().defaults().padRight(3.0f).left();
                            if (speed != Float.MAX_VALUE) {
                                bt.add((CharSequence)unit.replace("{0}", "[stat]" + Strings.autoFixed((float)(speed * (strength ? liquid.heatCapacity : 1.0f) + (strength ? 1.0f : 0.0f)), (int)2) + "[lightgray]")).pad(5.0f);
                            }
                        }).right().grow().pad(10.0f).padRight(15.0f);
                    }).growX().pad(5.0f).row();
                }
            }).growX().colspan(table2.getColumns());
            table2.row();
        };
    }

    public static StatValue itemBoosters(String unit, float timePeriod, float speedBoost, float rangeBoost, ItemStack[] items) {
        return table2 -> {
            table2.row();
            table2.table(c -> c.table(Styles.grayPanel, b -> {
                b.table(it -> {
                    for (ItemStack stack : items) {
                        if (timePeriod < 0.0f) {
                            it.add((Element)StatValues.displayItem(stack.item, stack.amount, true)).pad(10.0f).padLeft(15.0f).left();
                        } else {
                            it.add((Element)StatValues.displayItem(stack.item, stack.amount, timePeriod, true)).pad(10.0f).padLeft(15.0f).left();
                        }
                        it.row();
                    }
                }).left();
                b.table(bt -> {
                    bt.right().defaults().padRight(3.0f).left();
                    if (rangeBoost != 0.0f) {
                        bt.add((CharSequence)("[lightgray]+[stat]" + Strings.autoFixed((float)(rangeBoost / 8.0f), (int)2) + "[lightgray] " + StatUnit.blocks.localized())).row();
                    }
                    if (speedBoost != 0.0f) {
                        bt.add((CharSequence)("[lightgray]" + unit.replace("{0}", "[stat]" + Strings.autoFixed((float)speedBoost, (int)2) + "[lightgray]")));
                    }
                }).right().top().grow().pad(10.0f).padRight(15.0f);
            }).growX().pad(5.0f).padBottom(-5.0f).row()).growX().colspan(table2.getColumns());
            table2.row();
        };
    }

    public static StatValue weapons(UnitType unit, Seq<Weapon> weapons) {
        return table2 -> {
            table2.row();
            for (int i = 0; i < weapons.size; ++i) {
                Weapon weapon = (Weapon)weapons.get(i);
                if (weapon.flipSprite || !weapon.hasStats(unit)) continue;
                TextureRegion region = !weapon.name.isEmpty() ? Core.atlas.find(weapon.name + "-preview", weapon.region) : null;
                table2.table(Styles.grayPanel, w -> {
                    w.left().top().defaults().padRight(3.0f).left();
                    if (region != null && region.found() && weapon.showStatSprite) {
                        w.image(region).size(60.0f).scaling(Scaling.bounded).left().top();
                    }
                    w.row();
                    weapon.addStats(unit, (Table)w);
                }).growX().pad(5.0f).margin(10.0f);
                table2.row();
            }
        };
    }

    public static StatValue abilities(Seq<Ability> abilities) {
        return StatValues.abilities(null, abilities);
    }

    public static StatValue abilities(@Nullable UnitType unit, Seq<Ability> abilities) {
        return table2 -> {
            table2.row();
            table2.table(t -> {
                for (Ability ability : abilities) {
                    if (!ability.display) continue;
                    t.table(Styles.grayPanel, a -> {
                        String customDescription;
                        a.left().top().defaults().left();
                        a.add((CharSequence)("[accent]" + ability.localized())).minWidth(100.0f).padBottom(4.0f);
                        String string = customDescription = unit == null ? null : StatExt.description(ability, unit);
                        if (customDescription != null) {
                            a.add((CharSequence)customDescription).row();
                        }
                        a.defaults().colspan(2);
                        ability.addStats(a);
                    }).pad(5.0f).margin(10.0f).growX().top();
                    t.row();
                }
            });
        };
    }

    public static <T extends UnlockableContent> StatValue ammo(ObjectMap<T, BulletType> map) {
        return StatValues.ammo(map, false, false);
    }

    public static <T extends UnlockableContent> StatValue ammo(ObjectMap<T, BulletType> map, boolean showUnit) {
        return StatValues.ammo(map, false, showUnit);
    }

    public static <T extends UnlockableContent> StatValue ammo(ObjectMap<T, BulletType> map, boolean nested, boolean showUnit) {
        return table2 -> {
            table2.row();
            Seq orderedKeys = map.keys().toSeq();
            orderedKeys.sort();
            for (UnlockableContent t : orderedKeys) {
                boolean compact = t instanceof UnitType && !showUnit || nested;
                BulletType type = (BulletType)map.get((Object)t);
                if (type.spawnUnit != null && type.spawnUnit.weapons.size > 0) {
                    StatValues.ammo(ObjectMap.of((Object[])new Object[]{t, ((Weapon)type.spawnUnit.weapons.first()).bullet}), nested, false).display(table2);
                    continue;
                }
                table2.table(Styles.grayPanel, bt -> {
                    Seq spawn;
                    block38: {
                        block39: {
                            LaserBulletType lb;
                            bt.left().top().defaults().padRight(3.0f).left();
                            if (!compact && !(t instanceof Turret)) {
                                bt.table(title -> {
                                    title.image(StatValues.icon(t)).size(24.0f).padRight(4.0f).right().scaling(Scaling.fit).top().with(i -> StatValues.withTooltip(i, t, false));
                                    title.add((CharSequence)t.localizedName).padRight(10.0f).left().top();
                                    if (type.displayAmmoMultiplier && type.statLiquidConsumed > 0.0f) {
                                        title.add((CharSequence)("[stat]" + StatValues.fixValue(type.statLiquidConsumed / type.ammoMultiplier * 60.0f) + " [lightgray]" + StatUnit.perSecond.localized()));
                                    }
                                });
                                bt.row();
                            }
                            if (type instanceof LaserBulletType) {
                                lb = (LaserBulletType)type;
                                if (lb.lightningSpacing > 0.0f) {
                                    StatValues.lightning(Mathf.floor((float)(lb.length / lb.lightningSpacing)) + 1, lb.lightningDamage, lb.lightningLength, lb.lightningLengthRand).display(bt);
                                }
                            }
                            if (type instanceof LightningBulletType) {
                                lb = (LightningBulletType)type;
                                StatValues.lightning(0, lb.damage, lb.lightningLength, lb.lightningLengthRand).display(bt);
                            } else if (type.damage > 0.0f && (type.collides || type.splashDamage <= 0.0f)) {
                                if (type.continuousDamage() > 0.0f) {
                                    bt.add((CharSequence)(Core.bundle.format("bullet.damage", new Object[]{Float.valueOf(type.continuousDamage())}) + StatUnit.perSecond.localized()));
                                } else {
                                    bt.add((CharSequence)Core.bundle.format("bullet.damage", new Object[]{Float.valueOf(type.damage)}));
                                }
                            }
                            if (type.buildingDamageMultiplier != 1.0f) {
                                StatValues.sep(bt, StatValues.multStat(type.buildingDamageMultiplier) + "[lightgray]x\u5efa\u7b51\u4f24\u5bb3");
                            }
                            if (type.rangeChange != 0.0f && !compact) {
                                StatValues.sep(bt, "[lightgray]\u5c04\u7a0b " + StatValues.ammoStat(type.rangeChange / 8.0f) + " [lightgray]\u683c");
                            }
                            if (type.shieldDamageMultiplier != 1.0f) {
                                StatValues.sep(bt, Core.bundle.format("bullet.shielddamage", new Object[]{StatValues.ammoStat((int)(type.shieldDamageMultiplier * 100.0f - 100.0f))}));
                            }
                            if (type.splashDamage > 0.0f) {
                                StatValues.sep(bt, Core.bundle.format("bullet.splashdamage", new Object[]{(int)type.splashDamage, Strings.fixed((float)(type.splashDamageRadius / 8.0f), (int)1)}));
                            }
                            if (!(type.statLiquidConsumed <= 0.0f) || compact || Mathf.equal((float)type.ammoMultiplier, (float)1.0f) || !type.displayAmmoMultiplier) break block38;
                            if (!(t instanceof Turret)) break block39;
                            Turret turret = (Turret)((Object)((Object)((Object)((Object)t))));
                            if (!turret.displayAmmoMultiplier) break block38;
                        }
                        StatValues.sep(bt, Core.bundle.format("bullet.multiplier", new Object[]{(int)type.ammoMultiplier}));
                    }
                    if (!compact && !Mathf.equal((float)type.reloadMultiplier, (float)1.0f)) {
                        StatValues.sep(bt, StatValues.multStat(type.reloadMultiplier) + "[lightgray]x\u5c04\u901f");
                    }
                    if (type.knockback > 0.0f) {
                        StatValues.sep(bt, Core.bundle.format("bullet.knockback", new Object[]{Strings.autoFixed((float)type.knockback, (int)2)}));
                    }
                    if (type.healPercent > 0.0f) {
                        StatValues.sep(bt, Core.bundle.format("bullet.healpercent", new Object[]{Strings.autoFixed((float)type.healPercent, (int)2)}));
                    }
                    if (type.healAmount > 0.0f) {
                        StatValues.sep(bt, Core.bundle.format("bullet.healamount", new Object[]{Strings.autoFixed((float)type.healAmount, (int)2)}));
                    }
                    if ((type.pierce || type.pierceCap != -1) && !(type instanceof PointLaserBulletType)) {
                        boolean laserPierce = type instanceof LaserBulletType || type instanceof ContinuousLaserBulletType || type instanceof ShrapnelBulletType;
                        boolean pierceBuilding = laserPierce || type instanceof ContinuousFlameBulletType || type instanceof RailBulletType || type.pierceBuilding;
                        boolean pierceUnit = type.pierce;
                        StringBuilder str = new StringBuilder("[stat]");
                        if (type instanceof RailBulletType) {
                            RailBulletType rail = (RailBulletType)type;
                            str.append(Strings.autoFixed((float)(rail.pierceDamageFactor * 100.0f), (int)1) + "%\u8870\u51cf");
                        } else {
                            str.append(type.pierceCap == -1 ? "\u65e0\u9650" : type.pierceCap + "x");
                        }
                        str.append("\u7a7f\u900f[lightgray]");
                        if (pierceBuilding && pierceUnit) {
                            str.append("\u5efa\u7b51\u4e0e\u5355\u4f4d");
                        } else {
                            str.append(pierceBuilding ? "\u5efa\u7b51" : "\u5355\u4f4d");
                        }
                        if (laserPierce) {
                            str.append("[stat](\u7535\u6027)");
                        }
                        StatValues.sep(bt, str.toString());
                    }
                    if (type.incendAmount > 0) {
                        StatValues.sep(bt, "@bullet.incendiary");
                    }
                    if (type.homingPower > 0.01f) {
                        StatValues.sep(bt, "[stat]\u8ffd\u8e2a[lightgray]~[]" + Strings.autoFixed((float)(type.homingPower * 50.0f * 60.0f), (int)1) + "\u00b0/s[lightgray]~[]" + Strings.fixed((float)(type.homingRange / 8.0f), (int)1) + "[lightgray]\u683c");
                    }
                    if (!(type instanceof LightningBulletType) && type.lightning > 0) {
                        StatValues.lightning(type.lightning, type.lightningDamage < 0.0f ? type.damage : type.lightningDamage, type.lightningLength, type.lightningLengthRand).display(bt);
                    }
                    if (type.pierceArmor) {
                        StatValues.sep(bt, "@bullet.armorpierce");
                    }
                    if (type.maxDamageFraction > 0.0f) {
                        StatValues.sep(bt, Core.bundle.format("bullet.maxdamagefraction", new Object[]{(int)(type.maxDamageFraction * 100.0f)}));
                    }
                    if (type.suppressionRange > 0.0f) {
                        StatValues.sep(bt, Core.bundle.format("bullet.suppression", new Object[]{Strings.autoFixed((float)(type.suppressionDuration / 60.0f), (int)2), Strings.fixed((float)(type.suppressionRange / 8.0f), (int)1)}));
                    }
                    if (type.status != StatusEffects.none) {
                        StatValues.sep(bt, (type.status.hasEmoji() ? type.status.emoji() : "") + "[stat]" + type.status.localizedName + (type.status.reactive ? "" : "[lightgray] ~ [stat]" + Strings.autoFixed((float)(type.statusDuration / 60.0f), (int)1) + "[lightgray] " + Core.bundle.get("unit.seconds"))).with(c -> StatValues.withTooltip(c, type.status));
                    }
                    if (!type.targetMissiles) {
                        StatValues.sep(bt, "@bullet.notargetsmissiles");
                    }
                    if (!type.targetBlocks) {
                        StatValues.sep(bt, "@bullet.notargetsbuildings");
                    }
                    if (type.intervalBullet != null) {
                        StatValues.collapse(bt, Core.bundle.format("bullet.interval", new Object[]{Strings.autoFixed((float)((float)type.intervalBullets / type.bulletInterval * 60.0f), (int)2)}), (Cons<Table>)((Cons)ic -> StatValues.ammo(ObjectMap.of((Object[])new Object[]{t, type.intervalBullet}), true, false).display(ic)));
                    }
                    if (type instanceof EmpBulletType) {
                        EmpBulletType eb = (EmpBulletType)type;
                        StatValues.collapse(bt, Strings.format((String)"[stat]EMP~@[lightgray]\u683c[]~[white]\ue810[]@%/[white]\ue86d[]@%~[white]\uf899[][green]@%[]/[negstat]@%[]", (Object[])new Object[]{Strings.autoFixed((float)(eb.radius / 8.0f), (int)0), Strings.autoFixed((float)(eb.powerDamageScl * 100.0f), (int)0), Strings.autoFixed((float)(eb.unitDamageScl * 100.0f), (int)0), Strings.autoFixed((float)(eb.timeIncrease * 100.0f), (int)0), Strings.autoFixed((float)(eb.powerSclDecrease * 100.0f), (int)0)}), (Cons<Table>)((Cons)ec -> {
                            ec.defaults().padLeft(5.0f);
                            StatValues.sep(ec, Strings.format((String)"[stat]\u5bf9\u654c\u65b9\u7535\u7f51\u5efa\u7b51\u9020\u6210@%\u5b50\u5f39\u4f24\u5bb3", (Object[])new Object[]{Strings.autoFixed((float)(eb.powerDamageScl * 100.0f), (int)0)}));
                            StatValues.sep(ec, Strings.format((String)"[stat]\u5bf9\u654c\u65b9\u5355\u4f4d\u9020\u6210@%\u5b50\u5f39\u4f24\u5bb3", (Object[])new Object[]{Strings.autoFixed((float)(eb.unitDamageScl * 100.0f), (int)0)}));
                            StatValues.sep(ec, Strings.format((String)"[stat]\u5bf9\u6211\u65b9\u8017\u7535\u5efa\u7b51\u8d85\u901f\u81f3@%", (Object[])new Object[]{Strings.autoFixed((float)(eb.timeIncrease * 100.0f), (int)0)}));
                            StatValues.sep(ec, Strings.format((String)"[stat]\u5bf9\u654c\u65b9\u7535\u7f51\u5efa\u7b51\u51cf\u901f\u81f3@%", (Object[])new Object[]{Strings.autoFixed((float)(eb.powerSclDecrease * 100.0f), (int)0)}));
                        }));
                    }
                    if (type.fragBullet != null) {
                        StatValues.collapse(bt, Core.bundle.format("bullet.frags", new Object[]{type.fragBullets}), (Cons<Table>)((Cons)fc -> StatValues.ammo(ObjectMap.of((Object[])new Object[]{t, type.fragBullet}), true, false).display(fc)));
                    }
                    if ((spawn = type.spawnBullets.copy()).any()) {
                        StatValues.collapse(bt, Strings.format((String)"[stat]@x[lightgray]\u751f\u6210\u5b50\u5f39\uff1a", (Object[])new Object[]{spawn.size}), (Cons<Table>)((Cons)sc -> {
                            while (spawn.any()) {
                                BulletType bullet = (BulletType)spawn.first();
                                Boolf pred = b -> bullet.damage == b.damage && bullet.splashDamage == b.splashDamage;
                                int count = spawn.count(pred);
                                if (count == type.spawnBullets.size) {
                                    StatValues.ammo(ObjectMap.of((Object[])new Object[]{t, bullet}), true, false).display(sc);
                                } else {
                                    StatValues.sep(sc, Strings.format((String)" [stat]@x[lightgray]\u5b50\u5f39\uff1a", (Object[])new Object[]{count})).padLeft(0.0f);
                                    StatValues.ammo(ObjectMap.of((Object[])new Object[]{t, bullet}), true, false).display(sc);
                                }
                                bt.row();
                                spawn.removeAll(pred);
                            }
                        }));
                    }
                }).padLeft(5.0f).padTop(5.0f).padBottom(compact ? 0.0f : 5.0f).growX().margin(compact ? 0.0f : 10.0f);
                table2.row();
            }
        };
    }

    public static StatValue lightning(int shots, float damage, int length, int lengthRand) {
        return table2 -> {
            String str = "[lightgray]";
            if (shots > 0) {
                str = str + String.format("[stat]%d[]x", shots);
            }
            str = str + String.format("\u95ea\u7535~[stat]%s[]\u4f24\u5bb3~", Strings.autoFixed((float)damage, (int)1));
            str = lengthRand > 0 ? str + String.format("[stat]%d~%d[]\u957f\u5ea6", length, length + lengthRand) : str + String.format("[stat]%d[]\u957f\u5ea6", length);
            StatValues.sep(table2, str);
        };
    }

    private static Cell<?> sep(Table table2, String text) {
        table2.row();
        return table2.add((CharSequence)text);
    }

    private static void collapse(Table table2, String text, Cons<Table> cons) {
        table2.row();
        Table collt = new Table();
        collt.left().defaults().left();
        cons.get((Object)collt);
        Collapser coll = new Collapser(collt, true);
        coll.setDuration(0.1f);
        table2.table(tt -> {
            tt.add((CharSequence)text);
            tt.button((Drawable)Icon.downOpen, Styles.emptyi, () -> coll.toggle(false)).update(i -> {
                i.getStyle().imageUp = !coll.isCollapsed() ? Icon.upOpen : Icon.downOpen;
            }).size(8.0f).padLeft(16.0f).expandX();
        });
        table2.row();
        table2.add((Element)coll);
    }

    private static String ammoStat(float val) {
        return (val > 0.0f ? "[stat]+" : "[negstat]") + Strings.autoFixed((float)val, (int)1);
    }

    private static String multStat(float val) {
        return (val >= 1.0f ? "[stat]" : "[negstat]") + Strings.autoFixed((float)val, (int)2);
    }

    private static TextureRegion icon(UnlockableContent t) {
        return t.uiIcon;
    }
}

