/*
 * Decompiled with CFR 0.152.
 */
package mindustryX;

import arc.ApplicationListener;
import arc.Core;
import arc.Events;
import arc.files.Fi;
import arc.func.ConsT;
import arc.struct.Seq;
import arc.util.Http;
import arc.util.I18NBundle;
import arc.util.Log;
import arc.util.Nullable;
import arc.util.OS;
import arc.util.Reflect;
import arc.util.Strings;
import java.net.URL;
import java.util.Locale;
import mindustry.Vars;
import mindustry.game.EventType;
import mindustry.gen.Player;
import mindustry.mod.Mods;
import mindustryX.VarsX;
import mindustryX.features.ArcOld;
import mindustryX.features.AutoUpdate;
import mindustryX.features.BindingExt;
import mindustryX.features.DamagePopup;
import mindustryX.features.DebugUtil;
import mindustryX.features.LogicExt;
import mindustryX.features.MarkerType;
import mindustryX.features.MetricCollector;
import mindustryX.features.RenderExt;
import mindustryX.features.ReplayController;
import mindustryX.features.SettingsV2;
import mindustryX.features.TimeControl;
import mindustryX.features.UIExt;
import mindustryX.features.ui.ArcMessageDialog;

public class Hooks
implements ApplicationListener {
    private static String lastTitle;

    public static void beforeInit() {
        Log.infoTag((String)"MindustryX", (String)"Hooks.beforeInit");
        Hooks.registerBundle();
        SettingsV2.INSTANCE.init();
        DebugUtil.init();
        BindingExt.init();
        Events.on(EventType.ClientLoadEvent.class, e -> MetricCollector.INSTANCE.onLaunch());
        if (!OS.isAndroid && Strings.parseInt((String)OS.javaVersion.split("\\.")[0]) < 17) {
            Log.warn((String)("Java\u7248\u672c\u8fc7\u4f4e\uff0c\u4e0d\u53d7\u652f\u6301(" + OS.javaVersion + ")\u3002\u8bf7\u4f7f\u7528Java 17\u6216\u66f4\u9ad8\u7248\u672c\u8fd0\u884cMindustryX\u3002"), (Object[])new Object[0]);
            Events.on(EventType.ClientLoadEvent.class, e -> Vars.ui.showInfo("Java\u7248\u672c\u8fc7\u4f4e\uff0c\u4e0d\u53d7\u652f\u6301(" + OS.javaVersion + ")\u3002\u8bf7\u4f7f\u7528Java 17\u6216\u66f4\u9ad8\u7248\u672c\u8fd0\u884cMindustryX\u3002\n[grey]\u8be5\u8b66\u544a\u4e0d\u5b58\u5728\u8bbe\u7f6e\uff0c\u8bf7\u66f4\u65b0Java\u7248\u672c\u3002"));
        }
        try {
            Http.onBeforeRequest = Hooks::onHttp;
        }
        catch (NoSuchFieldError e2) {
            Log.warn((String)("Failed to set Http.onBeforeRequest " + e2.toString()), (Object[])new Object[0]);
        }
    }

    public void init() {
        Log.infoTag((String)"MindustryX", (String)"Hooks.init");
        LogicExt.init();
        if (!Vars.headless) {
            if (AutoUpdate.INSTANCE.getActive()) {
                AutoUpdate.INSTANCE.checkUpdate();
            }
            RenderExt.init();
            TimeControl.init();
            UIExt.init();
            ReplayController.init();
            ArcOld.colorizeContent();
            DamagePopup.init();
        }
        if (Vars.headless || Core.settings.getBool("console")) {
            Vars.mods.getScripts().runConsole("X=Packages.mindustryX.features");
        }
    }

    public static void onHttp(Http.HttpRequest req) {
        if (((Boolean)VarsX.githubMirror.get()).booleanValue()) {
            try {
                String url = req.url;
                String host = new URL(url).getHost();
                if (host.contains("github.com") || host.contains("raw.githubusercontent.com")) {
                    req.url = url = "https://gh.tinylake.top/" + url;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Nullable
    public static String onHandleSendMessage(String message, @Nullable Player sender) {
        if (message == null) {
            return null;
        }
        if (Vars.ui != null) {
            if (!MarkerType.resolveMessage(message)) {
                if (((Boolean)ArcOld.schematicShare.get()).booleanValue() && message.contains("<ARC") && message.contains("<Schem>")) {
                    try {
                        String id = message.split("<Schem>")[1].split(" ")[1];
                        Http.get("https://pastebin.com/raw/" + id, (ConsT<Http.HttpResponse, Exception>)((ConsT)r -> {
                            String content = r.getResultAsString().replace(" ", "+");
                            Core.app.post(() -> Vars.ui.schematics.readShare(content, sender));
                        }));
                    }
                    catch (Exception e) {
                        Log.err((Throwable)e);
                    }
                } else {
                    try {
                        ArcMessageDialog.resolveMsg(message, sender);
                    }
                    catch (Exception e) {
                        Log.err((Throwable)e);
                    }
                }
            }
            if (sender != null) {
                StringBuilder builder = new StringBuilder();
                if (Vars.state.rules.pvp) {
                    builder.append("[#").append(sender.team().color).append("]");
                    builder.append(sender.team() == Vars.player.team() ? "\ue872 " : Character.valueOf('\ue86d'));
                    builder.append("[]");
                }
                builder.append(sender.dead() ? Character.valueOf('\uf6aa') : sender.unit().type.emoji());
                builder.append(" ").append(message);
                message = builder.toString();
            }
        }
        return message;
    }

    public void update() {
        if (!Vars.headless) {
            this.updateTitle();
            BindingExt.pollKeys();
            if (BindingExt.oreAdsorption.keyDown()) {
                ArcOld.doOreAdsorption();
            }
            Vars.maxSchematicSize = (Integer)VarsX.maxSchematicSize.get() > 256 ? Integer.MAX_VALUE : (Integer)VarsX.maxSchematicSize.get();
            ArcOld.updatePlayer();
        }
    }

    private static void registerBundle() {
        try {
            I18NBundle originBundle = Core.bundle;
            Fi handle = Core.files.internal("bundles/bundle-mdtx");
            Core.bundle = I18NBundle.createBundle((Fi)handle, (Locale)Locale.getDefault());
            Reflect.set((Object)Core.bundle, (String)"locale", (Object)originBundle.getLocale());
            Log.info((Object)"MDTX: bundle has been loaded.");
            I18NBundle rootBundle = Core.bundle;
            while (rootBundle.getParent() != null) {
                rootBundle = rootBundle.getParent();
            }
            Reflect.set((Object)rootBundle, (String)"parent", (Object)originBundle);
        }
        catch (Throwable e) {
            Log.err((Throwable)e);
        }
    }

    private void updateTitle() {
        if (Core.graphics == null) {
            return;
        }
        Seq<Mods.LoadedMod> mod = Vars.mods.orderedMods();
        String title = "MindustryX | \u7248\u672c\u53f7 " + VarsX.version + " | mod\u542f\u7528" + mod.count(Mods.LoadedMod::enabled) + "/" + mod.size + " | " + Core.graphics.getWidth() + "x" + Core.graphics.getHeight();
        if (!title.equals(lastTitle)) {
            lastTitle = title;
            Core.graphics.setTitle(title);
        }
    }
}

