/*
 * Decompiled with CFR 0.152.
 */
package mindustryX.features;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import androidx.core.content.FileProvider;
import java.io.File;
import mindustry.Vars;

public class ApkInstallHelper {
    private static final int REQUEST_INSTALL_PERMISSION = 1234;
    private Activity activity;
    private File pendingApkFile;

    public ApkInstallHelper(Activity activity) {
        this.activity = activity;
    }

    public void installApk(File file) {
        if (Build.VERSION.SDK_INT >= 26 && !this.activity.getPackageManager().canRequestPackageInstalls()) {
            this.pendingApkFile = file;
            Intent intent = new Intent("android.settings.MANAGE_UNKNOWN_APP_SOURCES");
            intent.setData(Uri.parse((String)("package:" + this.activity.getPackageName())));
            this.activity.startActivityForResult(intent, 1234);
        } else {
            this.installApkInternal(file);
        }
    }

    public void onActivityResult(int requestCode, int resultCode) {
        if (requestCode == 1234 && resultCode == -1 && this.pendingApkFile != null) {
            this.installApkInternal(this.pendingApkFile);
            this.pendingApkFile = null;
        }
    }

    private void installApkInternal(File file) {
        try {
            Uri uri;
            Intent intent = new Intent("android.intent.action.VIEW");
            if (Build.VERSION.SDK_INT >= 24) {
                uri = FileProvider.getUriForFile((Context)this.activity, (String)(this.activity.getPackageName() + ".fileprovider"), (File)file);
                intent.addFlags(1);
            } else {
                uri = Uri.fromFile((File)file);
            }
            intent.setDataAndType(uri, "application/vnd.android.package-archive");
            intent.addFlags(0x10000000);
            this.activity.startActivity(intent);
        }
        catch (Exception e) {
            Vars.ui.showException("\u5b89\u88c5APK\u5931\u8d25", e);
        }
    }
}

