/*
 * Decompiled with CFR 0.152.
 */
package mindustryX.features;

import arc.Core;
import arc.Events;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.math.geom.Vec2;
import arc.struct.ObjectMap;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.ctype.UnlockableContent;
import mindustry.entities.bullet.BulletType;
import mindustry.game.EventType;
import mindustry.gen.Icon;
import mindustry.gen.Unit;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.type.Item;
import mindustry.world.Block;
import mindustry.world.blocks.defense.turrets.BaseTurret;
import mindustry.world.blocks.defense.turrets.ContinuousLiquidTurret;
import mindustry.world.blocks.defense.turrets.ItemTurret;
import mindustry.world.blocks.defense.turrets.LiquidTurret;
import mindustry.world.blocks.defense.turrets.PowerTurret;
import mindustry.world.blocks.defense.turrets.TractorBeamTurret;
import mindustry.world.blocks.defense.turrets.Turret;
import mindustryX.features.RenderExt;
import mindustryX.features.draw.ArcUnits;

public class ArcBuilds {
    private static boolean targetAir = false;
    private static boolean targetGround = false;
    private static boolean canShoot = false;
    private static boolean turretForceShowRange = false;
    private static int turretShowRange = 0;
    private static int turretAlertRange;
    private static boolean showTurretAmmo;
    private static boolean showTurretAmmoAmount;
    public static boolean blockWeaponTargetLine;
    private static boolean blockWeaponTargetLineWhenIdle;

    private static void drawRange(BaseTurret.BaseTurretBuild build) {
        Draw.z((float)49.2f);
        Draw.color((Color)build.team.color, (float)0.6f);
        Lines.circle(build.x, build.y, build.range());
        Draw.color();
    }

    public static void arcTurret(BaseTurret.BaseTurretBuild build) {
        if (build == null || build.team != Vars.player.team() && !RenderExt.showOtherInfo) {
            return;
        }
        Vec2 targetPos = Vec2.ZERO;
        Block block = build.block;
        if (block instanceof Turret) {
            Turret t = (Turret)((Object)block);
            targetAir = t.targetAir;
            targetGround = t.targetGround;
            targetPos = ((Turret.TurretBuild)build).targetPos;
            canShoot = ((Turret.TurretBuild)build).hasAmmo();
        } else {
            block = build.block;
            if (block instanceof TractorBeamTurret) {
                TractorBeamTurret t = (TractorBeamTurret)block;
                targetAir = t.targetAir;
                targetGround = t.targetGround;
                Unit target = ((TractorBeamTurret.TractorBeamBuild)build).target;
                if (target != null) {
                    targetPos = Tmp.v1.set(target.x, target.y);
                }
                boolean bl = canShoot = build.potentialEfficiency > 0.0f;
            }
        }
        if (build instanceof PowerTurret.PowerTurretBuild) {
            boolean bl = canShoot = build.efficiency > 0.0f;
        }
        if (turretForceShowRange || canShoot) {
            if (turretShowRange == 3 || turretShowRange == 2 && targetAir || turretShowRange == 1 && targetGround) {
                ArcBuilds.drawRange(build);
            } else if (turretAlertRange > 0 && build.team != Vars.player.team()) {
                boolean canHitPlans;
                boolean canHitPlayer = !Vars.player.dead() && Vars.player.unit().hittable() && (Vars.player.unit().isFlying() ? targetAir : targetGround) && build.within(Vars.player.unit().x, Vars.player.unit().y, build.range() + (float)turretAlertRange);
                boolean canHitMouse = build.within(Core.input.mouseWorldX(), Core.input.mouseWorldY(), build.range() + (float)turretAlertRange);
                boolean canHitCommand = Vars.control.input.commandMode && (ArcUnits.selectedUnitsFlyer && targetAir || ArcUnits.selectedUnitsLand && targetGround);
                boolean bl = canHitPlans = (Vars.control.input.block != null || Vars.control.input.selectPlans.size > 0) && targetGround;
                if (canHitPlayer || canHitMouse && (canHitCommand || canHitPlans)) {
                    ArcBuilds.drawRange(build);
                }
            }
            if (showTurretAmmo && build instanceof ItemTurret.ItemTurretBuild) {
                ItemTurret.ItemTurretBuild it = (ItemTurret.ItemTurretBuild)build;
                if (it.ammo.any()) {
                    ItemTurret.ItemEntry entry = (ItemTurret.ItemEntry)it.ammo.peek();
                    Item lastAmmo = entry.item;
                    Draw.z((float)50.1f);
                    float size = Math.max(4.0f, (float)(build.block.size * 8) / 2.5f);
                    float ammoX = build.x - (float)(build.block.size * 8) / 2.0f + size / 2.0f;
                    float ammoY = build.y - (float)(build.block.size * 8) / 2.0f + size / 2.0f;
                    Draw.rect((TextureRegion)lastAmmo.fullIcon, (float)ammoX, (float)ammoY, (float)size, (float)size);
                    float leftAmmo = Mathf.lerp((float)0.0f, (float)1.0f, (float)Math.min(1.0f, (float)entry.amount / (float)((ItemTurret)((Object)it.block)).maxAmmo));
                    if (leftAmmo < 0.75f && showTurretAmmoAmount) {
                        Draw.color((Color)lastAmmo.color, (float)0.5f);
                        Lines.stroke(Lines.getStroke() * (float)build.block.size * 0.5f);
                        Lines.arc(ammoX, ammoY, size * 0.5f, leftAmmo);
                    }
                    Draw.reset();
                }
            }
            if (targetPos.x != 0.0f && targetPos.y != 0.0f && blockWeaponTargetLine && Mathf.len((float)(targetPos.x - build.x), (float)(targetPos.y - build.y)) <= 1500.0f) {
                if (!(build instanceof Turret.TurretBuild) || ((Turret.TurretBuild)build).isShooting() || ((Turret.TurretBuild)build).isControlled()) {
                    Draw.color((float)1.0f, (float)0.2f, (float)0.2f, (float)0.8f);
                    Lines.stroke(1.5f);
                    Lines.line(build.x, build.y, targetPos.x, targetPos.y);
                    Lines.dashCircle(targetPos.x, targetPos.y, 8.0f);
                } else if (blockWeaponTargetLineWhenIdle) {
                    Draw.color((float)1.0f, (float)1.0f, (float)1.0f, (float)0.3f);
                    Lines.stroke(1.5f);
                    Lines.line(build.x, build.y, targetPos.x, targetPos.y);
                    Lines.dashCircle(targetPos.x, targetPos.y, 8.0f);
                }
            }
        }
    }

    public static void turretPlaceDraw(float x, float y, Turret block) {
        ObjectMap<Item, BulletType> ammoTypes;
        float iconSize = 6.0f + 2.0f * (float)block.size;
        float range = block.range;
        if (block instanceof ContinuousLiquidTurret) {
            ContinuousLiquidTurret t = (ContinuousLiquidTurret)block;
            ammoTypes = t.ammoTypes;
        } else if (block instanceof LiquidTurret) {
            LiquidTurret t = (LiquidTurret)block;
            ammoTypes = t.ammoTypes;
        } else if (block instanceof ItemTurret) {
            ItemTurret t = (ItemTurret)block;
            ammoTypes = t.ammoTypes;
        } else {
            if (block instanceof PowerTurret) {
                float oldZ = Draw.z();
                Draw.z((float)(oldZ + 0.01f));
                ArcBuilds.turretBulletDraw(x, y, Icon.power.getRegion(), iconSize, range, 0.0f);
                Draw.z((float)oldZ);
                return;
            }
            return;
        }
        int drawIndex = 0;
        for (ObjectMap.Entry e : ammoTypes.entries()) {
            UnlockableContent item = (UnlockableContent)((Object)e.key);
            BulletType bulletType = (BulletType)e.value;
            ++drawIndex;
            if (!item.unlockedNow()) {
                return;
            }
            Drawf.dashCircle((float)x, (float)y, (float)(range + bulletType.rangeChange), (Color)Pal.placing);
            ArcBuilds.turretBulletDraw(x, y, item.fullIcon, iconSize, range + bulletType.rangeChange, (float)drawIndex / (float)ammoTypes.size);
        }
    }

    public static void turretSelectDraw(Turret.TurretBuild build) {
        TextureRegion currentAmmo = null;
        if (build.block instanceof ContinuousLiquidTurret || build.block instanceof LiquidTurret) {
            if (build.liquids.currentAmount() > 0.0f) {
                currentAmmo = build.liquids.current().fullIcon;
            }
        } else if (build.block instanceof ItemTurret) {
            if (build.hasAmmo()) {
                currentAmmo = ((ItemTurret.ItemEntry)build.ammo.peek()).item.fullIcon;
            }
        } else if (build.block instanceof PowerTurret) {
            currentAmmo = Icon.power.getRegion();
        } else {
            return;
        }
        if (currentAmmo == null) {
            ArcBuilds.turretPlaceDraw(build.x, build.y, (Turret)((Object)build.block));
            return;
        }
        float iconSize = 6.0f + 2.0f * (float)build.block.size;
        ArcBuilds.turretBulletDraw(build.x, build.y, currentAmmo, iconSize, build.range(), 0.0f);
    }

    private static void turretBulletDraw(float x, float y, TextureRegion icon, float iconSize, float range, float rotOffset) {
        for (int i = 0; i < 4; ++i) {
            float rot = ((float)i + rotOffset) * 90.0f + Time.time * 0.3f;
            Draw.rect((TextureRegion)icon, (float)(x + Mathf.sin((float)((float)Math.toRadians(rot))) * range), (float)(y + Mathf.cos((float)((float)Math.toRadians(rot))) * range), (float)iconSize, (float)iconSize, (float)(-rot));
        }
    }

    static {
        showTurretAmmo = false;
        showTurretAmmoAmount = false;
        blockWeaponTargetLine = false;
        blockWeaponTargetLineWhenIdle = false;
        Events.run((Object)EventType.Trigger.update, () -> {
            turretForceShowRange = Core.settings.getBool("turretForceShowRange");
            turretShowRange = Core.settings.getInt("turretShowRange");
            turretAlertRange = Core.settings.getInt("turretAlertRange") * 8;
            showTurretAmmo = Core.settings.getBool("showTurretAmmo");
            showTurretAmmoAmount = Core.settings.getBool("showTurretAmmoAmount");
            blockWeaponTargetLine = Core.settings.getBool("blockWeaponTargetLine");
            blockWeaponTargetLineWhenIdle = Core.settings.getBool("blockWeaponTargetLineWhenIdle");
        });
    }
}

