/*
 * Decompiled with CFR 0.152.
 */
package mindustryX.features;

import arc.Core;
import arc.Events;
import arc.func.Cons;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.math.Interp;
import arc.math.Mathf;
import arc.math.geom.Position;
import arc.scene.Element;
import arc.scene.event.Touchable;
import arc.scene.style.Style;
import arc.scene.ui.layout.Table;
import arc.util.Strings;
import arc.util.Time;
import arc.util.Tmp;
import java.util.List;
import kotlin.collections.CollectionsKt;
import mindustry.Vars;
import mindustry.game.EventType;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.gen.Groups;
import mindustry.gen.Icon;
import mindustry.gen.Player;
import mindustry.gen.Unit;
import mindustry.graphics.Pal;
import mindustry.ui.Styles;
import mindustry.world.Tile;
import mindustry.world.blocks.storage.CoreBlock;
import mindustryX.features.BindingExt;
import mindustryX.features.MarkerType;
import mindustryX.features.SettingsV2;
import mindustryX.features.UIExt;
import mindustryX.features.func.FuncX;

public class ArcRadar {
    private static final float ratio = 10.0f;
    private static final float unitSize = 0.1f;
    private static final float markerSize = 120.0f;
    private static final int basicRadarCir = 25;
    public static boolean mobileRadar = false;
    private static float rRatio;
    private static float rMarkerSize;
    private static float radarCir;
    private static float scanTime;
    private static float scanRate;
    private static final float scanSpeed = -0.02f;
    private static float curScanRange;
    private static float expandRate;
    private static boolean working;
    private static Table t;
    private static final SettingsV2.Data<Integer> mode;
    private static final SettingsV2.Data<Integer> size;
    public static List<SettingsV2.Data<?>> settings;

    public static void draw() {
        float extendSpd = (float)((Integer)mode.getValue()).intValue() * 0.2f;
        if (extendSpd >= 6.0f) {
            if (BindingExt.arcDetail.keyTap() || mobileRadar) {
                working = !working;
                scanRate = working ? 1.0f : 0.0f;
                mobileRadar = false;
            }
        } else if (BindingExt.arcDetail.keyDown() || mobileRadar) {
            working = true;
            scanRate = Mathf.approachDelta((float)scanRate, (float)1.0f, (float)(1.0f * extendSpd / (60.0f * scanTime)));
        } else {
            working = false;
            scanRate = Mathf.approachDelta((float)scanRate, (float)0.0f, (float)(3.0f * extendSpd / (60.0f * scanTime)));
        }
        if (working && t == null) {
            t = new Table(Styles.black3);
            ArcRadar.t.touchable = Touchable.disabled;
            t.margin(8.0f).add((CharSequence)">> \u96f7\u8fbe\u626b\u63cf\u4e2d <<").color(Pal.accent).style((Style)Styles.outlineLabel);
            t.pack();
            t.visible(() -> working);
            t.update(() -> t.setPosition((float)Core.graphics.getWidth() / 2.0f, (float)Core.graphics.getHeight() * 0.1f, 1));
            Vars.ui.hudGroup.addChild((Element)t);
        }
        if (scanRate <= 0.0f) {
            return;
        }
        float playerToBorder = Math.max(Math.max(Math.max(Mathf.dst((float)Vars.player.tileX(), (float)Vars.player.tileY()), Mathf.dst((float)(Vars.world.width() - Vars.player.tileX()), (float)Vars.player.tileY())), Mathf.dst((float)(Vars.world.width() - Vars.player.tileX()), (float)(Vars.world.height() - Vars.player.tileY()))), Mathf.dst((float)Vars.player.tileX(), (float)(Vars.world.height() - Vars.player.tileY())));
        float worldSize = Math.min(playerToBorder, (float)((int)(Mathf.dst((float)Vars.world.width(), (float)Vars.world.height()) / radarCir)) * radarCir);
        float playerSize = (float)(Math.min(Vars.world.width(), Vars.world.height()) * 8) * 0.03f;
        float sizeRate = (Integer)size.getValue() == 0 ? 1.0f : (float)((Integer)size.getValue()).intValue() * 0.1f / Vars.renderer.getDisplayScale();
        rRatio = 10.0f / (sizeRate *= Math.min(Core.scene.getHeight() / (float)(Vars.world.height() * 8), Core.scene.getWidth() / (float)(Vars.world.width() * 8)) * 2.0f);
        float rUnitSize = 0.1f * sizeRate;
        rMarkerSize = 120.0f * sizeRate;
        expandRate = worldSize / 25.0f / 10.0f + 1.0f;
        radarCir = (int)expandRate * 25;
        curScanRange = worldSize * 8.0f * scanRate;
        expandRate *= sizeRate;
        int i = 1;
        while ((float)i < curScanRange / radarCir / 8.0f + 1.0f) {
            Draw.color((Color)Vars.player.team().color, (float)0.45f);
            Lines.stroke(expandRate * 0.75f);
            Lines.circle(Vars.player.x, Vars.player.y, radarCir * (float)i * 8.0f / rRatio);
            float cirRatio = radarCir * (float)i * 8.0f / rRatio + 2.0f;
            FuncX.drawText((Position)Tmp.v1.trns(30.0f, cirRatio).add((Position)Vars.player), i * (int)radarCir + "", 1.25f * expandRate, Pal.accent);
            FuncX.drawText((Position)Tmp.v1.trns(150.0f, cirRatio).add((Position)Vars.player), i * (int)radarCir + "", 1.25f * expandRate, Pal.accent);
            FuncX.drawText((Position)Tmp.v1.trns(270.0f, cirRatio).add((Position)Vars.player), i * (int)radarCir + "", 1.25f * expandRate, Pal.accent);
            ++i;
        }
        if (scanRate < 1.0f) {
            Draw.color((Color)Vars.player.team().color, (float)0.8f);
            Lines.stroke(expandRate);
            Lines.circle(Vars.player.x, Vars.player.y, curScanRange / rRatio);
            Draw.color((Color)Vars.player.team().color, (float)0.1f);
            Fill.circle((float)Vars.player.x, (float)Vars.player.y, (float)(curScanRange / rRatio));
        } else {
            curScanRange = (float)((int)(curScanRange / radarCir / 8.0f + 1.0f)) * radarCir * 8.0f;
            Draw.color((Color)Vars.player.team().color, (float)0.1f);
            Fill.circle((float)Vars.player.x, (float)Vars.player.y, (float)(curScanRange / rRatio));
            Draw.color((Color)Vars.player.team().color, (float)0.6f);
            float curve = Mathf.curve((float)(Time.time % 360.0f), (float)120.0f, (float)360.0f);
            Lines.stroke(expandRate * 1.5f);
            Lines.circle(Vars.player.x, Vars.player.y, curScanRange / rRatio);
            Lines.stroke(expandRate * 1.5f);
            Lines.circle(Vars.player.x, Vars.player.y, curScanRange * Interp.pow3Out.apply(curve) / rRatio);
            Lines.stroke(expandRate * 1.5f);
            Draw.color((Color)Vars.player.team().color, (float)0.1f);
            Fill.rect((float)(Vars.player.x - Vars.player.x / rRatio + (float)(Vars.world.width() * 8) / rRatio / 2.0f), (float)(Vars.player.y - Vars.player.y / rRatio + (float)(Vars.world.height() * 8) / rRatio / 2.0f), (float)((float)(Vars.world.width() * 8) / rRatio), (float)((float)(Vars.world.height() * 8) / rRatio));
            Draw.color((Color)Vars.player.team().color, (float)0.85f);
            Lines.rect(Vars.player.x - Vars.player.x / rRatio, Vars.player.y - Vars.player.y / rRatio, (float)(Vars.world.width() * 8) / rRatio, (float)(Vars.world.height() * 8) / rRatio);
        }
        Draw.color((Color)Vars.player.team().color, (float)0.8f);
        Lines.line(Vars.player.x, Vars.player.y, Vars.player.x + curScanRange * Mathf.cos((float)(Time.time * -0.02f)) / rRatio, Vars.player.y + curScanRange * Mathf.sin((float)(Time.time * -0.02f)) / rRatio);
        Draw.reset();
        if (Vars.spawner.countSpawns() < 25 && !Vars.state.rules.pvp) {
            for (Tile tile : Vars.spawner.getSpawns()) {
                if (scanRate < 1.0f && Mathf.dst((float)(tile.worldx() - Vars.player.x), (float)(tile.worldy() - Vars.player.y)) > curScanRange) continue;
                Draw.color((Color)Vars.state.rules.waveTeam.color, (float)1.0f);
                ArcRadar.arcDrawNearby(Icon.units.getRegion(), tile, Math.max(6.0f * expandRate, Vars.state.rules.dropZoneRadius / rRatio / 2.0f));
                float curve = Mathf.curve((float)(Time.time % 200.0f), (float)60.0f, (float)200.0f);
                Draw.color((Color)Vars.state.rules.waveTeam.color, (float)1.0f);
                Lines.stroke(expandRate);
                Lines.circle(ArcRadar.transX(tile.worldx()), ArcRadar.transY(tile.worldy()), Vars.state.rules.dropZoneRadius * Interp.pow3Out.apply(curve) / rRatio);
                Draw.color((Color)Vars.state.rules.waveTeam.color, (float)0.5f);
                Lines.stroke(expandRate * 0.8f);
                Lines.dashCircle(ArcRadar.transX(tile.worldx()), ArcRadar.transY(tile.worldy()), Vars.state.rules.dropZoneRadius / rRatio);
            }
        }
        for (Team team : Team.all) {
            for (CoreBlock.CoreBuild core : team.cores()) {
                if (Vars.state.rules.pvp && core.inFogTo(Vars.player.team()) || scanRate < 1.0f && Mathf.dst((float)(core.x - Vars.player.x), (float)(core.y - Vars.player.y)) > curScanRange) continue;
                Draw.color((Color)core.team.color, (float)1.0f);
                Draw.rect((TextureRegion)core.block.fullIcon, (float)ArcRadar.transX(core.tile.worldx()), (float)ArcRadar.transY(core.tile.worldy()), (float)(4.0f * expandRate), (float)(4.0f * expandRate));
            }
        }
        for (Building build : UIExt.advanceBuildTool.buildingSeq) {
            if (scanRate < 1.0f && Mathf.dst((float)(build.x - Vars.player.x), (float)(build.y - Vars.player.y)) > curScanRange) continue;
            Draw.color((Color)build.team.color, (float)1.0f);
            Draw.rect((TextureRegion)build.block.fullIcon, (float)ArcRadar.transX(build.tile.worldx()), (float)ArcRadar.transY(build.tile.worldy()), (float)(4.0f * expandRate), (float)(4.0f * expandRate));
        }
        for (Unit unit : Groups.unit) {
            if (scanRate < 1.0f && Mathf.dst((float)(unit.x - Vars.player.x), (float)(unit.y - Vars.player.y)) > curScanRange) continue;
            Draw.color((Color)unit.team.color, (float)0.6f);
            Fill.circle((float)ArcRadar.transX(unit.x), (float)ArcRadar.transY(unit.y), (float)(unit.hitSize * rUnitSize));
        }
        for (Player unit : Groups.player) {
            if (unit.dead() || scanRate < 1.0f && Mathf.dst((float)(unit.x - Vars.player.x), (float)(unit.y - Vars.player.y)) > curScanRange) continue;
            Draw.color((Color)unit.team().color, (float)0.9f);
            float angle = unit.unit().rotation * ((float)Math.PI / 180);
            Fill.tri((float)ArcRadar.transX(unit.x + Mathf.cos((float)angle) * playerSize), (float)ArcRadar.transY(unit.y + Mathf.sin((float)angle) * playerSize), (float)ArcRadar.transX(unit.x + Mathf.cos((float)(angle + 2.0943952f)) * playerSize * 0.75f), (float)ArcRadar.transY(unit.y + Mathf.sin((float)(angle + 2.0943952f)) * playerSize * 0.75f), (float)ArcRadar.transX(unit.x + Mathf.cos((float)(angle + 4.1887903f)) * playerSize * 0.75f), (float)ArcRadar.transY(unit.y + Mathf.sin((float)(angle + 4.1887903f)) * playerSize * 0.75f));
        }
        MarkerType.eachActive((Cons<MarkerType.MarkElement>)((Cons)a -> {
            Draw.color((Color)a.color);
            Lines.stroke(expandRate * (1.0f - (Time.time % 180.0f + 30.0f) / 210.0f));
            Lines.circle(ArcRadar.transX(a.x), ArcRadar.transY(a.y), rMarkerSize / rRatio * (Time.time % 180.0f) / 180.0f);
            Lines.stroke(expandRate);
            Lines.circle(ArcRadar.transX(a.x), ArcRadar.transY(a.y), rMarkerSize / rRatio);
            Lines.arc(ArcRadar.transX(a.x), ArcRadar.transY(a.y), (rMarkerSize - expandRate) / rRatio, 1.0f - (Time.time - a.time) / 1800.0f);
            Draw.reset();
        }));
    }

    public static void arcDrawNearby(TextureRegion region, Tile tile, float size) {
        float range = Mathf.dst((float)(tile.worldy() - Vars.player.y), (float)(tile.worldx() - Vars.player.x));
        if (range > curScanRange) {
            return;
        }
        float nx = Vars.player.x + (tile.worldx() - Vars.player.x) / rRatio;
        float ny = Vars.player.y + (tile.worldy() - Vars.player.y) / rRatio;
        Draw.rect((TextureRegion)region, (float)nx, (float)ny, (float)size, (float)size);
    }

    private static float transX(float x) {
        return Vars.player.x + (x - Vars.player.x) / rRatio;
    }

    private static float transY(float y) {
        return Vars.player.y + (y - Vars.player.y) / rRatio;
    }

    static {
        radarCir = 25.0f;
        scanTime = 5.0f;
        scanRate = 0.0f;
        curScanRange = 0.0f;
        expandRate = 1.0f;
        working = false;
        mode = new SettingsV2.SliderPref("arcExtra.radarMode", 1, 1, 30, 1, s -> {
            String string;
            switch (s) {
                case 0: {
                    string = "\u5173\u95ed";
                    break;
                }
                case 30: {
                    string = "\u77ac\u95f4\u5b8c\u6210";
                    break;
                }
                default: {
                    string = "[lightgray]x[white]" + Strings.autoFixed((float)((float)s.intValue() * 0.2f), (int)1) + "\u500d\u641c\u7d22\u901f\u5ea6";
                }
            }
            return string;
        });
        size = new SettingsV2.SliderPref("arcExtra.radarSize", 0, 0, 50, 1, s -> {
            if (s == 0) {
                return "\u56fa\u5b9a\u5927\u5c0f";
            }
            return "[lightgray]x[white]" + Strings.autoFixed((float)((float)s.intValue() * 0.1f), (int)1) + "\u500d";
        });
        settings = CollectionsKt.listOf(mode, size);
        mode.addFallbackName("radar.mode");
        size.addFallbackName("radar.size");
        mode.addFallbackName("radarMode");
        size.addFallbackName("radarSize");
        Events.on(EventType.WorldLoadEvent.class, event -> {
            scanTime = Math.max(Mathf.dst((float)Vars.world.width(), (float)Vars.world.height()) / 20.0f, 7.5f);
        });
    }
}

