/*
 * Decompiled with CFR 0.152.
 */
package mindustryX.features;

import arc.Events;
import arc.func.Boolf;
import arc.graphics.Color;
import arc.scene.ui.layout.Table;
import arc.struct.Seq;
import mindustry.Vars;
import mindustry.content.StatusEffects;
import mindustry.core.UI;
import mindustry.game.EventType;
import mindustry.game.SpawnGroup;
import mindustry.graphics.Pal;
import mindustry.type.UnitType;
import mindustryX.features.ui.FormatDefault;

public class ArcWaveSpawner {
    public static boolean hasFlyer = true;
    private static final Seq<WaveInfo> arcWaveCache = new Seq();
    private static Seq<SpawnGroup> groups = Vars.state.rules.spawns;

    public static void reload(Seq<SpawnGroup> groups2) {
        groups = groups2;
        hasFlyer = groups2.contains(sg -> sg.type.flying);
        arcWaveCache.clear();
    }

    public static WaveInfo getOrInit(int wave) {
        wave = Math.min(wave, ArcWaveSpawner.calWinWaveClamped());
        while (ArcWaveSpawner.arcWaveCache.size <= wave) {
            arcWaveCache.add((Object)new WaveInfo(ArcWaveSpawner.arcWaveCache.size));
        }
        return (WaveInfo)arcWaveCache.get(wave);
    }

    public static int calWinWave() {
        if (Vars.state.rules.winWave >= 1) {
            return Vars.state.rules.winWave;
        }
        int maxwave = 1;
        for (SpawnGroup group : groups) {
            maxwave = Math.max(maxwave, group.end);
        }
        return maxwave;
    }

    public static int calWinWaveClamped() {
        return Math.min(ArcWaveSpawner.calWinWave(), 10000);
    }

    public static Color unitTypeColor(UnitType type) {
        if (type.naval) {
            return Color.cyan;
        }
        if (type.allowLegStep) {
            return Color.magenta;
        }
        if (type.flying) {
            return Color.acid;
        }
        if (type.hovering) {
            return Color.sky;
        }
        return Pal.stat;
    }

    static {
        Events.on(EventType.WorldLoadEvent.class, event -> ArcWaveSpawner.reload(Vars.state.rules.spawns));
    }

    public static class WaveInfo {
        public final int wave;
        public final Seq<WaveGroup> groups = new Seq();
        public int amount = 0;
        public float health = 0.0f;
        public float effHealth = 0.0f;
        public float dps = 0.0f;

        WaveInfo(int wave) {
            this.wave = wave;
            for (SpawnGroup group : groups) {
                int amount = group.getSpawned(wave);
                if (amount == 0) continue;
                this.groups.add((Object)new WaveGroup(wave, group));
            }
            this.initProperty();
        }

        private void initProperty() {
            this.groups.each(group -> {
                this.amount += group.amountT;
                this.health += group.healthT;
                this.effHealth += group.effHealthT;
                this.dps += group.dpsT;
            });
        }

        public Table proTable(boolean doesRow, int spawn, Boolf<SpawnGroup> filter) {
            int amount = 0;
            this.dps = 0.0f;
            this.effHealth = 0.0f;
            float health = 0.0f;
            for (WaveGroup group : this.groups) {
                if (spawn != -1 && group.group.spawn != -1 && group.group.spawn != spawn || !filter.get((Object)group.group)) continue;
                amount += group.amountT;
                health += group.healthT;
                this.effHealth += group.effHealthT;
                this.dps += group.dpsT;
            }
            if (amount == 0) {
                return new Table(t -> t.add((CharSequence)"\u8be5\u6ce2\u6b21\u6ca1\u6709\u654c\u4eba"));
            }
            Table t2 = new Table();
            t2.add((CharSequence)"\ue86d").width(50.0f);
            t2.add((CharSequence)("[accent]" + amount)).growX().padRight(50.0f);
            if (doesRow) {
                t2.row();
            }
            t2.add((CharSequence)"\ue813").width(50.0f);
            t2.add((CharSequence)("[accent]" + UI.formatAmount((long)health))).growX().padRight(50.0f);
            if (doesRow) {
                t2.row();
            }
            if (this.effHealth != health) {
                t2.add((CharSequence)"\ue810").width(50.0f);
                t2.add((CharSequence)("[accent]" + UI.formatAmount((long)this.effHealth))).growX().padRight(50.0f);
                if (doesRow) {
                    t2.row();
                }
            }
            t2.add((CharSequence)"\ue86e").width(50.0f);
            t2.add((CharSequence)("[accent]" + UI.formatAmount((long)this.dps))).growX();
            return t2;
        }

        public Table unitTable(int spawn, Boolf<SpawnGroup> pre) {
            return this.unitTable(spawn, pre, 10);
        }

        public Table unitTable(int spawn, Boolf<SpawnGroup> pre, int perCol) {
            int[] count = new int[1];
            return new Table(t -> this.groups.each(waveGroup -> (spawn == -1 || waveGroup.group.spawn == -1 || waveGroup.group.spawn == spawn) && pre.get((Object)waveGroup.group), wg -> {
                count[0] = count[0] + 1;
                if (count[0] % perCol == 0) {
                    t.row();
                }
                t.table(tt -> {
                    tt.table(ttt -> {
                        ttt.image(wg.group.type.uiIcon).size(30.0f);
                        ttt.add((CharSequence)("" + wg.amount)).color(ArcWaveSpawner.unitTypeColor(wg.group.type)).fillX();
                    }).row();
                    StringBuilder groupInfo = new StringBuilder();
                    if (wg.shield > 0.0f) {
                        groupInfo.append(FormatDefault.format(wg.shield));
                    }
                    groupInfo.append("\n[]");
                    if (wg.group.spawn != -1 && spawn == -1) {
                        groupInfo.append("*");
                    }
                    if (wg.group.effect != null && wg.group.effect != StatusEffects.none) {
                        groupInfo.append(wg.group.effect.emoji());
                    }
                    if (wg.group.items != null && wg.group.items.amount > 0) {
                        groupInfo.append(wg.group.items.item.emoji());
                    }
                    if (wg.group.payloads != null && wg.group.payloads.size > 0) {
                        groupInfo.append("\ue87b");
                    }
                    tt.add((CharSequence)groupInfo.toString()).fill();
                }).height(80.0f).width(70.0f);
            }));
        }
    }

    public static class WaveGroup {
        public final int wave;
        public final SpawnGroup group;
        public final int amount;
        public final float shield;
        public final float health;
        public final float effHealth;
        public final float dps;
        public final int amountT;
        public final float healthT;
        public final float effHealthT;
        public final float dpsT;

        public WaveGroup(int wave, SpawnGroup group) {
            this.wave = wave;
            this.group = group;
            this.amount = group.getSpawned(wave);
            this.shield = group.getShield(wave);
            this.health = (group.type.health + this.shield) * (float)this.amount;
            this.effHealth = this.health * (group.effect != null ? group.effect.healthMultiplier : 1.0f);
            this.dps = group.type.estimateDps() * (float)this.amount * (group.effect != null ? group.effect.damageMultiplier * group.effect.reloadMultiplier : 1.0f);
            int multiplier = group.spawn != -1 || Vars.spawner.countSpawns() < 2 ? 1 : Vars.spawner.countSpawns();
            this.amountT = this.amount * multiplier;
            this.healthT = this.health * (float)multiplier;
            this.effHealthT = this.effHealth * (float)multiplier;
            this.dpsT = this.dps * (float)multiplier;
        }
    }
}

