/*
 * Decompiled with CFR 0.152.
 */
package mindustryX.features;

import arc.Core;
import arc.Events;
import arc.files.Fi;
import arc.func.Cons;
import arc.func.ConsT;
import arc.graphics.Color;
import arc.math.Mathf;
import arc.scene.Element;
import arc.scene.style.Drawable;
import arc.scene.ui.ScrollPane;
import arc.scene.ui.TextButton;
import arc.scene.ui.layout.Table;
import arc.struct.Seq;
import arc.util.Http;
import arc.util.Log;
import arc.util.OS;
import arc.util.Strings;
import arc.util.io.Streams;
import arc.util.serialization.Jval;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import mindustry.Vars;
import mindustry.core.Version;
import mindustry.game.EventType;
import mindustry.gen.Icon;
import mindustry.graphics.Pal;
import mindustry.net.BeControl;
import mindustry.ui.Bar;
import mindustry.ui.Styles;
import mindustry.ui.dialogs.BaseDialog;
import mindustryX.VarsX;
import mindustryX.features.SettingsV2;
import mindustryX.features.UIExt;
import mindustryX.features.UIExtKt;
import mindustryX.features.ui.CommitsTable;
import mindustryX.features.ui.Format;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001<B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010+\u001a\u00020,J(\u0010-\u001a\u00020,2\u0006\u0010.\u001a\u00020\t2\u0018\u0010/\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\u0004\u0012\u00020,00J\u0006\u00101\u001a\u00020,J\b\u00102\u001a\u00020,H\u0002J\u0014\u00103\u001a\u00020,2\n\b\u0002\u00104\u001a\u0004\u0018\u00010\fH\u0007J$\u00105\u001a\u00020,2\u0006\u00106\u001a\u0002072\u0012\u00108\u001a\u000e\u0012\u0004\u0012\u000209\u0012\u0004\u0012\u00020,00H\u0002J\u0010\u0010:\u001a\u00020,2\u0006\u0010;\u001a\u000209H\u0002R\u0011\u0010\u0004\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R \u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0013\u0010\u0011\u001a\u0004\u0018\u00010\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u001c\u0010\u0014\u001a\u0004\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u0013\u0010\u0019\u001a\u0004\u0018\u00010\f8F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0016R\u0011\u0010\u001b\u001a\u00020\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0017\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\t0 \u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0017\u0010#\u001a\b\u0012\u0004\u0012\u00020\t0 \u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\"R\u001b\u0010%\u001a\u00020&8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b)\u0010*\u001a\u0004\b'\u0010(\u00a8\u0006="}, d2={"LmindustryX/features/AutoUpdate;", "", "<init>", "()V", "active", "", "getActive", "()Z", "devRepo", "", "versions", "", "LmindustryX/features/AutoUpdate$Release;", "getVersions", "()Ljava/util/List;", "setVersions", "(Ljava/util/List;)V", "currentBranch", "getCurrentBranch", "()Ljava/lang/String;", "latest", "getLatest", "()LmindustryX/features/AutoUpdate$Release;", "setLatest", "(LmindustryX/features/AutoUpdate$Release;)V", "newVersion", "getNewVersion", "showUpdateDialog", "LmindustryX/features/SettingsV2$CheckPref;", "getShowUpdateDialog", "()LmindustryX/features/SettingsV2$CheckPref;", "ignoreOnce", "LmindustryX/features/SettingsV2$Data;", "getIgnoreOnce", "()LmindustryX/features/SettingsV2$Data;", "ignoreUntil", "getIgnoreUntil", "commitsTable", "LmindustryX/features/ui/CommitsTable;", "getCommitsTable", "()LmindustryX/features/ui/CommitsTable;", "commitsTable$delegate", "Lkotlin/Lazy;", "initUI", "", "getReleases", "repo", "result", "Lkotlin/Function1;", "checkUpdate", "fetchSuccess", "showDialog", "version", "startDownload", "asset", "LmindustryX/features/AutoUpdate$Release$Asset;", "endDownload", "Larc/files/Fi;", "installDesktopJar", "file", "Release", "core"})
@SourceDebugExtension(value={"SMAP\nAutoUpdate.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AutoUpdate.kt\nmindustryX/features/AutoUpdate\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,282:1\n1#2:283\n774#3:284\n865#3,2:285\n1971#3,14:287\n774#3:301\n865#3,2:302\n774#3:304\n865#3,2:305\n1863#3,2:310\n1062#3:312\n827#3:313\n855#3,2:314\n1863#3,2:316\n3829#4:307\n4344#4,2:308\n*S KotlinDebug\n*F\n+ 1 AutoUpdate.kt\nmindustryX/features/AutoUpdate\n*L\n113#1:284\n113#1:285,2\n114#1:287,14\n168#1:301\n168#1:302,2\n172#1:304\n172#1:305,2\n227#1:310,2\n93#1:312\n101#1:313\n101#1:314,2\n135#1:316,2\n227#1:307\n227#1:308,2\n*E\n"})
public final class AutoUpdate {
    @NotNull
    public static final AutoUpdate INSTANCE;
    @NotNull
    public static final String devRepo = "TinyLake/MindustryX-work";
    @NotNull
    private static List<Release> versions;
    @Nullable
    private static Release latest;
    @NotNull
    private static final SettingsV2.CheckPref showUpdateDialog;
    @NotNull
    private static final SettingsV2.Data<String> ignoreOnce;
    @NotNull
    private static final SettingsV2.Data<String> ignoreUntil;
    @NotNull
    private static final Lazy commitsTable$delegate;

    private AutoUpdate() {
    }

    public final boolean getActive() {
        return !VarsX.devVersion;
    }

    @NotNull
    public final List<Release> getVersions() {
        return versions;
    }

    public final void setVersions(@NotNull List<Release> list) {
        Intrinsics.checkNotNullParameter(list, "<set-?>");
        versions = list;
    }

    @Nullable
    public final String getCurrentBranch() {
        char[] cArray = new char[]{'-'};
        return (String)CollectionsKt.getOrNull(StringsKt.split$default((CharSequence)VarsX.version, cArray, false, 2, 2, null), 1);
    }

    @Nullable
    public final Release getLatest() {
        return latest;
    }

    public final void setLatest(@Nullable Release release) {
        latest = release;
    }

    @Nullable
    public final Release getNewVersion() {
        Release release;
        Release release2 = latest;
        if (release2 != null) {
            Release release3;
            Release it = release3 = release2;
            boolean bl = false;
            release = it.getVersion().compareTo(VarsX.version) > 0 ? release3 : null;
        } else {
            release = null;
        }
        return release;
    }

    @NotNull
    public final SettingsV2.CheckPref getShowUpdateDialog() {
        return showUpdateDialog;
    }

    @NotNull
    public final SettingsV2.Data<String> getIgnoreOnce() {
        return ignoreOnce;
    }

    @NotNull
    public final SettingsV2.Data<String> getIgnoreUntil() {
        return ignoreUntil;
    }

    private final CommitsTable getCommitsTable() {
        Lazy lazy = commitsTable$delegate;
        return (CommitsTable)((Object)lazy.getValue());
    }

    public final void initUI() {
        Vars.ui.menuGroup.fill(AutoUpdate::initUI$lambda$8);
    }

    public final void getReleases(@NotNull String repo, @NotNull Function1<? super List<Release>, Unit> result) {
        Intrinsics.checkNotNullParameter(repo, "repo");
        Intrinsics.checkNotNullParameter(result, "result");
        Http.get("https://api.github.com/repos/" + repo + "/releases").timeout(30000).error((Cons<Throwable>)((Cons)arg_0 -> AutoUpdate.getReleases$lambda$9(repo, result, arg_0))).submit((ConsT<Http.HttpResponse, Exception>)((ConsT)arg_0 -> AutoUpdate.getReleases$lambda$12(result, repo, arg_0)));
    }

    public final void checkUpdate() {
        if (!((Collection)versions).isEmpty()) {
            return;
        }
        this.getReleases("TinyLake/MindustryX", AutoUpdate::checkUpdate$lambda$16);
    }

    /*
     * WARNING - void declaration
     */
    private final void fetchSuccess() {
        Release newVersion;
        block15: {
            block14: {
                Object object;
                Object v0;
                Release it;
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv = versions;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it = (Release)element$iv$iv;
                    boolean bl = false;
                    if (!it.matchCurrent()) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List available = (List)destination$iv$iv;
                Iterable $this$maxByOrNull$iv = available;
                boolean $i$f$maxByOrNull = false;
                Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
                if (!iterator$iv.hasNext()) {
                    v0 = null;
                } else {
                    Object maxElem$iv = iterator$iv.next();
                    if (!iterator$iv.hasNext()) {
                        v0 = maxElem$iv;
                    } else {
                        Release it2 = (Release)maxElem$iv;
                        boolean bl = false;
                        Comparable maxValue$iv = (Comparable)((Object)it2.getVersion());
                        do {
                            Object e$iv = iterator$iv.next();
                            it = (Release)e$iv;
                            $i$a$-maxByOrNull-AutoUpdate$fetchSuccess$1 = false;
                            Comparable v$iv = (Comparable)((Object)it.getVersion());
                            if (maxValue$iv.compareTo(v$iv) >= 0) continue;
                            maxElem$iv = e$iv;
                            maxValue$iv = v$iv;
                        } while (iterator$iv.hasNext());
                        v0 = maxElem$iv;
                    }
                }
                Release release = v0;
                if (release == null) {
                    return;
                }
                latest = release;
                Release release2 = this.getNewVersion();
                if (release2 == null) {
                    return;
                }
                newVersion = release2;
                if (!((Boolean)showUpdateDialog.getValue()).booleanValue() || Intrinsics.areEqual(ignoreOnce.getValue(), newVersion.getVersion())) break block14;
                try {
                    boolean bl = false;
                    object = Result.constructor-impl(Instant.parse((CharSequence)ignoreUntil.getValue()).compareTo(Instant.now()) > 0);
                }
                catch (Throwable throwable) {
                    object = Result.constructor-impl(ResultKt.createFailure(throwable));
                }
                if (!Intrinsics.areEqual(Result.isFailure-impl(object) ? null : object, true)) break block15;
            }
            return;
        }
        if (Vars.clientLoaded) {
            this.showDialog(newVersion);
            return;
        }
        Events.on(EventType.ClientLoadEvent.class, AutoUpdate::fetchSuccess$lambda$20);
    }

    @JvmOverloads
    public final void showDialog(@Nullable Release version) {
        Release it;
        this.checkUpdate();
        BaseDialog dialog = new BaseDialog("\u81ea\u52a8\u66f4\u65b0");
        dialog.getCell((Element)dialog.cont).setElement((Element)new ScrollPane((Element)dialog.cont));
        Element element = dialog.cont.table().growY().get();
        Table $this$showDialog_u24lambda_u2439 = (Table)element;
        boolean bl = false;
        $this$showDialog_u24lambda_u2439.add((CharSequence)("\u5f53\u524d\u7248\u672c\u53f7: " + VarsX.version)).labelAlign(1).width(500.0f).row();
        Release release = INSTANCE.getNewVersion();
        if (release != null) {
            it = release;
            boolean bl2 = false;
            $this$showDialog_u24lambda_u2439.add((CharSequence)("[green]\u53d1\u73b0\u65b0\u7248\u672c[]: " + it.getVersion())).row();
        }
        if (versions.isEmpty()) {
            $this$showDialog_u24lambda_u2439.add((CharSequence)"\u68c0\u67e5\u66f4\u65b0\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5").row();
        } else {
            Release it2;
            Iterable $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            $this$showDialog_u24lambda_u2439.image().fillX().height(2.0f).row();
            $this$showDialog_u24lambda_u2439.add((CharSequence)"\u6b63\u5f0f\u7248").row();
            Iterable iterable = versions;
            BaseDialog baseDialog = dialog;
            Release release2 = version;
            Table table2 = $this$showDialog_u24lambda_u2439;
            boolean $i$f$filter = false;
            it = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it2 = (Release)element$iv$iv;
                boolean bl3 = false;
                if (!it2.isRelease()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List list = (List)destination$iv$iv;
            AutoUpdate.showDialog$lambda$39$buildVersionList(table2, release2, baseDialog, list);
            $this$showDialog_u24lambda_u2439.image().fillX().height(2.0f).row();
            $this$showDialog_u24lambda_u2439.add((CharSequence)"\u9884\u89c8\u7248(\u66f4\u65b0\u66f4\u5feb,\u65b0\u529f\u80fd\u4f53\u9a8c,BUG\u4fee\u590d)").row();
            $this$filter$iv = versions;
            baseDialog = dialog;
            release2 = version;
            table2 = $this$showDialog_u24lambda_u2439;
            $i$f$filter = false;
            $this$filterTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it2 = (Release)element$iv$iv;
                boolean bl4 = false;
                if (!(!it2.isRelease())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
            AutoUpdate.showDialog$lambda$39$buildVersionList(table2, release2, baseDialog, list);
            $this$showDialog_u24lambda_u2439.image().fillX().height(2.0f).row();
            if (version == null) {
                $this$showDialog_u24lambda_u2439.add((CharSequence)"\u4f60\u5df2\u662f\u6700\u65b0\u7248\u672c\uff0c\u4e0d\u9700\u8981\u66f4\u65b0\uff01");
            } else {
                Release.Asset asset = version.findAsset();
                Ref.ObjectRef url = new Ref.ObjectRef();
                Release.Asset asset2 = asset;
                String string = asset2 != null ? asset2.getUrl() : null;
                if (string == null) {
                    string = "";
                }
                url.element = string;
                Element element2 = $this$showDialog_u24lambda_u2439.table().fillX().get();
                Table $this$showDialog_u24lambda_u2439_u24lambda_u2433 = (Table)element2;
                boolean bl5 = false;
                $this$showDialog_u24lambda_u2439_u24lambda_u2433.field((String)url.element, arg_0 -> AutoUpdate.showDialog$lambda$39$lambda$33$lambda$31(url, arg_0)).growX();
                $this$showDialog_u24lambda_u2439_u24lambda_u2433.button("\u2650", () -> AutoUpdate.showDialog$lambda$39$lambda$33$lambda$32(url)).width(50.0f);
                $this$showDialog_u24lambda_u2439.row();
                $this$showDialog_u24lambda_u2439.button("\u81ea\u52a8\u4e0b\u8f7d\u66f4\u65b0", () -> AutoUpdate.showDialog$lambda$39$lambda$35(asset, url)).fillX().row();
                if (Intrinsics.areEqual(version, INSTANCE.getNewVersion())) {
                    element2 = $this$showDialog_u24lambda_u2439.table().fillX().get();
                    Table $this$showDialog_u24lambda_u2439_u24lambda_u2438 = (Table)element2;
                    boolean bl6 = false;
                    $this$showDialog_u24lambda_u2439_u24lambda_u2438.button(ignoreOnce.getTitle(), () -> AutoUpdate.showDialog$lambda$39$lambda$38$lambda$36(version, dialog)).growX();
                    $this$showDialog_u24lambda_u2439_u24lambda_u2438.button(ignoreUntil.getTitle(), () -> AutoUpdate.showDialog$lambda$39$lambda$38$lambda$37(dialog)).growX();
                    ((Table)element2).row();
                }
            }
        }
        dialog.cont.row();
        dialog.cont.add((Element)this.getCommitsTable()).height(Core.scene.getHeight() * 0.3f).width(500.0f);
        dialog.addCloseButton();
        dialog.show();
    }

    public static /* synthetic */ void showDialog$default(AutoUpdate autoUpdate, Release release, int n, Object object) {
        if ((n & 1) != 0) {
            release = latest;
        }
        autoUpdate.showDialog(release);
    }

    /*
     * WARNING - void declaration
     */
    private final void startDownload(Release.Asset asset, Function1<? super Fi, Unit> endDownload) {
        BaseDialog baseDialog;
        void $this$forEach$iv;
        Iterator $this$filterTo$iv$iv;
        Fi file = Vars.bebuildDirectory.child(asset.getName());
        Fi[] fiArray = Vars.bebuildDirectory.list();
        Intrinsics.checkNotNullExpressionValue(fiArray, "list(...)");
        Object $this$filter$iv = fiArray;
        boolean $i$f$filter = false;
        Object[] objectArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (void element$iv$iv : $this$filterTo$iv$iv) {
            Fi it = (Fi)element$iv$iv;
            boolean bl = false;
            if (!(!Intrinsics.areEqual(it.name(), asset.getName()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Fi it = (Fi)element$iv;
            boolean bl = false;
            Log.info((String)("Delete old update file: " + it.name()), (Object[])new Object[0]);
            it.delete();
        }
        Ref.FloatRef progress = new Ref.FloatRef();
        Ref.FloatRef length = new Ref.FloatRef();
        Ref.BooleanRef canceled = new Ref.BooleanRef();
        BaseDialog $this$startDownload_u24lambda_u2447 = baseDialog = new BaseDialog("@be.updating");
        boolean bl = false;
        $this$startDownload_u24lambda_u2447.cont.add((Element)new Bar(() -> AutoUpdate.startDownload$lambda$47$lambda$43(length, progress), AutoUpdate::startDownload$lambda$47$lambda$44, () -> AutoUpdate.startDownload$lambda$47$lambda$45(progress))).width(400.0f).height(70.0f);
        $this$startDownload_u24lambda_u2447.buttons.button("@cancel", (Drawable)Icon.cancel, () -> AutoUpdate.startDownload$lambda$47$lambda$46(canceled, $this$startDownload_u24lambda_u2447)).size(210.0f, 64.0f);
        $this$startDownload_u24lambda_u2447.setFillParent(false);
        $this$startDownload_u24lambda_u2447.show();
        BaseDialog dialog = baseDialog;
        Http.get(asset.getUrl()).timeout(30000).error((Cons<Throwable>)((Cons)arg_0 -> AutoUpdate.startDownload$lambda$48(dialog, arg_0))).submit((ConsT<Http.HttpResponse, Exception>)((ConsT)arg_0 -> AutoUpdate.startDownload$lambda$53(file, dialog, length, canceled, endDownload, progress, arg_0)));
    }

    private final void installDesktopJar(Fi file) {
        String[] stringArray;
        String[] stringArray2;
        Fi fileDest;
        Fi fi = fileDest = OS.hasProp((String)"becopy") ? Fi.get((String)OS.prop((String)"becopy")) : Fi.get((String)BeControl.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath());
        if (OS.isMac) {
            stringArray2 = new String[]{Vars.javaPath, "-XstartOnFirstThread", "-DlastBuild=" + Version.build, "-Dberestart", "-Dbecopy=" + fileDest.absolutePath(), "-jar", file.absolutePath()};
            stringArray = stringArray2;
        } else {
            stringArray2 = new String[]{Vars.javaPath, "-DlastBuild=" + Version.build, "-Dberestart", "-Dbecopy=" + fileDest.absolutePath(), "-jar", file.absolutePath()};
            stringArray = stringArray2;
        }
        String[] args = stringArray;
        Runtime.getRuntime().exec(args);
        Core.app.exit();
    }

    @JvmOverloads
    public final void showDialog() {
        AutoUpdate.showDialog$default(this, null, 1, null);
    }

    private static final CommitsTable commitsTable_delegate$lambda$2() {
        return new CommitsTable("TinyLake/MindustryX");
    }

    private static final void initUI$lambda$8$lambda$3() {
        UIExt.openURI("https://github.com/TinyLake/MindustryX");
    }

    private static final void initUI$lambda$8$lambda$4() {
        UIExt.openURI("https://qm.qq.com/cgi-bin/qm/qr?k=EpvRLTE26gKzbs8WVDxUomwu34k7a-w8&jump_from=webapi&authKey=nPltwJhZjjkhi6O4Nb/hQXhF9bn1fSK2lzo077KLOY4g2Ua80Itx1vp8PY1aDtq+");
    }

    private static final void initUI$lambda$8$lambda$5() {
        AutoUpdate.showDialog$default(INSTANCE, null, 1, null);
    }

    private static final void initUI$lambda$8$lambda$7(TextButton it) {
        Color color;
        Color $this$initUI_u24lambda_u248_u24lambda_u247_u24lambda_u246 = color = it.getLabel().color;
        boolean bl = false;
        $this$initUI_u24lambda_u248_u24lambda_u247_u24lambda_u246.set(Color.white);
        if (INSTANCE.getNewVersion() != null) {
            $this$initUI_u24lambda_u248_u24lambda_u247_u24lambda_u246.lerp(Pal.accent, Mathf.absin((float)5.0f, (float)1.0f));
        }
    }

    private static final void initUI$lambda$8(Table c) {
        c.bottom().right().defaults().size(200.0f, 60.0f);
        c.button("@mdtx.report", (Drawable)Icon.github, AutoUpdate::initUI$lambda$8$lambda$3).row();
        c.button("@mdtx.qqLink", (Drawable)Icon.units, AutoUpdate::initUI$lambda$8$lambda$4).row();
        c.button("@be.check", (Drawable)Icon.refresh, AutoUpdate::initUI$lambda$8$lambda$5).update(AutoUpdate::initUI$lambda$8$lambda$7);
    }

    private static final void getReleases$lambda$9(String $repo, Function1 $result, Throwable it) {
        Log.warn((String)("Fetch releases fail from " + $repo + ": " + it), (Object[])new Object[0]);
        $result.invoke(CollectionsKt.emptyList());
    }

    private static final Release getReleases$lambda$12$lambda$10(String $repo, Jval it) {
        String string = it.getString("html_url");
        Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
        String string2 = it.getString("tag_name");
        Intrinsics.checkNotNullExpressionValue(string2, "getString(...)");
        String string3 = it.getString("name");
        Intrinsics.checkNotNullExpressionValue(string3, "getString(...)");
        Intrinsics.checkNotNull(it);
        return new Release($repo, string, string2, string3, it);
    }

    /*
     * WARNING - void declaration
     */
    private static final void getReleases$lambda$12(Function1 $result, String $repo, Http.HttpResponse res) {
        void $this$sortedByDescending$iv;
        Jval json = Jval.read((String)res.getResultAsString());
        Seq seq = json.asArray().map(arg_0 -> AutoUpdate.getReleases$lambda$12$lambda$10($repo, arg_0));
        Intrinsics.checkNotNullExpressionValue(seq, "map(...)");
        Iterable iterable = (Iterable)seq;
        boolean $i$f$sortedByDescending = false;
        List releases = CollectionsKt.sortedWith($this$sortedByDescending$iv, new Comparator(){

            public final int compare(T a, T b) {
                Release it = (Release)b;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getVersion());
                it = (Release)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, (Comparable)((Object)it.getVersion()));
            }
        });
        $result.invoke(releases);
    }

    private static final void checkUpdate$lambda$16$lambda$15$lambda$14() {
        INSTANCE.fetchSuccess();
    }

    private static final Unit checkUpdate$lambda$16$lambda$15(List $versions, List devVersions) {
        Intrinsics.checkNotNullParameter(devVersions, "devVersions");
        versions = CollectionsKt.plus((Collection)$versions, (Iterable)devVersions);
        Core.app.post(AutoUpdate::checkUpdate$lambda$16$lambda$15$lambda$14);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit checkUpdate$lambda$16(List versions0) {
        void $this$filterNotTo$iv$iv;
        Intrinsics.checkNotNullParameter(versions0, "versions0");
        Iterable $this$filterNot$iv = versions0;
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            Release it = (Release)element$iv$iv;
            boolean bl = false;
            if (((CharSequence)it.getVersion()).length() == 0 || StringsKt.startsWith$default(it.getVersion(), "v", false, 2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List versions = (List)destination$iv$iv;
        INSTANCE.getReleases(devRepo, arg_0 -> AutoUpdate.checkUpdate$lambda$16$lambda$15(versions, arg_0));
        return Unit.INSTANCE;
    }

    private static final void fetchSuccess$lambda$20(EventType.ClientLoadEvent it) {
        AutoUpdate.showDialog$default(INSTANCE, null, 1, null);
    }

    private static final void showDialog$lambda$39$buildVersionList$lambda$27$lambda$26$lambda$21(BaseDialog $dialog, Release $it, boolean bl) {
        $dialog.hide();
        INSTANCE.showDialog($it);
    }

    private static final void showDialog$lambda$39$buildVersionList$lambda$27$lambda$26$lambda$24$lambda$23$lambda$22(Release $it, Table p) {
        p.add((CharSequence)$it.getDescription()).labelAlign(8);
    }

    private static final Unit showDialog$lambda$39$buildVersionList$lambda$27$lambda$26$lambda$24$lambda$23(Release $it, Table $this$showFloatSettingsPanel) {
        Intrinsics.checkNotNullParameter($this$showFloatSettingsPanel, "$this$showFloatSettingsPanel");
        $this$showFloatSettingsPanel.pane(arg_0 -> AutoUpdate.showDialog$lambda$39$buildVersionList$lambda$27$lambda$26$lambda$24$lambda$23$lambda$22($it, arg_0)).row();
        return Unit.INSTANCE;
    }

    private static final void showDialog$lambda$39$buildVersionList$lambda$27$lambda$26$lambda$24(Release $it) {
        UIExtKt.showFloatSettingsPanel(arg_0 -> AutoUpdate.showDialog$lambda$39$buildVersionList$lambda$27$lambda$26$lambda$24$lambda$23($it, arg_0));
    }

    private static final void showDialog$lambda$39$buildVersionList$lambda$27$lambda$26$lambda$25(Release $it) {
        UIExt.openURI($it.getUrl());
    }

    private static final void showDialog$lambda$39$buildVersionList(Table $this_apply, Release $version, BaseDialog dialog, List<Release> versions) {
        Element element = $this_apply.table().fillX().get();
        Table $this$showDialog_u24lambda_u2439_u24buildVersionList_u24lambda_u2427 = (Table)element;
        boolean bl = false;
        Iterable $this$forEach$iv = versions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Release it = (Release)element$iv;
            boolean bl2 = false;
            $this$showDialog_u24lambda_u2439_u24buildVersionList_u24lambda_u2427.check(it.getVersion(), Intrinsics.areEqual($version, it), arg_0 -> AutoUpdate.showDialog$lambda$39$buildVersionList$lambda$27$lambda$26$lambda$21(dialog, it, arg_0)).left().expandX();
            if (((CharSequence)it.getDescription()).length() > 0) {
                $this$showDialog_u24lambda_u2439_u24buildVersionList_u24lambda_u2427.button((Drawable)Icon.infoCircle, Styles.clearNonei, 24.0f, () -> AutoUpdate.showDialog$lambda$39$buildVersionList$lambda$27$lambda$26$lambda$24(it)).tooltip("\u53d1\u5e03\u8bf4\u660e").padRight(16.0f);
            }
            $this$showDialog_u24lambda_u2439_u24buildVersionList_u24lambda_u2427.button((Drawable)Icon.link, Styles.clearNonei, 24.0f, () -> AutoUpdate.showDialog$lambda$39$buildVersionList$lambda$27$lambda$26$lambda$25(it)).tooltip("\u6253\u5f00\u53d1\u5e03\u9875\u9762").padRight(4.0f).row();
        }
        $this_apply.row();
    }

    private static final void showDialog$lambda$39$lambda$33$lambda$31(Ref.ObjectRef $url, String it) {
        $url.element = it;
    }

    private static final void showDialog$lambda$39$lambda$33$lambda$32(Ref.ObjectRef $url) {
        UIExt.openURI((String)$url.element);
    }

    private static final Unit showDialog$lambda$39$lambda$35$lambda$34(Fi file) {
        Intrinsics.checkNotNullParameter(file, "file");
        if (VarsX.isLoader) {
            Vars.mods.importMod(file);
            file.delete();
            Vars.ui.mods.show();
        } else if (OS.isAndroid) {
            Vars.platform.shareFile(file);
        } else {
            INSTANCE.installDesktopJar(file);
        }
        return Unit.INSTANCE;
    }

    private static final void showDialog$lambda$39$lambda$35(Release.Asset $asset, Ref.ObjectRef $url) {
        if ($asset == null) {
            return;
        }
        INSTANCE.startDownload(Release.Asset.copy$default($asset, null, (String)$url.element, 1, null), AutoUpdate::showDialog$lambda$39$lambda$35$lambda$34);
    }

    private static final void showDialog$lambda$39$lambda$38$lambda$36(Release $version, BaseDialog $dialog) {
        ignoreOnce.set($version.getVersion());
        $dialog.hide();
    }

    private static final void showDialog$lambda$39$lambda$38$lambda$37(BaseDialog $dialog) {
        String string = Instant.now().plus(Duration.ofDays(7L)).toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        ignoreOnce.set(string);
        $dialog.hide();
    }

    private static final CharSequence startDownload$lambda$47$lambda$43(Ref.FloatRef $length, Ref.FloatRef $progress) {
        if ($length.element == 0.0f) {
            return Core.bundle.get("be.updating");
        }
        Format $this$startDownload_u24lambda_u2447_u24lambda_u2443_u24lambda_u2442 = new Format(0, true, 1, null);
        boolean bl = false;
        return $this$startDownload_u24lambda_u2447_u24lambda_u2443_u24lambda_u2442.format($progress.element * $length.element) + '/' + $this$startDownload_u24lambda_u2447_u24lambda_u2443_u24lambda_u2442.format($length.element) + "MB";
    }

    private static final Color startDownload$lambda$47$lambda$44() {
        return Pal.accent;
    }

    private static final float startDownload$lambda$47$lambda$45(Ref.FloatRef $progress) {
        return $progress.element;
    }

    private static final void startDownload$lambda$47$lambda$46(Ref.BooleanRef $canceled, BaseDialog $this_apply) {
        $canceled.element = true;
        $this_apply.hide();
    }

    private static final void startDownload$lambda$48(BaseDialog $dialog, Throwable it) {
        $dialog.hide();
        Vars.ui.showException(it);
    }

    private static final void startDownload$lambda$53$lambda$49(Function1 $endDownload, Fi $file) {
        Intrinsics.checkNotNull($file);
        $endDownload.invoke($file);
    }

    private static final void startDownload$lambda$53$lambda$51$lambda$50(Ref.FloatRef $progress, Ref.BooleanRef $canceled, Http.HttpResponse $res, float it) {
        $progress.element = it;
        if ($canceled.element) {
            $res.getResultAsStream().close();
        }
    }

    private static final void startDownload$lambda$53$lambda$52(Function1 $endDownload, Fi $file) {
        Intrinsics.checkNotNull($file);
        $endDownload.invoke($file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void startDownload$lambda$53(Fi $file, BaseDialog $dialog, Ref.FloatRef $length, Ref.BooleanRef $canceled, Function1 $endDownload, Ref.FloatRef $progress, Http.HttpResponse res) {
        if ($file.exists() && $file.length() == res.getContentLength()) {
            $dialog.hide();
            Core.app.post(() -> AutoUpdate.startDownload$lambda$53$lambda$49($endDownload, $file));
            return;
        }
        $length.element = (float)res.getContentLength() / (float)1024 / (float)1024;
        int buffer = 0x100000;
        Closeable closeable = $file.write(false, buffer);
        Throwable throwable = null;
        try {
            OutputStream out = (OutputStream)closeable;
            boolean bl = false;
            Streams.copyProgress((InputStream)res.getResultAsStream(), (OutputStream)out, (long)res.getContentLength(), (int)buffer, arg_0 -> AutoUpdate.startDownload$lambda$53$lambda$51$lambda$50($progress, $canceled, res, arg_0));
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
        if ($canceled.element) {
            return;
        }
        Core.app.post(() -> AutoUpdate.startDownload$lambda$53$lambda$52($endDownload, $file));
        $dialog.hide();
    }

    static {
        SettingsV2.CheckPref checkPref;
        INSTANCE = new AutoUpdate();
        versions = CollectionsKt.emptyList();
        SettingsV2.CheckPref $this$showUpdateDialog_u24lambda_u241 = checkPref = new SettingsV2.CheckPref("AutoUpdate.showUpdateDialog", true);
        boolean bl = false;
        $this$showUpdateDialog_u24lambda_u241.addFallbackName("showUpdateDialog");
        showUpdateDialog = checkPref;
        ignoreOnce = new SettingsV2.Data<String>("AutoUpdate.ignoreOnce", "");
        ignoreUntil = new SettingsV2.Data<String>("AutoUpdate.ignoreUntil", "");
        commitsTable$delegate = LazyKt.lazy(AutoUpdate::commitsTable_delegate$lambda$2);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001:\u0001'B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0006\u0010\u0019\u001a\u00020\u0015J\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bJ\t\u0010\u001c\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010 \u001a\u00020\bH\u00c6\u0003J;\u0010!\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\"\u001a\u00020\u00152\b\u0010#\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010$\u001a\u00020%H\u00d6\u0001J\t\u0010&\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\fR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\fR\u0011\u0010\u0014\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0017\u00a8\u0006("}, d2={"LmindustryX/features/AutoUpdate$Release;", "", "repo", "", "url", "tag", "version", "json", "Larc/util/serialization/Jval;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Larc/util/serialization/Jval;)V", "getRepo", "()Ljava/lang/String;", "getUrl", "getTag", "getVersion", "getJson", "()Larc/util/serialization/Jval;", "description", "getDescription", "preRelease", "", "getPreRelease", "()Z", "isRelease", "matchCurrent", "findAsset", "LmindustryX/features/AutoUpdate$Release$Asset;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "hashCode", "", "toString", "Asset", "core"})
    @SourceDebugExtension(value={"SMAP\nAutoUpdate.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AutoUpdate.kt\nmindustryX/features/AutoUpdate$Release\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,282:1\n1557#2:283\n1628#2,3:284\n1062#2:287\n295#2,2:288\n*S KotlinDebug\n*F\n+ 1 AutoUpdate.kt\nmindustryX/features/AutoUpdate$Release\n*L\n45#1:283\n45#1:284,3\n46#1:287\n47#1:288,2\n*E\n"})
    public static final class Release {
        @NotNull
        private final String repo;
        @NotNull
        private final String url;
        @NotNull
        private final String tag;
        @NotNull
        private final String version;
        @NotNull
        private final Jval json;

        public Release(@NotNull String repo, @NotNull String url, @NotNull String tag, @NotNull String version, @NotNull Jval json) {
            Intrinsics.checkNotNullParameter(repo, "repo");
            Intrinsics.checkNotNullParameter(url, "url");
            Intrinsics.checkNotNullParameter(tag, "tag");
            Intrinsics.checkNotNullParameter(version, "version");
            Intrinsics.checkNotNullParameter(json, "json");
            this.repo = repo;
            this.url = url;
            this.tag = tag;
            this.version = version;
            this.json = json;
        }

        @NotNull
        public final String getRepo() {
            return this.repo;
        }

        @NotNull
        public final String getUrl() {
            return this.url;
        }

        @NotNull
        public final String getTag() {
            return this.tag;
        }

        @NotNull
        public final String getVersion() {
            return this.version;
        }

        @NotNull
        public final Jval getJson() {
            return this.json;
        }

        @NotNull
        public final String getDescription() {
            String string = this.json.getString("body");
            if (string == null) {
                string = "";
            }
            String string2 = Strings.stripColors((CharSequence)string);
            Intrinsics.checkNotNull(string2);
            return string2;
        }

        public final boolean getPreRelease() {
            return this.json.getBool("prerelease", false);
        }

        public final boolean isRelease() {
            return Intrinsics.areEqual(this.repo, "TinyLake/MindustryX") && !this.getPreRelease();
        }

        public final boolean matchCurrent() {
            if (this.isRelease()) {
                return INSTANCE.getCurrentBranch() == null;
            }
            if (Intrinsics.areEqual(this.repo, "TinyLake/MindustryX") && this.getPreRelease() && INSTANCE.getCurrentBranch() != null) {
                return true;
            }
            return Intrinsics.areEqual(this.tag, INSTANCE.getCurrentBranch() + "-build") || StringsKt.contains$default((CharSequence)this.getDescription(), "REPLACE " + INSTANCE.getCurrentBranch(), false, 2, null);
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final Asset findAsset() {
            Object v4;
            block2: {
                void $this$mapTo$iv$iv;
                Jval.JsonArray jsonArray = this.json.get("assets").asArray();
                Intrinsics.checkNotNullExpressionValue(jsonArray, "asArray(...)");
                Iterable $this$map$iv = (Iterable)jsonArray;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Jval jval = (Jval)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    String string = it.getString("name");
                    Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
                    String string2 = it.getString("browser_download_url", "");
                    Intrinsics.checkNotNullExpressionValue(string2, "getString(...)");
                    collection.add(new Asset(string, string2));
                }
                Iterable $this$sortedByDescending$iv = (List)destination$iv$iv;
                boolean $i$f$sortedByDescending = false;
                List assets = CollectionsKt.sortedWith($this$sortedByDescending$iv, new Comparator(){

                    public final int compare(T a, T b) {
                        Asset it = (Asset)b;
                        boolean bl = false;
                        Comparable comparable = (Comparable)((Object)it.getName());
                        it = (Asset)a;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues(comparable2, (Comparable)((Object)it.getName()));
                    }
                });
                Iterable $this$firstOrNull$iv = assets;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Asset it = (Asset)element$iv;
                    boolean bl = false;
                    boolean bl2 = VarsX.isLoader ? StringsKt.contains$default((CharSequence)it.getName(), "loader", false, 2, null) && StringsKt.endsWith$default(it.getName(), ".jar", false, 2, null) : (OS.isAndroid ? StringsKt.endsWith$default(it.getName(), ".apk", false, 2, null) : StringsKt.endsWith$default(it.getName(), "Desktop.jar", false, 2, null));
                    if (!bl2) continue;
                    v4 = element$iv;
                    break block2;
                }
                v4 = null;
            }
            return v4;
        }

        @NotNull
        public final String component1() {
            return this.repo;
        }

        @NotNull
        public final String component2() {
            return this.url;
        }

        @NotNull
        public final String component3() {
            return this.tag;
        }

        @NotNull
        public final String component4() {
            return this.version;
        }

        @NotNull
        public final Jval component5() {
            return this.json;
        }

        @NotNull
        public final Release copy(@NotNull String repo, @NotNull String url, @NotNull String tag, @NotNull String version, @NotNull Jval json) {
            Intrinsics.checkNotNullParameter(repo, "repo");
            Intrinsics.checkNotNullParameter(url, "url");
            Intrinsics.checkNotNullParameter(tag, "tag");
            Intrinsics.checkNotNullParameter(version, "version");
            Intrinsics.checkNotNullParameter(json, "json");
            return new Release(repo, url, tag, version, json);
        }

        public static /* synthetic */ Release copy$default(Release release, String string, String string2, String string3, String string4, Jval jval, int n, Object object) {
            if ((n & 1) != 0) {
                string = release.repo;
            }
            if ((n & 2) != 0) {
                string2 = release.url;
            }
            if ((n & 4) != 0) {
                string3 = release.tag;
            }
            if ((n & 8) != 0) {
                string4 = release.version;
            }
            if ((n & 0x10) != 0) {
                jval = release.json;
            }
            return release.copy(string, string2, string3, string4, jval);
        }

        @NotNull
        public String toString() {
            return "Release(repo=" + this.repo + ", url=" + this.url + ", tag=" + this.tag + ", version=" + this.version + ", json=" + this.json + ')';
        }

        public int hashCode() {
            int result = this.repo.hashCode();
            result = result * 31 + this.url.hashCode();
            result = result * 31 + this.tag.hashCode();
            result = result * 31 + this.version.hashCode();
            result = result * 31 + this.json.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Release)) {
                return false;
            }
            Release release = (Release)other;
            if (!Intrinsics.areEqual(this.repo, release.repo)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.url, release.url)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.tag, release.tag)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.version, release.version)) {
                return false;
            }
            return Intrinsics.areEqual(this.json, release.json);
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0013"}, d2={"LmindustryX/features/AutoUpdate$Release$Asset;", "", "name", "", "url", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "getUrl", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "core"})
        public static final class Asset {
            @NotNull
            private final String name;
            @NotNull
            private final String url;

            public Asset(@NotNull String name, @NotNull String url) {
                Intrinsics.checkNotNullParameter(name, "name");
                Intrinsics.checkNotNullParameter(url, "url");
                this.name = name;
                this.url = url;
            }

            @NotNull
            public final String getName() {
                return this.name;
            }

            @NotNull
            public final String getUrl() {
                return this.url;
            }

            @NotNull
            public final String component1() {
                return this.name;
            }

            @NotNull
            public final String component2() {
                return this.url;
            }

            @NotNull
            public final Asset copy(@NotNull String name, @NotNull String url) {
                Intrinsics.checkNotNullParameter(name, "name");
                Intrinsics.checkNotNullParameter(url, "url");
                return new Asset(name, url);
            }

            public static /* synthetic */ Asset copy$default(Asset asset, String string, String string2, int n, Object object) {
                if ((n & 1) != 0) {
                    string = asset.name;
                }
                if ((n & 2) != 0) {
                    string2 = asset.url;
                }
                return asset.copy(string, string2);
            }

            @NotNull
            public String toString() {
                return "Asset(name=" + this.name + ", url=" + this.url + ')';
            }

            public int hashCode() {
                int result = this.name.hashCode();
                result = result * 31 + this.url.hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Asset)) {
                    return false;
                }
                Asset asset = (Asset)other;
                if (!Intrinsics.areEqual(this.name, asset.name)) {
                    return false;
                }
                return Intrinsics.areEqual(this.url, asset.url);
            }
        }
    }
}

