/*
 * Decompiled with CFR 0.152.
 */
package mindustryX.features;

import arc.Core;
import arc.Events;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Font;
import arc.math.Angles;
import arc.math.Mathf;
import arc.math.geom.Bezier;
import arc.math.geom.Position;
import arc.math.geom.Rect;
import arc.math.geom.Vec2;
import arc.math.geom.Vector;
import arc.scene.ui.layout.Scl;
import arc.struct.ObjectMap;
import arc.util.Nullable;
import arc.util.Strings;
import arc.util.Time;
import arc.util.Tmp;
import arc.util.pooling.Pools;
import mindustry.Vars;
import mindustry.content.StatusEffects;
import mindustry.entities.Sized;
import mindustry.game.EventType;
import mindustry.gen.Bulletc;
import mindustry.gen.Decal;
import mindustry.gen.Entityc;
import mindustry.gen.Healthc;
import mindustry.gen.Ownerc;
import mindustry.gen.Unit;
import mindustry.graphics.Pal;
import mindustry.ui.Fonts;
import mindustry.world.blocks.ControlBlock;
import mindustryX.events.HealthChangedEvent;
import mindustryX.features.RenderExt;
import mindustryX.features.SettingsV2;

public class DamagePopup {
    private static final ObjectMap<Sized, Popup> damagePopups = new ObjectMap();
    private static final ObjectMap<Sized, Popup> healPopups = new ObjectMap();
    public static final float minScale = 0.25f / Scl.scl((float)1.0f);
    public static final float maxScale = 0.5f / Scl.scl((float)1.0f);
    public static float popupLifetime = 60.0f;
    private static final SettingsV2.CheckPref enable = new SettingsV2.CheckPref("damagePopup.enable");
    private static final SettingsV2.CheckPref playerOnly = new SettingsV2.CheckPref("damagePopup.playerOnly", true);
    private static final SettingsV2.CheckPref healPopup = new SettingsV2.CheckPref("damagePopup.showHeal");
    private static final SettingsV2.SliderPref minHealth = new SettingsV2.SliderPref("damagePopup.minHealth", 600, 0, 4000, 50, v -> v + "[red]HP");

    public static void init() {
        Events.on(HealthChangedEvent.class, DamagePopup::handleEvent);
        Events.on(EventType.ResetEvent.class, e -> {
            damagePopups.clear();
            healPopups.clear();
        });
    }

    private static void handleEvent(HealthChangedEvent event) {
        Healthc healthc;
        if (!((Boolean)enable.get()).booleanValue()) {
            return;
        }
        if (event.entity.maxHealth() < (float)((Integer)minHealth.get()).intValue()) {
            return;
        }
        if (event.amount < 0.0f && !((Boolean)healPopup.get()).booleanValue()) {
            return;
        }
        if (event.source != null) {
            Rect cameraBounds = Core.camera.bounds(Tmp.r1).grow(32.0f);
            if (!cameraBounds.contains(event.entity.getX(), event.entity.getY())) {
                return;
            }
            if (event.source != null && ((Boolean)playerOnly.get()).booleanValue() && !DamagePopup.inControl(DamagePopup.getOwner(event.source))) {
                return;
            }
        }
        if ((healthc = event.entity) instanceof Sized) {
            Sized sized;
            Sized entitySized = (Sized)healthc;
            healthc = event.source;
            DamagePopup.popup(healthc instanceof Sized ? (sized = (Sized)healthc) : null, entitySized, event.amount, event.isSplash);
        }
    }

    @Nullable
    private static Entityc getOwner(Entityc source) {
        Entityc current = source;
        while (current instanceof Ownerc) {
            Bulletc o2;
            Object object;
            Ownerc o = (Ownerc)current;
            if ((current = o.owner()) != null || !(o instanceof Bulletc) || !((object = (o2 = (Bulletc)o).data()) instanceof Bulletc)) continue;
            Bulletc bullet = (Bulletc)object;
            current = bullet;
        }
        return current;
    }

    private static boolean inControl(Entityc entity) {
        ControlBlock b;
        Unit u;
        if (entity instanceof Unit && ((u = (Unit)entity).isLocal() || Vars.control.input.selectedUnits.contains((Object)u))) {
            return true;
        }
        return entity instanceof ControlBlock && (b = (ControlBlock)entity).unit().isLocal();
    }

    private static void popup(@Nullable Sized source, Sized damaged, float amount, boolean isSplash) {
        if (Mathf.equal((float)amount, (float)0.0f)) {
            return;
        }
        float hitSize = damaged.hitSize();
        float rotation = source != null ? damaged.angleTo((Position)source) + Mathf.random((float)35.0f) : 90.0f + Mathf.range((float)35.0f);
        float scale = Mathf.clamp((float)(hitSize / 64.0f / Scl.scl((float)1.0f)), (float)minScale, (float)maxScale);
        float offsetLength = hitSize * Mathf.random((float)0.4f, (float)0.7f);
        if (!isSplash) {
            float offsetX = Angles.trnsx((float)rotation, (float)(hitSize * Mathf.random((float)0.2f, (float)0.4f)));
            float offsetY = Angles.trnsy((float)rotation, (float)(hitSize * Mathf.random((float)0.2f, (float)0.4f)));
            if (amount >= 0.0f) {
                Popup data = (Popup)damagePopups.get((Object)damaged);
                if (data != null) {
                    data.superposeAmount(amount);
                } else {
                    data = Popup.create();
                    damagePopups.put((Object)damaged, (Object)data);
                    data.set(damaged, damagePopups, "", Pal.health, offsetX, offsetY, popupLifetime, amount, 1.0f, scale, rotation, offsetLength).add();
                }
            } else {
                Popup data = (Popup)healPopups.get((Object)damaged);
                if (data != null) {
                    data.superposeAmount(-amount);
                } else {
                    data = Popup.create();
                    healPopups.put((Object)damaged, (Object)data);
                    data.set(damaged, healPopups, "", Pal.heal, offsetX, offsetY, popupLifetime, -amount, 1.0f, scale, rotation, offsetLength).add();
                }
            }
        } else {
            float offsetX = Angles.trnsx((float)rotation, (float)(hitSize * Mathf.random((float)0.3f, (float)0.4f)));
            float offsetY = Angles.trnsy((float)rotation, (float)(hitSize * Mathf.random((float)0.3f, (float)0.4f)));
            Popup.create().set(damaged, null, StatusEffects.blasted.emoji(), StatusEffects.blasted.color, offsetX, offsetY, popupLifetime, Math.abs(amount), 1.0f, scale *= 0.65f, rotation, offsetLength).add();
        }
    }

    static {
        enable.addFallbackName("damagePopup");
        playerOnly.addFallbackName("playerPopupOnly");
        healPopup.addFallbackName("healPopup");
        minHealth.addFallbackName("popupMinHealth");
    }

    private static class Popup
    extends Decal {
        public static float maxAmountEffect = 5000.0f;
        public static int maxCountEffect = 50;
        public static float amountEffect = 3.0f;
        public static float countEffect = 2.0f;
        public static float fontScaleEffectScl = 8.0f;
        public static float splashTime = 15.0f;
        public Font font = Fonts.outline;
        public Sized damaged;
        @Nullable
        public ObjectMap<Sized, Popup> superposeMap;
        public String icon;
        public float alpha;
        public float scale;
        public float offsetX;
        public float offsetY;
        public float offsetLength;
        public float amount;
        public int count;
        private float floatTimer;
        private float splashTimer;

        private Popup() {
        }

        public Popup set(Sized damaged, @Nullable ObjectMap<Sized, Popup> superposeMap, String icon, Color color, float offsetX, float offsetY, float lifetime, float amount, float alpha, float scale, float rotation, float offsetLength) {
            this.damaged = damaged;
            this.superposeMap = superposeMap;
            this.color.set(color);
            this.icon = icon;
            this.set(damaged.getX() + offsetX, damaged.getY() + offsetY);
            this.offsetX = superposeMap != null ? offsetX : this.x;
            this.offsetY = superposeMap != null ? offsetY : this.y;
            this.offsetLength = offsetLength;
            this.lifetime = lifetime;
            this.amount = amount;
            this.alpha = alpha;
            this.scale = scale;
            this.rotation = rotation;
            return this;
        }

        @Override
        public float clipSize() {
            return 40.0f;
        }

        @Override
        public void draw() {
            if (((Boolean)RenderExt.unitHide.get()).booleanValue() && this.damaged instanceof Unit) {
                return;
            }
            float alphaScaleEase = ((Vec2)Bezier.quadratic((Vector)Tmp.v1, (float)this.fin(), (Vector)Tmp.v2.set((float)1.0f, (float)1.0f), (Vector)Tmp.v3.set((float)0.0f, (float)1.0f), (Vector)Tmp.v4.set((float)0.0f, (float)0.8f), (Vector)Tmp.v5.set((float)0.0f, (float)0.5f))).y;
            float alpha = this.alpha * alphaScaleEase;
            float scale = this.scale * alphaScaleEase * Math.max(this.effect() / fontScaleEffectScl, 1.0f);
            Draw.z((float)120.0f);
            Tmp.c1.set(this.color).a(alpha).lerp(Color.white, this.splashTimer / splashTime * 0.75f);
            String text = this.icon + Strings.autoFixed((float)this.amount, (int)1);
            this.font.draw((CharSequence)text, this.x, this.y, this.color, scale, false, 1);
        }

        @Override
        public void update() {
            if (this.superposeMap != null) {
                this.x = this.damaged.getX() + this.offsetX;
                this.y = this.damaged.getY() + this.offsetY;
            } else {
                float positionEase = ((Vec2)Bezier.quadratic((Vector)Tmp.v1, (float)this.fin(), (Vector)Tmp.v2.set((float)0.0f, (float)0.0f), (Vector)Tmp.v3.set((float)0.19f, (float)1.0f), (Vector)Tmp.v4.set((float)0.22f, (float)1.0f), (Vector)Tmp.v5.set((float)1.0f, (float)1.0f))).y;
                float offsetLength = this.offsetLength * positionEase;
                this.x = this.offsetX + Angles.trnsx((float)this.rotation, (float)offsetLength);
                this.y = this.offsetY + Angles.trnsy((float)this.rotation, (float)offsetLength);
            }
            if (this.floatTimer > 0.0f) {
                this.floatTimer = Math.max(0.0f, this.floatTimer - Time.delta);
            } else {
                super.update();
            }
            if (this.splashTimer > 0.0f) {
                this.splashTimer = Math.max(0.0f, this.splashTimer - Time.delta);
            }
        }

        protected float effect() {
            float damageEffect = amountEffect * Math.min(this.amount / maxAmountEffect, 1.0f);
            float countEffect = Popup.countEffect * (float)Math.min(this.count / maxCountEffect, 1);
            return 1.0f + damageEffect + countEffect;
        }

        public void superposeAmount(float amount) {
            this.amount += amount;
            ++this.count;
            this.floatTimer = this.lifetime;
            this.splashTimer = splashTime;
        }

        public static Popup create() {
            return (Popup)Pools.obtain(Popup.class, Popup::new);
        }

        @Override
        public void remove() {
            if (this.damaged != null && this.superposeMap != null) {
                this.superposeMap.remove((Object)this.damaged);
            }
            super.remove();
        }

        @Override
        public void reset() {
            super.reset();
            this.damaged = null;
            this.superposeMap = null;
            this.icon = null;
            this.alpha = 0.0f;
            this.scale = 0.0f;
            this.offsetLength = 0.0f;
            this.offsetY = 0.0f;
            this.offsetX = 0.0f;
            this.amount = 0.0f;
            this.count = 0;
            this.splashTimer = 0.0f;
            this.floatTimer = 0.0f;
        }
    }
}

