/*
 * Decompiled with CFR 0.152.
 */
package mindustryX.features;

import arc.Core;
import arc.Events;
import arc.func.Cons;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Lines;
import arc.input.KeyCode;
import arc.math.Angles;
import arc.math.Mathf;
import arc.math.geom.Circle;
import arc.math.geom.Position;
import arc.math.geom.Vec2;
import arc.scene.Element;
import arc.scene.event.EventListener;
import arc.scene.event.InputEvent;
import arc.scene.event.InputListener;
import arc.scene.event.Touchable;
import arc.scene.style.TextureRegionDrawable;
import arc.scene.ui.layout.Scl;
import arc.scene.ui.layout.Table;
import arc.struct.Seq;
import arc.util.Nullable;
import arc.util.Strings;
import arc.util.Time;
import arc.util.Tmp;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mindustry.Vars;
import mindustry.entities.Effect;
import mindustry.game.EventType;
import mindustry.gen.EffectState;
import mindustry.gen.Groups;
import mindustry.gen.Tex;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.ui.Styles;
import mindustryX.features.UIExt;
import mindustryX.features.func.FuncX;
import mindustryX.features.ui.ArcMessageDialog;
import mindustryX.features.ui.FormatDefault;

public class MarkerType {
    private static final Pattern posPattern = Pattern.compile("(?<type><[A-Za-z]+>)?\\((?<x>\\d+),(?<y>\\d+)\\)");
    public static final float heatTime = 60.0f;
    public static final float retainTime = 1800.0f;
    public static MarkerType mark;
    public static MarkerType gatherMark;
    public static MarkerType attackMark;
    public static MarkerType defenseMark;
    public static MarkerType quesMark;
    public static Seq<MarkerType> allTypes;
    private static MarkElement last;
    private static final Vec2 panCenter;
    private static final Element markHitter;
    public final Color color;
    private final String name;
    private final Effect effect;
    public String localizedName;

    public static void init() {
        mark = new MarkerType("Mark", new Effect(1800.0f, e -> {
            Draw.color((Color)e.color);
            Lines.stroke(2.0f);
            Lines.circle(e.x, e.y, 8.0f);
            Lines.stroke(e.fout() * 1.5f + 0.5f);
            Lines.circle(e.x, e.y, 8.0f + e.finpow() * 92.0f);
        }), Color.valueOf((String)"eab678"));
        gatherMark = new MarkerType("Gather", new Effect(1800.0f, e -> {
            Draw.color((Color)e.color, (float)0.8f);
            Lines.stroke(2.0f);
            Lines.circle(e.x, e.y, 32.0f);
            Lines.stroke(1.0f);
            Lines.circle(e.x, e.y, 32.0f * (e.finpow() * 8.0f - (float)((int)(e.finpow() * 8.0f))));
            for (int j = 0; j < 4; ++j) {
                Draw.alpha((float)Math.min(1.0f, (float)j - e.fout() * 3.0f));
                if (!(e.fout() * 3.0f < (float)j)) continue;
                for (int i = 0; i < 8; ++i) {
                    float rot = (float)i * 45.0f;
                    float radius = 32.0f + (float)j * 6.0f + 4.0f;
                    MarkerType.drawSimpleArrow(e.x + Angles.trnsx((float)rot, (float)radius), e.y + Angles.trnsy((float)rot, (float)radius), e.x, e.y, 4.0f, 2.0f);
                }
            }
            Draw.color();
        }), Color.cyan);
        attackMark = new MarkerType("Attack", new Effect(1800.0f, e -> {
            Draw.color((Color)e.color);
            Lines.stroke(2.0f);
            Lines.circle(e.x, e.y, 8.0f);
            float radius = 20.0f + e.finpow() * 80.0f;
            Lines.circle(e.x, e.y, radius);
            for (int i = 0; i < 4; ++i) {
                float rot = (float)i * 90.0f + 45.0f + -Time.time % 360.0f;
                MarkerType.drawSimpleArrow(e.x + Angles.trnsx((float)rot, (float)radius), e.y + Angles.trnsy((float)rot, (float)radius), e.x, e.y, 6.0f + 4.0f * e.finpow(), 2.0f + 4.0f * e.finpow());
            }
        }), Color.valueOf((String)"#DC143C"));
        defenseMark = new MarkerType("Defend", new Effect(1800.0f, e -> {
            Draw.color((Color)Pal.heal);
            if (e.fin() < 0.2f) {
                Lines.circle(e.x, e.y, 20.0f + e.fin() * 400.0f);
                return;
            }
            Lines.circle(e.x, e.y, 101.0f);
            Lines.circle(e.x, e.y, 93.0f);
            for (int i = 0; i < 16; ++i) {
                float rot = (float)i * 22.5f;
                if (!((e.fin() - 0.2f) * 50.0f > (float)i)) continue;
                MarkerType.drawSimpleArrow(e.x, e.y, e.x + Angles.trnsx((float)rot, (float)120.0f), e.y + Angles.trnsy((float)rot, (float)120.0f), 96.0f, 4.0f);
            }
        }), Color.acid);
        quesMark = new MarkerType("What", new Effect(1200.0f, e -> {
            Draw.color((Color)Color.violet);
            Lines.stroke(2.0f);
            Draw.alpha((float)Math.min(e.fin() * 5.0f, 1.0f));
            Lines.arc(e.x, e.y + 25.0f, 10.0f, 0.75f, 270.0f);
            Lines.line(e.x, e.y + 15.0f, e.x, e.y + 7.0f);
            Lines.circle(e.x, e.y, 3.0f);
            Lines.circle(e.x, e.y + 18.5f, 27.0f);
        }), Color.pink);
        allTypes = Seq.with((Object[])new MarkerType[]{mark, gatherMark, attackMark, defenseMark, quesMark});
    }

    public static void showPanUI() {
        panCenter.set(Core.input.mouseWorld());
    }

    public static void toggleMarkHitterUI() {
        if (MarkerType.markHitter.parent == null) {
            Vars.ui.hudGroup.addChildAt(0, markHitter);
        } else {
            markHitter.remove();
        }
    }

    public MarkerType(String name, Effect effect, Color color) {
        this.name = name;
        this.effect = effect;
        this.color = color;
        this.localizedName = Core.bundle.get("marker." + name + ".name", "unknown");
    }

    public MarkElement at(Position pos) {
        MarkElement element = new MarkElement(this, pos);
        element.show();
        return element;
    }

    public void markWithMessage(Vec2 pos) {
        if (last != null && MarkerType.last.time < 60.0f) {
            Vars.ui.announce("\u8bf7\u4e0d\u8981\u9891\u7e41\u6807\u8bb0!");
            return;
        }
        last = this.at((Position)pos);
        UIExt.sendChatMessage(Strings.format((String)"<ARCxMDTX>[#@]<@>[]@", (Object[])new Object[]{this.color, this.name, FormatDefault.formatTile((Position)pos)}));
    }

    public static boolean resolveMessage(String text) {
        MarkElement exists;
        Matcher matcher = posPattern.matcher(Strings.stripColors((CharSequence)text));
        if (!matcher.find()) {
            return false;
        }
        String typeName = matcher.group(1);
        Vec2 pos = Tmp.v1.set((float)Strings.parseInt((String)matcher.group(2)), (float)Strings.parseInt((String)matcher.group(3)));
        MarkerType type = mark;
        if (typeName != null) {
            typeName = typeName.substring(1, typeName.length() - 1);
            for (MarkerType it2 : allTypes) {
                if (!it2.name.equals(typeName)) continue;
                type = it2;
            }
        } else if (text.contains("\u96c6\u5408")) {
            type = gatherMark;
        }
        last = (exists = (MarkElement)Groups.draw.find(it -> {
            if (!(it instanceof MarkElement)) return false;
            MarkElement e = (MarkElement)it;
            if (e.message != null) return false;
            if (!e.within((Position)pos.scl(8.0f), 16.0f)) return false;
            return true;
        })) != null ? exists : type.at((Position)pos.scl(8.0f));
        MarkerType.last.message = text;
        new ArcMessageDialog.Msg(ArcMessageDialog.Type.markLoc, text, pos).add();
        return true;
    }

    public static void eachActive(Cons<MarkElement> cons) {
        if (last == null) {
            return;
        }
        Groups.draw.each(d -> {
            if (d instanceof MarkElement) {
                MarkElement e = (MarkElement)d;
                cons.get((Object)e);
            }
        });
    }

    public static void lockOnLastMark() {
        if (last == null) {
            return;
        }
        Vars.control.input.panCamera(Tmp.v1.set((Position)last));
        last.show();
    }

    @Nullable
    public static Position getLastPos() {
        return last;
    }

    private static void drawSimpleArrow(float x, float y, float x2, float y2, float length, float radius) {
        float angle = Angles.angle((float)x, (float)y, (float)x2, (float)y2);
        Tmp.v1.set(x2, y2).sub(x, y).limit(length);
        float vx = Tmp.v1.x + x;
        float vy = Tmp.v1.y + y;
        Fill.poly((float)vx, (float)vy, (int)3, (float)radius, (float)angle);
    }

    static {
        panCenter = new Vec2();
        markHitter = new Table(){
            {
                this.fillParent = true;
                this.touchable = Touchable.enabled;
                this.background(((TextureRegionDrawable)Tex.whiteui).tint(0.0f, 0.0f, 0.0f, 0.1f));
                this.center().add((CharSequence)"[cyan]\u6807\u8bb0\u6a21\u5f0f,\u70b9\u51fb\u5c4f\u5e55\u6807\u8bb0.", Styles.outlineLabel);
                this.tapped(() -> {
                    MarkerType.showPanUI();
                    Core.app.post(() -> (this).remove());
                });
            }
        };
        MarkerType.init();
        Events.run(EventType.WorldLoadEvent.class, () -> {
            last = null;
        });
        Vars.ui.hudGroup.addChildAt(0, new Element(){
            private final Circle outer = new Circle(0.0f, 0.0f, Scl.scl((float)120.0f));
            private final Circle inner = new Circle(0.0f, 0.0f, Scl.scl((float)60.0f));
            {
                this.name = "markPanUI";
                this.addListener((EventListener)new InputListener(){

                    public boolean touchDown(InputEvent event, float x, float y, int pointer, KeyCode button2) {
                        if (inner.contains(x, y)) {
                            mark.markWithMessage(panCenter);
                        } else if (outer.contains(x, y)) {
                            int i = Mathf.round((float)(Mathf.angle((float)x, (float)y) / 360.0f * (float)(MarkerType.allTypes.size - 1))) % (MarkerType.allTypes.size - 1);
                            ((MarkerType)allTypes.get(1 + i)).markWithMessage(panCenter);
                        }
                        panCenter.setZero();
                        event.stop();
                        return true;
                    }
                });
            }

            public void updateVisibility() {
                this.visible = !panCenter.isZero();
            }

            public void act(float delta) {
                super.act(delta);
                Vec2 pos = Core.camera.project(Tmp.v1.set(panCenter));
                this.setPosition(pos.x, pos.y);
            }

            public void draw() {
                int i;
                float oR = this.outer.radius;
                float iR = this.inner.radius;
                Draw.color((Color)Color.black, (float)0.6f);
                Fill.circle((float)this.x, (float)this.y, (float)oR);
                Draw.color((Color)Pal.accent);
                Lines.circle(this.x, this.y, oR);
                Lines.circle(this.x, this.y, iR);
                int sp = MarkerType.allTypes.size - 1;
                for (i = 0; i < sp; ++i) {
                    Lines.lineAngle(this.x, this.y, 360.0f * ((float)i - 0.5f) / (float)sp, oR - iR, iR);
                }
                FuncX.drawText((Position)Tmp.v1.set(this.x, this.y), MarkerType.mark.localizedName + "\n[white]" + FormatDefault.formatTile((Position)panCenter), Scl.scl((float)4.0f), MarkerType.mark.color);
                for (i = 0; i < sp; ++i) {
                    MarkerType mark = (MarkerType)allTypes.get(1 + i);
                    Vec2 tCenter = Tmp.v1.trns(360.0f * (float)i / (float)sp, (oR + iR) / 2.0f).add(this.x, this.y);
                    FuncX.drawText((Position)tCenter, mark.localizedName, Scl.scl((float)4.0f), mark.color);
                }
                Draw.reset();
            }

            public Element hit(float x, float y, boolean touchable) {
                return this;
            }
        });
    }

    public static class MarkElement
    extends EffectState {
        public final MarkerType type;
        @Nullable
        public String message;

        public MarkElement(MarkerType MarkerType2, Position markPos) {
            this.type = MarkerType2;
            this.set(markPos);
            this.effect = MarkerType2.effect;
            this.lifetime = this.effect.lifetime;
            this.color.set(MarkerType2.color);
        }

        public void show() {
            this.time = 0.0f;
            this.add();
        }

        @Override
        public float clipSize() {
            return Float.MAX_VALUE;
        }

        @Override
        public void draw() {
            super.draw();
            Draw.z((float)120.0f);
            this.showArrow();
            if (this.message != null) {
                FuncX.drawText((Position)this, this.message);
            }
        }

        private void showArrow() {
            Draw.reset();
            Drawf.arrow((float)Vars.player.x, (float)Vars.player.y, (float)this.x, (float)this.y, (float)40.0f, (float)4.0f, (Color)this.color);
            Vec2 p = Tmp.v1.set((Position)this).sub((Position)Vars.player).limit(36.0f).add((Position)Vars.player);
            FuncX.drawText((Position)p, (int)(this.dst((Position)Vars.player) / 8.0f) + "", Scl.scl((float)1.25f), this.color);
        }
    }
}

