/*
 * Decompiled with CFR 0.152.
 */
package mindustryX.features;

import arc.Core;
import arc.Graphics;
import arc.files.Fi;
import arc.func.ConsT;
import arc.struct.Seq;
import arc.util.Http;
import arc.util.Log;
import arc.util.OS;
import arc.util.Strings;
import arc.util.Time;
import arc.util.serialization.Jval;
import java.security.MessageDigest;
import java.util.Collection;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.concurrent.ThreadsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.HexExtensionsKt;
import kotlin.text.StringsKt;
import kotlin.uuid.Uuid;
import mindustry.Vars;
import mindustry.core.ContentLoader;
import mindustry.core.GameState;
import mindustry.core.Version;
import mindustry.mod.Mods;
import mindustry.net.CrashHandler;
import mindustryX.VarsX;
import mindustryX.features.SettingsV2;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\n\u0010\u0011\u001a\u0004\u0018\u00010\nH\u0002J\b\u0010\u0012\u001a\u00020\nH\u0002J\u0015\u0010\u0013\u001a\n \u0014*\u0004\u0018\u00010\u00100\u0010H\u0002\u00a2\u0006\u0002\u0010\u0015J\u0015\u0010\u0016\u001a\n \u0014*\u0004\u0018\u00010\u00100\u0010H\u0002\u00a2\u0006\u0002\u0010\u0015J\u0015\u0010\u0017\u001a\n \u0014*\u0004\u0018\u00010\u00100\u0010H\u0002\u00a2\u0006\u0002\u0010\u0015J\u0015\u0010\u0018\u001a\n \u0014*\u0004\u0018\u00010\u00100\u0010H\u0002\u00a2\u0006\u0002\u0010\u0015J\b\u0010\u0019\u001a\u00020\u0010H\u0002J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u000e\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u001dJ\u0006\u0010\u001f\u001a\u00020\u000eJ\u0006\u0010 \u001a\u00020\u000eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"LmindustryX/features/MetricCollector;", "", "<init>", "()V", "enable", "LmindustryX/features/SettingsV2$CheckPref;", "lastTime", "LmindustryX/features/SettingsV2$PersistentProvider$Arc;", "", "lastCrashMod", "", "task", "Ljava/lang/Thread;", "postLog", "", "data", "Larc/util/serialization/Jval;", "getDeviceId", "getUserId", "getEnvInfo", "kotlin.jvm.PlatformType", "()Larc/util/serialization/Jval;", "getModList", "getDisabledModList", "getSettings", "getBaseInfo", "getModCause", "Lmindustry/mod/Mods$LoadedMod;", "e", "", "handleException", "waitPost", "onLaunch", "core"})
@SourceDebugExtension(value={"SMAP\nMetricCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MetricCollector.kt\nmindustryX/features/MetricCollector\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,155:1\n1#2:156\n1863#3,2:157\n1863#3,2:159\n1863#3,2:161\n*S KotlinDebug\n*F\n+ 1 MetricCollector.kt\nmindustryX/features/MetricCollector\n*L\n66#1:157,2\n75#1:159,2\n88#1:161,2\n*E\n"})
public final class MetricCollector {
    @NotNull
    public static final MetricCollector INSTANCE = new MetricCollector();
    @NotNull
    private static final SettingsV2.CheckPref enable = new SettingsV2.CheckPref("collectMetrics", true);
    @NotNull
    private static final SettingsV2.PersistentProvider.Arc<Long> lastTime = new SettingsV2.PersistentProvider.Arc("MetricCollector.lastPost");
    @NotNull
    private static final SettingsV2.PersistentProvider.Arc<String> lastCrashMod = new SettingsV2.PersistentProvider.Arc("MetricCollector.lastCrashMod");
    @Nullable
    private static Thread task;

    private MetricCollector() {
    }

    private final void postLog(Jval data) {
        Http.HttpRequest req = Http.post("https://s1367486.eu-nbg-2.betterstackdata.com/").header("Authorization", "Bearer cM5m9huGdtcFTiXcfdPK17zL").header("Content-Type", "application/json").content(data.toString()).timeout(3000);
        task = ThreadsKt.thread$default(true, false, null, null, 0, () -> MetricCollector.postLog$lambda$1(req), 30, null);
    }

    private final String getDeviceId() {
        try {
            boolean bl = false;
            Fi file = Vars.tmpDirectory.child("metric_device_id.txt");
            boolean bl2 = false;
            if (!file.exists()) {
                file.writeString(Uuid.Companion.random().toString());
            }
            return file.readString();
        }
        catch (Throwable throwable) {
            Object object = Result.constructor-impl(ResultKt.createFailure(throwable));
            return (String)(Result.isFailure-impl(object) ? null : object);
        }
    }

    private final String getUserId() {
        Object object;
        Object object2;
        String string = Core.settings.getString("uuid");
        if (string == null) {
            return "unknown";
        }
        String uid = string;
        try {
            boolean bl = false;
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
            byte[] byArray = uid.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue(byArray, "getBytes(...)");
            byte[] byArray2 = messageDigest.digest(byArray);
            Intrinsics.checkNotNullExpressionValue(byArray2, "digest(...)");
            object2 = Result.constructor-impl(HexExtensionsKt.toHexString$default(byArray2, null, 1, null));
        }
        catch (Throwable throwable) {
            object2 = Result.constructor-impl(ResultKt.createFailure(throwable));
        }
        Throwable throwable = Result.exceptionOrNull-impl(object2);
        if (throwable == null) {
            object = object2;
        } else {
            Throwable it = throwable;
            boolean bl = false;
            object = "Fail-HASH";
        }
        return (String)object;
    }

    private final Jval getEnvInfo() {
        Jval jval;
        Jval $this$getEnvInfo_u24lambda_u247 = jval = Jval.newObject();
        boolean bl = false;
        Jval jval2 = $this$getEnvInfo_u24lambda_u247;
        try {
            Jval $this$getEnvInfo_u24lambda_u247_u24lambda_u246 = jval2;
            boolean bl2 = false;
            $this$getEnvInfo_u24lambda_u247_u24lambda_u246.put("os", OS.osName + " x" + OS.osArchBits + " (" + OS.osArch + ')');
            if ((OS.isAndroid || OS.isIos) && Core.app != null) {
                $this$getEnvInfo_u24lambda_u247_u24lambda_u246.put("Android", (Number)Core.app.getVersion());
            }
            $this$getEnvInfo_u24lambda_u247_u24lambda_u246.put("javaVersion", OS.javaVersion);
            $this$getEnvInfo_u24lambda_u247_u24lambda_u246.put("cpuCores", (Number)OS.cores);
            $this$getEnvInfo_u24lambda_u247_u24lambda_u246.put("memory", (Number)Runtime.getRuntime().maxMemory());
            Object object = Result.constructor-impl($this$getEnvInfo_u24lambda_u247_u24lambda_u246.put("isLoader", VarsX.isLoader));
        }
        catch (Throwable throwable) {
            Object object = Result.constructor-impl(ResultKt.createFailure(throwable));
        }
        return jval;
    }

    private final Jval getModList() {
        Jval jval;
        block1: {
            Jval $this$getModList_u24lambda_u249 = jval = Jval.newObject();
            boolean bl = false;
            Seq<Mods.LoadedMod> seq = Vars.mods;
            if (seq == null || (seq = seq.list()) == null) break block1;
            Iterable $this$forEach$iv = (Iterable)seq;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Mods.LoadedMod mod = (Mods.LoadedMod)element$iv;
                boolean bl2 = false;
                if (!mod.enabled()) continue;
                $this$getModList_u24lambda_u249.put(mod.name, mod.meta.version);
            }
        }
        return jval;
    }

    /*
     * WARNING - void declaration
     */
    private final Jval getDisabledModList() {
        Jval jval;
        block1: {
            Jval $this$getDisabledModList_u24lambda_u2412 = jval = Jval.newObject();
            boolean bl = false;
            Seq<Mods.LoadedMod> seq = Vars.mods;
            if (seq == null || (seq = seq.list()) == null) break block1;
            Iterable $this$forEach$iv = (Iterable)seq;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                void $this$getDisabledModList_u24lambda_u2412_u24lambda_u2411_u24lambda_u2410;
                Jval jval2;
                Mods.LoadedMod mod = (Mods.LoadedMod)element$iv;
                boolean bl2 = false;
                if (mod.enabled()) continue;
                Jval jval3 = jval2 = Jval.newObject();
                String string = mod.name;
                Jval jval4 = $this$getDisabledModList_u24lambda_u2412;
                boolean bl3 = false;
                $this$getDisabledModList_u24lambda_u2412_u24lambda_u2411_u24lambda_u2410.put("version", mod.meta.version);
                $this$getDisabledModList_u24lambda_u2412_u24lambda_u2411_u24lambda_u2410.put("disabled", !mod.shouldBeEnabled());
                $this$getDisabledModList_u24lambda_u2412_u24lambda_u2411_u24lambda_u2410.put("notSupported", !mod.isSupported());
                $this$getDisabledModList_u24lambda_u2412_u24lambda_u2411_u24lambda_u2410.put("hasContentErrors", mod.hasContentErrors());
                $this$getDisabledModList_u24lambda_u2412_u24lambda_u2411_u24lambda_u2410.put("hasUnmetDependencies", mod.hasUnmetDependencies());
                Unit unit = Unit.INSTANCE;
                jval4.put(string, jval2);
            }
        }
        return jval;
    }

    private final Jval getSettings() {
        Jval jval;
        Jval $this$getSettings_u24lambda_u2414 = jval = Jval.newObject();
        boolean bl = false;
        Collection<SettingsV2.DataCore<?>> collection = SettingsV2.INSTANCE.getALL().values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SettingsV2.DataCore it = (SettingsV2.DataCore)element$iv;
            boolean bl2 = false;
            if (Intrinsics.areEqual(it.getValue(), it.getDef())) continue;
            $this$getSettings_u24lambda_u2414.put(it.getName(), Strings.truncate((String)String.valueOf(it.getValue()), (int)20, (String)"..."));
        }
        return jval;
    }

    private final Jval getBaseInfo() {
        Jval jval;
        Jval $this$getBaseInfo_u24lambda_u2415 = jval = Jval.newObject();
        boolean bl = false;
        $this$getBaseInfo_u24lambda_u2415.put("deviceId", INSTANCE.getDeviceId());
        $this$getBaseInfo_u24lambda_u2415.put("userId", INSTANCE.getUserId());
        $this$getBaseInfo_u24lambda_u2415.put("version", Version.combined());
        $this$getBaseInfo_u24lambda_u2415.put("env", INSTANCE.getEnvInfo());
        $this$getBaseInfo_u24lambda_u2415.put("mods", INSTANCE.getModList());
        $this$getBaseInfo_u24lambda_u2415.put("disabledMods", INSTANCE.getDisabledModList());
        $this$getBaseInfo_u24lambda_u2415.put("settings", INSTANCE.getSettings());
        Jval jval2 = jval;
        Intrinsics.checkNotNullExpressionValue(jval2, "apply(...)");
        return jval2;
    }

    private final Mods.LoadedMod getModCause(Throwable e) {
        Object object = e.getCause();
        if (object != null) {
            Object it = object;
            boolean bl = false;
            Mods.LoadedMod loadedMod = INSTANCE.getModCause((Throwable)it);
            object = loadedMod;
            if (loadedMod != null) {
                it = object;
                boolean bl2 = false;
                return it;
            }
        }
        return CrashHandler.getModCause(e);
    }

    /*
     * WARNING - void declaration
     */
    public final void handleException(@NotNull Throwable e) {
        void $this$handleException_u24lambda_u2420_u24lambda_u2418;
        Jval jval;
        Jval jval2;
        String likelyCause;
        Intrinsics.checkNotNullParameter(e, "e");
        if (!((Boolean)enable.getValue()).booleanValue() || VarsX.devVersion) {
            Log.warn((String)"MetricCollector: Exception occurred, but metrics collection is disabled.", (Object[])new Object[0]);
            return;
        }
        Mods.LoadedMod loadedMod = this.getModCause(e);
        String string = likelyCause = loadedMod != null ? loadedMod.name : null;
        if (likelyCause != null && Intrinsics.areEqual(lastCrashMod.get(), likelyCause)) {
            Log.warn((String)("MetricCollector: Exception occurred, but likely cause mod '" + likelyCause + "' has already been reported."), (Object[])new Object[0]);
            return;
        }
        lastCrashMod.setOrReset(likelyCause);
        Jval $this$handleException_u24lambda_u2420 = jval2 = this.getBaseInfo();
        boolean bl = false;
        $this$handleException_u24lambda_u2420.put("cause", ExceptionsKt.stackTraceToString(e));
        Jval jval3 = jval = Jval.newObject();
        String string2 = "state";
        Jval jval4 = $this$handleException_u24lambda_u2420;
        boolean bl2 = false;
        Graphics graphics = Core.graphics;
        $this$handleException_u24lambda_u2420_u24lambda_u2418.put("frameId", (Number)(graphics != null ? graphics.getFrameId() : 0L));
        GameState gameState = Vars.state;
        $this$handleException_u24lambda_u2420_u24lambda_u2418.put("state", gameState != null && (gameState = gameState.getState()) != null ? gameState.toString() : null);
        Object object = Vars.content;
        $this$handleException_u24lambda_u2420_u24lambda_u2418.put("currentMod", object != null && (object = ((ContentLoader)object).transformName("")) != null ? StringsKt.removeSuffix((String)object, (CharSequence)"-") : null);
        GameState gameState2 = Vars.state;
        $this$handleException_u24lambda_u2420_u24lambda_u2418.put("mapName", gameState2 != null && (gameState2 = gameState2.map) != null ? gameState2.name() : null);
        GameState gameState3 = Vars.state;
        $this$handleException_u24lambda_u2420_u24lambda_u2418.put("patches", (Number)(gameState3 != null && (gameState3 = gameState3.patcher) != null && (gameState3 = gameState3.patches) != null ? gameState3.size : 0));
        Unit unit = Unit.INSTANCE;
        jval4.put(string2, jval);
        String string3 = likelyCause;
        if (string3 != null) {
            String it = string3;
            boolean bl3 = false;
            $this$handleException_u24lambda_u2420.put("likelyCause", it);
        }
        Jval data = jval2;
        Log.err((String)("MetricCollector: Posting exception data: " + e), (Object[])new Object[0]);
        this.postLog(data);
    }

    public final void waitPost() {
        Thread thread2 = task;
        if (thread2 != null) {
            thread2.join();
        }
        task = null;
    }

    public final void onLaunch() {
        long last;
        if (!((Boolean)enable.getValue()).booleanValue()) {
            return;
        }
        Long l = lastTime.get();
        long l2 = last = l != null ? l : 0L;
        if (Time.timeSinceMillis((long)last) < 86400000L) {
            Log.infoTag((String)"MetricCollector", (String)"Skip posting metrics.");
            return;
        }
        this.postLog(this.getBaseInfo());
        lastTime.set(Time.millis());
    }

    private static final void postLog$lambda$1$lambda$0(Http.HttpResponse it) {
        Log.info((String)("Posted metrics successfully: " + (Object)((Object)it.getStatus()) + ' ' + it.getResultAsString()), (Object[])new Object[0]);
    }

    private static final Unit postLog$lambda$1(Http.HttpRequest $req) {
        $req.block((ConsT<Http.HttpResponse, Exception>)((ConsT)MetricCollector::postLog$lambda$1$lambda$0));
        return Unit.INSTANCE;
    }
}

