/*
 * Decompiled with CFR 0.152.
 */
package mindustryX.features;

import arc.Core;
import arc.files.Fi;
import arc.graphics.Pixmap;
import arc.graphics.Pixmaps;
import arc.math.Mathf;
import arc.scene.Element;
import arc.scene.ui.Label;
import arc.scene.ui.layout.Table;
import arc.struct.Seq;
import arc.struct.StringMap;
import arc.util.Strings;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import mindustry.Vars;
import mindustry.content.Blocks;
import mindustry.game.Schematic;
import mindustry.graphics.Pal;
import mindustry.type.Item;
import mindustry.ui.Styles;
import mindustry.ui.dialogs.BaseDialog;
import mindustry.world.blocks.logic.CanvasBlock;
import mindustryX.features.UIExt;

public class PicToMindustry {
    static final int[] palette;
    static final int canvasSize;
    static final float[] scaleList;
    static final String[] disFunList;
    static Table tTable;
    static float scale;
    static int colorDisFun;
    static Pixmap oriImage;
    static Fi originFile;

    public static void show() {
        BaseDialog pt = new BaseDialog("arc-\u56fe\u7247\u8f6c\u6362\u5668");
        pt.cont.table(t -> {
            t.add((CharSequence)"\u9009\u62e9\u5e76\u5bfc\u5165\u56fe\u7247\uff0c\u53ef\u5c06\u5176\u8f6c\u6210\u753b\u677f\u3001\u50cf\u7d20\u753b\u6216\u662f\u903b\u8f91\u753b").padBottom(20.0f).row();
            t.button("\u9009\u62e9\u56fe\u7247[white](png)", () -> Vars.platform.showFileChooser(true, "png", file -> {
                if (oriImage != null) {
                    oriImage.dispose();
                    oriImage = null;
                }
                try {
                    originFile = file;
                    byte[] bytes = file.readBytes();
                    oriImage = new Pixmap(bytes);
                    if (PicToMindustry.oriImage.width > 500 || PicToMindustry.oriImage.height > 500) {
                        UIExt.announce("[orange]\u8b66\u544a\uff1a\u56fe\u7247\u53ef\u80fd\u8fc7\u5927\uff0c\u8bf7\u5c1d\u8bd5\u538b\u7f29\u56fe\u7247", 5.0f);
                    }
                }
                catch (Throwable e) {
                    UIExt.announce("\u8bfb\u53d6\u56fe\u7247\u5931\u8d25\uff0c\u8bf7\u5c1d\u8bd5\u66f4\u6362\u56fe\u7247\n" + e);
                }
                PicToMindustry.rebuilt();
            })).size(240.0f, 50.0f).padBottom(20.0f).row();
            t.check("\u81ea\u52a8\u4fdd\u5b58\u4e3a\u84dd\u56fe", Core.settings.getBool("autoSavePTM"), ta -> Core.settings.put("autoSavePTM", (Object)ta));
        }).padBottom(20.0f).row();
        pt.cont.table(t -> {
            t.add((CharSequence)"\u7f29\u653e: \ue815 ");
            Label zoom = (Label)t.add((CharSequence)String.valueOf(scale)).padRight(20.0f).get();
            t.slider(0.0f, (float)(scaleList.length - 1), 1.0f, 11.0f, s -> {
                scale = scaleList[(int)s];
                zoom.setText((CharSequence)Strings.fixed((float)scale, (int)2));
                PicToMindustry.rebuilt();
            }).width(200.0f);
        }).padBottom(20.0f).visible(() -> oriImage != null).row();
        pt.cont.table(t -> {
            t.add((CharSequence)"\u8272\u8c03\u51fd\u6570: ");
            Label zoom = (Label)t.add((CharSequence)disFunList[0]).padRight(20.0f).get();
            t.slider(0.0f, (float)(disFunList.length - 1), 1.0f, 0.0f, s -> {
                colorDisFun = (int)s;
                zoom.setText((CharSequence)disFunList[colorDisFun]);
            }).width(200.0f);
        }).padBottom(20.0f).visible(() -> oriImage != null).row();
        pt.cont.add((Element)tTable);
        pt.cont.row();
        pt.cont.button("\u903b\u8f91\u753b\u7f51\u7ad9 " + Blocks.logicDisplay.emoji(), () -> UIExt.openURI("https://buibiu.github.io/imageToMLogicPage/#/")).width(200.0f);
        pt.addCloseButton();
        pt.show();
    }

    private static String formatNumber(int number) {
        if (number >= 500) {
            return "[red]" + number + "[]";
        }
        if (number >= 200) {
            return "[orange]" + number + "[]";
        }
        return String.valueOf(number);
    }

    private static void rebuilt() {
        tTable.clear();
        if (oriImage == null) {
            return;
        }
        int scaledW = (int)((float)oriImage.getWidth() * scale);
        int scaledH = (int)((float)oriImage.getHeight() * scale);
        tTable.table(t -> {
            t.add((CharSequence)"\u8def\u5f84").color(Pal.accent).padRight(25.0f).padBottom(10.0f);
            t.button("\ue874", () -> Core.app.setClipboardText(originFile.absolutePath()));
            t.add((CharSequence)originFile.absolutePath()).padBottom(10.0f).row();
            t.add((CharSequence)"\u540d\u79f0").color(Pal.accent).padRight(25.0f).padBottom(10.0f);
            t.button("\ue874", () -> Core.app.setClipboardText(originFile.name()));
            t.add((CharSequence)originFile.name()).padBottom(10.0f).row();
            t.add((CharSequence)"\u539f\u59cb\u5927\u5c0f").color(Pal.accent).padRight(25.0f);
            t.add((CharSequence)(PicToMindustry.formatNumber(PicToMindustry.oriImage.width) + "\ue815" + PicToMindustry.formatNumber(PicToMindustry.oriImage.height))).row();
            t.add((CharSequence)"\u7f29\u653e\u540e\u5927\u5c0f").color(Pal.accent).padRight(25.0f);
            t.add((CharSequence)(PicToMindustry.formatNumber(scaledW) + "\ue815" + PicToMindustry.formatNumber(scaledH)));
        }).padBottom(20.0f).row();
        tTable.table(t -> {
            t.table(tt -> {
                int w = Mathf.ceil((float)((float)scaledW * 1.0f / (float)canvasSize));
                int h = Mathf.ceil((float)((float)scaledH * 1.0f / (float)canvasSize));
                tt.button("\u753b\u677f " + Blocks.canvas.emoji(), Styles.cleart, () -> {
                    Pixmap image = Pixmaps.scale((Pixmap)oriImage, (int)(w * canvasSize), (int)(h * canvasSize), (boolean)false);
                    image.replace(pixel -> ArraysKt.minByOrThrow(palette, it -> Float.valueOf(PicToMindustry.diff_rbg(it, pixel))));
                    Schematic schem = PicToMindustry.canvasGenerator(image, w, h);
                    image.dispose();
                    PicToMindustry.saveSchem(schem, Blocks.canvas.emoji());
                }).size(100.0f, 50.0f);
                tt.add((CharSequence)("\u5927\u5c0f\uff1a" + w + "\ue815" + h));
            });
            t.row();
            t.table(tt -> {
                int w = Mathf.ceil((float)((float)scaledW * 1.0f / (float)canvasSize));
                int h = Mathf.ceil((float)((float)scaledH * 1.0f / (float)canvasSize));
                tt.button("\u753b\u677f++ " + Blocks.canvas.emoji(), Styles.cleart, () -> {
                    Pixmap image = Pixmaps.scale((Pixmap)oriImage, (int)(w * canvasSize), (int)(h * canvasSize), (boolean)false);
                    PicToMindustry.mapPalettePlus(image);
                    Schematic schem = PicToMindustry.canvasGenerator(image, w, h);
                    image.dispose();
                    PicToMindustry.saveSchem(schem, Blocks.canvas.emoji());
                }).size(100.0f, 50.0f);
                tt.add((CharSequence)("\u5927\u5c0f\uff1a" + w + "\ue815" + h));
            }).row();
            t.table(tt -> {
                tt.button("\u50cf\u7d20\u753b " + Blocks.sorter.emoji(), Styles.cleart, () -> {
                    Pixmap image = Pixmaps.scale((Pixmap)oriImage, (float)scale);
                    Schematic schem = PicToMindustry.sorterGenerator(image);
                    image.dispose();
                    PicToMindustry.saveSchem(schem, Blocks.sorter.emoji());
                }).size(100.0f, 50.0f);
                tt.add((CharSequence)("\u5927\u5c0f\uff1a" + PicToMindustry.formatNumber(scaledW) + "\ue815" + PicToMindustry.formatNumber(scaledH)));
            }).row();
        });
    }

    private static float diff_rbg(int a, int b) {
        int ar = a >> 24 & 0xFF;
        int ag = a >> 16 & 0xFF;
        int ab = a >> 8 & 0xFF;
        int br = b >> 24 & 0xFF;
        int bg = b >> 16 & 0xFF;
        int bb = b >> 8 & 0xFF;
        int dr = Math.abs(ar - br);
        int dg = Math.abs(ag - bg);
        int db = Math.abs(ab - bb);
        switch (colorDisFun) {
            case 1: {
                return dr * dr + dg * dg + db * db;
            }
            case 2: {
                float Rmean = (float)(ar + br) / 2.0f;
                return (float)Math.sqrt((2.0f + Rmean / 256.0f) * (float)(dr * dr) + (float)(4 * (dg * dg)) + (2.0f + (255.0f - Rmean) / 256.0f) * (float)(db * db));
            }
        }
        return dr + dg + db;
    }

    private static Schematic canvasGenerator(Pixmap image, int w, int h) {
        Seq tiles = new Seq();
        CanvasBlock.CanvasBuild build = (CanvasBlock.CanvasBuild)Blocks.canvas.newBuilding();
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                Pixmap region = image.crop(x * canvasSize, (h - y - 1) * canvasSize, canvasSize, canvasSize);
                byte[] bytes = build.packPixmap(region);
                Schematic.Stile stile = new Schematic.Stile(Blocks.canvas, x * 2, y * 2, bytes, 0);
                tiles.add((Object)stile);
            }
        }
        StringMap tags = new StringMap();
        tags.put((Object)"name", (Object)originFile.name());
        return new Schematic((Seq<Schematic.Stile>)tiles, tags, w * 2, h * 2);
    }

    private static void saveSchem(Schematic schem, String l) {
        schem.labels.add((Object)l);
        if (Core.settings.getBool("autoSavePTM")) {
            Vars.schematics.add(schem);
            String text = "\u5df2\u4fdd\u5b58\u84dd\u56fe\uff1a" + originFile.name();
            UIExt.announce(text, 10.0f);
        }
        if (Vars.state.isGame()) {
            Vars.ui.schematics.hide();
            Vars.control.input.useSchematic(schem);
        }
    }

    private static Schematic sorterGenerator(Pixmap image) {
        Seq tiles = new Seq();
        for (int y = 0; y < image.height; ++y) {
            for (int x = 0; x < image.width; ++x) {
                int pixel = image.get(x, y);
                if (pixel == 0) continue;
                Item closest = CollectionsKt.minByOrThrow(Vars.content.items(), it -> Float.valueOf(PicToMindustry.diff_rbg(it.color.rgba(), pixel)));
                Schematic.Stile stile = new Schematic.Stile(Blocks.sorter, x, image.height - y - 1, (Object)closest, 0);
                tiles.add((Object)stile);
            }
        }
        StringMap tags = new StringMap();
        tags.put((Object)"name", (Object)originFile.name());
        return new Schematic((Seq<Schematic.Stile>)tiles, tags, image.width, image.height);
    }

    private static int trans(RGB c1, RGB c2, int mul) {
        return c1.add(c2.cpy().mul(mul).mv(4)).rgba();
    }

    private static void mapPalettePlus(Pixmap image) {
        for (int y = 0; y < image.height; ++y) {
            for (int x = 0; x < image.width; ++x) {
                RGB pix = new RGB(image.get(x, y));
                int nearest = ArraysKt.minByOrThrow(palette, it -> new RGB((int)it).sub(pix).pow());
                image.set(x, y, nearest);
                pix.sub(new RGB(nearest));
                if (x + 1 < image.width) {
                    image.set(x + 1, y, PicToMindustry.trans(new RGB(image.get(x + 1, y)), pix, 7));
                }
                if (y + 1 >= image.height) continue;
                if (x - 1 > 0) {
                    image.set(x - 1, y + 1, PicToMindustry.trans(new RGB(image.get(x - 1, y + 1)), pix, 3));
                }
                image.set(x, y + 1, PicToMindustry.trans(new RGB(image.get(x, y + 1)), pix, 5));
                if (x + 1 >= image.width) continue;
                image.set(x + 1, y + 1, PicToMindustry.trans(new RGB(image.get(x + 1, y + 1)), pix, 1));
            }
        }
    }

    static {
        scaleList = new float[]{0.02f, 0.05f, 0.1f, 0.15f, 0.2f, 0.25f, 0.3f, 0.4f, 0.5f, 0.65f, 0.8f, 1.0f, 1.25f, 1.5f, 2.0f, 3.0f, 5.0f};
        disFunList = new String[]{"\u57fa\u7840\u5bf9\u6bd4", "\u5e73\u65b9\u5bf9\u6bd4", "LAB"};
        CanvasBlock canva = (CanvasBlock)Blocks.canvas;
        palette = canva.palette;
        canvasSize = canva.canvasSize;
        tTable = new Table();
        scale = 1.0f;
        colorDisFun = 0;
    }

    private static class RGB {
        int r;
        int g;
        int b;

        RGB(int r, int g, int b) {
            this.r = r;
            this.g = g;
            this.b = b;
        }

        RGB(int rgba) {
            this(rgba >> 24 & 0xFF, rgba >> 16 & 0xFF, rgba >> 8 & 0xFF);
        }

        public RGB sub(RGB c) {
            this.r -= c.r;
            this.g -= c.g;
            this.b -= c.b;
            return this;
        }

        public RGB add(RGB c) {
            this.r = Math.max(Math.min(c.r + this.r, 255), 0);
            this.g = Math.max(Math.min(c.g + this.g, 255), 0);
            this.b = Math.max(Math.min(c.b + this.b, 255), 0);
            return this;
        }

        public RGB mul(int m) {
            this.r *= m;
            this.g *= m;
            this.b *= m;
            return this;
        }

        public RGB mv(int s) {
            this.r >>= s;
            this.g >>= s;
            this.b >>= s;
            return this;
        }

        public int pow() {
            return this.r * this.r + this.g * this.g + this.b * this.b;
        }

        public int rgba() {
            return this.r << 24 | this.g << 16 | this.b << 8 | 0xFF;
        }

        public RGB cpy() {
            return new RGB(this.r, this.g, this.b);
        }
    }
}

