/*
 * Decompiled with CFR 0.152.
 */
package mindustryX.features;

import arc.Core;
import arc.func.Cons;
import arc.net.dns.ArcDns;
import arc.net.dns.SRVRecord;
import arc.util.Log;
import arc.util.Threads;
import arc.util.Time;
import arc.util.Timer;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import mindustry.net.Host;
import mindustry.net.NetworkIO;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001fB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J6\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0010\u0010\u0016\u001a\f\u0012\b\u0012\u00060\u0017j\u0002`\u00180\u0014J4\u0010\u0019\u001a\u0004\u0018\u0001H\u001a\"\u0004\b\u0000\u0010\u001a*\b\u0012\u0004\u0012\u0002H\u001a0\u00052\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u0002H\u001a\u0012\u0004\u0012\u00020\u001d0\u001cH\u0082\b\u00a2\u0006\u0002\u0010\u001eR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0007\u001a\u00020\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\n\u00a8\u0006 "}, d2={"LmindustryX/features/PingService;", "", "<init>", "()V", "requests", "Ljava/util/LinkedList;", "LmindustryX/features/PingService$Req;", "socket", "Ljava/net/DatagramSocket;", "getSocket", "()Ljava/net/DatagramSocket;", "socket$delegate", "Lkotlin/Lazy;", "pingHost", "", "address", "", "port", "", "valid", "Larc/func/Cons;", "Lmindustry/net/Host;", "invalid", "Ljava/lang/Exception;", "Lkotlin/Exception;", "removeFirst", "T", "f", "Lkotlin/Function1;", "", "(Ljava/util/LinkedList;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "Req", "core"})
@SourceDebugExtension(value={"SMAP\nPingService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PingService.kt\nmindustryX/features/PingService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,86:1\n76#1,9:87\n1#2:96\n*S KotlinDebug\n*F\n+ 1 PingService.kt\nmindustryX/features/PingService\n*L\n48#1:87,9\n*E\n"})
public final class PingService {
    @NotNull
    public static final PingService INSTANCE = new PingService();
    @NotNull
    private static final LinkedList<Req> requests = new LinkedList();
    @NotNull
    private static final Lazy socket$delegate = LazyKt.lazy(PingService::socket_delegate$lambda$6);

    private PingService() {
    }

    private final DatagramSocket getSocket() {
        Lazy lazy = socket$delegate;
        return (DatagramSocket)lazy.getValue();
    }

    public final void pingHost(@NotNull String address, int port, @NotNull Cons<Host> valid, @NotNull Cons<Exception> invalid) {
        Intrinsics.checkNotNullParameter(address, "address");
        Intrinsics.checkNotNullParameter(valid, "valid");
        Intrinsics.checkNotNullParameter(invalid, "invalid");
        AtomicBoolean handled = new AtomicBoolean(false);
        InetAddress inetAddress = InetAddress.getByName(address);
        Intrinsics.checkNotNullExpressionValue(inetAddress, "getByName(...)");
        new Req(inetAddress, port, handled, valid).send();
        if (port == 6567) {
            Iterator iterator2 = ArcDns.getSrvRecords((String)("_mindustry._tcp." + address)).iterator();
            Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
            Iterator iterator3 = iterator2;
            while (iterator3.hasNext()) {
                SRVRecord record = (SRVRecord)iterator3.next();
                InetAddress inetAddress2 = InetAddress.getByName(record.target);
                Intrinsics.checkNotNullExpressionValue(inetAddress2, "getByName(...)");
                new Req(inetAddress2, record.port, handled, valid).send();
            }
        }
        Timer.schedule(() -> PingService.pingHost$lambda$10(handled, invalid), (float)2.0f);
    }

    private final <T> T removeFirst(LinkedList<T> $this$removeFirst, Function1<? super T, Boolean> f) {
        boolean $i$f$removeFirst = false;
        Iterator iterator2 = $this$removeFirst.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator iter = iterator2;
        while (iter.hasNext()) {
            Object it = iter.next();
            if (!f.invoke(it).booleanValue()) continue;
            iter.remove();
            return (T)it;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void socket_delegate$lambda$6$lambda$5$lambda$4(DatagramSocket $socket) {
        while (true) {
            Throwable throwable;
            Object object;
            Req req2;
            Object[] objectArray;
            DatagramPacket packet = new DatagramPacket(new byte[512], 512);
            $socket.receive(packet);
            LinkedList<Req> linkedList = requests;
            synchronized (linkedList) {
                Object v0;
                block7: {
                    Iterator iter$iv;
                    boolean req2 = false;
                    objectArray = INSTANCE;
                    LinkedList<Req> $this$removeFirst$iv = requests;
                    boolean $i$f$removeFirst = false;
                    Intrinsics.checkNotNullExpressionValue($this$removeFirst$iv.iterator(), "iterator(...)");
                    while (iter$iv.hasNext()) {
                        Object it$iv = iter$iv.next();
                        Req it = (Req)it$iv;
                        boolean bl = false;
                        if (!(Intrinsics.areEqual(it.getAddr(), packet.getAddress()) && it.getPort() == packet.getPort() && !it.getHandled().get())) continue;
                        iter$iv.remove();
                        v0 = it$iv;
                        break block7;
                    }
                    v0 = null;
                }
                req2 = v0;
            }
            if (req2 == null) continue;
            try {
                Req req3;
                boolean bl = false;
                req3.handle(packet);
                object = Result.constructor-impl(Unit.INSTANCE);
            }
            catch (Throwable throwable2) {
                object = Result.constructor-impl(ResultKt.createFailure(throwable2));
            }
            if (Result.exceptionOrNull-impl(object) == null) continue;
            Throwable it = throwable;
            boolean bl = false;
            objectArray = new Object[]{it};
            Log.warn((String)"Failed to handle ping request", (Object[])objectArray);
        }
    }

    private static final DatagramSocket socket_delegate$lambda$6() {
        DatagramSocket datagramSocket;
        DatagramSocket socket = datagramSocket = new DatagramSocket();
        boolean bl = false;
        Threads.daemon((String)"PingService", () -> PingService.socket_delegate$lambda$6$lambda$5$lambda$4(socket));
        return datagramSocket;
    }

    private static final boolean pingHost$lambda$10$lambda$8$lambda$7(AtomicBoolean $handled, Req it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return Intrinsics.areEqual(it.getHandled(), $handled);
    }

    private static final void pingHost$lambda$10$lambda$9(Cons $invalid) {
        $invalid.get((Object)new TimeoutException());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void pingHost$lambda$10(AtomicBoolean $handled, Cons $invalid) {
        LinkedList<Req> linkedList = requests;
        synchronized (linkedList) {
            boolean bl = false;
            boolean bl2 = CollectionsKt.removeAll((List)requests, arg_0 -> PingService.pingHost$lambda$10$lambda$8$lambda$7($handled, arg_0));
        }
        if ($handled.compareAndSet(false, true)) {
            Core.app.post(() -> PingService.pingHost$lambda$10$lambda$9($invalid));
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ\u0006\u0010\u001d\u001a\u00020\u001aR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001e"}, d2={"LmindustryX/features/PingService$Req;", "", "addr", "Ljava/net/InetAddress;", "port", "", "handled", "Ljava/util/concurrent/atomic/AtomicBoolean;", "callback", "Larc/func/Cons;", "Lmindustry/net/Host;", "<init>", "(Ljava/net/InetAddress;ILjava/util/concurrent/atomic/AtomicBoolean;Larc/func/Cons;)V", "getAddr", "()Ljava/net/InetAddress;", "getPort", "()I", "getHandled", "()Ljava/util/concurrent/atomic/AtomicBoolean;", "getCallback", "()Larc/func/Cons;", "time", "", "getTime", "()J", "handle", "", "packet", "Ljava/net/DatagramPacket;", "send", "core"})
    private static final class Req {
        @NotNull
        private final InetAddress addr;
        private final int port;
        @NotNull
        private final AtomicBoolean handled;
        @NotNull
        private final Cons<Host> callback;
        private final long time;

        public Req(@NotNull InetAddress addr, int port, @NotNull AtomicBoolean handled, @NotNull Cons<Host> callback) {
            Intrinsics.checkNotNullParameter(addr, "addr");
            Intrinsics.checkNotNullParameter(handled, "handled");
            Intrinsics.checkNotNullParameter(callback, "callback");
            this.addr = addr;
            this.port = port;
            this.handled = handled;
            this.callback = callback;
            this.time = Time.millis();
        }

        @NotNull
        public final InetAddress getAddr() {
            return this.addr;
        }

        public final int getPort() {
            return this.port;
        }

        @NotNull
        public final AtomicBoolean getHandled() {
            return this.handled;
        }

        @NotNull
        public final Cons<Host> getCallback() {
            return this.callback;
        }

        public final long getTime() {
            return this.time;
        }

        public final void handle(@NotNull DatagramPacket packet) {
            Intrinsics.checkNotNullParameter(packet, "packet");
            ByteBuffer buffer = ByteBuffer.wrap(packet.getData());
            Host host = NetworkIO.readServerData((int)Time.timeSinceMillis((long)this.time), this.addr.getHostAddress(), buffer);
            host.port = this.port;
            if (this.handled.compareAndSet(false, true)) {
                Core.app.post(() -> Req.handle$lambda$0(this, host));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void send() {
            LinkedList linkedList = requests;
            synchronized (linkedList) {
                boolean bl = false;
                boolean bl2 = requests.add(this);
            }
            byte[] byArray = new byte[]{-2, 1};
            INSTANCE.getSocket().send(new DatagramPacket(byArray, 2, this.addr, this.port));
        }

        private static final void handle$lambda$0(Req this$0, Host $host) {
            this$0.callback.get((Object)$host);
        }
    }
}

