/*
 * Decompiled with CFR 0.152.
 */
package mindustryX.features;

import arc.Core;
import arc.Events;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureAtlas;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.math.geom.Position;
import arc.math.geom.Vec2;
import arc.struct.ObjectIntMap;
import arc.struct.ObjectMap;
import arc.util.Nullable;
import arc.util.Reflect;
import arc.util.Strings;
import arc.util.Time;
import arc.util.Tmp;
import java.util.HashSet;
import kotlin.collections.CollectionsKt;
import mindustry.Vars;
import mindustry.entities.Effect;
import mindustry.game.EventType;
import mindustry.gen.Building;
import mindustry.gen.Bulletc;
import mindustry.gen.Drawc;
import mindustry.gen.EffectState;
import mindustry.gen.Player;
import mindustry.gen.Unit;
import mindustry.gen.Unitc;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.type.Item;
import mindustry.type.UnitType;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.blocks.defense.ForceProjector;
import mindustry.world.blocks.defense.MendProjector;
import mindustry.world.blocks.defense.OverdriveProjector;
import mindustry.world.blocks.defense.Radar;
import mindustry.world.blocks.defense.turrets.BaseTurret;
import mindustry.world.blocks.distribution.MassDriver;
import mindustry.world.blocks.logic.LogicBlock;
import mindustry.world.blocks.logic.MessageBlock;
import mindustry.world.blocks.production.Drill;
import mindustry.world.blocks.storage.CoreBlock;
import mindustry.world.blocks.units.Reconstructor;
import mindustry.world.blocks.units.UnitAssembler;
import mindustry.world.blocks.units.UnitFactory;
import mindustryX.VarsX;
import mindustryX.features.ArcBuilds;
import mindustryX.features.ArcOld;
import mindustryX.features.ArcRadar;
import mindustryX.features.ArcSpawnerShow;
import mindustryX.features.NewTransferScanMode;
import mindustryX.features.SettingsV2;
import mindustryX.features.UIExt;
import mindustryX.features.draw.ArcUnits;
import mindustryX.features.draw.PayloadDropHint;
import mindustryX.features.func.FuncX;

public class RenderExt {
    public static boolean displayAllMessage;
    public static boolean arcChoiceUiIcon;
    public static boolean researchViewer;
    public static int hiddenItemTransparency;
    public static float overdriveZoneTransparency;
    public static float mendZoneTransparency;
    public static boolean logicDisplayNoBorder;
    public static boolean arcDrillMode;
    public static int blockRenderLevel;
    public static boolean renderSort;
    public static boolean massDriverLine;
    public static int massDriverLineInterval;
    public static boolean drawBars;
    public static boolean drawBarsMend;
    public static boolean drawBlockDisabled;
    public static boolean showOtherInfo;
    public static boolean editOtherBlock;
    public static boolean unitWeaponTargetLine;
    public static boolean unitItemCarried;
    public static Color massDriverLineColor;
    public static Color playerEffectColor;
    public static final SettingsV2.CheckPref noBulletShow;
    public static final SettingsV2.CheckPref unitHitbox;
    public static final SettingsV2.CheckPref payloadPreview;
    public static final SettingsV2.CheckPref unitHide;
    public static final SettingsV2.CheckPref unitHideExcludePlayers;
    public static final SettingsV2.SliderPref unitHideMinHealth;
    public static final SettingsV2.CheckPref spawnerWaveDisplay;
    public static final SettingsV2.CheckPref transportScan;
    public static final SettingsV2.CheckPref announceRtsTake;
    public static final SettingsV2.CheckPref deadOverlay;
    public static final SettingsV2.CheckPref renderSort0;
    public static final SettingsV2.CheckPref arcChoiceUiIcon0;
    public static final SettingsV2.SliderPref hiddenItemTransparency0;
    public static final SettingsV2.SliderPref overdriveZoneTransparency0;
    public static final SettingsV2.SliderPref mendZoneTransparency0;
    public static final SettingsV2.SliderPref healthBarMinHealth;
    public static final SettingsV2.ChoosePref blockRenderLevel0;
    public static final SettingsV2.CheckPref showOtherTeamState;
    public static final SettingsV2.CheckPref editOtherBlock0;
    public static final SettingsV2.CheckPref logicDisplayNoBorder0;
    private static Effect placementEffect;
    static ObjectMap<String, HashSet<Unit>> removePool;

    public static void init() {
        placementEffect = new Effect(0.0f, e -> {
            Draw.color((Color)e.color);
            float range = e.rotation;
            Lines.stroke((1.5f - e.fin()) * (range / 100.0f));
            if (e.fin() < 0.7f) {
                Lines.circle(e.x, e.y, (float)((1.0 - Math.pow((0.7f - e.fin()) / 0.7f, 2.0)) * (double)range));
            } else {
                Draw.alpha((float)((1.0f - e.fin()) * 5.0f));
                Lines.circle(e.x, e.y, range);
            }
        });
        Events.run((Object)EventType.Trigger.update, () -> {
            displayAllMessage = Core.settings.getBool("displayallmessage");
            arcChoiceUiIcon = (Boolean)arcChoiceUiIcon0.get();
            researchViewer = (Boolean)VarsX.researchViewer.get();
            hiddenItemTransparency = (Integer)hiddenItemTransparency0.get();
            overdriveZoneTransparency = (float)((Integer)overdriveZoneTransparency0.get()).intValue() / 100.0f;
            mendZoneTransparency = (float)((Integer)mendZoneTransparency0.get()).intValue() / 100.0f;
            logicDisplayNoBorder = (Boolean)logicDisplayNoBorder0.get();
            arcDrillMode = Core.settings.getBool("arcdrillmode");
            blockRenderLevel = (Integer)blockRenderLevel0.get();
            renderSort = (Boolean)renderSort0.get();
            massDriverLine = Core.settings.getBool("mass_driver_line");
            massDriverLineInterval = Core.settings.getInt("mass_driver_line_interval");
            drawBars = Core.settings.getBool("blockBars");
            drawBarsMend = Core.settings.getBool("blockBars_mend");
            drawBlockDisabled = Core.settings.getBool("blockdisabled");
            showOtherInfo = (Boolean)showOtherTeamState.get();
            editOtherBlock = (Boolean)editOtherBlock0.get();
            editOtherBlock &= !Vars.net.client();
            unitWeaponTargetLine = Core.settings.getBool("unitWeaponTargetLine");
            unitItemCarried = Core.settings.getBool("unitItemCarried");
        });
        Events.run((Object)EventType.Trigger.draw, RenderExt::draw);
        Events.on(EventType.TileChangeEvent.class, RenderExt::onSetBlock);
        Events.on(EventType.ResetEvent.class, e -> removePool.clear());
        TextureAtlas.AtlasRegion white = Core.atlas.white();
        TextureAtlas.AtlasRegion whiteUI = Core.atlas.find("whiteui");
        TextureAtlas.AtlasRegion whiteSet = new TextureAtlas.AtlasRegion(white){

            public void set(TextureRegion region0) {
                super.set(region0);
                if (region0 instanceof TextureAtlas.AtlasRegion) {
                    TextureAtlas.AtlasRegion region = (TextureAtlas.AtlasRegion)region0;
                    this.name = region.name;
                    this.offsetX = region.offsetX;
                    this.offsetY = region.offsetY;
                    this.packedWidth = region.packedWidth;
                    this.packedHeight = region.packedHeight;
                    this.originalWidth = region.originalWidth;
                    this.originalHeight = region.originalHeight;
                    this.rotate = region.rotate;
                    this.splits = region.splits;
                }
            }
        };
        Reflect.set(TextureAtlas.class, (Object)Core.atlas, (String)"white", (Object)whiteSet);
        Events.run((Object)EventType.Trigger.uiDrawBegin, () -> whiteSet.set((TextureRegion)whiteUI));
        Events.run((Object)EventType.Trigger.uiDrawEnd, () -> whiteSet.set((TextureRegion)white));
    }

    private static void draw() {
        ArcSpawnerShow.update(Vars.player != null && !Vars.player.dead() && (Boolean)spawnerWaveDisplay.get() != false);
        if (Vars.player == null || Vars.player.dead()) {
            return;
        }
        ArcRadar.draw();
        if (((Boolean)payloadPreview.get()).booleanValue()) {
            PayloadDropHint.draw(Vars.player);
        }
        if (((Boolean)transportScan.get()).booleanValue()) {
            NewTransferScanMode.INSTANCE.draw();
        }
    }

    public static void onGroupDraw(Drawc t) {
        Unitc u;
        if (((Boolean)noBulletShow.get()).booleanValue() && t instanceof Bulletc) {
            return;
        }
        if (!Vars.renderer.enableEffects && t instanceof EffectState) {
            return;
        }
        if (t instanceof Unitc && (!(u = (Unitc)t).isPlayer() || !u.isLocal() && !((Boolean)unitHideExcludePlayers.get()).booleanValue()) && (((Boolean)unitHide.get()).booleanValue() || u.maxHealth() + u.shield() < (float)((Integer)unitHideMinHealth.get()).intValue())) {
            return;
        }
        t.draw();
        if (t instanceof Unit) {
            u = (Unit)t;
            ArcUnits.draw((Unit)u);
            if (((Boolean)unitHitbox.get()).booleanValue()) {
                RenderExt.drawHitBox((Unit)u);
            }
        }
    }

    public static void onBlockDraw(Tile tile, Block block, @Nullable Building build) {
        if (blockRenderLevel < 2) {
            return;
        }
        block.drawBase(tile);
        if (displayAllMessage && build instanceof MessageBlock.MessageBuild) {
            Draw.z((float)119.9f);
            build.drawSelect();
        }
        if (arcDrillMode && build instanceof Drill.DrillBuild) {
            Drill.DrillBuild drill = (Drill.DrillBuild)build;
            Draw.z((float)35.0f);
            RenderExt.arcDrillModeDraw(block, drill);
        }
        if (massDriverLine && build instanceof MassDriver.MassDriverBuild) {
            MassDriver.MassDriverBuild b = (MassDriver.MassDriverBuild)build;
            Draw.z((float)110.0f);
            RenderExt.drawMassDriverLine(b);
        }
        if (build != null && drawBars) {
            Draw.z((float)54.0f);
            RenderExt.drawBars(build);
        }
        if (build instanceof BaseTurret.BaseTurretBuild) {
            BaseTurret.BaseTurretBuild turretBuild = (BaseTurret.BaseTurretBuild)build;
            Draw.z((float)50.0f);
            ArcBuilds.arcTurret(turretBuild);
        }
    }

    private static void placementEffect(float x, float y, float lifetime, float range, Color color) {
        RenderExt.placementEffect.lifetime = lifetime;
        placementEffect.at(x, y, range, color);
    }

    public static void onSetBlock(EventType.TileChangeEvent event) {
        Building build = event.tile.build;
        if (build != null && ((Boolean)ArcOld.showPlacementEffect.get()).booleanValue()) {
            Block block = build.block;
            if (block instanceof BaseTurret) {
                BaseTurret t = (BaseTurret)block;
                RenderExt.placementEffect(build.x, build.y, 120.0f, t.range, build.team.color);
            } else {
                block = build.block;
                if (block instanceof Radar) {
                    Radar t = (Radar)block;
                    RenderExt.placementEffect(build.x, build.y, 120.0f, t.fogRadius * 8, build.team.color);
                } else {
                    block = build.block;
                    if (block instanceof CoreBlock) {
                        CoreBlock t = (CoreBlock)((Object)block);
                        RenderExt.placementEffect(build.x, build.y, 180.0f, t.fogRadius * 8, build.team.color);
                    } else {
                        block = build.block;
                        if (block instanceof MendProjector) {
                            MendProjector t = (MendProjector)block;
                            RenderExt.placementEffect(build.x, build.y, 120.0f, t.range, Pal.heal);
                        } else {
                            block = build.block;
                            if (block instanceof OverdriveProjector) {
                                OverdriveProjector t = (OverdriveProjector)block;
                                RenderExt.placementEffect(build.x, build.y, 120.0f, t.range, t.baseColor);
                            } else {
                                block = build.block;
                                if (block instanceof LogicBlock) {
                                    LogicBlock t = (LogicBlock)block;
                                    RenderExt.placementEffect(build.x, build.y, 120.0f, t.range, t.mapColor);
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    private static void arcDrillModeDraw(Block block, Drill.DrillBuild build) {
        Item dominantItem = build.dominantItem;
        if (dominantItem == null) {
            return;
        }
        int size = block.size;
        float dx = build.x - (float)(size * 8) / 2.0f + 5.0f;
        float dy = build.y - (float)(size * 8) / 2.0f + 5.0f;
        float iconSize = 5.0f;
        Draw.rect((TextureRegion)dominantItem.fullIcon, (float)dx, (float)dy, (float)iconSize, (float)iconSize);
        Draw.reset();
        float eff = Mathf.lerp((float)0.0f, (float)1.0f, (float)Math.min(1.0f, (float)build.dominantItems / (float)(size * size)));
        if (eff < 0.9f) {
            Draw.alpha((float)0.5f);
            Draw.color((Color)dominantItem.color);
            Lines.stroke(1.0f);
            Lines.arc(dx, dy, iconSize * 0.75f, eff);
        }
    }

    private static void drawMassDriverLine(MassDriver.MassDriverBuild build) {
        if (build.waitingShooters.isEmpty()) {
            return;
        }
        float x = build.x;
        float y = build.y;
        float size = build.block.size;
        float sin = Mathf.absin((float)Time.time, (float)6.0f, (float)1.0f);
        for (Building shooter : build.waitingShooters) {
            Lines.stroke(2.0f, Pal.placing);
            Drawf.dashLine((Color)massDriverLineColor, (float)shooter.x, (float)shooter.y, (float)x, (float)y);
            int slice = Mathf.floorPositive((float)(build.dst((Position)shooter) / (float)massDriverLineInterval));
            Vec2 interval = Tmp.v1.set((Position)build).sub((Position)shooter).setLength((float)massDriverLineInterval);
            float dx = interval.x;
            float dy = interval.y;
            for (int i = 0; i < slice; ++i) {
                Drawf.arrow((float)(shooter.x + dx * (float)i), (float)(shooter.y + dy * (float)i), (float)x, (float)y, (float)(size * 8.0f + sin), (float)(4.0f + sin), (Color)massDriverLineColor);
            }
        }
    }

    private static void drawBars(Building build) {
        if (build.health / build.maxHealth < 0.9f && build.maxHealth > (float)((Integer)healthBarMinHealth.get()).intValue()) {
            RenderExt.drawBar(build, build.team.color, Pal.health, Float.valueOf(build.health / build.maxHealth));
        }
        if (drawBarsMend) {
            Block block;
            if (build instanceof MendProjector.MendBuild) {
                MendProjector.MendBuild b = (MendProjector.MendBuild)build;
                block = (MendProjector)build.block;
                RenderExt.drawBar(build, Color.black, Pal.heal, Float.valueOf(b.charge / block.reload));
            } else if (build instanceof ForceProjector.ForceBuild) {
                ForceProjector.ForceBuild b = (ForceProjector.ForceBuild)build;
                if (b.buildup > 0.0f) {
                    block = (ForceProjector)build.block;
                    float ratio = 1.0f - b.buildup / (((ForceProjector)block).shieldHealth + ((ForceProjector)block).phaseShieldBoost * b.phaseHeat);
                    RenderExt.drawBar(build, Color.black, b.broken ? Pal.remove : Pal.stat, Float.valueOf(ratio));
                }
            }
        }
        float buildRatio = -1.0f;
        float leftTime = 0.0f;
        if (build instanceof Reconstructor.ReconstructorBuild) {
            Reconstructor.ReconstructorBuild b = (Reconstructor.ReconstructorBuild)((Object)build);
            buildRatio = b.fraction();
            leftTime = ((Reconstructor)((Object)build.block)).constructTime - b.progress;
        } else if (build instanceof UnitAssembler.UnitAssemblerBuild) {
            UnitAssembler.UnitAssemblerBuild b = (UnitAssembler.UnitAssemblerBuild)((Object)build);
            buildRatio = b.progress;
            leftTime = b.plan().time * (1.0f - b.progress);
        } else if (build instanceof UnitFactory.UnitFactoryBuild) {
            UnitFactory.UnitFactoryBuild b = (UnitFactory.UnitFactoryBuild)((Object)build);
            buildRatio = b.fraction();
            float f = leftTime = b.currentPlan == -1 ? -1.0f : ((UnitFactory.UnitPlan)((UnitFactory)((Object)build.block)).plans.get((int)b.currentPlan)).time - b.progress;
        }
        if (buildRatio >= 0.0f) {
            RenderExt.drawBar(build, Color.black, Pal.accent, Float.valueOf(buildRatio));
            String progressT = Strings.format((String)"[stat]@% | @s", (Object[])new Object[]{(int)(Mathf.clamp((float)buildRatio, (float)0.0f, (float)1.0f) * 100.0f), leftTime < 0.0f ? Character.valueOf('\ue815') : Strings.fixed((float)(leftTime / (60.0f * Vars.state.rules.unitBuildSpeed(build.team) * build.timeScale())), (int)0)});
            FuncX.drawText((Position)Tmp.v1.set((Position)build).add(0.0f, build.block.offset * 0.8f - 5.0f), progressT, 0.9f);
        }
    }

    private static void drawBar(Building build, Color bg, Color fg, Float ratio) {
        float x = build.x;
        float size = (float)(build.block.size * 8) * 0.5f;
        float x1 = x - size * 0.6f;
        float x2 = x + size * 0.6f;
        float y = build.y + size * 0.8f;
        Draw.color((Color)bg, (float)0.3f);
        Lines.stroke(4.0f);
        Lines.line(x1, y, x2, y);
        Draw.color((Color)fg, (float)0.6f);
        Lines.stroke(2.0f);
        Lines.line(x1, y, Mathf.lerp((float)x1, (float)x2, (float)Mathf.clamp((float)ratio.floatValue(), (float)0.0f, (float)1.0f)), y);
        Draw.reset();
    }

    private static void drawHitBox(Unit unit) {
        Draw.color((Color)unit.team.color, (float)0.5f);
        Lines.circle(unit.x, unit.y, unit.hitSize / 2.0f);
        Draw.color();
    }

    public static void onRtsRemoveUnit(Player player, Unit unit) {
        if (!((Boolean)announceRtsTake.get()).booleanValue()) {
            return;
        }
        if (removePool.containsKey((Object)player.name)) {
            ((HashSet)removePool.get((Object)player.name)).add(unit);
            return;
        }
        HashSet<Unit> set = new HashSet<Unit>();
        set.add(unit);
        removePool.put((Object)player.name, set);
        Time.run((float)60.0f, () -> {
            ObjectIntMap count = new ObjectIntMap();
            for (Unit u : set) {
                count.increment((Object)u.type);
            }
            StringBuilder builder = new StringBuilder();
            builder.append("[gold][MDTX][]").append(player.name).append("\n[white]\u5206\u8d70\u4e86\u5355\u4f4d: ");
            for (UnitType type : count.keys()) {
                builder.append(type.emoji()).append("x").append(count.get((Object)type)).append(" ");
            }
            UIExt.announce(builder.toString());
        });
    }

    static {
        massDriverLineColor = Color.clear;
        playerEffectColor = Color.clear;
        noBulletShow = new SettingsV2.CheckPref("entityRender.noBulletShow");
        unitHitbox = new SettingsV2.CheckPref("entityRender.unitHitbox");
        payloadPreview = new SettingsV2.CheckPref("entityRender.payloadPreview");
        unitHide = new SettingsV2.CheckPref("entityRender.unitHide");
        unitHideExcludePlayers = new SettingsV2.CheckPref("entityRender.unitHideExcludePlayers", true);
        unitHideMinHealth = new SettingsV2.SliderPref("entityRender.unitHideMinHealth", 0, 0, 4000, 50, v -> v + "[red]HP");
        spawnerWaveDisplay = new SettingsV2.CheckPref("gameUI.spawnerWaveDisplay", true);
        transportScan = new SettingsV2.CheckPref("gameUI.transportScan");
        announceRtsTake = new SettingsV2.CheckPref("gameUI.announceRtsTake", true);
        deadOverlay = new SettingsV2.CheckPref("gameUI.deadOverlay");
        renderSort0 = new SettingsV2.CheckPref("debug.renderSort");
        arcChoiceUiIcon0 = new SettingsV2.CheckPref("block.arcChoiceUiIcon");
        hiddenItemTransparency0 = new SettingsV2.SliderPref("block.hiddenItemTransparency", 0, 0, 100, 2, v -> v > 0 ? v + "%" : "\u5173\u95ed");
        overdriveZoneTransparency0 = new SettingsV2.SliderPref("block.overdriveZoneTransparency", 0, 0, 100, 2, v -> v > 0 ? v + "%" : "\u5173\u95ed");
        mendZoneTransparency0 = new SettingsV2.SliderPref("block.mendZoneTransparency", 0, 0, 100, 2, v -> v > 0 ? v + "%" : "\u5173\u95ed");
        healthBarMinHealth = new SettingsV2.SliderPref("block.healthBarMinHealth", 0, 0, 4000, 50, v -> v > 0 ? v + "[red]HP" : "\u5168\u90e8\u663e\u793a");
        blockRenderLevel0 = new SettingsV2.ChoosePref("block.renderLevel", CollectionsKt.listOf("\u9690\u85cf\u5168\u90e8\u5efa\u7b51", "\u53ea\u663e\u793a\u5efa\u7b51\u72b6\u6001", "\u5168\u90e8\u663e\u793a"), 2);
        showOtherTeamState = new SettingsV2.CheckPref("block.showOtherTeamState");
        editOtherBlock0 = new SettingsV2.CheckPref("block.editOtherBlock");
        logicDisplayNoBorder0 = new SettingsV2.CheckPref("block.logicDisplayNoBorder");
        final SettingsV2.PersistentProvider.Arc internal = new SettingsV2.PersistentProvider.Arc("bulletShow");
        noBulletShow.addFallback(new SettingsV2.PersistentProvider<Boolean>(){

            @Override
            public Boolean get() {
                if (internal.get() == null) {
                    return null;
                }
                return (Boolean)internal.get() == false;
            }

            @Override
            public void reset() {
                internal.reset();
            }
        });
        unitHitbox.addFallbackName("unithitbox");
        unitHitbox.addFallbackName("payloadpreview");
        unitHide.setPersistentProvider(SettingsV2.PersistentProvider.Noop.INSTANCE);
        unitHideExcludePlayers.addFallbackName("unitHideExcludePlayers");
        unitHideMinHealth.addFallbackName("unitDrawMinHealth");
        deadOverlay.addFallbackName("deadOverlay");
        arcChoiceUiIcon0.addFallbackName("arcchoiceuiIcon");
        hiddenItemTransparency0.addFallbackName("HiddleItemTransparency");
        overdriveZoneTransparency0.addFallbackName("overdrive_zone");
        mendZoneTransparency0.addFallbackName("mend_zone");
        healthBarMinHealth.addFallbackName("blockbarminhealth");
        blockRenderLevel0.addFallbackName("blockRenderLevel");
        showOtherTeamState.addFallbackName("showOtherTeamState");
        editOtherBlock0.addFallbackName("editOtherBlock");
        logicDisplayNoBorder0.addFallbackName("logicDisplayNoBorder");
        removePool = new ObjectMap();
    }
}

