/*
 * Decompiled with CFR 0.152.
 */
package mindustryX.features;

import arc.Core;
import arc.Events;
import arc.files.Fi;
import arc.scene.style.Drawable;
import arc.scene.ui.layout.Table;
import arc.util.Log;
import arc.util.Reflect;
import arc.util.Strings;
import arc.util.Threads;
import arc.util.Time;
import java.io.EOFException;
import java.util.Date;
import java.util.List;
import mindustry.Vars;
import mindustry.core.Version;
import mindustry.game.EventType;
import mindustry.gen.Icon;
import mindustry.net.Net;
import mindustry.net.Packet;
import mindustry.net.Packets;
import mindustry.ui.dialogs.BaseDialog;
import mindustry.ui.dialogs.FileChooser;
import mindustry.ui.dialogs.PausedDialog;
import mindustryX.features.LogicExt;
import mindustryX.features.ReplayData;
import mindustryX.features.SettingsV2;

public class ReplayController {
    private static final SettingsV2.CheckPref enable = new SettingsV2.CheckPref("replayRecord");
    public static boolean replaying;
    private static ReplayData.Writer writer;
    private static ReplayData.Reader reader;

    public static void init() {
        Events.run((Object)EventType.Trigger.update, () -> {
            if (replaying && Vars.state.isMenu() && !Vars.netClient.isConnecting()) {
                ReplayController.stopPlay();
            }
        });
        Events.on(EventType.ClientServerConnectEvent.class, e -> ReplayController.stopPlay());
        Table buttons = Vars.ui.join.buttons;
        buttons.button("\u52a0\u8f7d\u56de\u653e\u6587\u4ef6", (Drawable)Icon.file, () -> {
            FileChooser.setLastDirectory((Fi)Vars.saveDirectory);
            Vars.platform.showFileChooser(true, "\u6253\u5f00\u56de\u653e\u6587\u4ef6", "mrep", f -> Core.app.post(() -> ReplayController.startPlay(f)));
        });
        PausedDialog pausedDialog = Vars.ui.paused;
        pausedDialog.shown(() -> {
            if (!replaying) {
                return;
            }
            pausedDialog.cont.row().button("\u67e5\u770b\u5f55\u5236\u4fe1\u606f", (Drawable)Icon.fileImage, ReplayController::showInfo).name("ReplayInfo").size(0.0f, 60.0f).colspan(pausedDialog.cont.getColumns()).fill();
        });
    }

    public static void onConnect(String ip) {
        ReplayData.Writer writer;
        if (!((Boolean)enable.get()).booleanValue() || LogicExt.contentsCompatibleMode) {
            return;
        }
        if (replaying) {
            return;
        }
        Fi file = Vars.saveDirectory.child(new Date().getTime() + ".mrep");
        try {
            writer = new ReplayData.Writer(file.write(false, 8192));
        }
        catch (Exception e) {
            Log.err((String)"\u521b\u5efa\u56de\u653e\u51fa\u9519!", (Throwable)e);
            return;
        }
        boolean anonymous = Core.settings.getBool("anonymous", false);
        ReplayData header = new ReplayData(Version.build, new Date(), anonymous ? "anonymous" : ip, anonymous ? "anonymous" : Vars.player.name.trim());
        writer.writeHeader(header);
        Log.info((String)"\u5f55\u5236\u4e2d: @", (Object[])new Object[]{file.absolutePath()});
        ReplayController.writer = writer;
    }

    public static void onClientPacket(Packet p) {
        if (writer == null) {
            return;
        }
        if (p instanceof Packets.Disconnect) {
            writer.close();
            writer = null;
            Log.info((Object)"\u5f55\u5236\u7ed3\u675f");
            return;
        }
        try {
            writer.writePacket(p);
        }
        catch (Exception e) {
            Vars.net.disconnect();
            Log.err((Throwable)e);
            Core.app.post(() -> Vars.ui.showException("\u5f55\u5236\u51fa\u9519!", e));
        }
    }

    public static void startPlay(Fi input) {
        try {
            reader = new ReplayData.Reader(input);
            Log.infoTag((String)"Replay", (String)reader.getMeta().toString());
        }
        catch (Exception e) {
            Core.app.post(() -> Vars.ui.showException("\u8bfb\u53d6\u56de\u653e\u5931\u8d25!", e));
        }
        replaying = true;
        Vars.ui.loadfrag.show("@connecting");
        Vars.ui.loadfrag.setButton(ReplayController::stopPlay);
        Vars.logic.reset();
        Vars.net.reset();
        Vars.netClient.beginConnecting();
        Reflect.set((Object)Vars.net, (String)"active", (Object)true);
        Threads.daemon((String)"Replay Controller", () -> {
            float startTime = Time.time;
            try {
                while (replaying) {
                    ReplayData.PacketInfo info = reader.nextPacket();
                    Packet packet = reader.readPacket(info);
                    while (Time.time - startTime < info.getOffset()) {
                        Thread.sleep(1L);
                    }
                    Core.app.post(() -> {
                        if (!replaying) {
                            return;
                        }
                        try {
                            Vars.net.handleClientReceived(packet);
                        }
                        catch (Exception e) {
                            ReplayController.stopPlay();
                            Vars.net.handleException(e);
                        }
                    });
                }
            }
            catch (EOFException e) {
                replaying = false;
                ReplayController.showInfo();
            }
            catch (Exception e) {
                replaying = false;
                Vars.ui.showException("Replay Error", e);
            }
            finally {
                ReplayController.stopPlay();
            }
        });
    }

    public static void stopPlay() {
        if (!replaying) {
            if (reader != null) {
                reader.close();
                reader = null;
            }
            return;
        }
        Log.infoTag((String)"Replay", (String)"stop");
        replaying = false;
        reader.close();
        reader = null;
        Vars.net.disconnect();
        Vars.ui.loadfrag.hide();
        Core.app.post(() -> Vars.logic.reset());
    }

    public static void showInfo() {
        BaseDialog dialog = new BaseDialog("\u56de\u653e\u7edf\u8ba1");
        if (reader == null) {
            dialog.cont.add((CharSequence)"\u672a\u52a0\u8f7d\u56de\u653e!");
            return;
        }
        ReplayData replay = reader.getMeta();
        dialog.cont.add((CharSequence)("\u56de\u653e\u7248\u672c:" + replay.getVersion())).row();
        dialog.cont.add((CharSequence)("\u56de\u653e\u521b\u5efa\u65f6\u95f4:" + replay.getTime())).row();
        dialog.cont.add((CharSequence)("\u670d\u52a1\u5668ip:" + replay.getServerIp())).row();
        dialog.cont.add((CharSequence)("\u73a9\u5bb6\u540d:" + replay.getRecordPlayer())).row();
        if (reader.getSource() != null) {
            ReplayData.Reader tmpReader = new ReplayData.Reader(reader.getSource());
            List<ReplayData.PacketInfo> packets = tmpReader.allPacket();
            tmpReader.close();
            dialog.cont.add((CharSequence)("\u6570\u636e\u5305\u603b\u6570\uff1a" + packets.size())).row();
            int secs = (int)(packets.get(packets.size() - 1).getOffset() / 60.0f);
            dialog.cont.add((CharSequence)("\u56de\u653e\u957f\u5ea6:" + secs / 3600 + ":" + secs / 60 % 60 + ":" + secs % 60)).row();
            dialog.cont.pane(t -> {
                t.defaults().pad(2.0f);
                for (ReplayData.PacketInfo packet : packets) {
                    t.add((CharSequence)Strings.format((String)"+@s", (Object[])new Object[]{Strings.fixed((float)(packet.getOffset() / 60.0f), (int)2)}));
                    t.add((CharSequence)Net.newPacket(packet.getId()).getClass().getSimpleName()).fillX();
                    t.add((CharSequence)("L=" + packet.getLength()));
                    t.row();
                }
            }).growX().row();
        }
        dialog.addCloseButton();
        dialog.show();
    }
}

