/*
 * Decompiled with CFR 0.152.
 */
package mindustryX.features;

import arc.files.Fi;
import arc.util.Time;
import arc.util.io.ByteBufferOutput;
import arc.util.io.Reads;
import arc.util.io.Writes;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.List;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import kotlin.Metadata;
import kotlin.UInt;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import mindustry.Vars;
import mindustry.net.Net;
import mindustry.net.Packet;
import mindustry.net.Streamable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\b\b\u0086\b\u0018\u00002\u00020\u0001:\u0004\u001c\u001d\u001e\u001fB'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0007H\u00c6\u0003J1\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u0007H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010\u00a8\u0006 "}, d2={"LmindustryX/features/ReplayData;", "", "version", "", "time", "Ljava/util/Date;", "serverIp", "", "recordPlayer", "<init>", "(ILjava/util/Date;Ljava/lang/String;Ljava/lang/String;)V", "getVersion", "()I", "getTime", "()Ljava/util/Date;", "getServerIp", "()Ljava/lang/String;", "getRecordPlayer", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "toString", "FakeServer", "Writer", "Reader", "PacketInfo", "core"})
public final class ReplayData {
    private final int version;
    @NotNull
    private final Date time;
    @NotNull
    private final String serverIp;
    @NotNull
    private final String recordPlayer;

    public ReplayData(int version, @NotNull Date time, @NotNull String serverIp, @NotNull String recordPlayer) {
        Intrinsics.checkNotNullParameter(time, "time");
        Intrinsics.checkNotNullParameter(serverIp, "serverIp");
        Intrinsics.checkNotNullParameter(recordPlayer, "recordPlayer");
        this.version = version;
        this.time = time;
        this.serverIp = serverIp;
        this.recordPlayer = recordPlayer;
    }

    public final int getVersion() {
        return this.version;
    }

    @NotNull
    public final Date getTime() {
        return this.time;
    }

    @NotNull
    public final String getServerIp() {
        return this.serverIp;
    }

    @NotNull
    public final String getRecordPlayer() {
        return this.recordPlayer;
    }

    public final int component1() {
        return this.version;
    }

    @NotNull
    public final Date component2() {
        return this.time;
    }

    @NotNull
    public final String component3() {
        return this.serverIp;
    }

    @NotNull
    public final String component4() {
        return this.recordPlayer;
    }

    @NotNull
    public final ReplayData copy(int version, @NotNull Date time, @NotNull String serverIp, @NotNull String recordPlayer) {
        Intrinsics.checkNotNullParameter(time, "time");
        Intrinsics.checkNotNullParameter(serverIp, "serverIp");
        Intrinsics.checkNotNullParameter(recordPlayer, "recordPlayer");
        return new ReplayData(version, time, serverIp, recordPlayer);
    }

    public static /* synthetic */ ReplayData copy$default(ReplayData replayData, int n, Date date, String string, String string2, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = replayData.version;
        }
        if ((n2 & 2) != 0) {
            date = replayData.time;
        }
        if ((n2 & 4) != 0) {
            string = replayData.serverIp;
        }
        if ((n2 & 8) != 0) {
            string2 = replayData.recordPlayer;
        }
        return replayData.copy(n, date, string, string2);
    }

    @NotNull
    public String toString() {
        return "ReplayData(version=" + this.version + ", time=" + this.time + ", serverIp=" + this.serverIp + ", recordPlayer=" + this.recordPlayer + ')';
    }

    public int hashCode() {
        int result = Integer.hashCode(this.version);
        result = result * 31 + this.time.hashCode();
        result = result * 31 + this.serverIp.hashCode();
        result = result * 31 + this.recordPlayer.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ReplayData)) {
            return false;
        }
        ReplayData replayData = (ReplayData)other;
        if (this.version != replayData.version) {
            return false;
        }
        if (!Intrinsics.areEqual(this.time, replayData.time)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.serverIp, replayData.serverIp)) {
            return false;
        }
        return Intrinsics.areEqual(this.recordPlayer, replayData.recordPlayer);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"LmindustryX/features/ReplayData$FakeServer;", "Lmindustry/net/Net;", "<init>", "()V", "server", "", "core"})
    private static final class FakeServer
    extends Net {
        @NotNull
        public static final FakeServer INSTANCE = new FakeServer();

        private FakeServer() {
            super(null);
        }

        @Override
        public boolean server() {
            return true;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0007H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001a"}, d2={"LmindustryX/features/ReplayData$PacketInfo;", "", "offset", "", "id", "", "length", "", "<init>", "(FBI)V", "getOffset", "()F", "getId", "()B", "getLength", "()I", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "core"})
    public static final class PacketInfo {
        private final float offset;
        private final byte id;
        private final int length;

        public PacketInfo(float offset, byte id, int length) {
            this.offset = offset;
            this.id = id;
            this.length = length;
        }

        public final float getOffset() {
            return this.offset;
        }

        public final byte getId() {
            return this.id;
        }

        public final int getLength() {
            return this.length;
        }

        public final float component1() {
            return this.offset;
        }

        public final byte component2() {
            return this.id;
        }

        public final int component3() {
            return this.length;
        }

        @NotNull
        public final PacketInfo copy(float offset, byte id, int length) {
            return new PacketInfo(offset, id, length);
        }

        public static /* synthetic */ PacketInfo copy$default(PacketInfo packetInfo, float f, byte by, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                f = packetInfo.offset;
            }
            if ((n2 & 2) != 0) {
                by = packetInfo.id;
            }
            if ((n2 & 4) != 0) {
                n = packetInfo.length;
            }
            return packetInfo.copy(f, by, n);
        }

        @NotNull
        public String toString() {
            return "PacketInfo(offset=" + this.offset + ", id=" + this.id + ", length=" + this.length + ')';
        }

        public int hashCode() {
            int result = Float.hashCode(this.offset);
            result = result * 31 + Byte.hashCode(this.id);
            result = result * 31 + Integer.hashCode(this.length);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PacketInfo)) {
                return false;
            }
            PacketInfo packetInfo = (PacketInfo)other;
            if (Float.compare(this.offset, packetInfo.offset) != 0) {
                return false;
            }
            if (this.id != packetInfo.id) {
                return false;
            }
            return this.length == packetInfo.length;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0011\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0004\u0010\bJ\b\u0010\u0019\u001a\u00020\u000eH\u0002J\u0006\u0010\u001a\u001a\u00020\u001bJ\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001bJ\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001b0 J\b\u0010!\u001a\u00020\"H\u0016J\f\u0010#\u001a\u00020$*\u00020\nH\u0002R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0011\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\bR\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"LmindustryX/features/ReplayData$Reader;", "Ljava/io/Closeable;", "inputStream", "Ljava/io/InputStream;", "<init>", "(Ljava/io/InputStream;)V", "fi", "Larc/files/Fi;", "(Larc/files/Fi;)V", "reads", "Ljava/io/DataInputStream;", "getReads", "()Ljava/io/DataInputStream;", "meta", "LmindustryX/features/ReplayData;", "getMeta", "()LmindustryX/features/ReplayData;", "source", "getSource", "()Larc/files/Fi;", "setSource", "arcOldFormat", "", "readsWrap", "Larc/util/io/Reads;", "readHeader", "nextPacket", "LmindustryX/features/ReplayData$PacketInfo;", "readPacket", "Lmindustry/net/Packet;", "info", "allPacket", "", "close", "", "readVarShort", "", "core"})
    public static final class Reader
    implements Closeable {
        @NotNull
        private final DataInputStream reads;
        @NotNull
        private final ReplayData meta;
        @Nullable
        private Fi source;
        private final boolean arcOldFormat;
        @NotNull
        private final Reads readsWrap;

        public Reader(@NotNull InputStream inputStream) {
            Intrinsics.checkNotNullParameter(inputStream, "inputStream");
            this.reads = new DataInputStream(new InflaterInputStream(inputStream));
            this.meta = this.readHeader();
            this.arcOldFormat = this.meta.getVersion() <= 10;
            this.readsWrap = new Reads((DataInput)this.reads);
        }

        @NotNull
        public final DataInputStream getReads() {
            return this.reads;
        }

        @NotNull
        public final ReplayData getMeta() {
            return this.meta;
        }

        @Nullable
        public final Fi getSource() {
            return this.source;
        }

        public final void setSource(@Nullable Fi fi) {
            this.source = fi;
        }

        public Reader(@NotNull Fi fi) {
            Intrinsics.checkNotNullParameter(fi, "fi");
            BufferedInputStream bufferedInputStream = fi.read(32768);
            Intrinsics.checkNotNullExpressionValue(bufferedInputStream, "read(...)");
            this(bufferedInputStream);
            this.source = fi;
        }

        private final ReplayData readHeader() {
            int version = this.reads.readInt();
            Date time = new Date(this.reads.readLong());
            String serverIp = this.reads.readUTF();
            String recordPlayer = this.reads.readUTF();
            Intrinsics.checkNotNull(serverIp);
            Intrinsics.checkNotNull(recordPlayer);
            return new ReplayData(version, time, serverIp, recordPlayer);
        }

        @NotNull
        public final PacketInfo nextPacket() throws EOFException {
            float offset = !this.arcOldFormat ? this.reads.readFloat() : (float)this.reads.readLong() * 60.0f / (float)1000000L / (float)1000;
            byte id = this.reads.readByte();
            int length = this.readVarShort(this.reads);
            return new PacketInfo(offset, id, length);
        }

        @NotNull
        public final Packet readPacket(@NotNull PacketInfo info) throws IOException {
            Intrinsics.checkNotNullParameter(info, "info");
            Object p = Net.newPacket(info.getId());
            if (p instanceof Streamable) {
                byte[] bs = new byte[info.getLength()];
                this.reads.readFully(bs);
                ((Streamable)p).stream = new ByteArrayInputStream(bs);
            } else {
                p.read(this.readsWrap, info.getLength());
            }
            Intrinsics.checkNotNull(p);
            return p;
        }

        @NotNull
        public final List<PacketInfo> allPacket() {
            List<PacketInfo> list;
            List<PacketInfo> $this$allPacket_u24lambda_u240 = list = CollectionsKt.createListBuilder();
            boolean bl = false;
            while (true) {
                try {
                    PacketInfo info = this.nextPacket();
                    this.reads.skip(info.getLength());
                    $this$allPacket_u24lambda_u240.add(info);
                }
                catch (EOFException e) {
                    return CollectionsKt.build(list);
                }
            }
        }

        @Override
        public void close() {
            this.reads.close();
        }

        private final int readVarShort(DataInputStream $this$readVarShort) {
            int n;
            int high = $this$readVarShort.readUnsignedShort();
            if ((high & 0x8000) != 0) {
                int low = $this$readVarShort.readUnsignedShort();
                n = ((high & Short.MAX_VALUE) << 16) + low;
            } else {
                n = high;
            }
            return n;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0016J\b\u0010\u0017\u001a\u00020\u0011H\u0016J\u0014\u0010\u0018\u001a\u00020\u0011*\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u001aH\u0002R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"LmindustryX/features/ReplayData$Writer;", "Ljava/io/Closeable;", "outputStream", "Ljava/io/OutputStream;", "<init>", "(Ljava/io/OutputStream;)V", "writes", "Ljava/io/DataOutputStream;", "getWrites", "()Ljava/io/DataOutputStream;", "startTime", "", "tmpBuf", "Ljava/nio/ByteBuffer;", "tmpWr", "Larc/util/io/Writes;", "writeHeader", "", "meta", "LmindustryX/features/ReplayData;", "writePacket", "packet", "Lmindustry/net/Packet;", "close", "writeVarShort", "value", "", "core"})
    public static final class Writer
    implements Closeable {
        @NotNull
        private final DataOutputStream writes;
        private final float startTime;
        @NotNull
        private final ByteBuffer tmpBuf;
        @NotNull
        private final Writes tmpWr;

        public Writer(@NotNull OutputStream outputStream) {
            Intrinsics.checkNotNullParameter(outputStream, "outputStream");
            this.writes = new DataOutputStream(new DeflaterOutputStream(outputStream));
            this.startTime = Time.time;
            ByteBuffer byteBuffer = ByteBuffer.allocate(32768);
            Intrinsics.checkNotNullExpressionValue(byteBuffer, "allocate(...)");
            this.tmpBuf = byteBuffer;
            this.tmpWr = new Writes((DataOutput)new ByteBufferOutput(this.tmpBuf));
        }

        @NotNull
        public final DataOutputStream getWrites() {
            return this.writes;
        }

        public final void writeHeader(@NotNull ReplayData meta) {
            Intrinsics.checkNotNullParameter(meta, "meta");
            this.writes.writeInt(meta.getVersion());
            this.writes.writeLong(meta.getTime().getTime());
            this.writes.writeUTF(meta.getServerIp());
            this.writes.writeUTF(meta.getRecordPlayer());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void writePacket(@NotNull Packet packet) {
            Intrinsics.checkNotNullParameter(packet, "packet");
            int id = UInt.constructor-impl(Net.getPacketId(packet));
            this.writes.writeFloat(Time.time - this.startTime);
            this.writes.writeByte(id);
            if (packet instanceof Streamable) {
                ByteArrayInputStream byteArrayInputStream;
                ByteArrayInputStream $this$writePacket_u24lambda_u240 = byteArrayInputStream = ((Streamable)packet).stream;
                boolean bl = false;
                $this$writePacket_u24lambda_u240.mark($this$writePacket_u24lambda_u240.available());
                this.writeVarShort(this.writes, $this$writePacket_u24lambda_u240.available());
                Intrinsics.checkNotNull($this$writePacket_u24lambda_u240);
                ByteStreamsKt.copyTo$default($this$writePacket_u24lambda_u240, this.writes, 0, 2, null);
                $this$writePacket_u24lambda_u240.reset();
            } else {
                this.tmpBuf.position(0);
                Net oldNet = Vars.net;
                try {
                    Vars.net = FakeServer.INSTANCE;
                    packet.write(this.tmpWr);
                }
                finally {
                    Vars.net = oldNet;
                }
                this.writeVarShort(this.writes, this.tmpBuf.position());
                this.writes.write(this.tmpBuf.array(), 0, this.tmpBuf.position());
            }
        }

        @Override
        public void close() {
            this.writes.close();
        }

        private final void writeVarShort(DataOutputStream $this$writeVarShort, int value) {
            if (value > Short.MAX_VALUE) {
                $this$writeVarShort.writeInt(Integer.MIN_VALUE | value);
            } else {
                $this$writeVarShort.writeShort(value);
            }
        }
    }
}

