/*
 * Decompiled with CFR 0.152.
 */
package mindustryX.features;

import arc.util.Nullable;
import arc.util.Strings;
import mindustry.Vars;
import mindustry.entities.abilities.Ability;
import mindustry.entities.abilities.ForceFieldAbility;
import mindustry.entities.abilities.LiquidExplodeAbility;
import mindustry.entities.abilities.LiquidRegenAbility;
import mindustry.entities.abilities.MoveLightningAbility;
import mindustry.entities.abilities.SuppressionFieldAbility;
import mindustry.entities.pattern.ShootHelix;
import mindustry.entities.pattern.ShootMulti;
import mindustry.entities.pattern.ShootPattern;
import mindustry.type.UnitType;
import mindustry.ui.Styles;
import mindustry.world.Block;
import mindustry.world.meta.BlockFlag;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatCat;
import mindustry.world.meta.StatValue;

public class StatExt {
    public static Stat canOverdrive = new Stat("can_overdrive");
    public static Stat cost = new Stat("cost");
    public static Stat healthScaling = new Stat("health_scaling");
    public static Stat hardness = new Stat("hardness");
    public static Stat buildable = new Stat("buildable");
    public static Stat boilPoint = new Stat("boil_point");
    public static Stat dragMultiplier = new Stat("drag_multiplier");
    public static Stat bufferCapacity = new Stat("buffer_capacity", StatCat.items);
    public static Stat regenSpeed = new Stat("regen_speed", StatCat.function);
    public static Stat regenSpeedBroken = new Stat("regen_speed_broken", StatCat.function);
    public static Stat mend = new Stat("mend", StatCat.function);
    public static Stat mendReload = new Stat("mend_reload", StatCat.function);
    public static Stat mendSpeed = new Stat("mend_speed", StatCat.function);
    public static Stat warmupPartial = new Stat("warmup_partial", StatCat.power);
    public static Stat warmupTime = new Stat("warmup_time", StatCat.power);
    public static Stat warmupPower = new Stat("warmup_power", StatCat.power);
    public static Stat rotateSpeed = new Stat("rotate_speed", StatCat.movement);
    public static Stat boostMultiplier = new Stat("boost_multiplier", StatCat.movement);
    public static Stat drownTimeMultiplier = new Stat("drown_time_multiplier", StatCat.movement);
    public static Stat mineLevel = new Stat("mine_level", StatCat.support);
    public static Stat crushDamage = new Stat("crush_damage", StatCat.combat);
    public static Stat estimateDPS = new Stat("estimate_dps", StatCat.combat);
    public static Stat aiController = new Stat("ai_controller", StatCat.combat);
    public static Stat targets = new Stat("targets", StatCat.combat);
    public static Stat ammoType = new Stat("ammo_type", StatCat.combat);
    public static Stat ammoCapacity = new Stat("ammo_capacity", StatCat.combat);

    private static String abilityFormat(String format, Object ... values2) {
        for (int i = 0; i < values2.length; ++i) {
            Object object = values2[i];
            if (object instanceof Number) {
                Number n = (Number)object;
                values2[i] = "[stat]" + Strings.autoFixed((float)n.floatValue(), (int)1) + "[]";
                continue;
            }
            values2[i] = "[white]" + values2[i] + "[]";
        }
        return Strings.format((String)("[lightgray]" + format.replace("~", "[accent]~[]")), (Object[])values2);
    }

    @Nullable
    public static String description(Ability ability, UnitType unit) {
        if (ability instanceof ForceFieldAbility) {
            ForceFieldAbility a = (ForceFieldAbility)ability;
            return StatExt.abilityFormat("@\u76fe\u5bb9~@\u683c~@\u6062\u590d~@s\u51b7\u5374", Float.valueOf(a.max), Float.valueOf(a.radius / 8.0f), Float.valueOf(a.regen * 60.0f), Float.valueOf(a.cooldown / 60.0f));
        }
        if (ability instanceof LiquidExplodeAbility) {
            LiquidExplodeAbility a = (LiquidExplodeAbility)ability;
            float rad = Math.max(unit.hitSize / 8.0f * a.radScale, 1.0f);
            return StatExt.abilityFormat("\u603b\u8ba1@@@~@\u683c\u534a\u5f84", 1.0471975824055166 * (double)rad * (double)rad * (double)a.amount * (double)a.radAmountScale, a.liquid.localizedName, a.liquid.emoji(), Float.valueOf(rad));
        }
        if (ability instanceof LiquidRegenAbility) {
            LiquidRegenAbility a = (LiquidRegenAbility)ability;
            return StatExt.abilityFormat("\u6bcf\u683c\u5438\u6536@/s@@~@/s\u56de\u8840~\u6700\u5927@/s", Float.valueOf(a.slurpSpeed), a.liquid.localizedName, a.liquid.emoji(), Float.valueOf(a.slurpSpeed * a.regenPerSlurp), Math.PI * Math.pow(Math.max(unit.hitSize / 8.0f * 0.6f, 1.0f), 2.0) * (double)a.slurpSpeed * (double)a.regenPerSlurp);
        }
        if (ability instanceof MoveLightningAbility) {
            MoveLightningAbility a = (MoveLightningAbility)ability;
            return StatExt.abilityFormat("\u95ea\u7535@\u6982\u7387~@\u4f24\u5bb3~@\u957f\u5ea6 @x\u901f\u5ea6", Float.valueOf(a.chance * 100.0f), Float.valueOf(a.damage), a.length, Float.valueOf(a.maxSpeed));
        }
        if (ability instanceof SuppressionFieldAbility) {
            SuppressionFieldAbility a = (SuppressionFieldAbility)ability;
            return StatExt.abilityFormat("@s~@\u683c", Float.valueOf(a.reload / 60.0f), Float.valueOf(a.range / 8.0f));
        }
        return null;
    }

    public static StatValue targets(BlockFlag[] targetFlags) {
        return table2 -> {
            table2.row();
            table2.table(t -> {
                t.background(Styles.grayPanel);
                for (BlockFlag flag : targetFlags) {
                    if (flag == null) continue;
                    t.add((CharSequence)flag.name()).width(150.0f).padBottom(5.0f);
                    int count = 0;
                    for (Block block : Vars.content.blocks()) {
                        if (!block.flags.contains((Enum)flag)) continue;
                        if (count >= 3) {
                            t.add((CharSequence)"\ue813").width(30.0f);
                            break;
                        }
                        t.add((CharSequence)block.emoji()).width(30.0f);
                        ++count;
                    }
                    t.row();
                }
            }).padLeft(12.0f);
        };
    }

    public static int totalShots(ShootPattern pattern) {
        if (pattern instanceof ShootHelix) {
            return pattern.shots * 2;
        }
        if (pattern instanceof ShootMulti) {
            ShootMulti s = (ShootMulti)pattern;
            int total = 0;
            for (ShootPattern p : s.dest) {
                total += StatExt.totalShots(p);
            }
            return s.source.shots * total;
        }
        return pattern.shots;
    }
}

