/*
 * Decompiled with CFR 0.152.
 */
package mindustryX.features;

import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.math.Interp;
import arc.scene.Action;
import arc.scene.Element;
import arc.scene.actions.Actions;
import arc.scene.event.ClickListener;
import arc.scene.event.EventListener;
import arc.scene.event.InputEvent;
import arc.scene.event.Touchable;
import arc.scene.style.Style;
import arc.scene.ui.layout.Table;
import mindustry.Vars;
import mindustry.gen.Call;
import mindustry.ui.Styles;
import mindustryX.features.AutoUpdate;
import mindustryX.features.Settings;
import mindustryX.features.UIExtKt;
import mindustryX.features.ui.ArcMessageDialog;
import mindustryX.features.ui.ModsRecommendDialog;
import mindustryX.features.ui.NewCoreItemsDisplay;
import mindustryX.features.ui.TeamSelectDialog;
import mindustryX.features.ui.toolTable.AdvanceBuildTool;

public class UIExt {
    public static TeamSelectDialog teamSelect;
    public static ModsRecommendDialog modsRecommend;
    public static ArcMessageDialog arcMessageDialog;
    public static AdvanceBuildTool advanceBuildTool;
    public static NewCoreItemsDisplay coreItems;

    public static void init() {
        teamSelect = new TeamSelectDialog();
        UIExtKt.init();
        Settings.addSettings();
        AutoUpdate.INSTANCE.initUI();
    }

    public static void announce(String text) {
        UIExt.announce(text, 3.0f);
    }

    public static void announce(String text, float duration) {
        Table t = new Table(Styles.black3);
        t.touchable = Touchable.disabled;
        t.margin(8.0f).add((CharSequence)text).style((Style)Styles.outlineLabel).labelAlign(1);
        t.update(() -> t.setPosition((float)Core.graphics.getWidth() / 2.0f, (float)Core.graphics.getHeight() / 2.0f + 30.0f, 1));
        t.actions(new Action[]{Actions.fadeOut((float)Math.min(duration, 30.0f), (Interp)Interp.pow4In), Actions.remove()});
        t.pack();
        t.act(0.1f);
        Core.scene.add((Element)t);
    }

    public static void sendChatMessage(String message) {
        int maxSize = 140;
        if (message.length() > maxSize) {
            int i;
            int add;
            for (i = 0; i < message.length() - maxSize; i += add) {
                add = maxSize;
                int sp = message.lastIndexOf(91, i + add);
                int sp2 = message.lastIndexOf(93, i + add + 10);
                if (sp2 > sp && i + add - sp < 10) {
                    add = sp - i;
                }
                UIExt.sendChatMessage(message.substring(i, i + add));
            }
            UIExt.sendChatMessage(message.substring(i));
            return;
        }
        Call.sendChatMessage((String)(Vars.ui.chatfrag.mode.normalizedPrefix() + message));
    }

    public static void shareMessage(char icon, String message) {
        UIExt.sendChatMessage("<MDTX " + icon + ">" + message);
    }

    public static void openURI(String uri) {
        if (!Core.app.openURI(uri)) {
            Vars.ui.showErrorMessage("@linkfail");
            Core.app.setClipboardText(uri);
        }
    }

    public static void hitter(final HitterCons cons) {
        final Element hitter = new Element(){

            public void draw() {
                super.draw();
                Draw.color((Color)Color.black, (float)0.25f);
                Fill.rect((float)(this.x + this.width / 2.0f), (float)(this.y + this.height / 2.0f), (float)this.width, (float)this.height);
            }
        };
        hitter.setFillParent(true);
        hitter.update(() -> ((Element)hitter).toFront());
        hitter.addListener((EventListener)new ClickListener(){

            public void clicked(InputEvent event, float x, float y) {
                super.clicked(event, x, y);
                if (cons.get(x, y)) {
                    hitter.remove();
                }
            }
        });
        Core.scene.add(hitter);
    }

    static {
        modsRecommend = new ModsRecommendDialog();
        arcMessageDialog = new ArcMessageDialog();
        advanceBuildTool = new AdvanceBuildTool();
        coreItems = new NewCoreItemsDisplay();
    }

    public static interface HitterCons {
        public boolean get(float var1, float var2);
    }
}

