/*
 * Decompiled with CFR 0.152.
 */
package mindustryX.features.ui;

import arc.Core;
import arc.math.geom.Rect;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0005 !\"#$B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J'\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\b2\u0017\u0010\u0019\u001a\u0013\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00170\u001a\u00a2\u0006\u0002\b\u001bJ\u0006\u0010\u001c\u001a\u00020\u0017J\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\t0\u001e2\u0006\u0010\u001f\u001a\u00020\tH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0013\u00a8\u0006%"}, d2={"LmindustryX/features/ui/AdsorptionSystem;", "", "<init>", "()V", "ADSORPTION_DISTANCE", "", "all", "", "", "LmindustryX/features/ui/AdsorptionSystem$Element;", "getAll", "()Ljava/util/Map;", "updaters", "", "Ljava/lang/Runnable;", "getUpdaters", "()Ljava/util/List;", "scene", "getScene", "()LmindustryX/features/ui/AdsorptionSystem$Element;", "placementRect", "getPlacementRect", "addDynamic", "", "name", "updater", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "update", "filterCandidates", "", "forPoint", "Axis", "Anchor", "ConstraintType", "Constraint", "Element", "core"})
@SourceDebugExtension(value={"SMAP\nAdsorptionSystem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AdsorptionSystem.kt\nmindustryX/features/ui/AdsorptionSystem\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,158:1\n1863#2,2:159\n774#2:168\n865#2,2:169\n1863#2,2:171\n381#3,7:161\n*S KotlinDebug\n*F\n+ 1 AdsorptionSystem.kt\nmindustryX/features/ui/AdsorptionSystem\n*L\n129#1:159,2\n152#1:168\n152#1:169,2\n145#1:171,2\n137#1:161,7\n*E\n"})
public final class AdsorptionSystem {
    @NotNull
    public static final AdsorptionSystem INSTANCE;
    public static final float ADSORPTION_DISTANCE = 16.0f;
    @NotNull
    private static final Map<String, Element> all;
    @NotNull
    private static final List<Runnable> updaters;
    @NotNull
    private static final Element scene;
    @NotNull
    private static final Element placementRect;

    private AdsorptionSystem() {
    }

    @NotNull
    public final Map<String, Element> getAll() {
        return all;
    }

    @NotNull
    public final List<Runnable> getUpdaters() {
        return updaters;
    }

    @NotNull
    public final Element getScene() {
        return scene;
    }

    @NotNull
    public final Element getPlacementRect() {
        return placementRect;
    }

    public final void addDynamic(@NotNull String name, @NotNull Function1<? super Element, Unit> updater) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(updater, "updater");
        Element elem = new Element(name);
        ((Collection)updaters).add(() -> AdsorptionSystem.addDynamic$lambda$2(updater, elem));
    }

    public final void update() {
        Iterable $this$forEach$iv = updaters;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Runnable it = (Runnable)element$iv;
            boolean bl = false;
            it.run();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<Element> filterCandidates(Element forPoint) {
        void $this$filterTo$iv$iv;
        Object $this$getOrPut$iv;
        Map reverseDeps = new LinkedHashMap();
        for (Element point : all.values()) {
            for (Element dep : point.getDependencies()) {
                Object object;
                $this$getOrPut$iv = reverseDeps;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(dep);
                if (value$iv == null) {
                    boolean bl = false;
                    List answer$iv = new ArrayList();
                    $this$getOrPut$iv.put(dep, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                ((List)object).add(point);
            }
        }
        Set excluded = new LinkedHashSet();
        AdsorptionSystem.filterCandidates$dfs(excluded, reverseDeps, forPoint);
        Rect around = Rect.tmp.set(forPoint.getRect()).grow(32.0f);
        Iterable $this$filter$iv = all.values();
        boolean $i$f$filter = false;
        $this$getOrPut$iv = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Element it = (Element)element$iv$iv;
            boolean bl = false;
            if (!(it.getLastUpdate() == Core.graphics.getFrameId() && around.overlaps(it.getRect()) && !excluded.contains(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final void scene$lambda$1$lambda$0(Element $this_apply) {
        $this_apply.reset(0.0f, 0.0f, Core.scene.getWidth(), Core.scene.getHeight());
    }

    private static final void addDynamic$lambda$2(Function1 $updater, Element $elem) {
        $updater.invoke($elem);
    }

    private static final void filterCandidates$dfs(Set<Element> excluded, Map<Element, List<Element>> reverseDeps, Element current) {
        block2: {
            if (!excluded.add(current)) {
                return;
            }
            List<Element> list = reverseDeps.get(current);
            if (list == null) break block2;
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Element it = (Element)element$iv;
                boolean bl = false;
                AdsorptionSystem.filterCandidates$dfs(excluded, reverseDeps, it);
            }
        }
    }

    static {
        Element element;
        INSTANCE = new AdsorptionSystem();
        all = new LinkedHashMap();
        updaters = new ArrayList();
        Element $this$scene_u24lambda_u241 = element = new Element("scene");
        boolean bl = false;
        updaters.add(() -> AdsorptionSystem.scene$lambda$1$lambda$0($this$scene_u24lambda_u241));
        scene = element;
        placementRect = new Element("placementRect");
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"LmindustryX/features/ui/AdsorptionSystem$Anchor;", "", "<init>", "(Ljava/lang/String;I)V", "Leading", "Center", "Trailing", "core"})
    public static final class Anchor
    extends Enum<Anchor> {
        public static final /* enum */ Anchor Leading = new Anchor();
        public static final /* enum */ Anchor Center = new Anchor();
        public static final /* enum */ Anchor Trailing = new Anchor();
        private static final /* synthetic */ Anchor[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Anchor[] values() {
            return (Anchor[])$VALUES.clone();
        }

        public static Anchor valueOf(String value) {
            return Enum.valueOf(Anchor.class, value);
        }

        @NotNull
        public static EnumEntries<Anchor> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = anchorArray = new Anchor[]{Anchor.Leading, Anchor.Center, Anchor.Trailing};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"LmindustryX/features/ui/AdsorptionSystem$Axis;", "", "<init>", "(Ljava/lang/String;I)V", "X", "Y", "core"})
    public static final class Axis
    extends Enum<Axis> {
        public static final /* enum */ Axis X = new Axis();
        public static final /* enum */ Axis Y = new Axis();
        private static final /* synthetic */ Axis[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Axis[] values() {
            return (Axis[])$VALUES.clone();
        }

        public static Axis valueOf(String value) {
            return Enum.valueOf(Axis.class, value);
        }

        @NotNull
        public static EnumEntries<Axis> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = axisArray = new Axis[]{Axis.X, Axis.Y};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tB\t\b\u0012\u00a2\u0006\u0004\b\b\u0010\nJ\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\u0011\u001a\u0004\u0018\u00010\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001f"}, d2={"LmindustryX/features/ui/AdsorptionSystem$Constraint;", "", "axis", "LmindustryX/features/ui/AdsorptionSystem$Axis;", "target", "", "type", "LmindustryX/features/ui/AdsorptionSystem$ConstraintType;", "<init>", "(LmindustryX/features/ui/AdsorptionSystem$Axis;Ljava/lang/String;LmindustryX/features/ui/AdsorptionSystem$ConstraintType;)V", "()V", "getAxis", "()LmindustryX/features/ui/AdsorptionSystem$Axis;", "getTarget", "()Ljava/lang/String;", "getType", "()LmindustryX/features/ui/AdsorptionSystem$ConstraintType;", "targetPoint", "LmindustryX/features/ui/AdsorptionSystem$Element;", "getTargetPoint", "()LmindustryX/features/ui/AdsorptionSystem$Element;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "core"})
    public static final class Constraint {
        @NotNull
        private final Axis axis;
        @NotNull
        private final String target;
        @NotNull
        private final ConstraintType type;

        public Constraint(@NotNull Axis axis, @NotNull String target, @NotNull ConstraintType type) {
            Intrinsics.checkNotNullParameter((Object)axis, "axis");
            Intrinsics.checkNotNullParameter(target, "target");
            Intrinsics.checkNotNullParameter((Object)type, "type");
            this.axis = axis;
            this.target = target;
            this.type = type;
        }

        @NotNull
        public final Axis getAxis() {
            return this.axis;
        }

        @NotNull
        public final String getTarget() {
            return this.target;
        }

        @NotNull
        public final ConstraintType getType() {
            return this.type;
        }

        private Constraint() {
            this(Axis.X, "", ConstraintType.AlignLeading);
        }

        @Nullable
        public final Element getTargetPoint() {
            return INSTANCE.getAll().get(this.target);
        }

        @NotNull
        public final Axis component1() {
            return this.axis;
        }

        @NotNull
        public final String component2() {
            return this.target;
        }

        @NotNull
        public final ConstraintType component3() {
            return this.type;
        }

        @NotNull
        public final Constraint copy(@NotNull Axis axis, @NotNull String target, @NotNull ConstraintType type) {
            Intrinsics.checkNotNullParameter((Object)axis, "axis");
            Intrinsics.checkNotNullParameter(target, "target");
            Intrinsics.checkNotNullParameter((Object)type, "type");
            return new Constraint(axis, target, type);
        }

        public static /* synthetic */ Constraint copy$default(Constraint constraint, Axis axis, String string, ConstraintType constraintType, int n, Object object) {
            if ((n & 1) != 0) {
                axis = constraint.axis;
            }
            if ((n & 2) != 0) {
                string = constraint.target;
            }
            if ((n & 4) != 0) {
                constraintType = constraint.type;
            }
            return constraint.copy(axis, string, constraintType);
        }

        @NotNull
        public String toString() {
            return "Constraint(axis=" + (Object)((Object)this.axis) + ", target=" + this.target + ", type=" + (Object)((Object)this.type) + ')';
        }

        public int hashCode() {
            int result = this.axis.hashCode();
            result = result * 31 + this.target.hashCode();
            result = result * 31 + this.type.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Constraint)) {
                return false;
            }
            Constraint constraint = (Constraint)other;
            if (this.axis != constraint.axis) {
                return false;
            }
            if (!Intrinsics.areEqual(this.target, constraint.target)) {
                return false;
            }
            return this.type == constraint.type;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0019\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000e\u00a8\u0006\u000f"}, d2={"LmindustryX/features/ui/AdsorptionSystem$ConstraintType;", "", "sourceAnchor", "LmindustryX/features/ui/AdsorptionSystem$Anchor;", "targetAnchor", "<init>", "(Ljava/lang/String;ILmindustryX/features/ui/AdsorptionSystem$Anchor;LmindustryX/features/ui/AdsorptionSystem$Anchor;)V", "getSourceAnchor", "()LmindustryX/features/ui/AdsorptionSystem$Anchor;", "getTargetAnchor", "AlignLeading", "AlignTrailing", "AlignCenter", "AttachTrailing", "AttachLeading", "core"})
    public static final class ConstraintType
    extends Enum<ConstraintType> {
        @NotNull
        private final Anchor sourceAnchor;
        @NotNull
        private final Anchor targetAnchor;
        public static final /* enum */ ConstraintType AlignLeading = new ConstraintType(Anchor.Leading, Anchor.Leading);
        public static final /* enum */ ConstraintType AlignTrailing = new ConstraintType(Anchor.Trailing, Anchor.Trailing);
        public static final /* enum */ ConstraintType AlignCenter = new ConstraintType(Anchor.Center, Anchor.Center);
        public static final /* enum */ ConstraintType AttachTrailing = new ConstraintType(Anchor.Leading, Anchor.Trailing);
        public static final /* enum */ ConstraintType AttachLeading = new ConstraintType(Anchor.Trailing, Anchor.Leading);
        private static final /* synthetic */ ConstraintType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private ConstraintType(Anchor sourceAnchor, Anchor targetAnchor) {
            this.sourceAnchor = sourceAnchor;
            this.targetAnchor = targetAnchor;
        }

        @NotNull
        public final Anchor getSourceAnchor() {
            return this.sourceAnchor;
        }

        @NotNull
        public final Anchor getTargetAnchor() {
            return this.targetAnchor;
        }

        public static ConstraintType[] values() {
            return (ConstraintType[])$VALUES.clone();
        }

        public static ConstraintType valueOf(String value) {
            return Enum.valueOf(ConstraintType.class, value);
        }

        @NotNull
        public static EnumEntries<ConstraintType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = constraintTypeArray = new ConstraintType[]{ConstraintType.AlignLeading, ConstraintType.AlignTrailing, ConstraintType.AlignCenter, ConstraintType.AttachTrailing, ConstraintType.AttachLeading};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J&\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u0019J\u0016\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!J\u000e\u0010\"\u001a\u00020\u00172\u0006\u0010#\u001a\u00020$J$\u0010%\u001a\u0010\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020\u0019\u0018\u00010&2\u0006\u0010'\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u001fJ\u0016\u0010(\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010$\u0012\u0006\u0012\u0004\u0018\u00010$0&J\u0006\u0010)\u001a\u00020\u0017R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00000\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006*"}, d2={"LmindustryX/features/ui/AdsorptionSystem$Element;", "", "name", "", "<init>", "(Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "rect", "Larc/math/geom/Rect;", "getRect", "()Larc/math/geom/Rect;", "dependencies", "", "getDependencies", "()Ljava/util/Set;", "lastUpdate", "", "getLastUpdate", "()J", "setLastUpdate", "(J)V", "reset", "", "x", "", "y", "width", "height", "computeAnchor", "axis", "LmindustryX/features/ui/AdsorptionSystem$Axis;", "anchor", "LmindustryX/features/ui/AdsorptionSystem$Anchor;", "applyConstraint", "constraint", "LmindustryX/features/ui/AdsorptionSystem$Constraint;", "findBestConstraint", "Lkotlin/Pair;", "target", "findBestConstraints", "remove", "core"})
    @SourceDebugExtension(value={"SMAP\nAdsorptionSystem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AdsorptionSystem.kt\nmindustryX/features/ui/AdsorptionSystem$Element\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,158:1\n1557#2:159\n1628#2,3:160\n774#2:163\n865#2,2:164\n2341#2,14:166\n1611#2,9:181\n1863#2:190\n1864#2:192\n1620#2:193\n2341#2,14:194\n1611#2,9:208\n1863#2:217\n1864#2:219\n1620#2:220\n2341#2,14:221\n1#3:180\n1#3:191\n1#3:218\n*S KotlinDebug\n*F\n+ 1 AdsorptionSystem.kt\nmindustryX/features/ui/AdsorptionSystem$Element\n*L\n92#1:159\n92#1:160,3\n93#1:163\n93#1:164,2\n94#1:166,14\n100#1:181,9\n100#1:190\n100#1:192\n100#1:193\n100#1:194,14\n101#1:208,9\n101#1:217\n101#1:219\n101#1:220\n101#1:221,14\n100#1:191\n101#1:218\n*E\n"})
    public static final class Element {
        @NotNull
        private final String name;
        @NotNull
        private final Rect rect;
        @NotNull
        private final Set<Element> dependencies;
        private long lastUpdate;

        public Element(@NotNull String name) {
            Intrinsics.checkNotNullParameter(name, "name");
            this.name = name;
            this.rect = new Rect();
            this.dependencies = new LinkedHashSet();
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final Rect getRect() {
            return this.rect;
        }

        @NotNull
        public final Set<Element> getDependencies() {
            return this.dependencies;
        }

        public final long getLastUpdate() {
            return this.lastUpdate;
        }

        public final void setLastUpdate(long l) {
            this.lastUpdate = l;
        }

        public final void reset(float x, float y, float width, float height) {
            this.lastUpdate = Core.graphics.getFrameId();
            this.rect.set(x, y, width, height);
            INSTANCE.getAll().put(this.name, this);
            this.dependencies.clear();
        }

        public final float computeAnchor(@NotNull Axis axis, @NotNull Anchor anchor) {
            float f;
            Intrinsics.checkNotNullParameter((Object)axis, "axis");
            Intrinsics.checkNotNullParameter((Object)anchor, "anchor");
            block0 : switch (WhenMappings.$EnumSwitchMapping$1[axis.ordinal()]) {
                case 1: {
                    switch (WhenMappings.$EnumSwitchMapping$0[anchor.ordinal()]) {
                        case 1: {
                            f = this.rect.x;
                            break block0;
                        }
                        case 2: {
                            f = this.rect.x + this.rect.width / (float)2;
                            break block0;
                        }
                        case 3: {
                            f = this.rect.x + this.rect.width;
                            break block0;
                        }
                    }
                    throw new NoWhenBranchMatchedException();
                }
                case 2: {
                    switch (WhenMappings.$EnumSwitchMapping$0[anchor.ordinal()]) {
                        case 1: {
                            f = this.rect.y;
                            break block0;
                        }
                        case 2: {
                            f = this.rect.y + this.rect.height / (float)2;
                            break block0;
                        }
                        case 3: {
                            f = this.rect.y + this.rect.height;
                            break block0;
                        }
                    }
                    throw new NoWhenBranchMatchedException();
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return f;
        }

        public final void applyConstraint(@NotNull Constraint constraint) {
            Intrinsics.checkNotNullParameter(constraint, "constraint");
            Element element = constraint.getTargetPoint();
            if (element == null) {
                return;
            }
            Element target = element;
            this.dependencies.add(target);
            float cur = this.computeAnchor(constraint.getAxis(), constraint.getType().getSourceAnchor());
            float tar = target.computeAnchor(constraint.getAxis(), constraint.getType().getTargetAnchor());
            float delta = tar - cur;
            if (constraint.getAxis() == Axis.X) {
                Rect rect = this.rect;
                rect.x += delta;
            } else {
                Rect rect = this.rect;
                rect.y += delta;
            }
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final Pair<Constraint, Float> findBestConstraint(@NotNull Element target, @NotNull Axis axis) {
            Pair pair;
            Object v0;
            void $this$minByOrNull$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Pair it;
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(target, "target");
            Intrinsics.checkNotNullParameter((Object)axis, "axis");
            Iterable $this$map$iv = ConstraintType.getEntries();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                ConstraintType constraintType = (ConstraintType)((Object)item$iv$iv);
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(TuplesKt.to(it, Float.valueOf(Math.abs(this.computeAnchor(axis, ((ConstraintType)((Object)it)).getSourceAnchor()) - target.computeAnchor(axis, ((ConstraintType)((Object)it)).getTargetAnchor())))));
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$filter = false;
            $this$mapTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (Pair)element$iv$iv;
                boolean bl = false;
                if (!(((Number)it.getSecond()).floatValue() < 16.0f)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$minByOrNull = false;
            Iterator iterator$iv = $this$minByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v0 = null;
            } else {
                Object minElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v0 = minElem$iv;
                } else {
                    Pair it2 = (Pair)minElem$iv;
                    boolean bl = false;
                    float minValue$iv = ((Number)it2.getSecond()).floatValue();
                    do {
                        Object e$iv = iterator$iv.next();
                        Pair it3 = (Pair)e$iv;
                        $i$a$-minByOrNull-AdsorptionSystem$Element$findBestConstraint$3 = false;
                        float v$iv = ((Number)it3.getSecond()).floatValue();
                        if (Float.compare(minValue$iv, v$iv) <= 0) continue;
                        minElem$iv = e$iv;
                        minValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v0 = minElem$iv;
                }
            }
            Pair pair2 = v0;
            if (pair2 != null) {
                Pair it4 = pair2;
                boolean bl = false;
                pair = TuplesKt.to(new Constraint(axis, target.name, (ConstraintType)((Object)it4.getFirst())), it4.getSecond());
            } else {
                pair = null;
            }
            return pair;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Pair<Constraint, Constraint> findBestConstraints() {
            Object v2;
            Object minElem$iv;
            Object v0;
            Pair<Constraint, Float> it$iv$iv;
            boolean bl;
            Element target;
            boolean bl2;
            Object element$iv$iv;
            Object element$iv$iv$iv;
            void $this$mapNotNullTo$iv$iv;
            List available = INSTANCE.filterCandidates(this);
            Iterable $this$mapNotNull$iv = available;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                element$iv$iv = element$iv$iv$iv = iterator2.next();
                bl2 = false;
                target = (Element)element$iv$iv;
                boolean bl3 = false;
                if (this.findBestConstraint(target, Axis.X) == null) continue;
                bl = false;
                destination$iv$iv.add(it$iv$iv);
            }
            Iterable $this$minByOrNull$iv = (List)destination$iv$iv;
            boolean $i$f$minByOrNull = false;
            Iterator iterator$iv = $this$minByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v0 = null;
            } else {
                minElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v0 = minElem$iv;
                } else {
                    Pair it = (Pair)minElem$iv;
                    boolean bl4 = false;
                    float minValue$iv = ((Number)it.getSecond()).floatValue();
                    do {
                        Object e$iv = iterator$iv.next();
                        Pair it2 = (Pair)e$iv;
                        iterator3 = false;
                        float v$iv = ((Number)it2.getSecond()).floatValue();
                        if (Float.compare(minValue$iv, v$iv) <= 0) continue;
                        minElem$iv = e$iv;
                        minValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v0 = minElem$iv;
                }
            }
            Pair pair = v0;
            $this$minByOrNull$iv = available;
            Constraint constraint = pair != null ? (Constraint)pair.getFirst() : null;
            $i$f$mapNotNull = false;
            iterator$iv = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList();
            $i$f$mapNotNullTo = false;
            $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            $i$f$forEach = false;
            Iterator iterator3 = $this$forEach$iv$iv$iv.iterator();
            while (iterator3.hasNext()) {
                element$iv$iv = element$iv$iv$iv = iterator3.next();
                bl2 = false;
                target = (Element)element$iv$iv;
                boolean bl5 = false;
                if (this.findBestConstraint(target, Axis.Y) == null) continue;
                bl = false;
                destination$iv$iv.add(it$iv$iv);
            }
            $this$mapNotNull$iv = (List)destination$iv$iv;
            $i$f$minByOrNull = false;
            iterator$iv = $this$minByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v2 = null;
            } else {
                minElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v2 = minElem$iv;
                } else {
                    Pair it = (Pair)minElem$iv;
                    boolean bl6 = false;
                    float minValue$iv = ((Number)it.getSecond()).floatValue();
                    do {
                        Object e$iv = iterator$iv.next();
                        Pair it3 = (Pair)e$iv;
                        $i$a$-minByOrNull-AdsorptionSystem$Element$findBestConstraints$4 = false;
                        float v$iv = ((Number)it3.getSecond()).floatValue();
                        if (Float.compare(minValue$iv, v$iv) <= 0) continue;
                        minElem$iv = e$iv;
                        minValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v2 = minElem$iv;
                }
            }
            Pair pair2 = v2;
            return TuplesKt.to(constraint, pair2 != null ? (Constraint)pair2.getFirst() : null);
        }

        public final void remove() {
            if (Intrinsics.areEqual(INSTANCE.getAll().get(this.name), this)) {
                INSTANCE.getAll().remove(this.name);
            }
        }

        @Metadata(mv={2, 1, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;
            public static final /* synthetic */ int[] $EnumSwitchMapping$1;

            static {
                int[] nArray = new int[Anchor.values().length];
                try {
                    nArray[Anchor.Leading.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Anchor.Center.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Anchor.Trailing.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
                nArray = new int[Axis.values().length];
                try {
                    nArray[Axis.X.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Axis.Y.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$1 = nArray;
            }
        }
    }
}

