/*
 * Decompiled with CFR 0.152.
 */
package mindustryX.features.ui;

import arc.Core;
import arc.flabel.FLabel;
import arc.func.Cons;
import arc.func.ConsT;
import arc.graphics.Pixmap;
import arc.graphics.Texture;
import arc.graphics.g2d.TextureRegion;
import arc.scene.Element;
import arc.scene.style.Drawable;
import arc.scene.style.Style;
import arc.scene.ui.layout.Cell;
import arc.scene.ui.layout.Table;
import arc.struct.ObjectMap;
import arc.struct.Seq;
import arc.util.Http;
import arc.util.Log;
import arc.util.Nullable;
import arc.util.Structs;
import arc.util.serialization.Json;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import mindustry.gen.Icon;
import mindustry.graphics.Pal;
import mindustry.ui.Styles;

public class CommitsTable
extends Table {
    private static final ObjectMap<String, TextureRegion> AVATAR_CACHE = new ObjectMap();
    private static final TextureRegion NOT_FOUND = Core.atlas.find("nomap");
    private static final SimpleDateFormat ISO_DATE_FORMATTER = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    private static final SimpleDateFormat DATE_FORMATTER = new SimpleDateFormat("yyyy-MM-dd");
    public static final float STROKE = 1.5f;
    private final Seq<CommitData> commitsData = new Seq();
    public String repo;
    private final Table commitsTable = new Table();
    private boolean autoFetched = false;

    public CommitsTable(String repo) {
        this.repo = repo;
        this.table(top -> {
            top.defaults().left();
            top.add((CharSequence)this.repo).style((Style)Styles.outlineLabel).pad(4.0f);
            top.add((CharSequence)"@commit.recentUpdates").color(Pal.lightishGray);
        }).padBottom(16.0f).padTop(8.0f).growX();
        this.row();
        this.pane(Styles.noBarPane, t -> t.add((Element)this.commitsTable).minHeight(200.0f).grow()).grow();
    }

    public void act(float delta) {
        super.act(delta);
        if (!this.commitsTable.hasChildren() && !this.autoFetched) {
            this.autoFetched = true;
            this.fetch();
        }
    }

    public void fetch() {
        this.commitsTable.clearChildren();
        this.commitsTable.add((Element)new FLabel((CharSequence)"@alphaLoading")).style((Style)Styles.outlineLabel).expand().center();
        Http.HttpRequest request = Http.get("https://api.github.com/repos/" + this.repo + "/commits");
        request.header("Accept", "application/vnd.github+json");
        request.header("User-Agent", "MindustryX");
        request.error((Cons<Throwable>)((Cons)e -> Core.app.post(() -> {
            Log.err((String)"Failed to load commits: ", (Throwable)e);
            this.commitsTable.clearChildren();
            this.commitsTable.add((Element)new FLabel((CharSequence)"@alphaLoadFailed")).style((Style)Styles.outlineLabel).expand().center().row();
            this.commitsTable.add((CharSequence)e.toString()).style((Style)Styles.outlineLabel).fillX().center().row();
        })));
        request.submit((ConsT<Http.HttpResponse, Exception>)((ConsT)resp -> {
            String result = resp.getResultAsString();
            Seq data = (Seq)new Json().fromJson(Seq.class, CommitData.class, result);
            Core.app.post(() -> {
                if (data == null) {
                    this.commitsTable.clearChildren();
                    this.commitsTable.add((Element)new FLabel((CharSequence)"@alphaLoadFailed")).style((Style)Styles.outlineLabel).expand().center();
                    return;
                }
                this.commitsData.set(data);
                this.commitsData.removeAll(commitData -> commitData.commit.author == null);
                this.commitsData.sort(Structs.comparing(c -> c.commit.author.date)).reverse();
                this.rebuildCommitsTable();
            });
        }));
    }

    private void rebuildCommitsTable() {
        this.commitsTable.clearChildren();
        this.commitsTable.image().color(this.color).width(1.5f).growY();
        Table right = (Table)this.commitsTable.table().get();
        Date lastDate = null;
        for (CommitData data : this.commitsData) {
            Date date = data.commit.author.getDate();
            if (!(date == null || lastDate != null && CommitsTable.isSameDay(lastDate, date))) {
                right.table(timeSplit -> {
                    timeSplit.image().color(this.color).width(8.0f).height(1.5f);
                    timeSplit.add((CharSequence)DATE_FORMATTER.format(date)).color(this.color).padLeft(8.0f).padRight(8.0f);
                    timeSplit.image().color(this.color).height(1.5f).padRight(8.0f).growX();
                }).padTop(lastDate == null ? 0.0f : 16.0f).padBottom(8.0f).growX();
                right.row();
                lastDate = date;
            }
            right.table(commitInfo -> this.setupCommitInfo((Table)commitInfo, data)).minWidth(400.0f).padLeft(16.0f).growX();
            right.row();
        }
    }

    private void setupCommitInfo(Table t, CommitData data) {
        CommitData.Commit commit = data.commit;
        CommitData.Author author = data.author;
        String[] split = commit.message.split("\n");
        t.table(left -> {
            left.defaults().left();
            Cell topCell = left.table(top -> {
                top.add((CharSequence)(split[0] + (split.length > 1 ? "..." : ""))).style((Style)Styles.outlineLabel).minWidth(350.0f).wrap().expandX().left();
                if (split.length > 1) {
                    top.image((Drawable)Icon.infoCircleSmall).pad(4.0f);
                }
            }).growX();
            if (split.length > 1) {
                topCell.tooltip(commit.message, true);
            }
            left.row();
            left.table(bottom -> {
                bottom.defaults().left();
                bottom.image(CommitsTable.getAvatar(author.login, author.avatar_url)).pad(8.0f).size(32.0f);
                bottom.add((CharSequence)author.login).style((Style)Styles.outlineLabel).color(Pal.lightishGray).padLeft(4.0f);
            });
        });
        t.add().growX();
        t.table(right -> {
            right.defaults().size(32.0f).right();
            right.button((Drawable)Icon.linkSmall, Styles.cleari, () -> Core.app.openURI(data.html_url));
        }).fillY();
    }

    private static TextureRegion getAvatar(String login, String url) {
        TextureRegion region = (TextureRegion)AVATAR_CACHE.get((Object)login, TextureRegion::new);
        if (region.texture == null) {
            region.set(NOT_FOUND);
            Http.get(url, (ConsT<Http.HttpResponse, Exception>)((ConsT)res -> {
                Pixmap pix = new Pixmap(res.getResult());
                Core.app.post(() -> {
                    try {
                        Texture tex = new Texture(pix);
                        tex.setFilter(Texture.TextureFilter.linear);
                        region.set(tex);
                    }
                    catch (Exception e) {
                        Log.err((Throwable)e);
                    }
                    pix.dispose();
                });
            }), (Cons<Throwable>)((Cons)err -> {
                region.set(NOT_FOUND);
                Log.err((Throwable)err);
            }));
        }
        return region;
    }

    private static boolean isSameDay(Date date1, Date date2) {
        Calendar cal1 = Calendar.getInstance();
        Calendar cal2 = Calendar.getInstance();
        cal1.setTime(date1);
        cal2.setTime(date2);
        return cal1.get(1) == cal2.get(1) && cal1.get(6) == cal2.get(6);
    }

    public static class CommitData {
        public String html_url;
        public Commit commit;
        @Nullable
        public Author author;
        @Nullable
        public Author committer;

        public String toString() {
            return "CommitsData{html_url='" + this.html_url + '\'' + ", commit=" + this.commit + ", author=" + this.author + ", committer=" + this.committer + '}';
        }

        public static class Commit {
            public String message;
            @Nullable
            public GitUser author;

            public String toString() {
                return "Commit{message='" + this.message + '\'' + ", author=" + this.author + '}';
            }
        }

        public static class Author {
            public String login;
            @Nullable
            public String name;
            @Nullable
            public String email;
            public String avatar_url;
            public String html_url;

            public String toString() {
                return "Author{name='" + this.name + '\'' + ", login='" + this.login + '\'' + ", email='" + this.email + '\'' + ", avatar_url='" + this.avatar_url + '\'' + ", html_url='" + this.html_url + '\'' + '}';
            }
        }

        public static class GitUser {
            public String name;
            public String email;
            public String date;
            private transient Date cacheDate;

            public String toString() {
                return "GitUser{name='" + this.name + '\'' + ", email='" + this.email + '\'' + ", date='" + this.date + '\'' + '}';
            }

            public Date getDate() {
                if (this.cacheDate != null) {
                    return this.cacheDate;
                }
                try {
                    this.cacheDate = ISO_DATE_FORMATTER.parse(this.date);
                    return this.cacheDate;
                }
                catch (Exception e) {
                    return null;
                }
            }
        }
    }
}

