/*
 * Decompiled with CFR 0.152.
 */
package mindustryX.features.ui;

import arc.Core;
import arc.Graphics;
import arc.func.Prov;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import arc.input.KeyCode;
import arc.math.Mathf;
import arc.math.geom.Rect;
import arc.math.geom.Vec2;
import arc.scene.Element;
import arc.scene.Group;
import arc.scene.event.EventListener;
import arc.scene.event.InputEvent;
import arc.scene.event.InputListener;
import arc.scene.event.Touchable;
import arc.scene.style.Drawable;
import arc.scene.ui.ImageButton;
import arc.scene.ui.Label;
import arc.scene.ui.Slider;
import arc.scene.ui.TextButton;
import arc.scene.ui.layout.Cell;
import arc.scene.ui.layout.Scl;
import arc.scene.ui.layout.Stack;
import arc.scene.ui.layout.Table;
import arc.scene.ui.layout.WidgetGroup;
import arc.struct.SnapshotSeq;
import arc.util.Align;
import arc.util.Log;
import arc.util.Strings;
import arc.util.Tmp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import mindustry.Vars;
import mindustry.gen.Icon;
import mindustry.gen.Tex;
import mindustry.ui.Styles;
import mindustryX.features.SettingsV2;
import mindustryX.features.UIExtKt;
import mindustryX.features.ui.AdsorptionSystem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0004\"#$%B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0015\u001a\u0004\u0018\u00010\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0002J\u0016\u0010\u001a\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eJ\u0006\u0010\u001f\u001a\u00020 J\u0006\u0010!\u001a\u00020 R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"LmindustryX/features/ui/OverlayUI;", "", "<init>", "()V", "showOverlayButton", "LmindustryX/features/SettingsV2$CheckPref;", "value", "", "open", "getOpen", "()Z", "windows", "", "LmindustryX/features/ui/OverlayUI$Window;", "getWindows", "()Ljava/util/List;", "constraintDrawTask", "", "LmindustryX/features/ui/AdsorptionSystem$Constraint;", "group", "Larc/scene/ui/layout/WidgetGroup;", "rectForElements", "Larc/math/geom/Rect;", "elements", "", "Larc/scene/Element;", "registerWindow", "name", "", "table", "Larc/scene/ui/layout/Table;", "init", "", "toggle", "WindowData", "WindowSetting", "Window", "PreferAnyWidth", "core"})
@SourceDebugExtension(value={"SMAP\nOverlayUI.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OverlayUI.kt\nmindustryX/features/ui/OverlayUI\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,585:1\n808#2,11:586\n808#2,11:597\n1863#2,2:608\n1863#2,2:610\n1863#2,2:612\n1863#2:614\n1864#2:616\n1863#2,2:617\n295#2,2:619\n1#3:615\n*S KotlinDebug\n*F\n+ 1 OverlayUI.kt\nmindustryX/features/ui/OverlayUI\n*L\n446#1:586,11\n580#1:597,11\n580#1:608,2\n466#1:610,2\n479#1:612,2\n507#1:614\n507#1:616\n513#1:617,2\n542#1:619,2\n*E\n"})
public final class OverlayUI {
    @NotNull
    public static final OverlayUI INSTANCE;
    @NotNull
    private static final SettingsV2.CheckPref showOverlayButton;
    private static boolean open;
    @NotNull
    private static final List<AdsorptionSystem.Constraint> constraintDrawTask;
    @NotNull
    private static final WidgetGroup group;

    private OverlayUI() {
    }

    public final boolean getOpen() {
        return open;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Window> getWindows() {
        void $this$filterIsInstanceTo$iv$iv;
        SnapshotSeq snapshotSeq = group.getChildren();
        Intrinsics.checkNotNullExpressionValue(snapshotSeq, "getChildren(...)");
        Iterable $this$filterIsInstance$iv = (Iterable)snapshotSeq;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof Window)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final Rect rectForElements(Iterable<? extends Element> elements) {
        Iterator<? extends Element> iter = elements.iterator();
        if (!iter.hasNext()) {
            return null;
        }
        Element $this$rectForElements_u24lambda_u2431 = iter.next();
        boolean bl = false;
        Rect r = Tmp.r1.set($this$rectForElements_u24lambda_u2431.x, $this$rectForElements_u24lambda_u2431.y, $this$rectForElements_u24lambda_u2431.getWidth(), $this$rectForElements_u24lambda_u2431.getHeight());
        while (iter.hasNext()) {
            Element it = iter.next();
            r.merge(Tmp.r2.set(it.x, it.y, it.getWidth(), it.getHeight()));
        }
        return r;
    }

    @NotNull
    public final Window registerWindow(@NotNull String name, @NotNull Table table2) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(table2, "table");
        Window window = new Window(name, table2);
        group.addChild((Element)window);
        return window;
    }

    public final void init() {
        Core.scene.add((Element)group);
    }

    /*
     * WARNING - void declaration
     */
    public final void toggle() {
        void $this$filterIsInstanceTo$iv$iv;
        open = !open;
        SnapshotSeq snapshotSeq = group.getChildren();
        Intrinsics.checkNotNullExpressionValue(snapshotSeq, "getChildren(...)");
        Iterable $this$filterIsInstance$iv = (Iterable)snapshotSeq;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof Window)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Window it = (Window)((Object)element$iv);
            boolean bl = false;
            it.updateVisibility();
            if (!it.visible) continue;
            it.rebuild();
        }
    }

    private static final boolean group$lambda$30$lambda$10$lambda$0() {
        return open;
    }

    private static final boolean group$lambda$30$lambda$10$lambda$8$lambda$7$lambda$4$lambda$3$lambda$1(Window $it) {
        return $it.getData().getEnabled();
    }

    private static final void group$lambda$30$lambda$10$lambda$8$lambda$7$lambda$4$lambda$3$lambda$2(Window $it) {
        $it.getData().setEnabled(true);
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit group$lambda$30$lambda$10$lambda$8$lambda$7(Table $this$showFloatSettingsPanel) {
        TextButton $this$group_u24lambda_u2430_u24lambda_u2410_u24lambda_u248_u24lambda_u247_u24lambda_u244_u24lambda_u243;
        Table table2;
        TextButton textButton;
        Window it;
        Intrinsics.checkNotNullParameter($this$showFloatSettingsPanel, "$this$showFloatSettingsPanel");
        $this$showFloatSettingsPanel.add((CharSequence)"\u6dfb\u52a0\u9762\u677f").color(Color.gold).align(1).row();
        $this$showFloatSettingsPanel.defaults().minWidth(120.0f).fillX().pad(4.0f);
        List notAvailable = new ArrayList();
        Iterable $this$forEach$iv = INSTANCE.getWindows();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Window)((Object)element$iv);
            boolean bl = false;
            if (!((Boolean)it.getAvailability().get()).booleanValue()) {
                notAvailable.add(it);
                continue;
            }
            TextButton textButton2 = textButton = new TextButton(it.getData().getTitle());
            table2 = $this$showFloatSettingsPanel;
            boolean bl2 = false;
            $this$group_u24lambda_u2430_u24lambda_u2410_u24lambda_u248_u24lambda_u247_u24lambda_u244_u24lambda_u243.getLabel().setWrap(false);
            $this$group_u24lambda_u2430_u24lambda_u2410_u24lambda_u248_u24lambda_u247_u24lambda_u244_u24lambda_u243.setDisabled(() -> OverlayUI.group$lambda$30$lambda$10$lambda$8$lambda$7$lambda$4$lambda$3$lambda$1(it));
            $this$group_u24lambda_u2430_u24lambda_u2410_u24lambda_u248_u24lambda_u247_u24lambda_u244_u24lambda_u243.changed(() -> OverlayUI.group$lambda$30$lambda$10$lambda$8$lambda$7$lambda$4$lambda$3$lambda$2(it));
            table2.add((Element)textButton).row();
        }
        if (!((Collection)notAvailable).isEmpty()) {
            $this$showFloatSettingsPanel.add((CharSequence)"\u5f53\u524d\u4e0d\u53ef\u7528\u7684\u9762\u677f:").align(1).row();
            $this$forEach$iv = notAvailable;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                void $this$group_u24lambda_u2430_u24lambda_u2410_u24lambda_u248_u24lambda_u247_u24lambda_u246_u24lambda_u245;
                it = (Window)((Object)element$iv);
                boolean bl = false;
                $this$group_u24lambda_u2430_u24lambda_u2410_u24lambda_u248_u24lambda_u247_u24lambda_u244_u24lambda_u243 = textButton = new TextButton(it.getData().getTitle());
                table2 = $this$showFloatSettingsPanel;
                boolean bl3 = false;
                $this$group_u24lambda_u2430_u24lambda_u2410_u24lambda_u248_u24lambda_u247_u24lambda_u246_u24lambda_u245.getLabel().setWrap(false);
                $this$group_u24lambda_u2430_u24lambda_u2410_u24lambda_u248_u24lambda_u247_u24lambda_u246_u24lambda_u245.setDisabled(true);
                table2.add((Element)textButton).row();
            }
        }
        return Unit.INSTANCE;
    }

    private static final void group$lambda$30$lambda$10$lambda$8() {
        UIExtKt.showFloatSettingsPanel(OverlayUI::group$lambda$30$lambda$10$lambda$8$lambda$7);
    }

    private static final void group$lambda$30$lambda$10$lambda$9() {
        INSTANCE.toggle();
    }

    private static final void group$lambda$30$lambda$10(Table t) {
        t.name = "overlayUI-bg";
        t.touchable = Touchable.enabled;
        t.visibility = OverlayUI::group$lambda$30$lambda$10$lambda$0;
        t.bottom();
        t.defaults().size(40.0f).width(60.0f).pad(4.0f);
        t.button((Drawable)Icon.add, OverlayUI::group$lambda$30$lambda$10$lambda$8);
        t.button((Drawable)Icon.exit, OverlayUI::group$lambda$30$lambda$10$lambda$9);
    }

    private static final boolean group$lambda$30$lambda$12$lambda$11() {
        return open;
    }

    private static final void group$lambda$30$lambda$12(Table t) {
        t.name = "overlayUI-tips";
        t.touchable = Touchable.disabled;
        t.visibility = OverlayUI::group$lambda$30$lambda$12$lambda$11;
        t.left().top();
        t.add((CharSequence)"@overlayUI.tips").pad(8.0f);
    }

    private static final void group$lambda$30$lambda$15$lambda$13() {
        INSTANCE.toggle();
    }

    private static final boolean group$lambda$30$lambda$15$lambda$14() {
        return (Boolean)showOverlayButton.getValue();
    }

    private static final void group$lambda$30$lambda$15(Table t) {
        t.left().name = "toggle";
        t.button((Drawable)Icon.settings, 32.0f, OverlayUI::group$lambda$30$lambda$15$lambda$13);
        t.visible(OverlayUI::group$lambda$30$lambda$15$lambda$14);
    }

    private static final void group$lambda$30$lambda$19(float f, float f2, float f3, float f4) {
        AdsorptionSystem.Constraint c;
        Draw.color((Color)Color.red);
        Lines.stroke(4.0f * Scl.scl());
        Iterable $this$forEach$iv = constraintDrawTask;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            c = (AdsorptionSystem.Constraint)element$iv;
            boolean bl = false;
            AdsorptionSystem.Element element = c.getTargetPoint();
            if (element == null || (element = element.getRect()) == null) continue;
            AdsorptionSystem.Element it = element;
            boolean bl2 = false;
            Lines.rect((Rect)it);
        }
        Draw.color((Color)Color.yellow);
        Lines.stroke(2.0f * Scl.scl());
        $this$forEach$iv = constraintDrawTask;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AdsorptionSystem.Element target;
            c = (AdsorptionSystem.Constraint)element$iv;
            boolean bl = false;
            if (c.getTargetPoint() == null) continue;
            float tar = target.computeAnchor(c.getAxis(), c.getType().getTargetAnchor());
            if (c.getAxis() == AdsorptionSystem.Axis.X) {
                Lines.dashLine(tar, 0.0f, tar, Core.scene.getHeight(), 64);
                continue;
            }
            Lines.dashLine(0.0f, tar, Core.scene.getWidth(), tar, 64);
        }
        Draw.reset();
        constraintDrawTask.clear();
    }

    private static final void group$lambda$30$lambda$21$lambda$20(Element $this_apply) {
        $this_apply.toFront();
    }

    private static final Unit group$lambda$30$lambda$24$lambda$23(Group $minimapParent, AdsorptionSystem.Element $this$addDynamic) {
        block1: {
            Intrinsics.checkNotNullParameter($this$addDynamic, "$this$addDynamic");
            if (!UIExtKt.INSTANCE.isVisible((Element)$minimapParent)) break block1;
            SnapshotSeq snapshotSeq = $minimapParent.getChildren();
            Intrinsics.checkNotNullExpressionValue(snapshotSeq, "getChildren(...)");
            Rect rect = INSTANCE.rectForElements((Iterable)snapshotSeq);
            if (rect != null) {
                Rect it = rect;
                boolean bl = false;
                $this$addDynamic.reset(it.x, it.y, it.width, it.height);
            }
        }
        return Unit.INSTANCE;
    }

    private static final Unit group$lambda$30$lambda$28$lambda$27(Stack $stack, AdsorptionSystem.Element $this$addDynamic) {
        block3: {
            Object v1;
            block2: {
                Intrinsics.checkNotNullParameter($this$addDynamic, "$this$addDynamic");
                SnapshotSeq snapshotSeq = $stack.getChildren();
                Intrinsics.checkNotNullExpressionValue(snapshotSeq, "getChildren(...)");
                Iterable $this$firstOrNull$iv = (Iterable)snapshotSeq;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Element it = (Element)element$iv;
                    boolean bl = false;
                    if (!it.visible) continue;
                    v1 = element$iv;
                    break block2;
                }
                v1 = null;
            }
            Element element = v1;
            if (element == null || !UIExtKt.INSTANCE.isVisible(element) || !(element instanceof Table)) break block3;
            SnapshotSeq snapshotSeq = ((Table)element).getChildren();
            Intrinsics.checkNotNullExpressionValue(snapshotSeq, "getChildren(...)");
            Rect rect = INSTANCE.rectForElements((Iterable)snapshotSeq);
            if (rect != null) {
                Rect it = rect;
                boolean bl = false;
                $this$addDynamic.reset(it.x, it.y, it.width, it.height);
            }
        }
        return Unit.INSTANCE;
    }

    private static final void group$lambda$30$lambda$29() {
        AdsorptionSystem.INSTANCE.update();
    }

    static {
        Element element;
        WidgetGroup widgetGroup;
        INSTANCE = new OverlayUI();
        showOverlayButton = new SettingsV2.CheckPref("gameUI.overlayButton", true);
        constraintDrawTask = new ArrayList();
        WidgetGroup $this$group_u24lambda_u2430 = widgetGroup = new WidgetGroup();
        boolean bl = false;
        $this$group_u24lambda_u2430.name = "overlayUI";
        $this$group_u24lambda_u2430.setFillParent(true);
        $this$group_u24lambda_u2430.touchable = Touchable.childrenOnly;
        $this$group_u24lambda_u2430.setZIndex(99);
        $this$group_u24lambda_u2430.fill(Styles.black6, OverlayUI::group$lambda$30$lambda$10);
        $this$group_u24lambda_u2430.fill(OverlayUI::group$lambda$30$lambda$12);
        $this$group_u24lambda_u2430.fill(OverlayUI::group$lambda$30$lambda$15);
        Element $this$group_u24lambda_u2430_u24lambda_u2421 = element = $this$group_u24lambda_u2430.fill(OverlayUI::group$lambda$30$lambda$19);
        boolean bl2 = false;
        $this$group_u24lambda_u2430_u24lambda_u2421.name = "draw-Constant";
        $this$group_u24lambda_u2430_u24lambda_u2421.update(() -> OverlayUI.group$lambda$30$lambda$21$lambda$20($this$group_u24lambda_u2430_u24lambda_u2421));
        Element element2 = Vars.ui.hudGroup.find("minimap");
        if (element2 != null && (element2 = element2.parent) != null) {
            Element minimapParent = element2;
            boolean bl3 = false;
            AdsorptionSystem.INSTANCE.addDynamic("minimapFrag", arg_0 -> OverlayUI.group$lambda$30$lambda$24$lambda$23((Group)minimapParent, arg_0));
        } else {
            Log.warn((String)"[OverlayUI] cannot find 'minimap' for adsorption", (Object[])new Object[0]);
        }
        Stack stack = (Stack)Vars.ui.hudGroup.find("waves/editor");
        if (stack != null) {
            Stack stack2 = stack;
            boolean bl4 = false;
            AdsorptionSystem.INSTANCE.addDynamic("statusFrag", arg_0 -> OverlayUI.group$lambda$30$lambda$28$lambda$27(stack2, arg_0));
        } else {
            Log.warn((String)"[OverlayUI] cannot init 'statusFrag' for adsorption", (Object[])new Object[0]);
        }
        $this$group_u24lambda_u2430.update(OverlayUI::group$lambda$30$lambda$29);
        group = widgetGroup;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0005H\u0016\u00a8\u0006\u0007"}, d2={"LmindustryX/features/ui/OverlayUI$PreferAnyWidth;", "Larc/scene/Element;", "<init>", "()V", "getMinWidth", "", "getPrefWidth", "core"})
    public static final class PreferAnyWidth
    extends Element {
        public float getMinWidth() {
            return 0.0f;
        }

        public float getPrefWidth() {
            return this.width;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001:\u00044567B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010&\u001a\u00020'H\u0016J\u0010\u0010(\u001a\u00020'2\u0006\u0010)\u001a\u00020*H\u0016J\b\u0010+\u001a\u00020'H\u0002J\u0006\u0010,\u001a\u00020'J\u0016\u0010-\u001a\u00020'2\u0006\u0010.\u001a\u00020/2\u0006\u0010)\u001a\u000200J\u0006\u00101\u001a\u00020'J\b\u00102\u001a\u00020'H\u0002J\b\u00103\u001a\u00020'H\u0002R\u0011\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0018\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R \u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00140\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001b\u0010\u001f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030!0 \u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u000e\u0010$\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"LmindustryX/features/ui/OverlayUI$Window;", "Larc/scene/ui/layout/Table;", "name", "", "table", "<init>", "(Ljava/lang/String;Larc/scene/ui/layout/Table;)V", "getTable", "()Larc/scene/ui/layout/Table;", "data", "LmindustryX/features/ui/OverlayUI$WindowSetting;", "getData", "()LmindustryX/features/ui/OverlayUI$WindowSetting;", "paneBg", "Larc/scene/style/Drawable;", "kotlin.jvm.PlatformType", "Larc/scene/style/Drawable;", "state", "LmindustryX/features/ui/OverlayUI$Window$State;", "autoHeight", "", "getAutoHeight", "()Z", "setAutoHeight", "(Z)V", "availability", "Larc/func/Prov;", "getAvailability", "()Larc/func/Prov;", "setAvailability", "(Larc/func/Prov;)V", "settings", "", "LmindustryX/features/SettingsV2$Data;", "getSettings", "()Ljava/util/List;", "adsorption", "LmindustryX/features/ui/AdsorptionSystem$Element;", "updateVisibility", "", "act", "delta", "", "updateData", "rebuild", "dragResize", "side", "", "Larc/math/geom/Vec2;", "endResize", "applyScale", "unapplyScale", "DragListener", "ResizeListener", "FixedResizeListener", "State", "core"})
    @SourceDebugExtension(value={"SMAP\nOverlayUI.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OverlayUI.kt\nmindustryX/features/ui/OverlayUI$Window\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,585:1\n1#2:586\n1863#3,2:587\n*S KotlinDebug\n*F\n+ 1 OverlayUI.kt\nmindustryX/features/ui/OverlayUI$Window\n*L\n335#1:587,2\n*E\n"})
    public static final class Window
    extends Table {
        @NotNull
        private final Table table;
        @NotNull
        private final WindowSetting data;
        private final Drawable paneBg;
        @NotNull
        private State state;
        private boolean autoHeight;
        @NotNull
        private Prov<Boolean> availability;
        @NotNull
        private final List<SettingsV2.Data<?>> settings;
        @NotNull
        private final AdsorptionSystem.Element adsorption;

        public Window(@NotNull String name, @NotNull Table table2) {
            Intrinsics.checkNotNullParameter(name, "name");
            Intrinsics.checkNotNullParameter(table2, "table");
            this.table = table2;
            this.data = new WindowSetting("overlayUI." + name);
            this.paneBg = Tex.pane;
            this.state = State.Stable;
            this.availability = Window::availability$lambda$0;
            SettingsV2.Data[] dataArray = new SettingsV2.Data[]{this.data};
            this.settings = CollectionsKt.mutableListOf(dataArray);
            this.adsorption = new AdsorptionSystem.Element(name);
            this.name = name;
        }

        @NotNull
        public final Table getTable() {
            return this.table;
        }

        @NotNull
        public final WindowSetting getData() {
            return this.data;
        }

        public final boolean getAutoHeight() {
            return this.autoHeight;
        }

        public final void setAutoHeight(boolean bl) {
            this.autoHeight = bl;
        }

        @NotNull
        public final Prov<Boolean> getAvailability() {
            return this.availability;
        }

        public final void setAvailability(@NotNull Prov<Boolean> prov) {
            Intrinsics.checkNotNullParameter(prov, "<set-?>");
            this.availability = prov;
        }

        @NotNull
        public final List<SettingsV2.Data<?>> getSettings() {
            return this.settings;
        }

        public void updateVisibility() {
            boolean bl = this.visible = this.data.getEnabled() && (Boolean)this.availability.get() != false && (INSTANCE.getOpen() || ((WindowData)this.data.getValue()).getPinned());
            if (!this.visible) {
                this.adsorption.remove();
            }
        }

        public void act(float delta) {
            AdsorptionSystem.Element element;
            super.act(delta);
            if (!this.data.getEnabled()) {
                return;
            }
            this.updateData();
            if (SettingsV2.DataCore.changed$default(this.data, null, 1, null)) {
                this.rebuild();
                SettingsV2.DataCore.changed$default(this.data, null, 1, null);
            }
            if (this.autoHeight && this.state == State.Stable && !(this.getPrefHeight() == this.height)) {
                this.height = this.getPrefHeight();
            }
            this.applyScale();
            this.width = RangesKt.coerceAtMost(this.width, Core.scene.getWidth());
            this.height = RangesKt.coerceAtMost(this.height, Core.scene.getHeight());
            if (this.state == State.Stable) {
                Vec2 vec2 = ((WindowData)this.data.getValue()).getCenter();
                if (vec2 != null) {
                    Vec2 it = vec2;
                    boolean bl = false;
                    this.setPosition(it.x, it.y, 1);
                }
            }
            this.keepInStage();
            AdsorptionSystem.Element $this$act_u24lambda_u246 = element = this.adsorption;
            boolean bl = false;
            $this$act_u24lambda_u246.reset(this.x, this.y, this.width, this.height);
            if (this.state == State.Stable) {
                AdsorptionSystem.Constraint constraint = ((WindowData)this.data.getValue()).getConstraintX();
                if (constraint != null) {
                    AdsorptionSystem.Constraint it = constraint;
                    boolean bl2 = false;
                    $this$act_u24lambda_u246.applyConstraint(it);
                }
                AdsorptionSystem.Constraint constraint2 = ((WindowData)this.data.getValue()).getConstraintY();
                if (constraint2 != null) {
                    AdsorptionSystem.Constraint it = constraint2;
                    boolean bl3 = false;
                    $this$act_u24lambda_u246.applyConstraint(it);
                }
            } else {
                AdsorptionSystem.Constraint it;
                Pair<AdsorptionSystem.Constraint, AdsorptionSystem.Constraint> pair = $this$act_u24lambda_u246.findBestConstraints();
                AdsorptionSystem.Constraint constraintX = pair.component1();
                AdsorptionSystem.Constraint constraintY = pair.component2();
                AdsorptionSystem.Constraint constraint = constraintX;
                if (constraint != null) {
                    it = constraint;
                    boolean bl4 = false;
                    $this$act_u24lambda_u246.applyConstraint(it);
                    constraintDrawTask.add(it);
                }
                AdsorptionSystem.Constraint constraint3 = constraintY;
                if (constraint3 != null) {
                    it = constraint3;
                    boolean bl5 = false;
                    $this$act_u24lambda_u246.applyConstraint(it);
                    constraintDrawTask.add(it);
                }
            }
            this.setPosition($this$act_u24lambda_u246.getRect().x, $this$act_u24lambda_u246.getRect().y);
            if (this.state == State.EndDrag) {
                this.state = State.Stable;
                Vec2 center = new Vec2(this.getX(1), this.getY(1));
                Pair<AdsorptionSystem.Constraint, AdsorptionSystem.Constraint> pair = this.adsorption.findBestConstraints();
                AdsorptionSystem.Constraint constraintX = pair.component1();
                AdsorptionSystem.Constraint constraintY = pair.component2();
                this.data.set(WindowData.copy$default((WindowData)this.data.getValue(), false, false, null, center, null, constraintX, constraintY, 0.0f, 151, null));
            }
            this.unapplyScale();
        }

        private final void updateData() {
            Rect rect = ((WindowData)this.data.getValue()).getRect();
            if (rect != null) {
                Rect old = rect;
                boolean bl = false;
                Vec2 center = old.getCenter(new Vec2());
                Vec2 size = old.getSize(new Vec2());
                this.data.set(WindowData.copy$default((WindowData)this.data.getValue(), false, false, null, center, size, null, null, 0.0f, 227, null));
            }
            if (((WindowData)this.data.getValue()).getCenter() == null) {
                this.data.set(WindowData.copy$default((WindowData)this.data.getValue(), false, false, null, new Vec2(this.parent.getWidth() / (float)2, this.parent.getHeight() / (float)2), null, null, null, 0.0f, 247, null));
            }
        }

        /*
         * WARNING - void declaration
         */
        public final void rebuild() {
            block2: {
                block1: {
                    void $this$rebuild_u24lambda_u2418;
                    ImageButton imageButton;
                    this.clear();
                    if (!INSTANCE.getOpen()) break block1;
                    this.setBackground(this.paneBg);
                    this.touchable = Touchable.enabled;
                    this.addListener((EventListener)new ResizeListener());
                    this.table(arg_0 -> Window.rebuild$lambda$16(this, arg_0)).fillX().row();
                    Cell cell = this.add((Element)this.table);
                    Vec2 vec2 = ((WindowData)this.data.getValue()).getSize();
                    if (vec2 != null) {
                        Vec2 it = vec2;
                        boolean bl = false;
                        cell.maxSize(it.x / Scl.scl(), it.y / Scl.scl());
                    }
                    this.pack();
                    cell.grow().maxSize(Float.NEGATIVE_INFINITY);
                    this.layout();
                    this.addChild(new Element(this){
                        final /* synthetic */ Window this$0;
                        {
                            this.this$0 = $receiver;
                        }

                        public void act(float delta) {
                            this.touchable = Touchable.disabled;
                            this.setBounds(this.this$0.getTable().x, this.this$0.getTable().y, this.this$0.getTable().getWidth(), this.this$0.getTable().getHeight());
                        }

                        public void draw() {
                            Draw.color();
                            Lines.rect(this.x, this.y, this.width, this.height);
                        }
                    });
                    ImageButton imageButton2 = imageButton = new ImageButton((Drawable)Icon.resize);
                    Window window = this;
                    boolean bl = false;
                    $this$rebuild_u24lambda_u2418.setSize(32.0f);
                    $this$rebuild_u24lambda_u2418.addListener((EventListener)new FixedResizeListener(12));
                    window.addChild((Element)imageButton);
                    break block2;
                }
                this.setBackground(null);
                this.touchable = Touchable.childrenOnly;
                this.add((Element)this.table).grow();
                Vec2 vec2 = ((WindowData)this.data.getValue()).getSize();
                if (vec2 == null) break block2;
                Vec2 it = vec2;
                boolean bl = false;
                this.setSize(it.x, it.y);
            }
        }

        public final void dragResize(int side, @NotNull Vec2 delta) {
            Intrinsics.checkNotNullParameter(delta, "delta");
            if (Align.isCenterHorizontal((int)side)) {
                delta.x = 0.0f;
            }
            if (Align.isCenterVertical((int)side)) {
                delta.y = 0.0f;
            }
            if (Align.isLeft((int)side)) {
                delta.x = -delta.x;
            }
            if (Align.isBottom((int)side)) {
                delta.y = -delta.y;
            }
            if (this.width + delta.x < this.getMinWidth()) {
                delta.x = this.getMinWidth() - this.width;
            }
            if (this.getMaxWidth() > 0.0f && this.width + delta.x > this.getMaxWidth()) {
                delta.x = this.getMaxWidth() - this.width;
            }
            if (this.height + delta.y < this.getMinHeight()) {
                delta.y = this.getMinHeight() - this.height;
            }
            if (this.getMaxHeight() > 0.0f && this.height + delta.y > this.getMaxHeight()) {
                delta.y = this.getMaxHeight() - this.height;
            }
            if (Align.isLeft((int)side)) {
                this.x -= delta.x;
            }
            if (Align.isBottom((int)side)) {
                this.y -= delta.y;
            }
            this.setSize(this.width + delta.x, this.height + delta.y);
        }

        public final void endResize() {
            if (this.parent == null) {
                return;
            }
            this.pack();
            this.data.set(WindowData.copy$default((WindowData)this.data.getValue(), false, false, null, null, new Vec2(this.table.getWidth(), this.table.getHeight()), null, null, 0.0f, 239, null));
        }

        private final void applyScale() {
            float scale = ((WindowData)this.data.getValue()).getScale();
            this.x = this.x + this.width / (float)2 - this.width * scale / (float)2;
            this.y = this.y + this.height / (float)2 - this.height * scale / (float)2;
            this.width *= scale;
            this.height *= scale;
            this.setScale(1.0f);
        }

        private final void unapplyScale() {
            float scale = ((WindowData)this.data.getValue()).getScale();
            this.x = this.x + this.width / (float)2 - this.width / scale / (float)2;
            this.y = this.y + this.height / (float)2 - this.height / scale / (float)2;
            this.width /= scale;
            this.height /= scale;
            this.transform = !(scale == 1.0f);
            this.setScale(scale);
            this.setOrigin(this.width / (float)2, this.height / (float)2);
        }

        private static final Boolean availability$lambda$0() {
            return true;
        }

        private static final void rebuild$lambda$16$lambda$8(Window this$0, Label it) {
            it.setText((CharSequence)this$0.data.getTitle());
            it.update(null);
        }

        private static final Unit rebuild$lambda$16$lambda$11$lambda$10(Window this$0, Table $this$showFloatSettingsPanel) {
            Intrinsics.checkNotNullParameter($this$showFloatSettingsPanel, "$this$showFloatSettingsPanel");
            $this$showFloatSettingsPanel.defaults().minWidth(120.0f).pad(4.0f);
            Iterable $this$forEach$iv = this$0.settings;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                SettingsV2.Data setting = (SettingsV2.Data)element$iv;
                boolean bl = false;
                $this$showFloatSettingsPanel.add((Element)setting.buildUI()).growX().padBottom(4.0f).row();
            }
            return Unit.INSTANCE;
        }

        private static final void rebuild$lambda$16$lambda$11(Window this$0) {
            UIExtKt.showFloatSettingsPanel(arg_0 -> Window.rebuild$lambda$16$lambda$11$lambda$10(this$0, arg_0));
        }

        private static final void rebuild$lambda$16$lambda$13(Window this$0) {
            this$0.data.setPinned(!this$0.data.getPinned());
        }

        private static final boolean rebuild$lambda$16$lambda$14(Window this$0, ImageButton it) {
            return this$0.data.getPinned();
        }

        private static final void rebuild$lambda$16$lambda$15(Window this$0) {
            this$0.data.setEnabled(false);
        }

        private static final void rebuild$lambda$16(Window this$0, Table header) {
            ImageButton.ImageButtonStyle imageButtonStyle;
            header.add((CharSequence)"").update(arg_0 -> Window.rebuild$lambda$16$lambda$8(this$0, arg_0)).ellipsis(true).minWidth(0.0f).growX().labelAlign(8);
            header.touchable = Touchable.enabled;
            header.addListener((EventListener)this$0.new DragListener());
            header.defaults().size(32.0f).pad(2.0f);
            header.button((Drawable)Icon.settingsSmall, Styles.cleari, () -> Window.rebuild$lambda$16$lambda$11(this$0));
            ImageButton.ImageButtonStyle imageButtonStyle2 = imageButtonStyle = new ImageButton.ImageButtonStyle(Styles.cleari);
            Drawable drawable = (Drawable)Icon.lockOpenSmall;
            Table table2 = header;
            boolean bl = false;
            $this$rebuild_u24lambda_u2416_u24lambda_u2412.up = null;
            $this$rebuild_u24lambda_u2416_u24lambda_u2412.imageChecked = (Drawable)Icon.lockSmall;
            Unit unit = Unit.INSTANCE;
            table2.button(drawable, imageButtonStyle, () -> Window.rebuild$lambda$16$lambda$13(this$0)).checked(arg_0 -> Window.rebuild$lambda$16$lambda$14(this$0, arg_0));
            header.button((Drawable)Icon.cancelSmall, Styles.cleari, () -> Window.rebuild$lambda$16$lambda$15(this$0));
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J2\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J(\u0010\u0011\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0016J4\u0010\u0013\u001a\u00020\u00122\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"LmindustryX/features/ui/OverlayUI$Window$DragListener;", "Larc/scene/event/InputListener;", "<init>", "(LmindustryX/features/ui/OverlayUI$Window;)V", "offset", "Larc/math/geom/Vec2;", "touchDown", "", "event", "Larc/scene/event/InputEvent;", "x", "", "y", "pointer", "", "button", "Larc/input/KeyCode;", "touchDragged", "", "touchUp", "core"})
        public final class DragListener
        extends InputListener {
            @NotNull
            private final Vec2 offset = new Vec2();

            public boolean touchDown(@NotNull InputEvent event, float x, float y, int pointer, @Nullable KeyCode button2) {
                Intrinsics.checkNotNullParameter(event, "event");
                if (Core.app.isMobile() && pointer != 0) {
                    return false;
                }
                this.offset.set(event.stageX, event.stageY).sub(Window.this.x, Window.this.y);
                Window.this.state = State.Dragging;
                Window.this.toFront();
                return true;
            }

            public void touchDragged(@NotNull InputEvent event, float x, float y, int pointer) {
                Intrinsics.checkNotNullParameter(event, "event");
                if (Core.app.isMobile() && pointer != 0) {
                    return;
                }
                Window.this.setPosition(event.stageX - this.offset.x, event.stageY - this.offset.y);
                Window.this.applyScale();
                Window.this.keepInStage();
                Window.this.unapplyScale();
            }

            public void touchUp(@Nullable InputEvent event, float x, float y, int pointer, @Nullable KeyCode button2) {
                if (Core.app.isMobile() && pointer != 0) {
                    return;
                }
                Window.this.state = State.EndDrag;
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J0\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J(\u0010\u0014\u001a\u00020\u00152\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0003H\u0016J4\u0010\u0016\u001a\u00020\u00152\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00032\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"LmindustryX/features/ui/OverlayUI$Window$FixedResizeListener;", "Larc/scene/event/InputListener;", "align", "", "<init>", "(LmindustryX/features/ui/OverlayUI$Window;I)V", "getAlign", "()I", "last", "Larc/math/geom/Vec2;", "touchDown", "", "event", "Larc/scene/event/InputEvent;", "x", "", "y", "pointer", "button", "Larc/input/KeyCode;", "touchDragged", "", "touchUp", "core"})
        public final class FixedResizeListener
        extends InputListener {
            private final int align;
            @NotNull
            private final Vec2 last;

            public FixedResizeListener(int align) {
                this.align = align;
                this.last = new Vec2();
            }

            public final int getAlign() {
                return this.align;
            }

            public boolean touchDown(@NotNull InputEvent event, float x, float y, int pointer, @NotNull KeyCode button2) {
                Intrinsics.checkNotNullParameter(event, "event");
                Intrinsics.checkNotNullParameter((Object)button2, "button");
                if (Core.app.isMobile() && pointer != 0) {
                    return false;
                }
                this.mouseMoved(event, x, y);
                if (!Intrinsics.areEqual(event.targetActor, event.listenerActor)) {
                    return false;
                }
                this.last.set(event.stageX, event.stageY);
                Window.this.toFront();
                return true;
            }

            public void touchDragged(@NotNull InputEvent event, float x, float y, int pointer) {
                Intrinsics.checkNotNullParameter(event, "event");
                if (Core.app.isMobile() && pointer != 0) {
                    return;
                }
                Vec2 delta = Tmp.v1.set(event.stageX, event.stageY).sub(this.last);
                this.last.set(event.stageX, event.stageY);
                Intrinsics.checkNotNull(delta);
                Window.this.dragResize(this.align, delta);
            }

            public void touchUp(@Nullable InputEvent event, float x, float y, int pointer, @Nullable KeyCode button2) {
                if (Core.app.isMobile() && pointer != 0) {
                    return;
                }
                Window.this.endResize();
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0016J4\u0010\u000f\u001a\u00020\u00102\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00072\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J0\u0010\u0014\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J(\u0010\u0017\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0007H\u0016J4\u0010\u0018\u001a\u00020\u00102\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00072\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"LmindustryX/features/ui/OverlayUI$Window$ResizeListener;", "Larc/scene/event/InputListener;", "<init>", "(LmindustryX/features/ui/OverlayUI$Window;)V", "last", "Larc/math/geom/Vec2;", "resizeSide", "", "mouseMoved", "", "event", "Larc/scene/event/InputEvent;", "x", "", "y", "exit", "", "pointer", "toActor", "Larc/scene/Element;", "touchDown", "button", "Larc/input/KeyCode;", "touchDragged", "touchUp", "core"})
        public final class ResizeListener
        extends InputListener {
            @NotNull
            private final Vec2 last = new Vec2();
            private int resizeSide;

            public boolean mouseMoved(@NotNull InputEvent event, float x, float y) {
                Intrinsics.checkNotNullParameter(event, "event");
                int n = !Intrinsics.areEqual(event.targetActor, (Object)Window.this) ? 0 : (x < Window.this.getTable().getX(8) ? 8 : (x > Window.this.getTable().getX(16) ? 16 : (y < Window.this.getTable().getY(4) ? 4 : (this.resizeSide = y > Window.this.getTable().getY(2) ? 2 : 0))));
                if (Align.isLeft((int)this.resizeSide) || Align.isRight((int)this.resizeSide)) {
                    Core.graphics.cursor((Graphics.Cursor)Graphics.Cursor.SystemCursor.horizontalResize);
                } else if (Align.isTop((int)this.resizeSide) || Align.isBottom((int)this.resizeSide)) {
                    Core.graphics.cursor((Graphics.Cursor)Graphics.Cursor.SystemCursor.verticalResize);
                } else {
                    Core.graphics.restoreCursor();
                    return false;
                }
                return true;
            }

            public void exit(@Nullable InputEvent event, float x, float y, int pointer, @Nullable Element toActor) {
                if (Core.app.isMobile() && pointer != 0) {
                    return;
                }
                Core.graphics.restoreCursor();
            }

            public boolean touchDown(@NotNull InputEvent event, float x, float y, int pointer, @NotNull KeyCode button2) {
                Intrinsics.checkNotNullParameter(event, "event");
                Intrinsics.checkNotNullParameter((Object)button2, "button");
                if (Core.app.isMobile() && pointer != 0) {
                    return false;
                }
                this.mouseMoved(event, x, y);
                if (!Intrinsics.areEqual(event.targetActor, (Object)Window.this) || this.resizeSide == 0) {
                    return false;
                }
                this.last.set(event.stageX, event.stageY);
                Window.this.toFront();
                return true;
            }

            public void touchDragged(@NotNull InputEvent event, float x, float y, int pointer) {
                Intrinsics.checkNotNullParameter(event, "event");
                if (Core.app.isMobile() && pointer != 0) {
                    return;
                }
                Vec2 delta = Tmp.v1.set(event.stageX, event.stageY).sub(this.last);
                this.last.set(event.stageX, event.stageY);
                Intrinsics.checkNotNull(delta);
                Window.this.dragResize(this.resizeSide, delta);
            }

            public void touchUp(@Nullable InputEvent event, float x, float y, int pointer, @Nullable KeyCode button2) {
                if (Core.app.isMobile() && pointer != 0) {
                    return;
                }
                Window.this.endResize();
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"LmindustryX/features/ui/OverlayUI$Window$State;", "", "<init>", "(Ljava/lang/String;I)V", "Stable", "Dragging", "EndDrag", "core"})
        public static final class State
        extends Enum<State> {
            public static final /* enum */ State Stable = new State();
            public static final /* enum */ State Dragging = new State();
            public static final /* enum */ State EndDrag = new State();
            private static final /* synthetic */ State[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            public static State[] values() {
                return (State[])$VALUES.clone();
            }

            public static State valueOf(String value) {
                return Enum.valueOf(State.class, value);
            }

            @NotNull
            public static EnumEntries<State> getEntries() {
                return $ENTRIES;
            }

            static {
                $VALUES = stateArray = new State[]{State.Stable, State.Dragging, State.EndDrag};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u001d\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001Ba\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\b\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u000b\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\t\u0010 \u001a\u00020\u0003H\u00c6\u0003J\t\u0010!\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\"\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J\u000b\u0010#\u001a\u0004\u0018\u00010\bH\u00c6\u0003J\u000b\u0010$\u001a\u0004\u0018\u00010\bH\u00c6\u0003J\u000b\u0010%\u001a\u0004\u0018\u00010\u000bH\u00c6\u0003J\u000b\u0010&\u001a\u0004\u0018\u00010\u000bH\u00c6\u0003J\t\u0010'\u001a\u00020\u000eH\u00c6\u0003Jc\u0010(\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\b2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u000b2\b\b\u0002\u0010\r\u001a\u00020\u000eH\u00c6\u0001J\u0013\u0010)\u001a\u00020\u00032\b\u0010*\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010+\u001a\u00020,H\u00d6\u0001J\t\u0010-\u001a\u00020.H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u001e\u0010\u0005\u001a\u0004\u0018\u00010\u00068\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0016\u0010\u0017R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0013\u0010\t\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0019R\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0013\u0010\f\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001cR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006/"}, d2={"LmindustryX/features/ui/OverlayUI$WindowData;", "", "enabled", "", "pinned", "rect", "Larc/math/geom/Rect;", "center", "Larc/math/geom/Vec2;", "size", "constraintX", "LmindustryX/features/ui/AdsorptionSystem$Constraint;", "constraintY", "scale", "", "<init>", "(ZZLarc/math/geom/Rect;Larc/math/geom/Vec2;Larc/math/geom/Vec2;LmindustryX/features/ui/AdsorptionSystem$Constraint;LmindustryX/features/ui/AdsorptionSystem$Constraint;F)V", "getEnabled", "()Z", "getPinned", "getRect$annotations", "()V", "getRect", "()Larc/math/geom/Rect;", "getCenter", "()Larc/math/geom/Vec2;", "getSize", "getConstraintX", "()LmindustryX/features/ui/AdsorptionSystem$Constraint;", "getConstraintY", "getScale", "()F", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "copy", "equals", "other", "hashCode", "", "toString", "", "core"})
    public static final class WindowData {
        private final boolean enabled;
        private final boolean pinned;
        @Nullable
        private final Rect rect;
        @Nullable
        private final Vec2 center;
        @Nullable
        private final Vec2 size;
        @Nullable
        private final AdsorptionSystem.Constraint constraintX;
        @Nullable
        private final AdsorptionSystem.Constraint constraintY;
        private final float scale;

        public WindowData(boolean enabled, boolean pinned, @Nullable Rect rect, @Nullable Vec2 center, @Nullable Vec2 size, @Nullable AdsorptionSystem.Constraint constraintX, @Nullable AdsorptionSystem.Constraint constraintY, float scale) {
            this.enabled = enabled;
            this.pinned = pinned;
            this.rect = rect;
            this.center = center;
            this.size = size;
            this.constraintX = constraintX;
            this.constraintY = constraintY;
            this.scale = scale;
        }

        public /* synthetic */ WindowData(boolean bl, boolean bl2, Rect rect, Vec2 vec2, Vec2 vec22, AdsorptionSystem.Constraint constraint, AdsorptionSystem.Constraint constraint2, float f, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                bl = false;
            }
            if ((n & 2) != 0) {
                bl2 = false;
            }
            if ((n & 4) != 0) {
                rect = null;
            }
            if ((n & 8) != 0) {
                vec2 = null;
            }
            if ((n & 0x10) != 0) {
                vec22 = null;
            }
            if ((n & 0x20) != 0) {
                constraint = null;
            }
            if ((n & 0x40) != 0) {
                constraint2 = null;
            }
            if ((n & 0x80) != 0) {
                f = 1.0f;
            }
            this(bl, bl2, rect, vec2, vec22, constraint, constraint2, f);
        }

        public final boolean getEnabled() {
            return this.enabled;
        }

        public final boolean getPinned() {
            return this.pinned;
        }

        @Nullable
        public final Rect getRect() {
            return this.rect;
        }

        @Deprecated(message="use center,size,constraintX,constraintY replaced")
        public static /* synthetic */ void getRect$annotations() {
        }

        @Nullable
        public final Vec2 getCenter() {
            return this.center;
        }

        @Nullable
        public final Vec2 getSize() {
            return this.size;
        }

        @Nullable
        public final AdsorptionSystem.Constraint getConstraintX() {
            return this.constraintX;
        }

        @Nullable
        public final AdsorptionSystem.Constraint getConstraintY() {
            return this.constraintY;
        }

        public final float getScale() {
            return this.scale;
        }

        public final boolean component1() {
            return this.enabled;
        }

        public final boolean component2() {
            return this.pinned;
        }

        @Nullable
        public final Rect component3() {
            return this.rect;
        }

        @Nullable
        public final Vec2 component4() {
            return this.center;
        }

        @Nullable
        public final Vec2 component5() {
            return this.size;
        }

        @Nullable
        public final AdsorptionSystem.Constraint component6() {
            return this.constraintX;
        }

        @Nullable
        public final AdsorptionSystem.Constraint component7() {
            return this.constraintY;
        }

        public final float component8() {
            return this.scale;
        }

        @NotNull
        public final WindowData copy(boolean enabled, boolean pinned, @Nullable Rect rect, @Nullable Vec2 center, @Nullable Vec2 size, @Nullable AdsorptionSystem.Constraint constraintX, @Nullable AdsorptionSystem.Constraint constraintY, float scale) {
            return new WindowData(enabled, pinned, rect, center, size, constraintX, constraintY, scale);
        }

        public static /* synthetic */ WindowData copy$default(WindowData windowData, boolean bl, boolean bl2, Rect rect, Vec2 vec2, Vec2 vec22, AdsorptionSystem.Constraint constraint, AdsorptionSystem.Constraint constraint2, float f, int n, Object object) {
            if ((n & 1) != 0) {
                bl = windowData.enabled;
            }
            if ((n & 2) != 0) {
                bl2 = windowData.pinned;
            }
            if ((n & 4) != 0) {
                rect = windowData.rect;
            }
            if ((n & 8) != 0) {
                vec2 = windowData.center;
            }
            if ((n & 0x10) != 0) {
                vec22 = windowData.size;
            }
            if ((n & 0x20) != 0) {
                constraint = windowData.constraintX;
            }
            if ((n & 0x40) != 0) {
                constraint2 = windowData.constraintY;
            }
            if ((n & 0x80) != 0) {
                f = windowData.scale;
            }
            return windowData.copy(bl, bl2, rect, vec2, vec22, constraint, constraint2, f);
        }

        @NotNull
        public String toString() {
            return "WindowData(enabled=" + this.enabled + ", pinned=" + this.pinned + ", rect=" + this.rect + ", center=" + this.center + ", size=" + this.size + ", constraintX=" + this.constraintX + ", constraintY=" + this.constraintY + ", scale=" + this.scale + ')';
        }

        public int hashCode() {
            int result = Boolean.hashCode(this.enabled);
            result = result * 31 + Boolean.hashCode(this.pinned);
            result = result * 31 + (this.rect == null ? 0 : this.rect.hashCode());
            result = result * 31 + (this.center == null ? 0 : this.center.hashCode());
            result = result * 31 + (this.size == null ? 0 : this.size.hashCode());
            result = result * 31 + (this.constraintX == null ? 0 : this.constraintX.hashCode());
            result = result * 31 + (this.constraintY == null ? 0 : this.constraintY.hashCode());
            result = result * 31 + Float.hashCode(this.scale);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof WindowData)) {
                return false;
            }
            WindowData windowData = (WindowData)other;
            if (this.enabled != windowData.enabled) {
                return false;
            }
            if (this.pinned != windowData.pinned) {
                return false;
            }
            if (!Intrinsics.areEqual(this.rect, windowData.rect)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.center, windowData.center)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.size, windowData.size)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.constraintX, windowData.constraintX)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.constraintY, windowData.constraintY)) {
                return false;
            }
            return Float.compare(this.scale, windowData.scale) == 0;
        }

        public WindowData() {
            this(false, false, null, null, null, null, null, 0.0f, 255, null);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016R$\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR$\u0010\u0010\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0011\u0010\r\"\u0004\b\u0012\u0010\u000f\u00a8\u0006\u0013"}, d2={"LmindustryX/features/ui/OverlayUI$WindowSetting;", "LmindustryX/features/SettingsV2$Data;", "LmindustryX/features/ui/OverlayUI$WindowData;", "name", "", "<init>", "(Ljava/lang/String;)V", "buildUI", "Larc/scene/ui/layout/Table;", "v", "", "enabled", "getEnabled", "()Z", "setEnabled", "(Z)V", "pinned", "getPinned", "setPinned", "core"})
    public static final class WindowSetting
    extends SettingsV2.Data<WindowData> {
        public WindowSetting(@NotNull String name) {
            Intrinsics.checkNotNullParameter(name, "name");
            super(name, new WindowData(false, false, null, null, null, null, null, 0.0f, 255, null));
            this.setPersistentProvider(new SettingsV2.PersistentProvider.AsUBJson(new SettingsV2.PersistentProvider.Arc(name), WindowData.class, null, 4, null));
        }

        @Override
        @NotNull
        public Table buildUI() {
            Table table2;
            block1: {
                ImageButton.ImageButtonStyle imageButtonStyle;
                Table $this$buildUI_u24lambda_u2419 = table2 = new Table();
                boolean bl = false;
                $this$buildUI_u24lambda_u2419.image((Drawable)Icon.list).padRight(4.0f);
                $this$buildUI_u24lambda_u2419.add((CharSequence)this.getTitle()).width(148.0f).padRight(8.0f);
                StringBuilder builder = new StringBuilder();
                $this$buildUI_u24lambda_u2419.label(() -> WindowSetting.buildUI$lambda$19$lambda$1(builder, this)).expandX().left();
                ImageButton.ImageButtonStyle $this$buildUI_u24lambda_u2419_u24lambda_u242 = imageButtonStyle = new ImageButton.ImageButtonStyle(Styles.clearNonei);
                boolean bl2 = false;
                $this$buildUI_u24lambda_u2419_u24lambda_u242.imageUpColor = Color.darkGray;
                $this$buildUI_u24lambda_u2419_u24lambda_u242.imageCheckedColor = Color.white;
                ImageButton.ImageButtonStyle myToggleI = imageButtonStyle;
                $this$buildUI_u24lambda_u2419.button((Drawable)Icon.eyeSmall, myToggleI, 24.0f, () -> WindowSetting.buildUI$lambda$19$lambda$3(this)).tooltip("\u5f00\u5173").padRight(4.0f).checked(arg_0 -> WindowSetting.buildUI$lambda$19$lambda$4(this, arg_0));
                $this$buildUI_u24lambda_u2419.button((Drawable)Icon.lockSmall, myToggleI, 24.0f, () -> WindowSetting.buildUI$lambda$19$lambda$5(this)).tooltip("\u9501\u5b9a").padRight(4.0f).checked(arg_0 -> WindowSetting.buildUI$lambda$19$lambda$6(this, arg_0));
                $this$buildUI_u24lambda_u2419.button((Drawable)Icon.resizeSmall, myToggleI, 24.0f, () -> WindowSetting.buildUI$lambda$19$lambda$13(this)).tooltip("\u7f29\u653e").padRight(4.0f).checked(arg_0 -> WindowSetting.buildUI$lambda$19$lambda$14(this, arg_0));
                this.addTools($this$buildUI_u24lambda_u2419);
                $this$buildUI_u24lambda_u2419.row();
                AdsorptionSystem.Constraint constraint = ((WindowData)this.getValue()).getConstraintX();
                if (constraint != null) {
                    AdsorptionSystem.Constraint it = constraint;
                    boolean bl3 = false;
                    $this$buildUI_u24lambda_u2419.add();
                    $this$buildUI_u24lambda_u2419.label(() -> WindowSetting.buildUI$lambda$19$lambda$16$lambda$15(it)).colspan($this$buildUI_u24lambda_u2419.getColumns() - 1).left().row();
                }
                AdsorptionSystem.Constraint constraint2 = ((WindowData)this.getValue()).getConstraintY();
                if (constraint2 == null) break block1;
                AdsorptionSystem.Constraint it = constraint2;
                boolean bl4 = false;
                $this$buildUI_u24lambda_u2419.add();
                $this$buildUI_u24lambda_u2419.label(() -> WindowSetting.buildUI$lambda$19$lambda$18$lambda$17(it)).colspan($this$buildUI_u24lambda_u2419.getColumns() - 1).left().row();
            }
            return table2;
        }

        public final boolean getEnabled() {
            return ((WindowData)this.getValue()).getEnabled();
        }

        public final void setEnabled(boolean v) {
            this.set(WindowData.copy$default((WindowData)this.getValue(), v, false, null, null, null, null, null, 0.0f, 254, null));
        }

        public final boolean getPinned() {
            return ((WindowData)this.getValue()).getPinned();
        }

        public final void setPinned(boolean v) {
            this.set(WindowData.copy$default((WindowData)this.getValue(), false, v, null, null, null, null, null, 0.0f, 253, null));
        }

        private static final CharSequence buildUI$lambda$19$lambda$1(StringBuilder $builder, WindowSetting this$0) {
            block1: {
                StringsKt.clear($builder);
                Vec2 vec2 = ((WindowData)this$0.getValue()).getCenter();
                if (vec2 == null) {
                    return "[grey][UNUSED]";
                }
                Vec2 center = vec2;
                $builder.append("" + '[' + MathKt.roundToInt(center.x) + ',' + MathKt.roundToInt(center.y) + ']');
                Vec2 vec22 = ((WindowData)this$0.getValue()).getSize();
                if (vec22 == null) break block1;
                Vec2 it = vec22;
                boolean bl = false;
                $builder.append("" + '[' + MathKt.roundToInt(it.x) + 'x' + MathKt.roundToInt(it.y) + ']');
            }
            return $builder;
        }

        private static final void buildUI$lambda$19$lambda$3(WindowSetting this$0) {
            this$0.set(WindowData.copy$default((WindowData)this$0.getValue(), !((WindowData)this$0.getValue()).getEnabled(), false, null, null, null, null, null, 0.0f, 254, null));
        }

        private static final boolean buildUI$lambda$19$lambda$4(WindowSetting this$0, ImageButton it) {
            return ((WindowData)this$0.getValue()).getEnabled();
        }

        private static final void buildUI$lambda$19$lambda$5(WindowSetting this$0) {
            this$0.set(WindowData.copy$default((WindowData)this$0.getValue(), false, !((WindowData)this$0.getValue()).getPinned(), null, null, null, null, null, 0.0f, 253, null));
        }

        private static final boolean buildUI$lambda$19$lambda$6(WindowSetting this$0, ImageButton it) {
            return ((WindowData)this$0.getValue()).getPinned();
        }

        private static final CharSequence buildUI$lambda$19$lambda$13$lambda$12$lambda$7(WindowSetting this$0) {
            return "\u7f29\u653e: x" + Strings.fixed((float)((WindowData)this$0.getValue()).getScale(), (int)1);
        }

        private static final void buildUI$lambda$19$lambda$13$lambda$12$lambda$8(WindowSetting this$0, float it) {
            this$0.set(WindowData.copy$default((WindowData)this$0.getValue(), false, false, null, null, null, null, null, it, 127, null));
        }

        private static final void buildUI$lambda$19$lambda$13$lambda$12$lambda$9(WindowSetting this$0, Slider it) {
            it.setValue(((WindowData)this$0.getValue()).getScale());
        }

        private static final void buildUI$lambda$19$lambda$13$lambda$12$lambda$10(WindowSetting this$0) {
            this$0.set(WindowData.copy$default((WindowData)this$0.getValue(), false, false, null, null, null, null, null, 1.0f, 127, null));
        }

        private static final boolean buildUI$lambda$19$lambda$13$lambda$12$lambda$11(WindowSetting this$0, ImageButton it) {
            return Mathf.equal((float)((WindowData)this$0.getValue()).getScale(), (float)1.0f);
        }

        private static final Unit buildUI$lambda$19$lambda$13$lambda$12(WindowSetting this$0, Table $this$showFloatSettingsPanel) {
            Intrinsics.checkNotNullParameter($this$showFloatSettingsPanel, "$this$showFloatSettingsPanel");
            $this$showFloatSettingsPanel.label(() -> WindowSetting.buildUI$lambda$19$lambda$13$lambda$12$lambda$7(this$0)).center().row();
            $this$showFloatSettingsPanel.slider(0.2f, 3.0f, 0.1f, ((WindowData)this$0.getValue()).getScale(), arg_0 -> WindowSetting.buildUI$lambda$19$lambda$13$lambda$12$lambda$8(this$0, arg_0)).update(arg_0 -> WindowSetting.buildUI$lambda$19$lambda$13$lambda$12$lambda$9(this$0, arg_0)).width(200.0f);
            $this$showFloatSettingsPanel.button((Drawable)Icon.undo, Styles.clearNonei, () -> WindowSetting.buildUI$lambda$19$lambda$13$lambda$12$lambda$10(this$0)).disabled(arg_0 -> WindowSetting.buildUI$lambda$19$lambda$13$lambda$12$lambda$11(this$0, arg_0)).padTop(4.0f);
            $this$showFloatSettingsPanel.row();
            return Unit.INSTANCE;
        }

        private static final void buildUI$lambda$19$lambda$13(WindowSetting this$0) {
            UIExtKt.showFloatSettingsPanel(arg_0 -> WindowSetting.buildUI$lambda$19$lambda$13$lambda$12(this$0, arg_0));
        }

        private static final boolean buildUI$lambda$19$lambda$14(WindowSetting this$0, ImageButton it) {
            return !Mathf.equal((float)((WindowData)this$0.getValue()).getScale(), (float)1.0f);
        }

        private static final CharSequence buildUI$lambda$19$lambda$16$lambda$15(AdsorptionSystem.Constraint $it) {
            return "X: " + $it.getType().name() + " to [" + $it.getTarget() + ']';
        }

        private static final CharSequence buildUI$lambda$19$lambda$18$lambda$17(AdsorptionSystem.Constraint $it) {
            return "Y: " + $it.getType().name() + " to [" + $it.getTarget() + ']';
        }
    }
}

