/*
 * Decompiled with CFR 0.152.
 */
package mindustryX.features.ui.comp;

import arc.func.Cons;
import arc.graphics.Color;
import arc.scene.Action;
import arc.scene.actions.Actions;
import arc.scene.ui.layout.Cell;
import arc.scene.ui.layout.Table;
import arc.util.Nullable;
import mindustry.gen.Tex;
import mindustry.graphics.Pal;

public class Card
extends Table {
    public static CardStyle grayOuterDark = new CardStyle(){
        {
            this.shadowStyle = CardShadowStyle.outer;
            this.shadowDark = Pal.darkerGray;
        }
    };
    public static CardStyle accentOutBack = new CardStyle(){
        {
            this.shadowStyle = CardShadowStyle.outer;
            this.shadowDark = Pal.accentBack;
        }
    };
    public CardStyle style;

    public Card(CardStyle style, Cons<Table> contCons) {
        this(Pal.gray, style, contCons);
    }

    public Card(Color cardColor, CardStyle style, Cons<Table> contCons) {
        this.style = style;
        if (cardColor != null) {
            this.background(Tex.whiteui);
            this.setColor(cardColor);
        }
        this.setup(contCons);
    }

    private void setup(Cons<Table> contCons) {
        Color rightBottom;
        Color topLeft;
        if (this.style.shadowStyle == CardShadowStyle.inner) {
            topLeft = this.style.shadowDark;
            rightBottom = this.style.shadowLight;
        } else if (this.style.shadowStyle == CardShadowStyle.outer) {
            topLeft = this.style.shadowLight;
            rightBottom = this.style.shadowDark;
        } else {
            throw new RuntimeException("Card got an unknown shadowStyle:" + (Object)((Object)this.style.shadowStyle));
        }
        float size = this.style.shadowSize;
        Cell topShadow = null;
        Cell bottomShadow = null;
        if (topLeft != null) {
            topShadow = this.image().color(topLeft).height(size).padRight(-1.0f).growX();
            this.row();
            this.image().color(topLeft).width(size).growY();
        }
        this.table(contCons).pad(size).grow();
        if (rightBottom != null) {
            this.image().color(rightBottom).width(size).growY();
            this.row();
            bottomShadow = this.image().color(rightBottom).height(size).padRight(-1.0f).growX();
        }
        int columns = this.getColumns();
        if (topShadow != null) {
            topShadow.colspan(columns);
        }
        if (bottomShadow != null) {
            bottomShadow.colspan(columns);
        }
    }

    public void setCardColor(Color cardColor) {
        this.setCardColor(cardColor, 1.5f);
    }

    public void setCardColor(Color cardColor, float duration) {
        if (this.color.equals((Object)cardColor)) {
            return;
        }
        this.addAction((Action)Actions.color((Color)cardColor, (float)duration));
    }

    public static void cardShadow(Table table2, float size, Color color) {
        table2.image().width(size).color(color).growY().right();
        table2.row();
        table2.image().height(size).color(color).growX().colspan(table2.getColumns());
    }

    public static void cardShadow(Table table2) {
        Card.cardShadow(table2, 8.0f, Pal.darkerGray);
    }

    public static class CardStyle {
        public float shadowSize = 6.0f;
        public CardShadowStyle shadowStyle = CardShadowStyle.inner;
        @Nullable
        public Color shadowLight;
        @Nullable
        public Color shadowDark = Pal.darkestGray;
    }

    public static enum CardShadowStyle {
        inner,
        outer;

    }
}

