/*
 * Decompiled with CFR 0.152.
 */
package mindustryX.loader;

import arc.Core;
import arc.Events;
import arc.struct.ObjectMap;
import arc.util.Log;
import arc.util.Reflect;
import java.util.Objects;
import mindustry.Vars;
import mindustry.core.Version;
import mindustry.game.EventType;
import mindustry.mod.Mod;
import mindustry.mod.Mods;
import mindustryX.VarsX;
import mindustryX.features.AutoUpdate;
import mindustryX.loader.DesktopImpl;
import mindustryX.loader.LoaderPlatform;

public class Main
extends Mod {
    private static LoaderPlatform impl;

    static LoaderPlatform getLoaderPlatform() {
        try {
            if (Core.app.isDesktop()) {
                return new DesktopImpl();
            }
            if (Core.app.isAndroid()) {
                return (LoaderPlatform)Class.forName("mindustryX.loader.AndroidImpl").getConstructor(new Class[0]).newInstance(new Object[0]);
            }
        }
        catch (Exception e) {
            Log.err((Throwable)e);
        }
        return null;
    }

    public Main() {
        if (System.getProperty("MDTX-loaded") == null) {
            System.setProperty("MDTX-loaded", "true");
            LoaderPlatform impl = Main.getLoaderPlatform();
            if (impl == null) {
                Main.loadError("Not support platform, skip.");
                return;
            }
            impl.withSafeClassloader("preload");
        } else {
            Log.infoTag((String)"MindustryX", (String)"Already inside MindustryX.");
        }
    }

    private static void loadError(String msg) {
        Log.errTag((String)"MindustryX", (String)msg);
        Events.on(EventType.ClientLoadEvent.class, e -> Vars.ui.showErrorMessage("Exception when load MindustryX:\n" + msg));
    }

    static void preload() {
        if (Vars.clientLoaded) {
            return;
        }
        impl = Main.getLoaderPlatform();
        if (!Main.checkVersion()) {
            return;
        }
        Core.app.post(Main::load);
        try {
            Thread.sleep(9999999999999999L);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean checkVersion() {
        if (!Version.type.equals("official") || !Version.combined().startsWith(Version.modifier)) {
            Main.loadError("Not official version, skip: get " + Version.combined());
            return false;
        }
        try {
            Main.loadError("Detected ARC client, skip: " + Reflect.get(Version.class, (String)"arcBuild"));
            return false;
        }
        catch (Exception exception) {
            try {
                Main.loadError("Detected FOO client, skip: " + Reflect.get(Version.class, (String)"clientVersion"));
                return false;
            }
            catch (Exception exception2) {
                Mods.ModMeta meta = null;
                ObjectMap metas = (ObjectMap)Reflect.get((Object)Vars.mods, (String)"metas");
                for (ObjectMap.Entry entry : metas.entries()) {
                    if (!((Class)entry.key).getName().equals(Main.class.getName())) continue;
                    meta = (Mods.ModMeta)entry.value;
                    break;
                }
                Objects.requireNonNull(meta, "Can't get mod meta");
                String version = meta.minGameVersion;
                if (!Version.buildString().equals(version)) {
                    Main.loadError("Version not match, skip. (expect " + version + ", get " + Version.buildString() + ")");
                    if (meta.version != null) {
                        VarsX.version = meta.version;
                        VarsX.devVersion = VarsX.version.endsWith("-dev");
                    }
                    VarsX.isLoader = true;
                    AutoUpdate.INSTANCE.checkUpdate();
                    Events.on(EventType.ClientLoadEvent.class, e -> AutoUpdate.INSTANCE.initUI());
                    return false;
                }
                return true;
            }
        }
    }

    static void load() {
        ClassLoader classLoader = impl.createClassloader();
        impl.beforeLaunch();
        Vars.finishLaunch();
        Log.info((Object)"=========== Start mindustryX client ===============");
        Log.logger = new Log.NoopLogHandler();
        try {
            Thread.currentThread().setContextClassLoader(classLoader);
            Reflect.set(classLoader.loadClass("mindustryX.VarsX"), (String)"isLoader", (Object)true);
            impl.launch(classLoader);
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            Vars.launchIDFile.writeString(e.toString());
        }
    }
}

