# 开发前须知

> [!NOTE]
>
> 只有当您想要开发 MaaGB 时才需要看当前页面！
>
> 用户请转到 [MaaGB 使用手册](../manual/新手上路.md)。
>
> 开发 MaaFramework 或开发自己的项目请到 [MaaXYZ/MaaFramework](https://github.com/MaaXYZ/MaaFramework)。

## Github Pull Request 流程简述

### 我不懂编程，只是想改一点点 JSON 文件/文档等，要怎么操作？

欢迎收看 [牛牛也能看懂的 GitHub Pull Request 使用指南](https://maa.plus/docs/zh-cn/develop/pr-tutorial.html)

### 我有编程经验，但是没参与过相关项目，要怎么做？

1. 如果很久以前 fork 过，先在自己仓库的 `Settings` 里，翻到最下面，删除

2. 打开 [MaaGB 主仓库](https://github.com/KhazixW2/MaaGumballs)，点击 `Fork`，继续点击 `Create fork`

3. 克隆你自己的仓库到本地，并拉取子模块

    ```bash
    git clone --recursive https://github.com/<你的用户名>/MaaGumballs.git
    ```

    > ⚠
    >
    > **--recursive 一定不要忘！****--recursive 一定不要忘！****--recursive 一定不要忘！**
    >
    > OCR异常失败很可能就是没加recursive导致。子模块拉取失败会导致缺少必要的依赖文件。

4. 下载 MaaFramework 的 [Release 包](https://github.com/MaaXYZ/MaaFramework/releases)，解压到 `deps` 文件夹中。

5. 配置编程环境

    - 下载并安装vscode
    - 选择性安装调试/开发工具

        | 工具 | 简介 |
        | --- | --- |
        | [MaaDebugger](https://github.com/MaaXYZ/MaaDebugger) | 独立调试工具 |
        | [Maa Pipeline Support](https://marketplace.visualstudio.com/items?itemName=nekosu.maa-support) | VSCode 插件，提供调试、截图、获取 ROI 、取色等功能 |
        | [MFA Tools](https://github.com/SweetSmellFox/MFATools) | 独立截图、获取 ROI 及取色工具 |
        | [ImageCropper(不推荐)](https://github.com/MaaXYZ/MaaFramework/tree/main/tools/ImageCropper) | 独立截图及获取 ROI 工具 |

6. 本地安装

    1. 安装嵌入式python（仅Windows需要）

       ```bash
       ./tools/ci/setup_embed_python.py
       ```

    2. 通过运行 install 组装部件

       ```bash
       python ./tools/install.py
       ```

    便可以在 install 文件夹运行 MaaGB 了。

7. 开始开发

    开始愉快的改代码吧，开始前查看[相关阅读](#相关阅读)。

8. git 操作

    通常用的最多的基本命令有：
    - `git add <file>`：添加文件到暂存区，`*` 代表全部文件
    - `git commit -m "message"`：提交暂存区到本地仓库。`message` 请遵循 [约定式提交规范](https://www.conventionalcommits.org/zh-hans/v1.0.0/)，让你的 commit 信息更加清晰
    - `git pull origin <branch>`：拉取远程仓库到本地仓库
    - `git push origin <branch>`：推送本地仓库到远程仓库

    > ⚠
    >
    > 开发过程中，每一定数量，记得提交一个 commit, 别忘了写上 message
    > 假如你不熟悉 git 的使用，你可能需要创建并切换到一个新的分支，而不是直接提交在 main 上
    > 这样你的提交就能在新的分支上生长，不会受到 main 更新的打扰

    ```bash
    git checkout -b <branch-name> # 创建并切换到新的分支
    ```

    完成开发后，推送你修改的本地分支到远程仓库（fork 的仓库）

    ```bash
    git push origin <branch-name>
    ```

    当 MaaGB 仓库出现更改（如其他人的commit），你可能需要把这些更改同步到你的分支

    1. 关联 MaaGB 原仓库：首次需要执行以下命令

        ```bash
        git remote add upstream https://github.com/KhazixW2/MaaGumballs.git`
        ```

    2. 拉取远程仓库更新：

        ```bash
        git fetch upstream
        ```

    3. 变基（推荐）或者合并修改：

        ```bash
        git rebase upstream/main # 变基，使commit历史更清晰，完成你的个人pr时建议使用rebase而不是merge来合并修改
        ```

        或者

        ```bash
        git merge upstream/main
        ```

    git 参考资料：
    - [git 官方文档](https://git-scm.com/docs)
    - [git 简明指南](https://www.runoob.com/manual/git-guide/)
    - [git 教程|菜鸟教程](https://www.runoob.com/git/git-tutorial.html)

9. 提交 Pull Request

    你修改的代码已经提交到你的仓库，现在你需要提交一个 Pull Request 到 MaaGB 的仓库，等待维护者审核

    [GitHub Pull Request 参考](https://maa.plus/docs/zh-cn/develop/pr-tutorial.html)

## MaaGB 格式化要求

MaaGB 使用一系列的格式化工具来保证仓库中的代码和资源文件美观统一，以便于维护和阅读

请确保在提交之前已经格式化, 目前VSCode自动触发JSON文件的格式化。

还需要手动下载并安装以下工具：MarkDownLint、BlackFormatter.这两个插件都可以在vscode插件市场中下载。

目前启用的格式化工具如下：

| 文件类型 | 格式化工具 |
| --- | --- |
| JSON/VSCode | [VSCode Settings](https://code.visualstudio.com/docs/languages/json#_json-settings) |
| Markdown | [MarkdownLint](https://github.com/DavidAnson/markdownlint-cli2) |
| Python | [Black Formatter](https://black.readthedocs.io/en/stable/index.html) |

## 相关阅读

- [项目结构](./项目结构.md)
- [interface.json编写](./interface.json编写.md)
- [Pipeline编写](./Pipeline编写.md)
- [Custom编写](./Custom编写.md)
- [项目重构](./项目重构.md)
- [外服适配](./外服适配.md)
- [文档编写](./文档编写.md)
