# 新手上路

- [新手上路](#新手上路)
  - [前置准备](#前置准备)
    - [1. 确认版本系统](#1-确认版本系统)
    - [2. 安装运行环境](#2-安装运行环境)
      - [Windows](#windows)
      - [其他系统 (Linux, macOS)](#其他系统-linux-macos)
        - [Linux](#linux)
        - [macOS](#macos)
        - [图形用户界面 (MFAAvalonia) 额外依赖 (适用于 Linux 和 macOS)](#图形用户界面-mfaavalonia-额外依赖-适用于-linux-和-macos)
    - [3. 下载正确的版本](#3-下载正确的版本)
      - [Windows](#windows-1)
      - [macOS](#macos-1)
      - [Linux](#linux-1)
      - [Android](#android)
    - [4. 正确解压](#4-正确解压)
    - [5. 确认模拟器支持](#5-确认模拟器支持)
    - [6. 正确设置模拟器分辨率和机型](#6-正确设置模拟器分辨率和机型)
    - [7. pip 设置](#7-pip-设置)
  - [相关文档](#相关文档)

## 前置准备

### 1. 确认版本系统

MaaGB 在 Windows 下仅支持 10 和 11，旧版 Windows 请参阅[常见问题](https://maa.plus/docs/zh-cn/manual/faq.html#%E7%B3%BB%E7%BB%9F%E9%97%AE%E9%A2%98)中的系统问题部分。

> [!WARNING]
>
> 以下内容源自 MAA，与 MaaGB 有差异，故仅供参考
> [暂不支持 PlayCover](https://github.com/MaaXYZ/MaaFramework/issues/405)。

若您正在使用 Apple Silicon MacBook，请前往[此页面](https://maa.plus/docs/zh-cn/manual/device/macos.html#apple-silicon-%E8%8A%AF%E7%89%87)
MaaGB 同样支持搭载 [Intel 芯片](https://maa.plus/docs/zh-cn/manual/device/macos.html#intel-%E8%8A%AF%E7%89%87)的 MacBook，但更推荐使用 Mac 自带的多系统安装 Windows，并使用 Windows 版 MaaGB。

若您希望使用 Android 实体设备，请前往[此页面](https://maa.plus/docs/zh-cn/manual/device/android.html)。
由于此方法涉及 adb 调试且仍需与电脑连接，不推荐入门玩家使用此方法。

### 2. 安装运行环境

#### Windows

对于 Windows 用户：

1. **必须安装 VCRedist x64**：这是运行 MaaGumballs (无论是命令行版本还是图形界面版本 MFAAvalonia) 的基础需求。
    - 点击 [vc_redist.x64](https://aka.ms/vs/17/release/vc_redist.x64.exe) 下载并安装。

2. **如果使用图形界面 (MFAAvalonia)，则需要额外安装 .NET 8**：
    - 推荐访问 [.NET 官方下载页面](https://dotnet.microsoft.com/download/dotnet/8.0) 并下载安装适用于您系统的 **.NET Desktop Runtime 8** (通常是 x64 版本)。

**通过 `winget` 安装 (推荐)**:
您也可以右键 Windows 开始按钮，选择“命令提示符”或“PowerShell (管理员)”，然后在终端内粘贴以下命令并回车，以方便地同时安装 VCRedist x64 和 .NET 8 Desktop Runtime：

  ```shell
  winget install Microsoft.VCRedist.2017.x64 Microsoft.DotNet.DesktopRuntime.8
  ```

#### 其他系统 (Linux, macOS)

##### Linux

**Python 版本依赖**:

- 您的系统需要安装 **Python 版本 ≥ 3.10**。这是 MaaGB 启动和管理其内部环境所必需的。
- MaaGB 首次运行时会自动创建并使用独立的虚拟环境，并安装所需的 Python 依赖包 (来自 `requirements.txt`)。您**无需**手动创建虚拟环境或安装这些依赖。

##### macOS

**Python 环境**: MaaGB 的 macOS 版本已内置嵌入式 Python 环境，您**无需**单独安装或配置 Python。程序将自动使用此内嵌环境，并管理其依赖。

##### 图形用户界面 (MFAAvalonia) 额外依赖 (适用于 Linux 和 macOS)

如果您计划在 Linux 或 macOS 上使用图形用户界面 (MFAAvalonia)，则**还需要安装 .NET 8 运行时**。

- 请访问 [.NET 官方下载页面](https://dotnet.microsoft.com/download/dotnet/8.0)。
- 根据您的操作系统 (Linux/macOS) 和 CPU 架构 (例如 x64, Arm64) 选择并下载安装合适的 **.NET Runtime**。

### 3. 下载正确的版本

MaaGumballs 下载（更新）地址：<https://github.com/KhazixW2/MaaGumballs/releases>

国内用户也可通过 [Mirror酱](https://mirrorchyan.com/zh/projects?rid=MaaGB&source=gbgh-readme) 高速下载。

#### Windows

- 对于**绝大部分**用户，请下载 `MaaGumballs-win-x86_64-vXXX.zip`
- ~~若确定自己的电脑是 arm 架构，请下载 `MaaGumballs-win-aarch64-vXXX.zip`~~
- arm 架构目前已不支持

> [!WARNING]
> 请注意！Windows 的电脑几乎全都是 x86\_64 的，可能占 99.999%，除非你非常确定自己是 arm，否则别下这个！

- 解压后运行 `MaaPiCli.exe`（命令行）或 `MFAAvalonia.exe`（图形化界面）即可

#### macOS

- 查看处理器类型（重要：一定要选择正确版本才能正确运行）：

  1. 点击屏幕左上角的苹果标志。
  2. 选择“关于本机”。
  3. 在弹出的窗口中，你可以看到处理器的信息。

- 若使用 Intel X86 处理器，请下载 `MaaGumballs-macos-x86_64-vXXX.tar.gz`
- 若使用 Apple Silicon 系列如： M1, M2 等 ARM 架构处理器，请下载 `MaaGumballs-macos-aarch64-vXXX.tar.gz`

使用方式：

  1. 打开终端，解压分发的压缩包：

      **选项1：解压到系统目录（需要管理员权限）**

      ```shell
      sudo mkdir -p /usr/local/bin/MaaGumballs
      sudo tar -xzf <下载的MaaGumballs压缩包路径> -C /usr/local/bin/MaaGumballs
      ```

      **选项2：解压到用户目录（推荐，无需sudo）**

      ```shell
      mkdir -p ~/MaaGumballs
      tar -xzf <下载的MaaGumballs压缩包路径> -C ~/MaaGumballs
      ```

  2. 进入解压目录并运行程序：

      ```shell
      cd /usr/local/bin/MaaGumballs
      ./MaaPiCli
      ```

>[!NOTE]
>
> 若想使用**图形操作页面**请按第二步操作，由执行 `MaaPiCli` 改为执行 `MFAAvalonia` 程序。

⚠️Gatekeeper 安全提示处理：

在 macOS 10.15 (Catalina) 及更高版本中，Gatekeeper 可能会阻止运行未签名的应用程序。  
如果遇到"无法打开，因为无法验证开发者"等错误，请选择以下任一方案:

  ```shell
  # 方案1：以 MaaPiCli 为例，移除隔离属性（推荐，以实际路径为准）
  sudo xattr -rd com.apple.quarantine /usr/local/bin/MaaGumballs/MaaPiCli
  # 或用户目录版本：xattr -rd com.apple.quarantine ~/MaaGumballs/MaaPiCli

  # 方案2：添加到 Gatekeeper 白名单
  sudo spctl --add /usr/local/bin/MaaGumballs/MaaPiCli
  # 或用户目录版本：spctl --add ~/MaaGumballs/MaaPiCli

  # 方案3：一次性处理整个目录
  sudo xattr -rd com.apple.quarantine /usr/local/bin/MaaGumballs/*
  # 或用户目录版本：xattr -rd com.apple.quarantine ~/MaaGumballs/*
  ```

#### Linux

同macOS，下载对应版本的压缩包，运行 `MaaPiCli` 或 `MFAAvalonia` 即可。

#### Android

~~对于一般用户我们并不推荐该版本，故已在发行版删除~~
如您非常了解手机操作，可参考[使用方法](https://github.com/MaaXYZ/MaaFramework/issues/475)，以及[开发文档](../develop/开发前须知.md)自行安装。

### 4. 正确解压

确认解压完整，并确保将 MaaGumballs 解压到一个独立的文件夹中。除关闭内建管理员批准的Administrator账号外，请勿将 MAA 解压到如 `C:\`、`C:\Program Files\` 等需要 UAC 权限的路径。

> [!CAUTION]
> 不要在压缩软件直接打开程序！

### 5. 确认模拟器支持

查阅[模拟器和设备支持](https://maa.plus/docs/zh-cn/manual/device/)，确认正在使用的模拟器支持情况。

### 6. 正确设置模拟器分辨率和机型

模拟器分辨率应为 `16:9` 比例，推荐分辨率为 `1080*1920 dpi480`， 最低分辨率为`720*1280 dpi320`不符合要求造成的运行报错将不会被解决。

>[!WARNING]
>
> 注意修改分辨率后模拟器主页应该是竖屏的（手机版），不要选成横屏（平板版）了！
> 注意修改机型为samsung galaxy 24(推荐)

### 7. pip 设置

以下为 `config/pip_config.json` 的内容。

 ```jsonc
 {
     "enable_pip_install": true,  // 是否启用 pip 安装，默认 true，推荐开启
     "last_version": "v3.2.0",  // 完成 pip 安装时读取 interface.json 的 version ，启动时和 version 对比，不同则尝试安装
     "mirror": "https://mirrors.ustc.edu.cn/pypi/simple", // 镜像源。pip install -i 后参数，可根据个人需求填写。注意非大陆地区用户请修改值为 ""
     "backup_mirrors": [
     "https://pypi.tuna.tsinghua.edu.cn/simple",
     "https://mirrors.cloud.tencent.com/pypi/simple/",
     "https://pypi.org/simple"
    ]  // 备用镜像源
 }
 ```

## 相关文档

- [连接设置](./连接设置.md#连接设置)——介绍了adb连接以及模拟器设置
- [MaaPiCli操作说明](./MaaPiCli.md)——介绍了 MaaPiCli 使用方法~~翻译文档~~
- [功能介绍](./功能介绍.md)——介绍了部分功能的注意事项
- [常见问题](./常见问题.md)——介绍了常见问题及解决策略
- [Mirror酱使用说明](./Mirror酱.md)——介绍了Mirror酱使用方法
