/*
 * Decompiled with CFR 0.152.
 */
package arc.backend.sdl;

import arc.Application;
import arc.Core;
import arc.Graphics;
import arc.backend.sdl.SdlApplication;
import arc.backend.sdl.SdlGL20;
import arc.backend.sdl.SdlGL30;
import arc.backend.sdl.jni.SDL;
import arc.backend.sdl.jni.SDLGL;
import arc.graphics.GL20;
import arc.graphics.GL30;
import arc.graphics.Pixmap;
import arc.graphics.gl.GLVersion;
import arc.graphics.gl.HdpiMode;
import arc.struct.ObjectMap;
import arc.util.ArcRuntimeException;
import arc.util.OS;

public class SdlGraphics
extends Graphics {
    private GL20 gl20;
    private GL30 gl30;
    private GLVersion glVersion;
    private Graphics.BufferFormat bufferFormat;
    private SdlApplication app;
    private ObjectMap<Graphics.Cursor.SystemCursor, SdlCursor> cursors;
    private long lastFrameTime = -1L;
    private float deltaTime;
    private long frameId;
    private long frameCounterStart = 0L;
    private int frames;
    private int fps;
    private int[] wh = new int[2];
    int backBufferWidth;
    int backBufferHeight;
    int logicalWidth;
    int logicalHeight;

    SdlGraphics(SdlApplication app) {
        this.app = app;
        String errorMessage = SDLGL.init();
        if (errorMessage != null) {
            throw new ArcRuntimeException("GLEW failed to initialize: " + errorMessage);
        }
        Core.gl20 = this.gl20 = new SdlGL20();
        Core.gl = this.gl20;
        String versionString = this.gl20.glGetString(7938);
        String vendorString = this.gl20.glGetString(7936);
        String rendererString = this.gl20.glGetString(7937);
        this.cursors = new ObjectMap();
        this.glVersion = new GLVersion(Application.ApplicationType.desktop, versionString, vendorString, rendererString);
        this.bufferFormat = new Graphics.BufferFormat(app.config.r, app.config.g, app.config.b, app.config.a, app.config.depth, app.config.stencil, app.config.samples, false);
        if (!this.glVersion.atLeast(2, 0) || !this.supportsFBO()) {
            throw new ArcRuntimeException("OpenGL 2.0 or higher with the FBO extension is required. OpenGL version: " + versionString);
        }
        if (this.glVersion.atLeast(3, 0) && app.config.allowGl30) {
            Core.gl30 = this.gl30 = new SdlGL30();
            this.gl20 = this.gl30;
            Core.gl20 = this.gl30;
            Core.gl = this.gl30;
        }
        this.clear(app.config.initialBackgroundColor);
        SDL.SDL_GL_SwapWindow(app.window);
    }

    boolean supportsFBO() {
        return this.glVersion.atLeast(3, 0) || SDL.SDL_GL_ExtensionSupported("GL_EXT_framebuffer_object");
    }

    void update() {
        long time = System.nanoTime();
        if (this.lastFrameTime == -1L) {
            this.lastFrameTime = time;
        }
        this.deltaTime = (float)(time - this.lastFrameTime) / 1.0E9f;
        this.lastFrameTime = time;
        if (time - this.frameCounterStart >= 1000000000L) {
            this.fps = this.frames;
            this.frames = 0;
            this.frameCounterStart = time;
        }
        ++this.frames;
        ++this.frameId;
    }

    void updateSize(int width, int height) {
        this.logicalWidth = width;
        this.logicalHeight = height;
        if (OS.isMac) {
            SDL.SDL_GL_GetDrawableSize(this.app.window, this.wh);
            this.backBufferWidth = this.wh[0];
            this.backBufferHeight = this.wh[1];
        } else {
            this.backBufferWidth = width;
            this.backBufferHeight = height;
        }
        this.gl20.glViewport(0, 0, this.backBufferWidth, this.backBufferHeight);
    }

    @Override
    public boolean isGL30Available() {
        return this.gl30 != null;
    }

    @Override
    public GL20 getGL20() {
        return this.gl20;
    }

    @Override
    public void setGL20(GL20 gl20) {
        this.gl20 = gl20;
        Core.gl = Core.gl20 = gl20;
    }

    @Override
    public GL30 getGL30() {
        return this.gl30;
    }

    @Override
    public void setGL30(GL30 gl30) {
        this.gl30 = gl30;
        this.gl20 = this.gl30;
        Core.gl = Core.gl20 = gl30;
    }

    @Override
    public int getWidth() {
        if (this.app.config.hdpiMode == HdpiMode.pixels) {
            return this.backBufferWidth;
        }
        return this.logicalWidth;
    }

    @Override
    public int getHeight() {
        if (this.app.config.hdpiMode == HdpiMode.pixels) {
            return this.backBufferHeight;
        }
        return this.logicalHeight;
    }

    @Override
    public int getBackBufferWidth() {
        return this.backBufferWidth;
    }

    @Override
    public int getBackBufferHeight() {
        return this.backBufferHeight;
    }

    @Override
    public long getFrameId() {
        return this.frameId;
    }

    @Override
    public float getDeltaTime() {
        return this.deltaTime;
    }

    @Override
    public int getFramesPerSecond() {
        return this.fps;
    }

    @Override
    public GLVersion getGLVersion() {
        return this.glVersion;
    }

    @Override
    public float getPpiX() {
        return 0.0f;
    }

    @Override
    public float getPpiY() {
        return 0.0f;
    }

    @Override
    public float getPpcX() {
        return 0.0f;
    }

    @Override
    public float getPpcY() {
        return 0.0f;
    }

    @Override
    public float getDensity() {
        return 0.0f;
    }

    @Override
    public boolean setFullscreen() {
        int[] bounds = new int[4];
        int index = SDL.SDL_GetWindowDisplayIndex(this.app.window);
        if (index < 0) {
            return false;
        }
        int result = SDL.SDL_GetDisplayBounds(index, bounds);
        if (result != 0) {
            return false;
        }
        SDL.SDL_SetWindowSize(this.app.window, bounds[2], bounds[3]);
        SDL.SDL_SetWindowFullscreen(this.app.window, 1);
        return true;
    }

    @Override
    public boolean setWindowedMode(int width, int height) {
        SDL.SDL_SetWindowFullscreen(this.app.window, 0);
        SDL.SDL_SetWindowSize(this.app.window, width, height);
        return true;
    }

    @Override
    public void setTitle(String title) {
        SDL.SDL_SetWindowTitle(this.app.window, title);
    }

    @Override
    public void setBorderless(boolean borderless) {
        int result;
        int index;
        boolean maximized;
        boolean bl = maximized = (SDL.SDL_GetWindowFlags(this.app.window) & 0x80) == 128;
        if (maximized && OS.isLinux) {
            SDL.SDL_RestoreWindow(this.app.window);
        }
        if ((index = SDL.SDL_GetWindowDisplayIndex(this.app.window)) < 0) {
            return;
        }
        int[] bounds = new int[4];
        int n = result = borderless ? SDL.SDL_GetDisplayBounds(index, bounds) : SDL.SDL_GetDisplayUsableBounds(index, bounds);
        if (result != 0) {
            return;
        }
        SDL.SDL_SetWindowBordered(this.app.window, !borderless);
        if (maximized && OS.isLinux) {
            SDL.SDL_MaximizeWindow(this.app.window);
        }
        SDL.SDL_SetWindowPosition(this.app.window, bounds[0], bounds[1]);
        SDL.SDL_SetWindowSize(this.app.window, bounds[2], bounds[3]);
    }

    @Override
    public void setWindowPosition(int x, int y) {
        SDL.SDL_SetWindowPosition(this.app.window, x, y);
    }

    @Override
    public void setWindowSize(int width, int height) {
        SDL.SDL_SetWindowSize(this.app.window, width, height);
    }

    @Override
    public void setVSync(boolean vsync) {
        SDL.SDL_GL_SetSwapInterval(vsync ? 1 : 0);
    }

    @Override
    public Graphics.BufferFormat getBufferFormat() {
        return this.bufferFormat;
    }

    @Override
    public boolean supportsExtension(String extension) {
        return SDL.SDL_GL_ExtensionSupported(extension);
    }

    @Override
    public boolean isContinuousRendering() {
        return true;
    }

    @Override
    public void setContinuousRendering(boolean isContinuous) {
    }

    @Override
    public void requestRendering() {
    }

    @Override
    public boolean isFullscreen() {
        return (SDL.SDL_GetWindowFlags(this.app.window) & 1) == 1;
    }

    @Override
    public Graphics.Cursor newCursor(Pixmap pixmap, int xHotspot, int yHotspot) {
        long surface = SDL.SDL_CreateRGBSurfaceFrom(pixmap.pixels, pixmap.width, pixmap.height);
        long cursor = SDL.SDL_CreateColorCursor(surface, xHotspot, yHotspot);
        return new SdlCursor(surface, cursor);
    }

    @Override
    protected void setCursor(Graphics.Cursor cursor) {
        SDL.SDL_SetCursor(((SdlCursor)cursor).cursorHandle);
    }

    @Override
    protected void setSystemCursor(Graphics.Cursor.SystemCursor cursor) {
        if (!this.cursors.containsKey(cursor)) {
            long handle = SDL.SDL_CreateSystemCursor(this.mapCursor(cursor));
            this.cursors.put(cursor, new SdlCursor(0L, handle));
        }
        SDL.SDL_SetCursor(this.cursors.get((Graphics.Cursor.SystemCursor)cursor).cursorHandle);
    }

    @Override
    public void dispose() {
        super.dispose();
        this.cursors.each((ignored, value) -> value.dispose());
    }

    private int mapCursor(Graphics.Cursor.SystemCursor cursor) {
        switch (cursor) {
            case arrow: {
                return 0;
            }
            case ibeam: {
                return 1;
            }
            case crosshair: {
                return 3;
            }
            case hand: {
                return 11;
            }
            case horizontalResize: {
                return 7;
            }
            case verticalResize: {
                return 8;
            }
        }
        throw new IllegalArgumentException("this is impossible.");
    }

    public static class SdlCursor
    implements Graphics.Cursor {
        final long surfaceHandle;
        final long cursorHandle;

        public SdlCursor(long surfaceHandle, long cursorHandle) {
            this.surfaceHandle = surfaceHandle;
            this.cursorHandle = cursorHandle;
        }

        @Override
        public void dispose() {
            if (this.cursorHandle != 0L) {
                SDL.SDL_FreeCursor(this.cursorHandle);
            }
            if (this.surfaceHandle != 0L) {
                SDL.SDL_FreeSurface(this.surfaceHandle);
            }
        }
    }
}

