/*
 * Decompiled with CFR 0.152.
 */
package mindustry;

import arc.Core;
import arc.Events;
import arc.assets.Loadable;
import arc.files.Fi;
import arc.graphics.Color;
import arc.input.KeyBind;
import arc.scene.ui.layout.Scl;
import arc.struct.Seq;
import arc.struct.StringMap;
import arc.util.ColorCodes;
import arc.util.I18NBundle;
import arc.util.Log;
import arc.util.Nullable;
import arc.util.OS;
import arc.util.Strings;
import arc.util.Structs;
import arc.util.Threads;
import arc.util.Time;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Locale;
import java.util.concurrent.ExecutorService;
import mindustry.ai.BaseRegistry;
import mindustry.ai.BlockIndexer;
import mindustry.ai.ControlPathfinder;
import mindustry.ai.Pathfinder;
import mindustry.ai.WaveSpawner;
import mindustry.async.AsyncCore;
import mindustry.async.AvoidanceProcess;
import mindustry.core.ContentLoader;
import mindustry.core.Control;
import mindustry.core.FileTree;
import mindustry.core.GameState;
import mindustry.core.Logic;
import mindustry.core.NetClient;
import mindustry.core.NetServer;
import mindustry.core.Platform;
import mindustry.core.Renderer;
import mindustry.core.UI;
import mindustry.core.Version;
import mindustry.core.World;
import mindustry.ctype.ContentType;
import mindustry.editor.MapEditor;
import mindustry.entities.EntityCollisions;
import mindustry.game.EventType;
import mindustry.game.FogControl;
import mindustry.game.Schematics;
import mindustry.game.Universe;
import mindustry.game.Waves;
import mindustry.gen.Groups;
import mindustry.gen.Player;
import mindustry.graphics.CacheLayer;
import mindustry.input.Binding;
import mindustry.io.JsonIO;
import mindustry.logic.GlobalVars;
import mindustry.maps.Map;
import mindustry.maps.Maps;
import mindustry.mod.Mods;
import mindustry.net.BeControl;
import mindustry.net.Net;
import mindustry.net.ServerGroup;
import mindustry.service.GameService;
import mindustry.ui.dialogs.LanguageDialog;
import mindustry.world.Tile;

public class Vars
implements Loadable {
    public static boolean failedToLaunch = false;
    public static boolean loadLocales = true;
    public static boolean loadedLogger = false;
    public static boolean loadedFileLogger = false;
    public static String steamPlayerName = "";
    public static final int minModGameVersion = 136;
    public static final int minJavaModGameVersion = 154;
    public static boolean showSectorSubmissions = true;
    public static boolean forceBeServers = false;
    public static boolean skipModCode = false;
    public static final ContentType[] defaultContentIcons = new ContentType[]{ContentType.item, ContentType.liquid, ContentType.block, ContentType.unit, ContentType.status};
    public static final int defaultEnv = 233;
    public static final int darkRadius = 4;
    public static final int maxLoadoutSchematicPad = 5;
    public static final String schematicBaseStart = "bXNjaA";
    public static final int bufferSize = 8192;
    public static final Charset charset = Charset.forName("UTF-8");
    public static final String appName = "Mindustry";
    public static final String ghApi = "https://api.github.com";
    public static final String discordURL = "https://discord.gg/mindustry";
    public static final String modGuideURL = "https://mindustrygame.github.io/wiki/modding/1-modding/";
    public static final String patchesGuideURL = "https://mindustrygame.github.io/wiki/datapatches/";
    public static final String[] serverJsonBeURLs = new String[]{"https://raw.githubusercontent.com/Anuken/MindustryServerList/master/servers_be.json", "https://cdn.jsdelivr.net/gh/anuken/mindustryserverlist/servers_be.json"};
    public static final String[] serverJsonURLs = new String[]{"https://raw.githubusercontent.com/Anuken/MindustryServerList/master/servers_v8.json", "https://cdn.jsdelivr.net/gh/anuken/mindustryserverlist/servers_v8.json"};
    public static final String[] modJsonURLs = new String[]{"https://raw.githubusercontent.com/Anuken/MindustryMods/master/mods.json", "https://cdn.jsdelivr.net/gh/anuken/mindustrymods/mods.json"};
    public static final String reportIssueURL = "https://github.com/Anuken/Mindustry/issues/new?labels=bug&template=bug_report.md";
    public static final Seq<ServerGroup> defaultServers = Seq.with(new ServerGroup[0]);
    public static final Seq<ServerGroup> cachedServers = Seq.with(new ServerGroup[0]);
    public static final int maxGlErrors = 100;
    public static final int maxBlockSize = 16;
    public static final float mineTransferRange = 220.0f;
    public static final int maxTextLength = 150;
    public static final int maxNameLength = 40;
    public static final float itemSize = 5.0f;
    public static final float finalWorldBounds = 250.0f;
    public static final float buildingRange = 220.0f;
    public static final float unitCollisionRadiusScale = 0.6f;
    public static final float itemTransferRange = 220.0f;
    public static final float logicItemTransferRange = 45.0f;
    public static final float turnDuration = 7200.0f;
    public static final float baseInvasionChance = 0.01f;
    public static final float invasionGracePeriod = 20.0f;
    public static final float minArmorDamage = 0.1f;
    public static final int tilesize = 8;
    public static final float tilePayload = 64.0f;
    public static final float iconXLarge = 48.0f;
    public static final float iconLarge = 40.0f;
    public static final float iconMed = 32.0f;
    public static final float iconSmall = 24.0f;
    public static float macNotchHeight = 32.0f;
    public static boolean updateEditorOnChange = false;
    public static final Color[] playerColors = new Color[]{Color.valueOf("82759a"), Color.valueOf("c0c1c5"), Color.valueOf("ffffff"), Color.valueOf("7d2953"), Color.valueOf("ff074e"), Color.valueOf("ff072a"), Color.valueOf("ff76a6"), Color.valueOf("a95238"), Color.valueOf("ffa108"), Color.valueOf("feeb2c"), Color.valueOf("ffcaa8"), Color.valueOf("008551"), Color.valueOf("00e339"), Color.valueOf("423c7b"), Color.valueOf("4b5ef1"), Color.valueOf("2cabfe")};
    public static final String[] accessibleIcons = new String[]{"effect", "power", "logic", "units", "liquid", "production", "defense", "turret", "distribution", "crafting", "settings", "cancel", "zoom", "ok", "star", "home", "pencil", "up", "down", "left", "right", "hammer", "warning", "tree", "admin", "map", "modePvp", "terrain", "modeSurvival", "commandRally", "commandAttack"};
    public static final int maxTcpSize = 1100;
    public static final int port = 6567;
    public static final int multicastPort = 20151;
    public static final int maxModSubtitleLength = 40;
    public static final String multicastGroup = "227.2.7.7";
    public static float maxDeltaClient = 6.0f;
    public static float maxDeltaServer = 10.0f;
    public static boolean clientLoaded = false;
    public static int maxTextureSize = 2048;
    public static int maxSchematicSize = 64;
    public static boolean showSectorLandInfo = true;
    public static boolean checkScreenshotMemory = true;
    public static boolean confirmExit = true;
    public static boolean disableUI;
    public static boolean disableSave;
    public static boolean testMobile;
    public static boolean mobile;
    public static boolean ios;
    public static boolean android;
    public static boolean headless;
    public static boolean steam;
    public static boolean clearSectors;
    public static boolean enableLight;
    public static boolean enableDarkness;
    public static boolean drawDebugHitboxes;
    public static boolean debugDrawAvoidance;
    public static boolean loadedServerCache;
    public static boolean fetchedServers;
    public static Fi dataDirectory;
    public static Fi screenshotDirectory;
    public static Fi customMapDirectory;
    public static Fi mapPreviewDirectory;
    public static Fi tmpDirectory;
    public static Fi saveDirectory;
    public static Fi modDirectory;
    public static Fi schematicDirectory;
    public static Fi bebuildDirectory;
    public static Fi launchIDFile;
    public static Fi serverCacheFile;
    public static Map emptyMap;
    public static Tile emptyTile;
    public static final String mapExtension = "msav";
    public static final String saveExtension = "msav";
    public static final String schematicExtension = "msch";
    public static String javaPath;
    public static Locale[] locales;
    public static ExecutorService mainExecutor;
    public static FileTree tree;
    public static Net net;
    public static ContentLoader content;
    public static GameState state;
    public static EntityCollisions collisions;
    public static Waves waves;
    public static Platform platform;
    public static Mods mods;
    public static Schematics schematics;
    public static BeControl becontrol;
    public static AsyncCore asyncCore;
    public static BaseRegistry bases;
    public static GlobalVars logicVars;
    public static MapEditor editor;
    public static AvoidanceProcess avoidance;
    public static GameService service;
    public static Universe universe;
    public static World world;
    public static Maps maps;
    public static WaveSpawner spawner;
    public static BlockIndexer indexer;
    public static Pathfinder pathfinder;
    public static ControlPathfinder controlPath;
    public static FogControl fogControl;
    public static Control control;
    public static Logic logic;
    public static Renderer renderer;
    public static UI ui;
    public static NetServer netServer;
    public static NetClient netClient;
    @Nullable
    public static Player player;

    @Override
    public void loadAsync() {
        Vars.loadSettings();
        Vars.init();
    }

    public static void init() {
        Groups.init();
        if (loadLocales) {
            String[] stra = Core.files.internal("locales").readString().split("\n");
            locales = new Locale[stra.length];
            for (int i = 0; i < locales.length; ++i) {
                String code = stra[i];
                Vars.locales[i] = code.contains("_") ? new Locale(code.split("_")[0], code.split("_")[1]) : new Locale(code);
            }
            Arrays.sort(locales, Structs.comparing(LanguageDialog::getDisplayName, String.CASE_INSENSITIVE_ORDER));
            locales = (Locale[])Seq.with(locales).add(new Locale("router")).toArray(Locale.class);
        }
        Version.init();
        CacheLayer.init();
        if (!headless) {
            Log.info("[Mindustry] Version: @", Version.buildString());
        }
        dataDirectory = Core.settings.getDataDirectory();
        screenshotDirectory = dataDirectory.child("screenshots/");
        customMapDirectory = dataDirectory.child("maps/");
        mapPreviewDirectory = dataDirectory.child("previews/");
        saveDirectory = dataDirectory.child("saves/");
        tmpDirectory = dataDirectory.child("tmp/");
        modDirectory = dataDirectory.child("mods/");
        schematicDirectory = dataDirectory.child("schematics/");
        bebuildDirectory = dataDirectory.child("be_builds/");
        serverCacheFile = dataDirectory.child("server_list.json");
        emptyMap = new Map(new StringMap());
        if (tree == null) {
            tree = new FileTree();
        }
        if (mods == null) {
            mods = new Mods();
        }
        content = new ContentLoader();
        waves = new Waves();
        collisions = new EntityCollisions();
        world = new World();
        universe = new Universe();
        becontrol = new BeControl();
        asyncCore = new AsyncCore();
        if (!headless) {
            editor = new MapEditor();
        }
        maps = new Maps();
        spawner = new WaveSpawner();
        indexer = new BlockIndexer();
        pathfinder = new Pathfinder();
        controlPath = new ControlPathfinder();
        fogControl = new FogControl();
        bases = new BaseRegistry();
        logicVars = new GlobalVars();
        javaPath = new Fi(OS.prop("java.home")).child("bin/java").exists() ? new Fi(OS.prop("java.home")).child("bin/java").absolutePath() : (Core.files.local("jre/bin/java").exists() ? Core.files.local("jre/bin/java").absolutePath() : (Core.files.local("jre/bin/java.exe").exists() ? Core.files.local("jre/bin/java.exe").absolutePath() : "java"));
        state = new GameState();
        mobile = Core.app.isMobile() || testMobile;
        ios = Core.app.isIOS();
        android = Core.app.isAndroid();
        modDirectory.mkdirs();
        Events.on(EventType.ContentInitEvent.class, e -> {
            emptyTile = new Tile(32747, 32747);
        });
        mods.load();
        maps.load();
    }

    public static void checkLaunch() {
        Core.settings.setAppName(appName);
        launchIDFile = Core.settings.getDataDirectory().child("launchid.dat");
        if (launchIDFile.exists()) {
            failedToLaunch = true;
        } else {
            failedToLaunch = false;
            launchIDFile.writeString("go away");
        }
    }

    public static void finishLaunch() {
        Core.settings.put("lastBuild", Version.build);
        Core.settings.put("lastBuildString", Version.buildString());
        if (launchIDFile != null) {
            launchIDFile.delete();
        }
    }

    public static void loadLogger() {
        if (loadedLogger) {
            return;
        }
        String[] tags = new String[]{"[green][D][]", "[royal][I][]", "[yellow][W][]", "[scarlet][E][]", ""};
        String[] stags = new String[]{"&lc&fb[D]", "&lb&fb[I]", "&ly&fb[W]", "&lr&fb[E]", ""};
        Seq logBuffer = new Seq();
        Log.logger = (level, text) -> {
            Seq seq = logBuffer;
            synchronized (seq) {
                String result = text;
                String rawText = Log.format(stags[level.ordinal()] + "&fr " + text, new Object[0]);
                System.out.println(rawText);
                result = tags[level.ordinal()] + " " + result;
                if (!(headless || ui != null && Vars.ui.consolefrag != null)) {
                    logBuffer.add(result);
                } else if (!headless) {
                    if (!OS.isWindows) {
                        for (String code : ColorCodes.values) {
                            result = result.replace(code, "");
                        }
                    }
                    Vars.ui.consolefrag.addMessage(Log.removeColors(result));
                }
            }
        };
        Events.on(EventType.ClientLoadEvent.class, e -> logBuffer.each(Vars.ui.consolefrag::addMessage));
        loadedLogger = true;
    }

    public static void loadFileLogger() {
        if (loadedFileLogger) {
            return;
        }
        Core.settings.setAppName(appName);
        try {
            Writer writer = Core.settings.getDataDirectory().child("last_log.txt").writer(false);
            Log.LogHandler log = Log.logger;
            Log.logger = (level, text) -> {
                log.log(level, text);
                try {
                    writer.write("[" + Character.toUpperCase(level.name().charAt(0)) + "] " + Log.removeColors(text) + "\n");
                    writer.flush();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            };
        }
        catch (Exception e) {
            Log.err(e);
        }
        loadedFileLogger = true;
    }

    public static void loadSettings() {
        block11: {
            Core.settings.setJson(JsonIO.json);
            Core.settings.setAppName(appName);
            if (steam || Version.modifier != null && Version.modifier.contains("steam")) {
                Core.settings.setDataDirectory(Core.files.local("saves/"));
            }
            android = Core.app.isAndroid();
            Core.settings.defaults("locale", "default", "blocksync", true);
            Core.settings.setAutosave(false);
            Core.settings.load();
            for (KeyBind bind : KeyBind.all) {
                bind.load();
            }
            Binding.init();
            if (Core.settings.getInt("uiscale") == 5) {
                Core.settings.put("uiscale", 100);
            }
            Scl.setProduct((float)Math.max(Core.settings.getInt("uiscale", 100), 25) / 100.0f);
            if (!loadLocales) {
                return;
            }
            try {
                Fi handle = Core.files.local("bundle");
                Locale locale = Locale.ENGLISH;
                Core.bundle = I18NBundle.createBundle(handle, locale);
                Log.info("NOTE: external translation bundle has been loaded.");
                if (headless) break block11;
                Time.run(10.0f, () -> ui.showInfo("Note: You have successfully loaded an external translation bundle.\n[accent]" + handle.absolutePath()));
            }
            catch (Throwable e) {
                Locale locale;
                Fi handle = Core.files.internal("bundles/bundle");
                String loc = Core.settings.getString("locale");
                if (loc.equals("default")) {
                    locale = Locale.getDefault();
                } else {
                    Locale lastLocale;
                    if (loc.contains("_")) {
                        String[] split = loc.split("_");
                        lastLocale = new Locale(split[0], split[1]);
                    } else {
                        lastLocale = new Locale(loc);
                    }
                    locale = lastLocale;
                }
                Locale.setDefault(locale);
                Core.bundle = I18NBundle.createBundle(handle, locale);
                if (!locale.toString().equals("router")) break block11;
                I18NBundle defBundle = I18NBundle.createBundle(Core.files.internal("bundles/bundle"));
                String router = Character.toString('\uf88e');
                for (String s : Core.bundle.getKeys()) {
                    Core.bundle.getProperties().put(s, Strings.stripColors(defBundle.get(s)).replaceAll("\\S", router));
                }
            }
        }
    }

    static {
        clearSectors = false;
        enableLight = true;
        enableDarkness = true;
        drawDebugHitboxes = false;
        debugDrawAvoidance = false;
        loadedServerCache = false;
        fetchedServers = false;
        mainExecutor = Threads.executor("Main Executor", OS.cores);
        tree = new FileTree();
        platform = new Platform(){};
        service = new GameService();
    }
}

