/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ai.types;

import arc.math.Mathf;
import arc.struct.Queue;
import arc.struct.Seq;
import arc.util.Nullable;
import arc.util.Structs;
import mindustry.Vars;
import mindustry.entities.units.AIController;
import mindustry.entities.units.BuildPlan;
import mindustry.game.Teams;
import mindustry.gen.Call;
import mindustry.type.Category;
import mindustry.type.Item;
import mindustry.type.ItemStack;
import mindustry.world.Block;
import mindustry.world.Build;
import mindustry.world.Tile;
import mindustry.world.blocks.ConstructBlock;
import mindustry.world.blocks.storage.CoreBlock;

public class PrebuildAI
extends AIController {
    static float[] priorities = new float[Category.all.length];
    static Seq<Teams.BlockPlan> tmpCopy = new Seq();
    @Nullable
    Teams.BlockPlan lastPlan;
    @Nullable
    Block collectBlock;
    boolean collectingItems;
    boolean mining;
    @Nullable
    Item lastTargetItem;
    @Nullable
    Tile ore;

    public static void sortPlans(Queue<Teams.BlockPlan> plans) {
        Seq<Teams.BlockPlan> copy = Seq.with(plans);
        copy.sort(Structs.comps(Structs.comparingFloat(plan -> priorities[plan.block.category.ordinal()]), Structs.comparingFloat(plan -> plan.block.buildTime)));
        plans.clear();
        for (Teams.BlockPlan plan2 : copy) {
            plans.addFirst(plan2);
        }
    }

    private boolean canBuild(CoreBlock.CoreBuild core, Block block) {
        return Vars.state.rules.infiniteResources || this.unit.team.rules().infiniteResources || core.items.has(block.requirements, Vars.state.rules.buildCostMultiplier);
    }

    @Nullable
    private Teams.BlockPlan findNextPlan() {
        Teams.TeamData data = this.unit.team.data();
        CoreBlock.CoreBuild core = this.unit.core();
        if (data.buildingTree == null || core == null) {
            return null;
        }
        Queue<Teams.BlockPlan> plans = data.plans;
        tmpCopy.clear();
        tmpCopy.addAll((Iterable<Teams.BlockPlan>)plans);
        Teams.BlockPlan min = tmpCopy.min(plan -> !(!this.canBuild(core, plan.block) && Structs.contains(plan.block.requirements, it -> !Vars.indexer.hasOre(it.item)) || plan.block.category != Category.production && !data.buildingTree.any((float)(plan.x * 8) + plan.block.offset - ((float)(plan.block.size * 8) + 1.0f) / 2.0f, (float)(plan.y * 8) + plan.block.offset - ((float)(plan.block.size * 8) + 1.0f) / 2.0f, (float)(plan.block.size * 8) + 1.0f, (float)(plan.block.size * 8) + 1.0f)), plan -> this.unit.dst(plan.x * 8, plan.y * 8) - priorities[plan.block.category.ordinal()] * 200.0f);
        if (min != null) {
            return min;
        }
        return plans.first();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void updateMovement() {
        block11: {
            block12: {
                block13: {
                    block10: {
                        if (this.target != null && this.shouldShoot()) {
                            this.unit.lookAt(this.target);
                        } else if (!this.unit.type.flying) {
                            this.unit.lookAt(this.unit.prefRotation());
                        }
                        this.unit.updateBuilding = this.collectingItems == false;
                        moving = false;
                        if (!this.collectingItems) break block10;
                        this.doMining();
                        break block11;
                    }
                    if (this.unit.buildPlan() == null) break block12;
                    req = this.unit.buildPlan();
                    if (this.lastPlan != null && this.lastPlan.removed) ** GOTO lbl-1000
                    if (req.tile() == null || !((var5_4 = req.tile().build) instanceof ConstructBlock.ConstructBuild)) break block13;
                    cons = (ConstructBlock.ConstructBuild)var5_4;
                    if (cons.current == req.block) ** GOTO lbl-1000
                }
                if (req.breaking != false ? Build.validBreak(this.unit.team(), req.x, req.y) != false : Build.validPlace(req.block, this.unit.team(), req.x, req.y, req.rotation) != false) lbl-1000:
                // 2 sources

                {
                    v0 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v0 = valid = false;
                }
                if (valid) {
                    range = Math.min(this.unit.type.buildRange - 20.0f, 100.0f);
                    this.moveTo(req.tile(), range - 10.0f, 20.0f);
                    moving = this.unit.within(req.tile(), range) == false;
                } else {
                    this.unit.plans.removeFirst();
                    this.lastPlan = null;
                }
                break block11;
            }
            if (!this.unit.team.data().plans.isEmpty() && this.timer.get(2, 2.0f) && (plan = this.findNextPlan()) != null && Build.validPlace(plan.block, this.unit.team(), plan.x, plan.y, plan.rotation)) {
                if (!this.canBuild(this.unit.core(), plan.block)) {
                    this.collectingItems = true;
                    this.collectBlock = plan.block;
                    this.lastTargetItem = null;
                    this.ore = null;
                    this.timer.reset(0, 0.0f);
                }
                this.lastPlan = plan;
                this.unit.addBuild(new BuildPlan(plan.x, plan.y, plan.rotation, plan.block, plan.config));
            }
        }
        if (!this.unit.type.flying) {
            this.unit.updateBoosting(this.unit.type.boostWhenBuilding != false || moving != false || this.unit.floorOn().isDuct != false || this.unit.floorOn().damageTaken > 0.0f || this.unit.floorOn().isDeep() != false);
        }
    }

    void doMining() {
        CoreBlock.CoreBuild core = this.unit.closestCore();
        if (!this.unit.canMine() || core == null || this.collectBlock == null) {
            return;
        }
        if (!this.unit.validMine(this.unit.mineTile)) {
            this.unit.mineTile(null);
        }
        if (this.mining) {
            Item targetItem;
            ItemStack targetStack = Structs.find(this.collectBlock.requirements, i -> !core.items.has(i.item, Mathf.ceil(Vars.state.rules.buildCostMultiplier * (float)i.amount)));
            Item item = targetItem = targetStack == null ? null : targetStack.item;
            if (targetItem != null) {
                this.lastTargetItem = targetItem;
            } else {
                targetItem = this.lastTargetItem;
                if (!this.unit.hasItem() && this.canBuild(core, this.collectBlock)) {
                    this.collectingItems = false;
                    return;
                }
            }
            if (targetItem != null && core.acceptStack(targetItem, 1, this.unit) == 0) {
                this.unit.clearItem();
                this.unit.mineTile = null;
                return;
            }
            if (targetItem == null || this.unit.stack.amount >= this.unit.type.itemCapacity || targetItem != null && !this.unit.acceptsItem(targetItem)) {
                this.mining = false;
            } else {
                if (this.timer.get(2, 60.0f) && targetItem != null) {
                    this.ore = null;
                    if (this.unit.type.mineFloor) {
                        this.ore = Vars.indexer.findClosestOre(this.unit, targetItem);
                    }
                    if (this.ore == null && this.unit.type.mineWalls) {
                        this.ore = Vars.indexer.findClosestWallOre(this.unit, targetItem);
                    }
                }
                if (this.ore != null) {
                    this.moveTo(this.ore, this.unit.type.mineRange / 2.0f, 20.0f);
                    if (this.unit.within(this.ore, this.unit.type.mineRange) && this.unit.validMine(this.ore)) {
                        this.unit.mineTile = this.ore;
                    }
                }
            }
        } else {
            this.unit.mineTile = null;
            if (this.unit.stack.amount == 0) {
                this.mining = true;
                if (this.canBuild(core, this.collectBlock)) {
                    this.collectingItems = false;
                }
                return;
            }
            if (this.unit.within(core, this.unit.type.range)) {
                if (core.acceptStack(this.unit.stack.item, this.unit.stack.amount, this.unit) > 0) {
                    Call.transferItemTo(this.unit, this.unit.stack.item, this.unit.stack.amount, this.unit.x, this.unit.y, core);
                }
                this.unit.clearItem();
                this.mining = true;
                if (this.canBuild(core, this.collectBlock)) {
                    this.collectingItems = false;
                }
            }
            this.circle(core, this.unit.type.range / 1.8f);
        }
    }

    static {
        PrebuildAI.priorities[Category.production.ordinal()] = 11.0f;
        PrebuildAI.priorities[Category.distribution.ordinal()] = 10.0f;
        PrebuildAI.priorities[Category.liquid.ordinal()] = 9.0f;
        PrebuildAI.priorities[Category.crafting.ordinal()] = 8.0f;
    }
}

