/*
 * Decompiled with CFR 0.152.
 */
package mindustry.desktop.steam;

import arc.Core;
import arc.files.Fi;
import arc.func.Cons;
import arc.func.Cons2;
import arc.func.Prov;
import arc.scene.ui.TextArea;
import arc.struct.ObjectMap;
import arc.struct.Seq;
import arc.util.Log;
import arc.util.Strings;
import com.codedisaster.steamworks.SteamPublishedFileID;
import com.codedisaster.steamworks.SteamRemoteStorage;
import com.codedisaster.steamworks.SteamResult;
import com.codedisaster.steamworks.SteamUGC;
import com.codedisaster.steamworks.SteamUGCCallback;
import com.codedisaster.steamworks.SteamUGCDetails;
import com.codedisaster.steamworks.SteamUGCQuery;
import com.codedisaster.steamworks.SteamUGCUpdateHandle;
import mindustry.Vars;
import mindustry.desktop.steam.SVars;
import mindustry.game.Schematic;
import mindustry.gen.Icon;
import mindustry.maps.Map;
import mindustry.mod.Mods;
import mindustry.service.Achievement;
import mindustry.type.Publishable;
import mindustry.ui.dialogs.BaseDialog;

public class SWorkshop
implements SteamUGCCallback {
    public final SteamUGC ugc = new SteamUGC(this);
    private ObjectMap<Class<? extends Publishable>, Seq<Fi>> workshopFiles = new ObjectMap();
    private ObjectMap<SteamUGCQuery, Cons2<Seq<SteamUGCDetails>, SteamResult>> detailHandlers = new ObjectMap();
    private Seq<Cons<SteamPublishedFileID>> itemHandlers = new Seq();
    private ObjectMap<SteamPublishedFileID, Runnable> updatedHandlers = new ObjectMap();

    public SWorkshop() {
        int items = this.ugc.getNumSubscribedItems();
        SteamPublishedFileID[] ids = new SteamPublishedFileID[items];
        SteamUGC.ItemInstallInfo info = new SteamUGC.ItemInstallInfo();
        this.ugc.getSubscribedItems(ids);
        Seq<Fi> folders = Seq.with(ids).map(f -> !this.ugc.getItemInstallInfo((SteamPublishedFileID)f, info) || info.getFolder() == null ? null : new Fi(info.getFolder())).select(f -> f != null && f.list().length > 0);
        this.workshopFiles.put(Map.class, folders.select(f -> f.list().length == 1 && f.list()[0].extension().equals("msav")).map(f -> f.list()[0]));
        this.workshopFiles.put(Schematic.class, folders.select(f -> f.list().length == 1 && f.list()[0].extension().equals("msch")).map(f -> f.list()[0]));
        this.workshopFiles.put(Mods.LoadedMod.class, folders.select(f -> f.child("mod.json").exists() || f.child("mod.hjson").exists()));
        if (!this.workshopFiles.get(Map.class).isEmpty()) {
            Achievement.downloadMapWorkshop.complete();
        }
        this.workshopFiles.each((type, list) -> Log.info("Fetched content (@): @", type.getSimpleName(), list.size));
    }

    public Seq<Fi> getWorkshopFiles(Class<? extends Publishable> type) {
        return (Seq)((Object)this.workshopFiles.get(type, (Seq<Fi>)((Object)((Prov<Seq>)() -> new Seq(0)))));
    }

    public void publish(Publishable p) {
        Log.info("publish(): " + p.steamTitle());
        if (p.hasSteamID()) {
            Log.info("Content already published, redirecting to ID.");
            this.viewListing(p);
            return;
        }
        if (!p.prePublish()) {
            Log.info("Rejecting due to pre-publish.");
            return;
        }
        this.showPublish(id -> this.update(p, (SteamPublishedFileID)id, null, true));
    }

    public void viewListing(final Publishable p) {
        long handle = Strings.parseLong(p.getSteamID(), -1L);
        SteamPublishedFileID id = new SteamPublishedFileID(handle);
        Log.info("Handle = " + handle);
        Vars.ui.loadfrag.show();
        this.query(this.ugc.createQueryUGCDetailsRequest(id), (detailsList, result) -> {
            Vars.ui.loadfrag.hide();
            Log.info("Fetch result = " + (Object)result);
            if (result == SteamResult.OK) {
                SteamUGCDetails details = (SteamUGCDetails)detailsList.first();
                Log.info("Details result = " + (Object)((Object)details.getResult()));
                if (details.getResult() == SteamResult.OK) {
                    if (details.getOwnerID().equals(SVars.user.user.getSteamID())) {
                        final BaseDialog dialog = new BaseDialog("@workshop.info");
                        dialog.setFillParent(false);
                        dialog.cont.add("@workshop.menu").pad(20.0f);
                        dialog.addCloseButton();
                        dialog.buttons.button("@view.workshop", Icon.link, () -> {
                            this.viewListingID(id);
                            dialog.hide();
                        }).size(210.0f, 64.0f);
                        dialog.buttons.button("@workshop.update", Icon.up, () -> new BaseDialog("@workshop.update"){
                            {
                                super(arg0);
                                this.setFillParent(false);
                                this.cont.margin(10.0f).add("@changelog").padRight(6.0f);
                                this.cont.row();
                                TextArea field = this.cont.area("", t -> {}).size(500.0f, 160.0f).get();
                                field.setMaxLength(400);
                                this.cont.row();
                                boolean[] updatedesc = new boolean[]{false};
                                this.cont.check("@updatedesc", b -> {
                                    updatedesc[0] = b;
                                }).pad(4.0f);
                                this.buttons.defaults().size(120.0f, 54.0f).pad(4.0f);
                                this.buttons.button("@ok", () -> {
                                    if (!p.prePublish()) {
                                        Log.info("Rejecting due to pre-publish.");
                                        return;
                                    }
                                    Vars.ui.loadfrag.show("@publishing");
                                    SWorkshop.this.update(p, new SteamPublishedFileID(Strings.parseLong(p.getSteamID(), -1L)), field.getText().replace("\r", "\n"), updatedesc[0]);
                                    dialog.hide();
                                    this.hide();
                                });
                                this.buttons.button("@cancel", this::hide);
                            }
                        }.show()).size(210.0f, 64.0f);
                        dialog.show();
                    } else {
                        SVars.net.friends.activateGameOverlayToWebPage("steam://url/CommunityFilePage/" + details.getPublishedFileID().handle());
                    }
                } else if (details.getResult() == SteamResult.FileNotFound) {
                    p.removeSteamID();
                    Vars.ui.showErrorMessage("@missing");
                } else {
                    Vars.ui.showErrorMessage(Core.bundle.format("workshop.error", details.getResult().name()));
                }
            } else {
                Vars.ui.showErrorMessage(Core.bundle.format("workshop.error", result.name()));
            }
        });
    }

    void viewListingID(SteamPublishedFileID id) {
        SVars.net.friends.activateGameOverlayToWebPage("steam://url/CommunityFilePage/" + id.handle());
    }

    void update(Publishable p, SteamPublishedFileID id, String changelog, boolean updateDescription) {
        Log.info("Calling update(@) @", p.steamTitle(), id.handle());
        String sid = id.handle() + "";
        this.updateItem(id, h -> {
            if (updateDescription) {
                this.ugc.setItemTitle((SteamUGCUpdateHandle)h, p.steamTitle());
                if (p.steamDescription() != null) {
                    this.ugc.setItemDescription((SteamUGCUpdateHandle)h, p.steamDescription());
                }
            }
            Seq<String> tags = p.extraTags();
            tags.add(p.steamTag());
            this.ugc.setItemTags((SteamUGCUpdateHandle)h, (String[])tags.toArray(String.class));
            String path = p.createSteamPreview(sid).absolutePath();
            Log.info("PREVIEW @ @ @", this.ugc.setItemPreview((SteamUGCUpdateHandle)h, path), path, Fi.get(path).exists());
            this.ugc.setItemContent((SteamUGCUpdateHandle)h, p.createSteamFolder(sid).absolutePath());
            if (changelog == null) {
                this.ugc.setItemVisibility((SteamUGCUpdateHandle)h, SteamRemoteStorage.PublishedFileVisibility.Private);
            }
            this.ugc.submitItemUpdate((SteamUGCUpdateHandle)h, changelog == null ? "<Created>" : changelog);
            if (p instanceof Map) {
                Achievement.publishMap.complete();
            }
        }, () -> p.addSteamID(sid));
    }

    void showPublish(Cons<SteamPublishedFileID> published) {
        BaseDialog dialog = new BaseDialog("@confirm");
        dialog.setFillParent(false);
        dialog.cont.add("@publish.confirm").width(600.0f).wrap();
        dialog.addCloseButton();
        dialog.buttons.button("@eula", Icon.link, () -> SVars.net.friends.activateGameOverlayToWebPage("https://steamcommunity.com/sharedfiles/workshoplegalagreement")).size(210.0f, 64.0f);
        dialog.buttons.button("@ok", Icon.ok, () -> {
            Log.info("Accepted, publishing item...");
            this.itemHandlers.add(published);
            this.ugc.createItem(1127400, SteamRemoteStorage.WorkshopFileType.Community);
            Vars.ui.loadfrag.show("@publishing");
            dialog.hide();
        }).size(170.0f, 64.0f);
        dialog.show();
    }

    void query(SteamUGCQuery query, Cons2<Seq<SteamUGCDetails>, SteamResult> handler) {
        Log.info("POST QUERY " + query);
        this.detailHandlers.put(query, handler);
        this.ugc.sendQueryUGCRequest(query);
    }

    void updateItem(SteamPublishedFileID publishedFileID, Cons<SteamUGCUpdateHandle> tagger, Runnable updated) {
        try {
            SteamUGCUpdateHandle h = this.ugc.startItemUpdate(1127400, publishedFileID);
            Log.info("begin updateItem(@)", publishedFileID.handle());
            tagger.get(h);
            Log.info("Tagged.");
            SteamUGC.ItemUpdateInfo info = new SteamUGC.ItemUpdateInfo();
            Vars.ui.loadfrag.setProgress(() -> {
                SteamUGC.ItemUpdateStatus status = this.ugc.getItemUpdateProgress(h, info);
                Vars.ui.loadfrag.setText("@" + status.name().toLowerCase());
                if (status == SteamUGC.ItemUpdateStatus.Invalid) {
                    Vars.ui.loadfrag.setText("@done");
                    return 1.0f;
                }
                return (float)status.ordinal() / (float)SteamUGC.ItemUpdateStatus.values().length;
            });
            this.updatedHandlers.put(publishedFileID, updated);
        }
        catch (Throwable t) {
            Vars.ui.loadfrag.hide();
            Log.err(t);
        }
    }

    @Override
    public void onUGCQueryCompleted(SteamUGCQuery query, int numResultsReturned, int totalMatchingResults, boolean isCachedData, SteamResult result) {
        Log.info("GET QUERY " + query);
        if (this.detailHandlers.containsKey(query)) {
            Log.info("Query being handled...");
            if (numResultsReturned > 0) {
                Log.info("@ q results", numResultsReturned);
                Seq<SteamUGCDetails> details = new Seq<SteamUGCDetails>();
                for (int i = 0; i < numResultsReturned; ++i) {
                    details.add(new SteamUGCDetails());
                    this.ugc.getQueryUGCResult(query, i, (SteamUGCDetails)details.get(i));
                }
                this.detailHandlers.get(query).get(details, result);
            } else {
                Log.info("Nothing found.");
                this.detailHandlers.get(query).get(new Seq(), SteamResult.FileNotFound);
            }
            this.detailHandlers.remove(query);
        } else {
            Log.info("Query not handled.");
        }
    }

    @Override
    public void onSubscribeItem(SteamPublishedFileID publishedFileID, SteamResult result) {
        SteamUGC.ItemInstallInfo info = new SteamUGC.ItemInstallInfo();
        this.ugc.getItemInstallInfo(publishedFileID, info);
        Log.info("Item subscribed from @", info.getFolder());
        Achievement.downloadMapWorkshop.complete();
    }

    @Override
    public void onUnsubscribeItem(SteamPublishedFileID publishedFileID, SteamResult result) {
        SteamUGC.ItemInstallInfo info = new SteamUGC.ItemInstallInfo();
        this.ugc.getItemInstallInfo(publishedFileID, info);
        Log.info("Item unsubscribed from @", info.getFolder());
    }

    @Override
    public void onCreateItem(SteamPublishedFileID publishedFileID, boolean needsToAcceptWLA, SteamResult result) {
        Log.info("onCreateItem(" + (Object)((Object)result) + ")");
        if (!this.itemHandlers.isEmpty()) {
            if (result == SteamResult.OK) {
                Log.info("Passing to first handler.");
                this.itemHandlers.first().get(publishedFileID);
            } else {
                Vars.ui.showErrorMessage(Core.bundle.format("publish.error", result.name()));
            }
            this.itemHandlers.remove(0);
        } else {
            Log.err("No handlers for createItem()", new Object[0]);
        }
    }

    @Override
    public void onSubmitItemUpdate(SteamPublishedFileID publishedFileID, boolean needsToAcceptWLA, SteamResult result) {
        Vars.ui.loadfrag.hide();
        Log.info("onsubmititemupdate @ @ @", new Object[]{publishedFileID.handle(), needsToAcceptWLA, result});
        if (result == SteamResult.OK) {
            SVars.net.friends.activateGameOverlayToWebPage("steam://url/CommunityFilePage/" + publishedFileID.handle());
            if (needsToAcceptWLA) {
                SVars.net.friends.activateGameOverlayToWebPage("https://steamcommunity.com/sharedfiles/workshoplegalagreement");
            }
            if (this.updatedHandlers.containsKey(publishedFileID)) {
                this.updatedHandlers.get(publishedFileID).run();
            }
        } else {
            Vars.ui.showErrorMessage(Core.bundle.format("publish.error", result.name()));
        }
    }

    @Override
    public void onDownloadItemResult(int appID, SteamPublishedFileID publishedFileID, SteamResult result) {
        Achievement.downloadMapWorkshop.complete();
        SteamUGC.ItemInstallInfo info = new SteamUGC.ItemInstallInfo();
        this.ugc.getItemInstallInfo(publishedFileID, info);
        Log.info("Item downloaded to @", info.getFolder());
    }

    @Override
    public void onDeleteItem(SteamPublishedFileID publishedFileID, SteamResult result) {
        SteamUGC.ItemInstallInfo info = new SteamUGC.ItemInstallInfo();
        this.ugc.getItemInstallInfo(publishedFileID, info);
        Log.info("Item removed from @", info.getFolder());
    }
}

