/*
 * Decompiled with CFR 0.152.
 */
package mindustry.editor;

import arc.Core;
import arc.func.Cons;
import arc.graphics.Color;
import arc.graphics.g2d.TextureAtlas;
import arc.scene.Element;
import arc.scene.style.Drawable;
import arc.scene.style.TextureRegionDrawable;
import arc.scene.ui.Dialog;
import arc.scene.ui.Image;
import arc.scene.ui.TextButton;
import arc.scene.ui.TextField;
import arc.scene.ui.layout.Scl;
import arc.scene.ui.layout.Table;
import arc.scene.utils.Elem;
import arc.struct.ObjectIntMap;
import arc.struct.ObjectMap;
import arc.struct.Seq;
import arc.struct.StringMap;
import java.util.Locale;
import mindustry.Vars;
import mindustry.ctype.ContentType;
import mindustry.ctype.UnlockableContent;
import mindustry.game.Team;
import mindustry.gen.Icon;
import mindustry.gen.Iconc;
import mindustry.gen.Tex;
import mindustry.graphics.Pal;
import mindustry.io.JsonIO;
import mindustry.type.MapLocales;
import mindustry.ui.Fonts;
import mindustry.ui.Styles;
import mindustry.ui.dialogs.BaseDialog;

public class MapLocalesDialog
extends BaseDialog {
    private static final float cardWidth = 400.0f;
    private static final TextButton.TextButtonStyle filterStyle = new TextButton.TextButtonStyle(){
        {
            this.checked = this.over = Tex.whitePane;
            this.down = this.over;
            this.up = this.over;
            this.font = Fonts.outline;
            this.fontColor = Color.lightGray;
            this.overFontColor = Pal.accent;
            this.disabledFontColor = Color.gray;
            this.disabled = Styles.black;
        }
    };
    private static final ContentType[] contentIcons = new ContentType[]{ContentType.item, ContentType.block, ContentType.liquid, ContentType.status, ContentType.unit};
    private MapLocales locales;
    private MapLocales lastSaved;
    private boolean saved = true;
    private Table langs;
    private Table main;
    private Table propView;
    private String selectedLocale = MapLocales.currentLocale();
    private boolean applytoall = true;
    private boolean collapsed = false;
    private String searchString = "";
    private boolean searchByValue = false;
    private boolean showCorrect = true;
    private boolean showMissing = true;
    private boolean showSame = true;

    public MapLocalesDialog() {
        super("@editor.locales");
        this.langs = new Table(Tex.button);
        this.main = new Table();
        this.propView = new Table();
        this.buttons.add("").uniform();
        this.buttons.table((Table t) -> {
            t.defaults().pad(3.0f).center();
            t.button("@back", Icon.left, () -> {
                if (!this.saved) {
                    Vars.ui.showConfirm("@editor.locales", "@editor.savechanges", () -> {
                        Vars.editor.tags.put("locales", JsonIO.write(this.locales));
                        Vars.state.mapLocales = this.locales;
                    });
                }
                this.hide();
            }).size(210.0f, 64.0f);
            this.closeOnBack(() -> {
                if (!this.saved) {
                    Vars.ui.showConfirm("@editor.locales", "@editor.savechanges", () -> {
                        Vars.editor.tags.put("locales", JsonIO.write(this.locales));
                        Vars.state.mapLocales = this.locales;
                    });
                }
            });
            t.button("@editor.apply", Icon.ok, () -> {
                Vars.editor.tags.put("locales", JsonIO.write(this.locales));
                Vars.state.mapLocales = this.locales;
                this.lastSaved = this.locales.copy();
                this.saved = true;
            }).size(210.0f, 64.0f).disabled(b -> this.saved);
            t.button("@edit", Icon.edit, this::editDialog).size(210.0f, 64.0f);
        }).growX();
        this.resized(this::buildMain);
        this.buttons.button("?", () -> Vars.ui.showInfo("@locales.info")).size(60.0f, 64.0f).uniform();
        this.shown(this::setup);
    }

    public void show(MapLocales locales) {
        this.locales = locales;
        this.lastSaved = locales.copy();
        this.saved = true;
        this.show();
    }

    private void setup() {
        this.cont.clear();
        this.buildTables();
        this.cont.add(this.langs).left();
        this.cont.table((Table t) -> {
            t.table((Table a) -> {
                a.button((Drawable)Icon.downOpen, Styles.emptyTogglei, () -> {
                    this.collapsed = !this.collapsed;
                    this.buildMain();
                }).update((T b) -> {
                    b.replaceImage(new Image(this.collapsed ? Icon.upOpen : Icon.downOpen));
                    b.setChecked(this.collapsed);
                }).size(35.0f);
                a.button((Drawable)Icon.filter, Styles.emptyi, () -> this.filterDialog(this::buildMain)).padLeft(10.0f).size(35.0f);
                TextField field = a.field("", v -> {
                    this.searchString = v;
                    this.buildMain();
                }).update((T f) -> f.setText(this.searchString)).maxTextLength(64).padLeft(10.0f).width(250.0f).update((T f) -> f.setMessageText(this.searchByValue ? "@locales.searchvalue" : "@locales.searchname")).get();
                a.button((Drawable)Icon.cancel, Styles.emptyi, () -> {
                    this.searchString = "";
                    field.setText("");
                    this.buildMain();
                }).padLeft(10.0f).size(35.0f);
            }).row();
            t.check("@locales.applytoall", this.applytoall, b -> {
                this.applytoall = b;
            }).pad(10.0f).row();
            t.add(this.main).center().grow().row();
        }).pad(10.0f).grow();
        this.cont.table(Tex.button, t -> {
            TextField name = t.field("name", s -> {}).maxTextLength(64).fillX().padTop(10.0f).get();
            t.row();
            TextField value = t.area("text", s -> {}).maxTextLength(1000).fillX().height(140.0f).get();
            t.row();
            t.button("@add", Icon.add, () -> {
                if (this.applytoall) {
                    for (StringMap locale : this.locales.values()) {
                        locale.put(name.getText(), value.getText());
                    }
                } else {
                    ((StringMap)this.locales.get(this.selectedLocale)).put(name.getText(), value.getText());
                }
                this.saved = false;
                this.buildMain();
            }).padTop(10.0f).size(400.0f, 50.0f).fillX().row();
        }).right();
    }

    private void buildTables() {
        if (!this.locales.containsKey(this.selectedLocale)) {
            this.locales.put(this.selectedLocale, new StringMap());
        }
        this.buildLocalesTable();
        this.buildMain();
    }

    private void buildLocalesTable() {
        this.langs.clear();
        this.langs.pane((Table p) -> {
            for (Locale loc : Vars.locales) {
                String name = loc.toString();
                if (!this.locales.containsKey(name)) continue;
                p.button(loc.getDisplayName(Core.bundle.getLocale()), Styles.flatTogglet, () -> {
                    if (name.equals(this.selectedLocale)) {
                        return;
                    }
                    this.selectedLocale = name;
                    this.buildTables();
                }).update((T b) -> b.setChecked(this.selectedLocale.equals(name))).width(200.0f).minHeight(50.0f);
                p.button((Drawable)Icon.edit, Styles.flati, () -> this.localeEditDialog(name)).size(50.0f);
                p.button((Drawable)Icon.trash, Styles.flati, () -> Vars.ui.showConfirm("@confirm", "@locales.deletelocale", () -> {
                    this.locales.remove(name);
                    this.selectedLocale = this.locales.size != 0 ? (String)this.locales.keys().next() : Core.settings.getString("locale");
                    this.saved = false;
                    this.buildTables();
                })).size(50.0f).row();
            }
        }).row();
        this.langs.button("@add", Icon.add, this::addLocaleDialog).padTop(10.0f).width(250.0f);
    }

    private void buildMain() {
        this.main.clear();
        StringMap props = (StringMap)this.locales.get(this.selectedLocale);
        this.main.image().color(Pal.gray).height(3.0f).growX().expandY().top().row();
        this.main.pane((Table p) -> {
            int i;
            int cols = Math.max(1, (int)(((float)Core.graphics.getWidth() / Scl.scl() - 410.0f) / 400.0f) - 1);
            if (props.size == 0) {
                this.main.add("@empty").center().row();
                return;
            }
            p.defaults().top();
            Element[] colTables = new Table[cols];
            for (i = 0; i < cols; ++i) {
                colTables[i] = new Table();
            }
            i = 0;
            Seq keys = props.keys().toSeq().sort();
            for (String key : keys) {
                PropertyStatus status;
                String comparsionString;
                String string = comparsionString = this.searchByValue ? ((String)props.get(key)).toLowerCase() : key.toLowerCase();
                if (!this.searchString.isEmpty() && !comparsionString.contains(this.searchString.toLowerCase()) || (status = this.getPropertyStatus(key, (String)props.get(key), this.selectedLocale, false)) == PropertyStatus.correct && !this.showCorrect || status == PropertyStatus.missing && !this.showMissing || status == PropertyStatus.same && !this.showSame) continue;
                ((Table)colTables[i]).table(Tex.whitePane, t -> {
                    boolean[] shown = new boolean[]{!this.collapsed};
                    String[] propKey = new String[]{key};
                    String[] propValue = new String[]{(String)props.get(key)};
                    t.button((Drawable)Icon.downOpen, Styles.emptyTogglei, () -> {
                        shown[0] = !shown[0];
                    }).update((T b) -> {
                        b.replaceImage(new Image(shown[0] ? Icon.upOpen : Icon.downOpen));
                        b.setChecked(shown[0]);
                    }).size(35.0f);
                    t.field(propKey[0], (TextField f, char c) -> c != '=' && c != ':', (String v) -> {
                        if (props.containsKey(v)) {
                            t.setColor(Color.valueOf("f25555"));
                            return;
                        }
                        if (this.applytoall) {
                            for (StringMap bundle : this.locales.values()) {
                                String value;
                                if (bundle.containsKey(v) || (value = (String)bundle.get(propKey[0])) == null) continue;
                                bundle.remove(propKey[0]);
                                bundle.put(v, value);
                            }
                        } else if (!props.containsKey(v)) {
                            props.remove(propKey[0]);
                            props.put(v, propValue[0]);
                        }
                        propKey[0] = v;
                        this.updateCard((Table)t, (String)v, propValue[0]);
                        this.saved = false;
                    }).maxTextLength(64).width(275.0f);
                    t.button((Drawable)Icon.trash, Styles.emptyi, () -> {
                        if (this.applytoall) {
                            for (StringMap bundle : this.locales.values()) {
                                bundle.remove(propKey[0]);
                            }
                        } else {
                            props.remove(propKey[0]);
                        }
                        this.saved = false;
                        this.buildMain();
                    }).size(35.0f);
                    t.button((Drawable)Icon.edit, Styles.emptyi, () -> this.propEditDialog((Table)t, propKey[0], propValue[0])).size(35.0f).row();
                    t.collapser((Table c) -> c.area(propValue[0], v -> {
                        props.put(propKey[0], v);
                        this.updateCard((Table)t, propKey[0], (String)v);
                        this.saved = false;
                    }).maxTextLength(1000).height(140.0f).update((T a) -> {
                        propValue[0] = (String)props.get(propKey[0]);
                        a.setText((String)props.get(propKey[0]));
                    }).growX(), () -> shown[0]).colspan(4).growX();
                    this.updateCard((Table)t, propKey[0], propValue[0]);
                }).top().width(400.0f).pad(5.0f).row();
                ++i;
                i %= cols;
            }
            if (!colTables[0].hasChildren()) {
                this.main.add("@empty").center().row();
            } else {
                p.add(colTables);
            }
        }).growX().row();
        this.main.image().color(Pal.gray).height(3.0f).growX().expandY().bottom().row();
    }

    private void updateCard(Table table, String propKey, String propValue) {
        this.updateCard(table, propKey, propValue, this.selectedLocale, false);
    }

    private void updateCard(Table table, String propKey, String propValue, String locale, boolean viewCard) {
        switch (this.getPropertyStatus(propKey, propValue, locale, viewCard)) {
            case missing: {
                table.setColor(Pal.accent);
                break;
            }
            case same: {
                table.setColor(Pal.techBlue);
                break;
            }
            case correct: {
                table.setColor(Pal.gray);
            }
        }
    }

    private PropertyStatus getPropertyStatus(String propKey, String propValue, String locale, boolean forView) {
        if (forView && propValue == null) {
            return PropertyStatus.missing;
        }
        for (ObjectMap.Entry entry : this.locales.entries()) {
            if (!forView && ((String)entry.key).equals(this.selectedLocale) || forView && ((String)entry.key).equals(locale)) continue;
            StringMap props = (StringMap)entry.value;
            if (!props.containsKey(propKey)) {
                if (forView) continue;
                return PropertyStatus.missing;
            }
            if (!((String)props.get(propKey)).equals(propValue)) continue;
            return PropertyStatus.same;
        }
        return PropertyStatus.correct;
    }

    private void addLocaleDialog() {
        BaseDialog dialog = new BaseDialog("@add");
        dialog.cont.pane((Table t) -> {
            for (Locale loc : Vars.locales) {
                String name = loc.toString();
                if (this.locales.containsKey(name)) continue;
                t.button(loc.getDisplayName(Core.bundle.getLocale()), Styles.flatTogglet, () -> {
                    if (name.equals(this.selectedLocale)) {
                        return;
                    }
                    this.locales.put(name, new StringMap());
                    this.selectedLocale = name;
                    this.saved = false;
                    this.buildTables();
                    dialog.hide();
                }).update((T b) -> b.setChecked(this.selectedLocale.equals(name))).size(400.0f, 50.0f).row();
            }
        });
        dialog.addCloseButton();
        dialog.show();
    }

    private void propEditDialog(Table card, String key, String value) {
        BaseDialog dialog = new BaseDialog("@edit");
        dialog.cont.pane((Table p) -> {
            p.margin(10.0f);
            p.table(Tex.button, t -> {
                t.defaults().size(450.0f, 60.0f).left();
                t.button("@locales.addtoother", (Drawable)Icon.add, Styles.flatt, () -> {
                    for (StringMap bundle : this.locales.values()) {
                        if (bundle.containsKey(key)) continue;
                        bundle.put(key, value);
                    }
                    this.saved = false;
                    this.updateCard(card, key, value);
                    dialog.hide();
                }).marginLeft(12.0f).row();
                t.button("@locales.viewproperty", (Drawable)Icon.zoom, Styles.flatt, () -> {
                    this.viewPropertyDialog(key);
                    dialog.hide();
                }).marginLeft(12.0f).row();
                t.button("@locales.addicon", (Drawable)Icon.image, Styles.flatt, () -> {
                    this.addIconDialog(res -> {
                        ((StringMap)this.locales.get(this.selectedLocale)).put(key, value + res);
                        this.saved = false;
                    });
                    dialog.hide();
                }).marginLeft(12.0f).row();
                t.button("@locales.rollback", (Drawable)Icon.undo, Styles.flatt, () -> {
                    ((StringMap)this.locales.get(this.selectedLocale)).put(key, (String)((StringMap)this.lastSaved.get(this.selectedLocale)).get(key));
                    this.buildTables();
                    dialog.hide();
                }).disabled(b -> {
                    if (!this.lastSaved.containsKey(this.selectedLocale)) {
                        return true;
                    }
                    StringMap savedMap = (StringMap)this.lastSaved.get(this.selectedLocale);
                    return !savedMap.containsKey(key) || ((String)savedMap.get(key)).equals(((StringMap)this.locales.get(this.selectedLocale)).get(key));
                }).marginLeft(12.0f).row();
            });
        });
        dialog.addCloseButton();
        dialog.show();
    }

    private void localeEditDialog(String locale) {
        BaseDialog dialog = new BaseDialog("@edit");
        dialog.cont.pane((Table p) -> {
            p.margin(10.0f);
            p.table(Tex.button, t -> {
                t.defaults().size(350.0f, 60.0f).left();
                t.button("@waves.copy", (Drawable)Icon.copy, Styles.flatt, () -> {
                    Core.app.setClipboardText(this.writeLocale(locale));
                    Vars.ui.showInfoFade("@copied");
                    dialog.hide();
                }).marginLeft(12.0f).row();
                t.button("@waves.load", (Drawable)Icon.download, Styles.flatt, () -> {
                    this.locales.put(locale, this.readLocale(Core.app.getClipboardText()));
                    this.buildTables();
                    this.saved = false;
                    dialog.hide();
                }).disabled(Core.app.getClipboardText() == null).marginLeft(12.0f).row();
            });
        });
        dialog.addCloseButton();
        dialog.show();
    }

    private void editDialog() {
        BaseDialog dialog = new BaseDialog("@edit");
        dialog.cont.pane((Table p) -> {
            p.margin(10.0f);
            p.table(Tex.button, t -> {
                t.defaults().size(450.0f, 60.0f).left();
                t.button("@waves.copy", (Drawable)Icon.copy, Styles.flatt, () -> {
                    Core.app.setClipboardText(this.writeBundles());
                    Vars.ui.showInfoFade("@copied");
                    dialog.hide();
                }).marginLeft(12.0f).row();
                t.button("@waves.load", (Drawable)Icon.download, Styles.flatt, () -> {
                    this.locales = this.readBundles(Core.app.getClipboardText());
                    this.buildTables();
                    this.saved = false;
                    dialog.hide();
                }).disabled(Core.app.getClipboardText() == null).marginLeft(12.0f).row();
                t.button("@locales.rollback", (Drawable)Icon.undo, Styles.flatt, () -> {
                    this.locales = this.lastSaved.copy();
                    this.saved = true;
                    this.buildTables();
                    dialog.hide();
                }).disabled(b -> this.saved).marginLeft(12.0f).row();
            });
        });
        dialog.addCloseButton();
        dialog.show();
    }

    private void viewPropertyDialog(String key) {
        BaseDialog dialog = new BaseDialog(Core.bundle.format("locales.viewing", key));
        dialog.cont.table((Table t) -> {
            t.button((Drawable)Icon.filter, Styles.emptyi, () -> this.filterDialog(() -> this.buildPropView(key))).size(35.0f);
            TextField field = t.field(this.searchString, v -> {
                this.searchString = v;
                this.buildPropView(key);
            }).update((T f) -> f.setText(this.searchString)).maxTextLength(64).padLeft(10.0f).width(250.0f).update((T f) -> f.setMessageText(this.searchByValue ? "@locales.searchvalue" : "@locales.searchlocale")).get();
            t.button((Drawable)Icon.cancel, Styles.emptyi, () -> {
                this.searchString = "";
                field.setText("");
                this.buildPropView(key);
            }).padLeft(10.0f).size(35.0f);
        }).row();
        this.buildPropView(key);
        dialog.cont.add(this.propView).grow().center().row();
        dialog.addCloseButton();
        dialog.closeOnBack();
        dialog.hidden(this::buildMain);
        dialog.show();
    }

    private void buildPropView(String key) {
        this.propView.clear();
        this.propView.image().color(Pal.gray).height(3.0f).fillX().top().row();
        this.propView.pane((Table p) -> {
            int i;
            int cols = Math.max(1, (int)(((float)Core.graphics.getWidth() / Scl.scl() - 100.0f) / 400.0f));
            if (cols == 0) {
                this.propView.add("@empty").center().row();
                return;
            }
            p.defaults().top();
            Element[] colTables = new Table[cols];
            for (i = 0; i < cols; ++i) {
                colTables[i] = new Table();
            }
            i = 0;
            for (Locale loc : Vars.locales) {
                PropertyStatus status;
                String name = loc.toString();
                if (!this.locales.containsKey(name) || (status = this.getPropertyStatus(key, (String)((StringMap)this.locales.get(name)).get(key), name, true)) == PropertyStatus.correct && !this.showCorrect || status == PropertyStatus.missing && !this.showMissing || status == PropertyStatus.same && !this.showSame) continue;
                if (status != PropertyStatus.missing) {
                    String comparsionString;
                    String string = comparsionString = this.searchByValue ? ((String)((StringMap)this.locales.get(name)).get(key)).toLowerCase() : loc.getDisplayName(Core.bundle.getLocale()).toLowerCase();
                    if (!this.searchString.isEmpty() && !comparsionString.contains(this.searchString.toLowerCase())) continue;
                }
                ((Table)colTables[i]).table(Tex.whitePane, t -> {
                    t.add(loc.getDisplayName(Core.bundle.getLocale())).left().color(Pal.accent).row();
                    t.image().color(Pal.accent).fillX().row();
                    if (status == PropertyStatus.missing) {
                        t.table((Table b) -> b.button("@add", Icon.add, () -> {
                            ((StringMap)this.locales.get(name)).put(key, "moai");
                            t.getCells().get(2).clearElement();
                            t.getCells().remove(2);
                            t.area((String)((StringMap)this.locales.get(name)).get(key), v -> {
                                ((StringMap)this.locales.get(name)).put(key, v);
                                this.saved = false;
                            }).maxTextLength(1000).height(140.0f).growX().row();
                        }).size(160.0f, 50.0f)).height(140.0f).growX().row();
                    } else {
                        t.area((String)((StringMap)this.locales.get(name)).get(key), v -> {
                            ((StringMap)this.locales.get(name)).put(key, v);
                            this.saved = false;
                        }).maxTextLength(1000).height(140.0f).growX().row();
                    }
                }).update((T t) -> this.updateCard((Table)t, key, (String)((StringMap)this.locales.get(name)).get(key), name, true)).top().width(400.0f).pad(5.0f).row();
                ++i;
                i %= cols;
            }
            if (!colTables[0].hasChildren()) {
                this.propView.add("@empty").center().row();
            } else {
                p.add(colTables);
            }
        }).grow().row();
        this.propView.image().color(Pal.gray).height(3.0f).fillX().bottom().row();
    }

    private void filterDialog(Runnable hidden) {
        BaseDialog dialog = new BaseDialog("@locales.filter");
        dialog.cont.table((Table t) -> {
            t.add("@search").row();
            t.table((Table b) -> {
                b.button("@locales.byname", Styles.togglet, () -> {
                    this.searchByValue = false;
                }).size(300.0f, 50.0f).checked(v -> !this.searchByValue);
                b.button("@locales.byvalue", Styles.togglet, () -> {
                    this.searchByValue = true;
                }).padLeft(10.0f).size(300.0f, 50.0f).checked(v -> this.searchByValue);
            }).padTop(5.0f);
        }).row();
        dialog.cont.button("@locales.showcorrect", (Drawable)Icon.ok, filterStyle, () -> {
            this.showCorrect = !this.showCorrect;
        }).update((T b) -> {
            ((Image)b.getChildren().get(1)).setDrawable(this.showCorrect ? Icon.ok : Icon.cancel);
            b.setChecked(this.showCorrect);
        }).size(450.0f, 100.0f).color(Pal.gray).padTop(65.0f);
        dialog.cont.row();
        dialog.cont.button("@locales.showmissing", (Drawable)Icon.ok, filterStyle, () -> {
            this.showMissing = !this.showMissing;
        }).update((T b) -> {
            ((Image)b.getChildren().get(1)).setDrawable(this.showMissing ? Icon.ok : Icon.cancel);
            b.setChecked(this.showMissing);
        }).size(450.0f, 100.0f).color(Pal.accent).padTop(65.0f);
        dialog.cont.row();
        dialog.cont.button("@locales.showsame", (Drawable)Icon.ok, filterStyle, () -> {
            this.showSame = !this.showSame;
        }).update((T b) -> {
            ((Image)b.getChildren().get(1)).setDrawable(this.showSame ? Icon.ok : Icon.cancel);
            b.setChecked(this.showSame);
        }).size(450.0f, 100.0f).color(Pal.techBlue).padTop(65.0f);
        dialog.buttons.button("@back", Icon.left, () -> {
            hidden.run();
            dialog.hide();
        }).size(210.0f, 64.0f);
        dialog.closeOnBack(hidden);
        dialog.show();
    }

    private void addIconDialog(Cons<String> cons) {
        BaseDialog dialog = new BaseDialog("@locales.addicon");
        Table icons = new Table();
        TextField search = Elem.newField("", v -> this.iconsTable(icons, v.replace(" ", "").toLowerCase(), dialog, cons));
        search.setMessageText("@search");
        dialog.cont.table((Table t) -> {
            t.add(search).maxTextLength(64).padLeft(10.0f).width(250.0f);
            t.button((Drawable)Icon.cancel, Styles.emptyi, () -> {
                search.setText("");
                this.iconsTable(icons, "", dialog, cons);
            }).padLeft(10.0f).size(35.0f);
        }).row();
        dialog.cont.pane(icons).scrollX(false);
        dialog.resized(true, () -> this.iconsTable(icons, search.getText().replace(" ", "").toLowerCase(), dialog, cons));
        dialog.addCloseButton();
        dialog.closeOnBack();
        dialog.setFillParent(true);
        dialog.show();
    }

    private void iconsTable(Table table, String search, Dialog dialog, Cons<String> cons) {
        table.clear();
        table.marginRight(19.0f).marginLeft(12.0f);
        table.defaults().size(48.0f);
        int cols = (int)Math.min(20.0f, (float)Core.graphics.getWidth() / Scl.scl(52.0f));
        int i = 0;
        ObjectIntMap<String> codes = new ObjectIntMap<String>(Iconc.codes);
        for (String string : codes.keys()) {
            if (string.toLowerCase().contains(search)) continue;
            codes.remove(string);
        }
        if (codes.size > 0) {
            table.image().colspan(cols).growX().width(-1.0f).height(3.0f).color(Pal.accent).row();
        }
        for (ObjectIntMap.Entry entry : codes) {
            String res = (char)entry.value + "";
            table.button(Icon.icons.get((String)entry.key), Styles.flati, 32.0f, () -> {
                cons.get(res);
                dialog.hide();
            }).tooltip((String)entry.key);
            if (++i % cols != 0) continue;
            table.row();
        }
        for (ContentType ctype : contentIcons) {
            Seq<UnlockableContent> all = Vars.content.getBy(ctype).as().select(u -> u.localizedName.replace(" ", "").toLowerCase().contains(search) && u.uiIcon.found());
            table.row();
            if (all.size > 0) {
                table.image().colspan(cols).growX().width(-1.0f).height(3.0f).color(Pal.accent).row();
            }
            i = 0;
            for (UnlockableContent u2 : all) {
                table.button(new TextureRegionDrawable(u2.uiIcon), Styles.flati, 32.0f, () -> {
                    cons.get(u2.emoji() + "");
                    dialog.hide();
                }).tooltip(u2.localizedName);
                if (++i % cols != 0) continue;
                table.row();
            }
        }
        Seq<Team> teams = new Seq<Team>(Team.baseTeams);
        teams = teams.select(u -> u.localized().toLowerCase().contains(search) && Core.atlas.has("team-" + u.name));
        table.row();
        if (teams.size > 0) {
            table.image().colspan(cols).growX().width(-1.0f).height(3.0f).color(Pal.accent).row();
        }
        for (Team team : teams) {
            TextureAtlas.AtlasRegion region = Core.atlas.find("team-" + team.name);
            table.button(new TextureRegionDrawable(region), Styles.flati, 32.0f, () -> {
                cons.get(team.emoji);
                dialog.hide();
            }).tooltip(team.localized());
            if (++i % cols != 0) continue;
            table.row();
        }
    }

    private String writeBundles() {
        StringBuilder data = new StringBuilder();
        for (String locale : this.locales.keys()) {
            data.append(locale).append(":\n").append(this.writeLocale(locale));
        }
        return data.toString();
    }

    private String writeLocale(String key) {
        StringBuilder data = new StringBuilder();
        if (!this.locales.containsKey(key)) {
            return "";
        }
        for (ObjectMap.Entry entry : ((StringMap)this.locales.get(key)).entries()) {
            data.append((String)entry.key).append(" = ").append(((String)entry.value).replace("\\n", "\\\\n").replace("\n", "\\n")).append("\n");
        }
        return data.toString();
    }

    private MapLocales readBundles(String data) {
        MapLocales bundles = new MapLocales();
        String currentLocale = "";
        for (String line : data.split("\\r?\\n|\\r")) {
            if (line.endsWith(":") && !line.contains("=")) {
                currentLocale = line.substring(0, line.length() - 1);
                bundles.put(currentLocale, new StringMap());
                continue;
            }
            int sepIndex = line.indexOf(" = ");
            if (sepIndex == -1 || currentLocale.isEmpty()) continue;
            ((StringMap)bundles.get(currentLocale)).put(line.substring(0, sepIndex), line.substring(sepIndex + 3).replace("\\n", "\n").replace("\\\n", "\\n"));
        }
        return bundles;
    }

    private StringMap readLocale(String data) {
        StringMap map = new StringMap();
        for (String line : data.split("\\r?\\n|\\r")) {
            int sepIndex = line.indexOf(" = ");
            if (sepIndex == -1) continue;
            map.put(line.substring(0, sepIndex), line.substring(sepIndex + 3).replace("\\n", "\n").replace("\\\n", "\\n"));
        }
        return map;
    }

    private static enum PropertyStatus {
        correct,
        missing,
        same;

    }
}

