/*
 * Decompiled with CFR 0.152.
 */
package mindustry.editor;

import arc.scene.style.TextureRegionDrawable;
import arc.scene.ui.TextField;
import arc.scene.ui.layout.Table;
import arc.struct.Seq;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.content.Blocks;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.gen.Icon;
import mindustry.ui.Fonts;
import mindustry.ui.Styles;
import mindustry.ui.dialogs.BaseDialog;
import mindustry.ui.dialogs.IconSelectDialog;
import mindustry.world.Tile;
import mindustry.world.blocks.environment.StaticWall;
import mindustry.world.blocks.logic.LogicBlock;

public class MapProcessorsDialog
extends BaseDialog {
    private IconSelectDialog iconSelect = new IconSelectDialog(true);
    private TextField search;
    private Seq<Building> processors = new Seq();
    private Table list;

    public MapProcessorsDialog() {
        super("@editor.worldprocessors");
        this.shown(this::setup);
        this.addCloseButton();
        this.buttons.button("@add", Icon.add, () -> {
            boolean foundAny = false;
            block0: for (int y = 0; y < Vars.world.height(); ++y) {
                for (int x = 0; x < Vars.world.width(); ++x) {
                    Tile tile = Vars.world.rawTile(x, y);
                    if (tile.synthetic()) continue;
                    foundAny = true;
                    tile.setNet(Blocks.worldProcessor, Team.sharded, 0);
                    if (!Vars.ui.editor.isShown()) break block0;
                    Vars.editor.renderer.updateStatic(x, y);
                    break block0;
                }
            }
            if (!foundAny) {
                Vars.ui.showErrorMessage("@editor.worldprocessors.nospace");
            } else {
                this.setup();
            }
        }).size(210.0f, 64.0f);
        this.cont.top();
        this.getCell(this.cont).grow();
        this.cont.table((Table s) -> {
            s.image(Icon.zoom).padRight(8.0f);
            this.search = s.field(null, text -> this.rebuild()).growX().get();
            this.search.setMessageText("@players.search");
        }).width(440.0f).fillX().padBottom(4.0f).row();
        this.cont.pane((Table t) -> {
            this.list = t;
        });
    }

    private void rebuild() {
        this.list.clearChildren();
        if (this.processors.isEmpty()) {
            this.list.add("@editor.worldprocessors.none");
        } else {
            Table t = this.list;
            String text = this.search.getText().toLowerCase();
            t.defaults().pad(4.0f);
            float h = 50.0f;
            for (Building build : this.processors) {
                if (!(build instanceof LogicBlock.LogicBuild)) continue;
                LogicBlock.LogicBuild log = (LogicBlock.LogicBuild)build;
                if (!text.isEmpty() && (log.tag == null || !log.tag.toLowerCase().contains(text))) continue;
                t.button(log.iconTag == '\u0000' ? Styles.none : new TextureRegionDrawable(Fonts.getLargeIcon(Fonts.unicodeToName(log.iconTag))), Styles.graySquarei, 32.0f, () -> this.iconSelect.show((int ic) -> {
                    log.iconTag = (char)ic;
                    this.rebuild();
                })).size(h);
                t.button((log.tag == null ? "<no name>\n" : "[accent]" + log.tag + "\n") + "[lightgray][[" + log.tile.x + ", " + log.tile.y + "]", Styles.grayt, () -> log.showEditDialog(true)).size(Vars.mobile ? 390.0f : 450.0f, h).margin(10.0f).with(b -> b.getLabel().setAlignment(8, 8));
                t.button(Icon.pencil, Styles.graySquarei, 32.0f, () -> Vars.ui.showTextInput("", "@editor.name", 32, log.tag == null ? "" : log.tag, tag -> {
                    log.tag = tag;
                    this.setup();
                })).size(h);
                if (Vars.state.isGame() && Vars.state.isEditor()) {
                    t.button(Icon.eyeSmall, Styles.graySquarei, 32.0f, () -> {
                        this.hide();
                        Vars.control.input.config.showConfig(build);
                        Vars.control.input.panCamera(Tmp.v1.set(build));
                    }).size(h);
                }
                t.button(Icon.trash, Styles.graySquarei, 32.0f, () -> Vars.ui.showConfirm("@editor.worldprocessors.delete.confirm", () -> {
                    boolean surrounded = true;
                    for (int i = 0; i < 4; ++i) {
                        Tile other = build.tile.nearby(i);
                        if (other == null || other.block().privileged || other.block().isStatic()) continue;
                        surrounded = false;
                        break;
                    }
                    if (surrounded) {
                        build.tile.setNet(build.tile.floor().wall instanceof StaticWall ? build.tile.floor().wall : Blocks.stoneWall);
                    } else {
                        build.tile.setNet(Blocks.air);
                    }
                    this.processors.remove(build);
                    this.rebuild();
                })).size(h);
                t.row();
            }
        }
    }

    private void setup() {
        this.processors.clear();
        Vars.world.tiles.eachTile(t -> {
            if (t.isCenter() && t.block() == Blocks.worldProcessor) {
                this.processors.add(t.build);
            }
        });
        this.rebuild();
    }
}

