/*
 * Decompiled with CFR 0.152.
 */
package mindustry.entities.part;

import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Lines;
import arc.math.Mathf;
import arc.util.Nullable;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.entities.part.DrawPart;

public class ShapePart
extends DrawPart {
    public boolean circle = false;
    public boolean hollow = false;
    public int sides = 3;
    public float radius = 3.0f;
    public float radiusTo = -1.0f;
    public float stroke = 1.0f;
    public float strokeTo = -1.0f;
    public float x;
    public float y;
    public float rotation;
    public float moveX;
    public float moveY;
    public float moveRot;
    public float rotateSpeed = 0.0f;
    public Color color = Color.white;
    @Nullable
    public Color colorTo;
    public boolean mirror = false;
    public boolean clampProgress = true;
    public DrawPart.PartProgress progress = DrawPart.PartProgress.warmup;
    public float layer = -1.0f;
    public float layerOffset = 0.0f;

    @Override
    public void draw(DrawPart.PartParams params) {
        float z = Draw.z();
        if (this.layer > 0.0f) {
            Draw.z(this.layer);
        }
        if (this.under && this.turretShading) {
            Draw.z(z - 1.0E-4f);
        }
        Draw.z(Draw.z() + this.layerOffset);
        float prog = this.progress.getClamp(params, this.clampProgress);
        float baseRot = Time.time * this.rotateSpeed;
        float rad = this.radiusTo < 0.0f ? this.radius : Mathf.lerp(this.radius, this.radiusTo, prog);
        float str = this.strokeTo < 0.0f ? this.stroke : Mathf.lerp(this.stroke, this.strokeTo, prog);
        int len = this.mirror && params.sideOverride == -1 ? 2 : 1;
        for (int s = 0; s < len; ++s) {
            int i = params.sideOverride == -1 ? s : params.sideOverride;
            float sign = (i == 0 ? 1 : -1) * params.sideMultiplier;
            Tmp.v1.set((this.x + this.moveX * prog) * sign, this.y + this.moveY * prog).rotate(params.rotation - 90.0f);
            float rx = params.x + Tmp.v1.x;
            float ry = params.y + Tmp.v1.y;
            if (this.color != null && this.colorTo != null) {
                Draw.color(this.color, this.colorTo, prog);
            } else if (this.color != null) {
                Draw.color(this.color);
            }
            if (!this.hollow) {
                if (!this.circle) {
                    Fill.poly(rx, ry, this.sides, rad, this.moveRot * prog * sign + params.rotation - 90.0f * sign + this.rotation * sign + baseRot * sign);
                } else {
                    Fill.circle(rx, ry, rad);
                }
            } else if (str > 1.0E-4f) {
                Lines.stroke(str);
                if (!this.circle) {
                    Lines.poly(rx, ry, this.sides, rad, this.moveRot * prog * sign + params.rotation - 90.0f * sign + this.rotation * sign + baseRot * sign);
                } else {
                    Lines.circle(rx, ry, rad);
                }
                Lines.stroke(1.0f);
            }
            if (this.color == null) continue;
            Draw.color();
        }
        Draw.z(z);
    }

    @Override
    public void load(String name) {
    }
}

