/*
 * Decompiled with CFR 0.152.
 */
package mindustry.game;

import arc.Core;

public enum Difficulty {
    casual(0.75f, 0.5f, 2.0f),
    easy(1.0f, 0.75f, 1.5f),
    normal(1.0f, 1.0f, 1.0f),
    hard(1.25f, 1.5f, 0.8f),
    eradication(1.5f, 2.0f, 0.6f);

    public static final Difficulty[] all;
    public float enemyHealthMultiplier;
    public float enemySpawnMultiplier;
    public float waveTimeMultiplier;

    private Difficulty(float enemyHealthMultiplier, float enemySpawnMultiplier, float waveTimeMultiplier) {
        this.enemySpawnMultiplier = enemySpawnMultiplier;
        this.waveTimeMultiplier = waveTimeMultiplier;
        this.enemyHealthMultiplier = enemyHealthMultiplier;
    }

    public String info() {
        String res = (this.enemyHealthMultiplier == 1.0f ? "" : Core.bundle.format("difficulty.enemyHealthMultiplier", Difficulty.percentStat(this.enemyHealthMultiplier)) + "\n") + (this.enemySpawnMultiplier == 1.0f ? "" : Core.bundle.format("difficulty.enemySpawnMultiplier", Difficulty.percentStat(this.enemySpawnMultiplier)) + "\n") + (this.waveTimeMultiplier == 1.0f ? "" : Core.bundle.format("difficulty.waveTimeMultiplier", Difficulty.percentStatNeg(this.waveTimeMultiplier)) + "\n");
        return res.isEmpty() ? Core.bundle.get("difficulty.nomodifiers") : res;
    }

    public String localized() {
        return Core.bundle.get("difficulty." + this.name());
    }

    static String percentStat(float val) {
        return ((int)(val * 100.0f - 100.0f) > 0 ? "[negstat]+" : "[stat]") + (int)(val * 100.0f - 100.0f) + "%[]";
    }

    static String percentStatNeg(float val) {
        return ((int)(val * 100.0f - 100.0f) > 0 ? "[stat]+" : "[negstat]") + (int)(val * 100.0f - 100.0f) + "%[]";
    }

    static {
        all = Difficulty.values();
    }
}

