/*
 * Decompiled with CFR 0.152.
 */
package mindustry.gen;

import arc.Core;
import arc.Events;
import arc.Graphics;
import arc.func.Boolf;
import arc.func.Cons;
import arc.func.Func;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.math.geom.Geometry;
import arc.math.geom.Point2;
import arc.math.geom.Position;
import arc.math.geom.Rect;
import arc.math.geom.Vec2;
import arc.scene.ui.Image;
import arc.scene.ui.layout.Table;
import arc.struct.Bits;
import arc.struct.IntSet;
import arc.struct.ObjectSet;
import arc.struct.Seq;
import arc.util.Interval;
import arc.util.Nullable;
import arc.util.Scaling;
import arc.util.Strings;
import arc.util.Time;
import arc.util.io.Reads;
import arc.util.io.Writes;
import java.util.Arrays;
import mindustry.Vars;
import mindustry.content.Blocks;
import mindustry.content.Fx;
import mindustry.core.World;
import mindustry.ctype.Content;
import mindustry.ctype.UnlockableContent;
import mindustry.editor.EditorTile;
import mindustry.entities.Damage;
import mindustry.entities.Effect;
import mindustry.entities.EntityGroup;
import mindustry.entities.Puddles;
import mindustry.game.EventType;
import mindustry.game.Team;
import mindustry.game.Teams;
import mindustry.gen.Buildingc;
import mindustry.gen.Bullet;
import mindustry.gen.Call;
import mindustry.gen.Entityc;
import mindustry.gen.Groups;
import mindustry.gen.Healthc;
import mindustry.gen.Icon;
import mindustry.gen.IndexableEntity__all;
import mindustry.gen.IndexableEntity__build;
import mindustry.gen.Player;
import mindustry.gen.Posc;
import mindustry.gen.Puddle;
import mindustry.gen.Sounds;
import mindustry.gen.Teamc;
import mindustry.gen.Timerc;
import mindustry.gen.Unit;
import mindustry.gen.Unitc;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.logic.LAccess;
import mindustry.logic.Ranged;
import mindustry.type.Category;
import mindustry.type.Item;
import mindustry.type.Liquid;
import mindustry.type.PayloadSeq;
import mindustry.type.UnitType;
import mindustry.ui.Bar;
import mindustry.world.Block;
import mindustry.world.Edges;
import mindustry.world.Tile;
import mindustry.world.blocks.ConstructBlock;
import mindustry.world.blocks.ControlBlock;
import mindustry.world.blocks.environment.Floor;
import mindustry.world.blocks.heat.HeatBlock;
import mindustry.world.blocks.heat.HeatConductor;
import mindustry.world.blocks.logic.LogicBlock;
import mindustry.world.blocks.payloads.BuildPayload;
import mindustry.world.blocks.payloads.Payload;
import mindustry.world.blocks.payloads.UnitPayload;
import mindustry.world.blocks.power.PowerGraph;
import mindustry.world.blocks.power.PowerNode;
import mindustry.world.blocks.storage.CoreBlock;
import mindustry.world.consumers.Consume;
import mindustry.world.meta.BlockStatus;
import mindustry.world.meta.StatUnit;
import mindustry.world.modules.ItemModule;
import mindustry.world.modules.LiquidModule;
import mindustry.world.modules.PowerModule;

public class Building
implements Buildingc,
Entityc,
Healthc,
IndexableEntity__all,
IndexableEntity__build,
Posc,
Teamc,
Timerc {
    public static final EventType.BuildDamageEvent bulletDamageEvent = new EventType.BuildDamageEvent();
    public static final float hitDuration = 9.0f;
    public static final float recentDamageTime = 300.0f;
    public static int sleepingEntities = 0;
    public static final EventType.BuildTeamChangeEvent teamChangeEvent = new EventType.BuildTeamChangeEvent();
    public static final Seq<Building> tempBuilds = new Seq();
    public static final float timeToSleep = 60.0f;
    public static final ObjectSet<Building> tmpTiles = new ObjectSet();
    protected transient boolean added;
    public transient Block block;
    public transient int cdump;
    public transient boolean dead;
    protected transient float dumpAccum;
    public transient float efficiency;
    public transient boolean enabled = true;
    public transient float healSuppressionTime = -1.0f;
    public float health;
    public transient float hitTime;
    public transient int id = EntityGroup.nextId();
    protected transient int index__all = -1;
    protected transient int index__build = -1;
    protected transient boolean initialized;
    @Nullable
    public ItemModule items;
    public transient String lastAccessed;
    protected transient float lastDamageTime = -300.0f;
    @Nullable
    public transient Building lastDisabler;
    public transient float lastHealTime = -1200.0f;
    @Nullable
    public LiquidModule liquids;
    public transient float maxHealth = 1.0f;
    public transient float optionalEfficiency;
    public transient float payloadRotation;
    public transient float potentialEfficiency;
    @Nullable
    public PowerModule power;
    public transient Seq<Building> proximity = new Seq(true, 6, Building.class);
    public transient int rotation;
    public transient boolean shouldConsumePower;
    protected transient float sleepTime;
    protected transient boolean sleeping;
    public transient Color suppressColor = Pal.sapBullet;
    public Team team = Team.derelict;
    public transient Tile tile;
    protected transient float timeScale = 1.0f;
    protected transient float timeScaleDuration;
    public transient Interval timer = new Interval(6);
    public transient long visibleFlags;
    public transient float visualLiquid;
    public transient boolean wasDamaged;
    public transient boolean wasVisible;
    public float x;
    public float y;

    protected Building() {
    }

    @Nullable
    public Building back() {
        int trns = this.block.size / 2 + 1;
        return this.nearby(Geometry.d4((int)(this.rotation + 2)).x * trns, Geometry.d4((int)(this.rotation + 2)).y * trns);
    }

    @Override
    @Nullable
    public Building buildOn() {
        return Vars.world.buildWorld(this.x, this.y);
    }

    @Nullable
    public Building front() {
        int trns = this.block.size / 2 + 1;
        return this.nearby(Geometry.d4((int)this.rotation).x * trns, Geometry.d4((int)this.rotation).y * trns);
    }

    @Nullable
    public Building left() {
        int trns = this.block.size / 2 + 1;
        return this.nearby(Geometry.d4((int)(this.rotation + 1)).x * trns, Geometry.d4((int)(this.rotation + 1)).y * trns);
    }

    @Nullable
    public Building right() {
        int trns = this.block.size / 2 + 1;
        return this.nearby(Geometry.d4((int)(this.rotation + 3)).x * trns, Geometry.d4((int)(this.rotation + 3)).y * trns);
    }

    @Nullable
    public Vec2 getCommandPosition() {
        return null;
    }

    @Nullable
    public Object config() {
        return null;
    }

    @Nullable
    public PayloadSeq getPayloads() {
        return null;
    }

    @Nullable
    public Tile findClosestEdge(Position to, Boolf<Tile> solid) {
        if (to == null) {
            return null;
        }
        Tile best = null;
        float mindst = 0.0f;
        for (Point2 point : Edges.getEdges(this.block.size)) {
            Tile other = Vars.world.tile(this.tile.x + point.x, this.tile.y + point.y);
            if (other == null || solid.get(other) || best != null && !(to.dst2(other) < mindst)) continue;
            best = other;
            mindst = other.dst2(to);
        }
        return best;
    }

    @Override
    @Nullable
    public Tile tileOn() {
        return Vars.world.tileWorld(this.x, this.y);
    }

    @Nullable
    public Payload getPayload() {
        return null;
    }

    @Nullable
    public Payload takePayload() {
        return null;
    }

    @Override
    @Nullable
    public CoreBlock.CoreBuild closestCore() {
        return Vars.state.teams.closestCore(this.x, this.y, this.team);
    }

    @Override
    @Nullable
    public CoreBlock.CoreBuild closestEnemyCore() {
        return Vars.state.teams.closestEnemyCore(this.x, this.y, this.team);
    }

    @Override
    @Nullable
    public CoreBlock.CoreBuild core() {
        return this.team.core();
    }

    @Override
    public Interval timer() {
        return this.timer;
    }

    @Override
    public boolean dead() {
        return this.dead;
    }

    @Override
    public float health() {
        return this.health;
    }

    @Override
    public float hitTime() {
        return this.hitTime;
    }

    @Override
    public float maxHealth() {
        return this.maxHealth;
    }

    @Override
    public float x() {
        return this.x;
    }

    @Override
    public float y() {
        return this.y;
    }

    @Override
    public int classId() {
        return 6;
    }

    @Override
    public int id() {
        return this.id;
    }

    @Override
    public Team team() {
        return this.team;
    }

    @Override
    public void dead(boolean dead) {
        this.dead = dead;
    }

    @Override
    public void health(float health) {
        this.health = health;
    }

    @Override
    public void hitTime(float hitTime) {
        this.hitTime = hitTime;
    }

    @Override
    public void id(int id) {
        this.id = id;
    }

    @Override
    public void maxHealth(float maxHealth) {
        this.maxHealth = maxHealth;
    }

    @Override
    public void setIndex__all(int index) {
        this.index__all = index;
    }

    @Override
    public void setIndex__build(int index) {
        this.index__build = index;
    }

    @Override
    public void team(Team team) {
        this.team = team;
    }

    @Override
    public void timer(Interval timer) {
        this.timer = timer;
    }

    @Override
    public void x(float x) {
        this.x = x;
    }

    @Override
    public void y(float y) {
        this.y = y;
    }

    public void onRepaired() {
        this.placed();
    }

    public void placed() {
        if (Vars.net.client()) {
            return;
        }
        if ((this.block.consumesPower || this.block.outputsPower) && this.block.hasPower && this.block.connectedPower) {
            PowerNode.getNodeLinks(this.tile, this.block, this.team, other -> {
                if (!other.power.links.contains(this.pos())) {
                    other.configureAny(this.pos());
                }
            });
        }
    }

    public void playerPlaced(Object config) {
    }

    public void read(Reads read, byte revision) {
    }

    @Override
    public void write(Writes write) {
    }

    @Override
    public <T extends Entityc> T self() {
        return (T)this;
    }

    @Override
    public <T> T as() {
        return (T)this;
    }

    public Building create(Block block, Team team) {
        this.block = block;
        this.team = team;
        this.health = block.health;
        this.maxHealth(block.health);
        this.timer(new Interval(block.timers));
        if (block.hasItems) {
            this.items = new ItemModule();
        }
        if (block.hasLiquids) {
            this.liquids = new LiquidModule();
        }
        if (block.hasPower) {
            this.power = new PowerModule();
            this.power.graph.add(this);
        }
        this.initialized = true;
        return this;
    }

    public Building getLiquidDestination(Building from, Liquid liquid) {
        return this;
    }

    public Building init(Tile tile, Team team, boolean shouldAdd, int rotation) {
        if (!this.initialized) {
            this.create(tile.block(), team);
        } else if (this.block.hasPower) {
            this.power.init = false;
            new PowerGraph().add(this);
        }
        this.proximity.clear();
        this.rotation = rotation;
        this.tile = tile;
        this.set(tile.drawx(), tile.drawy());
        if (shouldAdd) {
            this.add();
        }
        this.checkAllowUpdate();
        this.created();
        return this;
    }

    public Building nearby(int dx, int dy) {
        return Vars.world.build(this.tile.x + dx, this.tile.y + dy);
    }

    public Building nearby(int rotation) {
        Building building;
        switch (rotation) {
            case 0: {
                building = Vars.world.build(this.tile.x + 1, this.tile.y);
                break;
            }
            case 1: {
                building = Vars.world.build(this.tile.x, this.tile.y + 1);
                break;
            }
            case 2: {
                building = Vars.world.build(this.tile.x - 1, this.tile.y);
                break;
            }
            case 3: {
                building = Vars.world.build(this.tile.x, this.tile.y - 1);
                break;
            }
            default: {
                building = null;
            }
        }
        return building;
    }

    public Graphics.Cursor getCursor() {
        return this.block.configurable && this.interactable(Vars.player.team()) ? Graphics.Cursor.SystemCursor.hand : Graphics.Cursor.SystemCursor.arrow;
    }

    public TextureRegion getDisplayIcon() {
        return this.block.uiIcon;
    }

    public Seq<Building> getPowerConnections(Seq<Building> out) {
        out.clear();
        if (this.power == null) {
            return out;
        }
        for (Building other : this.proximity) {
            if (other == null || other.power == null || other.team != this.team || this.block.consumesPower && other.block.consumesPower && !this.block.outputsPower && !other.block.outputsPower && !this.block.conductivePower && !other.block.conductivePower || !this.conductsTo(other) || !other.conductsTo(this) || this.power.links.contains(other.pos())) continue;
            out.add(other);
        }
        for (int i = 0; i < this.power.links.size; ++i) {
            Tile link = Vars.world.tile(this.power.links.get(i));
            if (link == null || link.build == null || link.build.power == null || link.build.team != this.team) continue;
            out.add(link.build);
        }
        return out;
    }

    public boolean absorbLasers() {
        return this.block.absorbLasers;
    }

    public boolean acceptItem(Building source, Item item) {
        return this.block.consumesItem(item) && this.items.get(item) < this.getMaximumAccepted(item);
    }

    public boolean acceptLiquid(Building source, Liquid liquid) {
        return this.block.hasLiquids && this.block.consumesLiquid(liquid);
    }

    public boolean acceptPayload(Building source, Payload payload) {
        return false;
    }

    public boolean allowDeposit() {
        return this.block.alwaysAllowDeposit || !Vars.state.rules.onlyDepositCore;
    }

    public boolean allowUpdate() {
        return this.team != Team.derelict && this.block.supportsEnv(Vars.state.rules.env) && (this.tile instanceof EditorTile || this.block.privileged || !Vars.state.rules.limitMapArea || !Vars.state.rules.disableOutsideArea || Rect.contains(Vars.state.rules.limitX, Vars.state.rules.limitY, Vars.state.rules.limitWidth, Vars.state.rules.limitHeight, this.tile.x, this.tile.y));
    }

    public boolean canBeReplaced(Block other) {
        return other.canReplace(this.block);
    }

    public boolean canConsume() {
        return this.potentialEfficiency > 0.0f;
    }

    public boolean canControlSelect(Unit player) {
        return false;
    }

    public boolean canDump(Building to, Item item) {
        return true;
    }

    public boolean canDumpLiquid(Building to, Liquid liquid) {
        return true;
    }

    public boolean canPickup() {
        return this.block.canPickup;
    }

    public boolean canResupply() {
        return this.block.allowResupply;
    }

    public boolean canUnload() {
        return this.block.unloadable;
    }

    public boolean canWithdraw() {
        return true;
    }

    @Override
    public boolean cheating() {
        return this.team.rules().cheat;
    }

    public boolean checkSolid() {
        return false;
    }

    public boolean checkSuppression() {
        if (this.isHealSuppressed()) {
            if (Mathf.chanceDelta(0.03)) {
                Fx.regenSuppressParticle.at(this.x + Mathf.range((float)(this.block.size * 8) / 2.0f - 1.0f), this.y + Mathf.range((float)(this.block.size * 8) / 2.0f - 1.0f), this.suppressColor);
            }
            return true;
        }
        return false;
    }

    public boolean collide(Bullet other) {
        return true;
    }

    public boolean collision(Bullet other) {
        boolean wasDead = this.health <= 0.0f;
        float damage = other.type.buildingDamage(other);
        if (!other.type.pierceArmor) {
            damage = Damage.applyArmor(damage, this.block.armor);
        }
        this.damage(other, other.team, damage);
        if (this.health <= 0.0f && !wasDead) {
            Events.fire(new EventType.BuildingBulletDestroyEvent(this, other));
        }
        return true;
    }

    public boolean conductsTo(Building other) {
        return !this.block.insulated;
    }

    public boolean configTapped() {
        return true;
    }

    public boolean consumeTriggerValid() {
        return false;
    }

    @Override
    public boolean damaged() {
        return this.health < this.maxHealth - 0.001f;
    }

    public boolean dump() {
        return this.dump(null);
    }

    public boolean dump(Item todump) {
        if (!this.block.hasItems || this.items.total() == 0 || this.proximity.size == 0 || todump != null && !this.items.has(todump)) {
            return false;
        }
        int dump = this.cdump;
        Seq<Item> allItems = Vars.content.items();
        int itemSize = allItems.size;
        T[] itemArray = allItems.items;
        if (todump == null) {
            for (int i = 0; i < this.proximity.size; ++i) {
                Building other = this.proximity.get((i + dump) % this.proximity.size);
                for (int ii = 0; ii < itemSize; ++ii) {
                    Item item;
                    if (!this.items.has(ii) || !other.acceptItem(this, item = (Item)itemArray[ii]) || !this.canDump(other, item)) continue;
                    other.handleItem(this, item);
                    this.items.remove(item, 1);
                    this.incrementDump(this.proximity.size);
                    return true;
                }
                this.incrementDump(this.proximity.size);
            }
        } else {
            for (int i = 0; i < this.proximity.size; ++i) {
                Building other = this.proximity.get((i + dump) % this.proximity.size);
                if (other.acceptItem(this, todump) && this.canDump(other, todump)) {
                    other.handleItem(this, todump);
                    this.items.remove(todump, 1);
                    this.incrementDump(this.proximity.size);
                    return true;
                }
                this.incrementDump(this.proximity.size);
            }
        }
        return false;
    }

    public boolean dumpAccumulate() {
        return this.dumpAccumulate(null);
    }

    public boolean dumpAccumulate(Item item) {
        boolean res = false;
        this.dumpAccum += this.delta();
        while (this.dumpAccum >= 1.0f) {
            res |= this.dump(item);
            this.dumpAccum -= 1.0f;
        }
        return res;
    }

    public boolean dumpPayload(Payload todump) {
        if (this.proximity.size == 0) {
            return false;
        }
        int dump = this.cdump;
        for (int i = 0; i < this.proximity.size; ++i) {
            Building other = this.proximity.get((i + dump) % this.proximity.size);
            if (other.acceptPayload(this, todump)) {
                other.handlePayload(this, todump);
                this.incrementDump(this.proximity.size);
                return true;
            }
            this.incrementDump(this.proximity.size);
        }
        return false;
    }

    @Override
    public boolean inFogTo(Team viewer) {
        if (this.team == viewer || !Vars.state.rules.fog) {
            return false;
        }
        int size = this.block.size;
        int of = this.block.sizeOffset;
        short tx = this.tile.x;
        short ty = this.tile.y;
        if (!this.isDiscovered(viewer)) {
            return true;
        }
        for (int x = 0; x < size; ++x) {
            for (int y = 0; y < size; ++y) {
                if (!Vars.fogControl.isVisibleTile(viewer, tx + x + of, ty + y + of)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean interactable(Team team) {
        return Vars.state.teams.canInteract(team, this.team());
    }

    @Override
    public boolean isAdded() {
        return this.added;
    }

    public boolean isCommandable() {
        return this.block.commandable;
    }

    public boolean isDiscovered(Team viewer) {
        if (Vars.state.rules.limitMapArea && Vars.world.getDarkness(this.tile.x, this.tile.y) >= 3.0f) {
            return false;
        }
        if (viewer == null || !Vars.state.rules.staticFog || !Vars.state.rules.fog) {
            return true;
        }
        if (this.block.size <= 2) {
            return Vars.fogControl.isDiscovered(viewer, this.tile.x, this.tile.y);
        }
        int s = this.block.size / 2;
        return Vars.fogControl.isDiscovered(viewer, this.tile.x, this.tile.y) || Vars.fogControl.isDiscovered(viewer, this.tile.x - s, this.tile.y - s) || Vars.fogControl.isDiscovered(viewer, this.tile.x - s, this.tile.y + s) || Vars.fogControl.isDiscovered(viewer, this.tile.x + s, this.tile.y + s) || Vars.fogControl.isDiscovered(viewer, this.tile.x + s, this.tile.y - s);
    }

    public boolean isHealSuppressed() {
        return this.block.suppressable && Time.time <= this.healSuppressionTime;
    }

    public boolean isInsulated() {
        return this.block.insulated;
    }

    @Override
    public boolean isLocal() {
        Unitc u;
        Building building;
        return this == Vars.player || (building = this) instanceof Unitc && (u = (Unitc)((Object)building)).controller() == Vars.player;
    }

    public boolean isPayload() {
        return this.tile == Vars.emptyTile;
    }

    @Override
    public boolean isRemote() {
        Unitc u;
        Building building = this;
        return building instanceof Unitc && (u = (Unitc)((Object)building)).isPlayer() && !this.isLocal();
    }

    @Override
    public boolean isValid() {
        return this.tile.build == this && !this.dead();
    }

    public boolean moveForward(Item item) {
        Building other = this.front();
        if (other != null && other.team == this.team && other.acceptItem(this, item)) {
            other.handleItem(this, item);
            return true;
        }
        return false;
    }

    public boolean movePayload(Payload todump) {
        int trns = this.block.size / 2 + 1;
        Tile next = this.tile.nearby(Geometry.d4((int)this.rotation).x * trns, Geometry.d4((int)this.rotation).y * trns);
        if (next != null && next.build != null && next.build.team == this.team && next.build.acceptPayload(this, todump)) {
            next.build.handlePayload(this, todump);
            return true;
        }
        return false;
    }

    public boolean onConfigureBuildTapped(Building other) {
        if (this.block.clearOnDoubleTap) {
            if (this == other) {
                this.deselect();
                this.configure(null);
                return false;
            }
            return true;
        }
        return this != other;
    }

    public boolean onConfigureTapped(float x, float y) {
        return false;
    }

    @Override
    public boolean onSolid() {
        Tile tile = this.tileOn();
        return tile == null || tile.solid();
    }

    public boolean payloadCheck(int conveyorRotation) {
        return this.block.rotate && (this.rotation + 2) % 4 == conveyorRotation;
    }

    public boolean productionValid() {
        return true;
    }

    public boolean put(Item item) {
        int dump = this.cdump;
        for (int i = 0; i < this.proximity.size; ++i) {
            this.incrementDump(this.proximity.size);
            Building other = this.proximity.get((i + dump) % this.proximity.size);
            if (!other.acceptItem(this, item) || !this.canDump(other, item)) continue;
            other.handleItem(this, item);
            return true;
        }
        return false;
    }

    @Override
    public boolean serialize() {
        return false;
    }

    public boolean shouldAmbientSound() {
        return this.shouldConsume();
    }

    public boolean shouldConsume() {
        return this.enabled;
    }

    public boolean shouldHideConfigure(Player player) {
        return false;
    }

    public boolean shouldShowConfigure(Player player) {
        return true;
    }

    @Override
    public boolean timer(int index, float time) {
        if (Float.isInfinite(time)) {
            return false;
        }
        return this.timer.get(index, time);
    }

    public boolean wasRecentlyDamaged() {
        return this.lastDamageTime + 300.0f >= Time.time;
    }

    public boolean wasRecentlyHealed(float duration) {
        return this.lastHealTime + duration >= Time.time;
    }

    public byte relativeTo(Building build) {
        if (Math.abs(this.x - build.x) > Math.abs(this.y - build.y)) {
            if (this.x <= build.x - 1.0f) {
                return 0;
            }
            if (this.x >= build.x + 1.0f) {
                return 2;
            }
        } else {
            if (this.y <= build.y - 1.0f) {
                return 1;
            }
            if (this.y >= build.y + 1.0f) {
                return 3;
            }
        }
        return -1;
    }

    public byte relativeTo(int cx, int cy) {
        return this.tile.absoluteRelativeTo(cx, cy);
    }

    public byte relativeTo(Tile tile) {
        return this.relativeTo(tile.x, tile.y);
    }

    public byte relativeToEdge(Tile other) {
        return this.relativeTo(Edges.getFacingEdge(other, this.tile));
    }

    public byte version() {
        return 0;
    }

    @Override
    public double sense(Content content) {
        if (content instanceof Item) {
            Item i = (Item)content;
            if (this.items != null) {
                return this.items.get(i);
            }
        }
        if (content instanceof Liquid) {
            Liquid l = (Liquid)content;
            if (this.liquids != null) {
                return this.liquids.get(l);
            }
        }
        if (this.getPayloads() != null) {
            if (content instanceof UnitType) {
                UnitType u = (UnitType)content;
                return this.getPayloads().get(u);
            }
            if (content instanceof Block) {
                Block b = (Block)content;
                return this.getPayloads().get(b);
            }
        }
        return Double.NaN;
    }

    @Override
    public double sense(LAccess sensor) {
        double d;
        switch (sensor) {
            case x: {
                d = World.conv(this.x);
                break;
            }
            case y: {
                d = World.conv(this.y);
                break;
            }
            case color: {
                d = Color.toDoubleBits(this.team.color.r, this.team.color.g, this.team.color.b, 1.0f);
                break;
            }
            case dead: {
                if (!this.isValid()) {
                    d = 1.0;
                    break;
                }
                d = 0.0;
                break;
            }
            case solid: {
                if (this.block.solid || this.checkSolid()) {
                    d = 1.0;
                    break;
                }
                d = 0.0;
                break;
            }
            case team: {
                d = this.team.id;
                break;
            }
            case health: {
                d = this.health;
                break;
            }
            case maxHealth: {
                d = this.maxHealth;
                break;
            }
            case efficiency: {
                d = this.efficiency;
                break;
            }
            case timescale: {
                d = this.timeScale;
                break;
            }
            case range: {
                Building building = this;
                if (building instanceof Ranged) {
                    Ranged r = (Ranged)((Object)building);
                    d = r.range() / 8.0f;
                    break;
                }
                d = 0.0;
                break;
            }
            case rotation: {
                d = this.rotation;
                break;
            }
            case totalItems: {
                if (this.items == null) {
                    d = 0.0;
                    break;
                }
                d = this.items.total();
                break;
            }
            case totalLiquids: {
                if (this.liquids == null) {
                    d = 0.0;
                    break;
                }
                d = this.liquids.currentAmount();
                break;
            }
            case totalPower: {
                if (this.power == null || this.block.consPower == null) {
                    d = 0.0;
                    break;
                }
                d = this.power.status * (this.block.consPower.buffered ? this.block.consPower.capacity : 1.0f);
                break;
            }
            case itemCapacity: {
                if (this.block.hasItems) {
                    d = this.block.itemCapacity;
                    break;
                }
                d = 0.0;
                break;
            }
            case liquidCapacity: {
                if (this.block.hasLiquids) {
                    d = this.block.liquidCapacity;
                    break;
                }
                d = 0.0;
                break;
            }
            case powerCapacity: {
                if (this.block.consPower != null) {
                    d = this.block.consPower.capacity;
                    break;
                }
                d = 0.0;
                break;
            }
            case powerNetIn: {
                if (this.power == null) {
                    d = 0.0;
                    break;
                }
                d = this.power.graph.getLastScaledPowerIn() * 60.0f;
                break;
            }
            case powerNetOut: {
                if (this.power == null) {
                    d = 0.0;
                    break;
                }
                d = this.power.graph.getLastScaledPowerOut() * 60.0f;
                break;
            }
            case powerNetStored: {
                if (this.power == null) {
                    d = 0.0;
                    break;
                }
                d = this.power.graph.getLastPowerStored();
                break;
            }
            case powerNetCapacity: {
                if (this.power == null) {
                    d = 0.0;
                    break;
                }
                d = this.power.graph.getLastCapacity();
                break;
            }
            case enabled: {
                if (this.enabled) {
                    d = 1.0;
                    break;
                }
                d = 0.0;
                break;
            }
            case controlled: {
                ControlBlock c;
                Building building = this;
                d = building instanceof ControlBlock && (c = (ControlBlock)((Object)building)).isControlled() ? 2 : 0;
                break;
            }
            case payloadCount: {
                d = (this.getPayloads() != null ? this.getPayloads().total() : 0) + (this.getPayload() != null ? 1 : 0);
                break;
            }
            case size: {
                d = this.block.size;
                break;
            }
            case cameraX: 
            case cameraY: 
            case cameraWidth: 
            case cameraHeight: {
                Building building = this;
                if (building instanceof ControlBlock) {
                    ControlBlock c = (ControlBlock)((Object)building);
                    d = c.unit().sense(sensor);
                    break;
                }
                d = 0.0;
                break;
            }
            default: {
                d = Double.NaN;
            }
        }
        return d;
    }

    public float ambientVolume() {
        return this.efficiency;
    }

    public float calculateHeat(float[] sideHeat) {
        return this.calculateHeat(sideHeat, null);
    }

    /*
     * Unable to fully structure code
     */
    public float calculateHeat(float[] sideHeat, IntSet cameFrom) {
        Arrays.fill(sideHeat, 0.0f);
        if (cameFrom != null) {
            cameFrom.clear();
        }
        heat = 0.0f;
        for (Building build : this.proximity) {
            block11: {
                block10: {
                    if (build == null || build.team != this.team || !(build instanceof HeatBlock)) continue;
                    heater = (HeatBlock)build;
                    var9_9 = build.block;
                    if (!(var9_9 instanceof HeatConductor)) ** GOTO lbl-1000
                    cond = (HeatConductor)var9_9;
                    if (cond.splitHeat) {
                        v0 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v0 = split = false;
                    }
                    if (build.block.rotate && (split || (this.relativeTo(build) + 2) % 4 != build.rotation) && (!split || this.relativeTo(build) == build.rotation)) continue;
                    if (!(build instanceof HeatConductor.HeatConductorBuild)) break block10;
                    hc = (HeatConductor.HeatConductorBuild)build;
                    if (hc.cameFrom.contains(this.id())) break block11;
                }
                diff = Math.min(Math.abs(build.x - this.x), Math.abs(build.y - this.y)) / 8.0f;
                contactPoints = Math.min((int)((float)this.block.size / 2.0f + (float)build.block.size / 2.0f - diff), Math.min(build.block.size, this.block.size));
                add = heater.heat() / (float)build.block.size * (float)contactPoints;
                if (split) {
                    add /= 3.0f;
                }
                v1 = Mathf.mod(this.relativeTo(build), 4);
                sideHeat[v1] = sideHeat[v1] + add;
                heat += add;
            }
            if (cameFrom != null) {
                cameFrom.add(build.id);
                if (build instanceof HeatConductor.HeatConductorBuild) {
                    hc = (HeatConductor.HeatConductorBuild)build;
                    cameFrom.addAll(hc.cameFrom);
                }
            }
            if (!(heater instanceof HeatConductor.HeatConductorBuild)) continue;
            cond = (HeatConductor.HeatConductorBuild)heater;
            cond.updateHeat();
        }
        return heat;
    }

    public float delta() {
        return Time.delta * this.timeScale;
    }

    public float drawrot() {
        return this.block.rotate && this.block.rotateDraw ? (float)(this.rotation * 90) : 0.0f;
    }

    public float edelta() {
        return this.efficiency * this.delta();
    }

    public float efficiencyScale() {
        return 1.0f;
    }

    public float fogRadius() {
        return this.block.fogRadius;
    }

    public float getDisplayEfficiency() {
        return this.getProgressIncrease(1.0f) / this.edelta();
    }

    public float getPowerProduction() {
        return 0.0f;
    }

    public float getProgressIncrease(float baseTime) {
        return 1.0f / baseTime * this.edelta();
    }

    @Override
    public float getX() {
        return this.x;
    }

    @Override
    public float getY() {
        return this.y;
    }

    public float handleDamage(float amount) {
        return amount;
    }

    @Override
    public float healthf() {
        return this.health / this.maxHealth;
    }

    @Override
    public float hitSize() {
        return this.tile.block().size * 8;
    }

    public float moveLiquid(Building next, Liquid liquid) {
        if (next == null) {
            return 0.0f;
        }
        next = next.getLiquidDestination(this, liquid);
        if (next.team == this.team && next.block.hasLiquids && this.liquids.get(liquid) > 0.0f) {
            float ofract = next.liquids.get(liquid) / next.block.liquidCapacity;
            float fract = this.liquids.get(liquid) / this.block.liquidCapacity * this.block.liquidPressure;
            float flow = Math.min(Mathf.clamp(fract - ofract) * this.block.liquidCapacity, this.liquids.get(liquid));
            if ((flow = Math.min(flow, next.block.liquidCapacity - next.liquids.get(liquid))) > 0.0f && ofract <= fract && next.acceptLiquid(this, liquid)) {
                next.handleLiquid(this, liquid, flow);
                this.liquids.remove(liquid, flow);
                return flow;
            }
            if (!next.block.consumesLiquid(liquid) && next.liquids.currentAmount() / next.block.liquidCapacity > 0.1f && fract > 0.1f) {
                float fx = (this.x + next.x) / 2.0f;
                float fy = (this.y + next.y) / 2.0f;
                Liquid other = next.liquids.current();
                if (other.blockReactive && liquid.blockReactive) {
                    if (other.flammability > 0.3f && liquid.temperature > 0.7f || liquid.flammability > 0.3f && other.temperature > 0.7f) {
                        this.damageContinuous(1.0f);
                        next.damageContinuous(1.0f);
                        if (Mathf.chanceDelta(0.1)) {
                            Fx.fire.at(fx, fy);
                        }
                    } else if (liquid.temperature > 0.7f && other.temperature < 0.55f || other.temperature > 0.7f && liquid.temperature < 0.55f) {
                        this.liquids.remove(liquid, Math.min(this.liquids.get(liquid), 0.7f * Time.delta));
                        if (Mathf.chanceDelta(0.2f)) {
                            Fx.steam.at(fx, fy);
                        }
                    }
                }
            }
        }
        return 0.0f;
    }

    public float moveLiquidForward(boolean leaks, Liquid liquid) {
        Tile next = this.tile.nearby(this.rotation);
        if (next == null) {
            return 0.0f;
        }
        if (next.build != null) {
            return this.moveLiquid(next.build, liquid);
        }
        if (leaks && !next.block().solid && !next.block().hasLiquids) {
            float leakAmount = this.liquids.get(liquid) / 1.5f;
            Puddles.deposit(next, this.tile, liquid, leakAmount, true, true);
            this.liquids.remove(liquid, leakAmount);
        }
        return 0.0f;
    }

    public float progress() {
        return 0.0f;
    }

    public float rotdeg() {
        return this.rotation * 90;
    }

    public float timeScale() {
        return this.timeScale;
    }

    public float totalProgress() {
        return Time.time;
    }

    public float warmup() {
        return 0.0f;
    }

    public int acceptStack(Item item, int amount, Teamc source) {
        if (this.acceptItem(this, item) && this.block.hasItems && (source == null || source.team() == this.team)) {
            return Math.min(this.getMaximumAccepted(item) - this.items.get(item), amount);
        }
        return 0;
    }

    public int explosionItemCap() {
        return this.block.itemCapacity;
    }

    public int getMaximumAccepted(Item item) {
        return this.block.itemCapacity;
    }

    public int moduleBitmask() {
        return (this.items != null ? 1 : 0) | (this.power != null ? 2 : 0) | (this.liquids != null ? 4 : 0) | 8 | (this.timeScale != 1.0f ? 16 : 0) | (this.lastDisabler != null && this.lastDisabler.isValid() ? 32 : 0);
    }

    public int pos() {
        return this.tile.pos();
    }

    public int removeStack(Item item, int amount) {
        if (this.items == null) {
            return 0;
        }
        amount = Math.min(amount, this.items.get(item));
        this.noSleep();
        this.items.remove(item, amount);
        return amount;
    }

    @Override
    public int tileX() {
        return this.tile.x;
    }

    @Override
    public int tileY() {
        return this.tile.y;
    }

    @Override
    public Object senseObject(LAccess sensor) {
        Object object;
        switch (sensor) {
            case type: {
                object = this.block;
                break;
            }
            case firstItem: {
                if (this.items == null) {
                    object = null;
                    break;
                }
                object = this.items.first();
                break;
            }
            case config: {
                if (this.block.configSenseable()) {
                    object = this.config();
                    break;
                }
                object = null;
                break;
            }
            case payloadType: {
                Payload payload = this.getPayload();
                if (payload instanceof UnitPayload) {
                    UnitPayload p1 = (UnitPayload)payload;
                    object = p1.unit.type;
                    break;
                }
                payload = this.getPayload();
                if (payload instanceof BuildPayload) {
                    BuildPayload p2 = (BuildPayload)payload;
                    object = p2.block();
                    break;
                }
                object = null;
                break;
            }
            default: {
                object = noSensed;
            }
        }
        return object;
    }

    public String getDisplayName() {
        return this.team == Team.derelict ? this.block.localizedName + "\n" + Core.bundle.get("block.derelict") : this.block.localizedName + (this.team == Vars.player.team() || this.team.emoji.isEmpty() ? "" : " " + this.team.emoji);
    }

    public String toString() {
        return "Building#" + this.id() + "[" + this.tileX() + "," + this.tileY() + "]:" + this.block;
    }

    @Override
    public Block blockOn() {
        Tile tile = this.tileOn();
        return tile == null ? Blocks.air : tile.block();
    }

    public Floor floor() {
        return this.tile.floor();
    }

    @Override
    public Floor floorOn() {
        Tile tile = this.tileOn();
        return tile == null || tile.block() != Blocks.air ? (Floor)Blocks.air : tile.floor();
    }

    public BlockStatus status() {
        if (!this.enabled) {
            return BlockStatus.logicDisable;
        }
        if (!this.shouldConsume()) {
            return BlockStatus.noOutput;
        }
        if (this.efficiency <= 0.0f || !this.productionValid()) {
            return BlockStatus.noInput;
        }
        return Vars.state.tick / 30.0 % 1.0 < (double)this.efficiency ? BlockStatus.active : BlockStatus.noInput;
    }

    public ItemModule flowItems() {
        return this.items;
    }

    public static Building create() {
        return new Building();
    }

    @Override
    public void add() {
        if (this.added) {
            return;
        }
        this.index__all = Groups.all.addIndex(this);
        this.index__build = Groups.build.addIndex(this);
        if (this.power != null) {
            this.power.graph.checkAdd();
        }
        this.added = true;
    }

    public void addPlan(boolean checkPrevious) {
        this.addPlan(checkPrevious, false);
    }

    public void addPlan(boolean checkPrevious, boolean ignoreConditions) {
        if (!ignoreConditions && (!this.block.rebuildable || this.team == Vars.state.rules.defaultTeam && Vars.state.isCampaign() && !this.block.isVisible())) {
            return;
        }
        Object overrideConfig = null;
        Block toAdd = this.block;
        Building building = this;
        if (building instanceof ConstructBlock.ConstructBuild) {
            ConstructBlock.ConstructBuild entity = (ConstructBlock.ConstructBuild)building;
            if (entity.current != null && entity.current.synthetic() && entity.wasConstructing) {
                toAdd = entity.current;
                overrideConfig = entity.lastConfig;
            } else {
                return;
            }
        }
        Teams.TeamData data = this.team.data();
        if (checkPrevious) {
            for (int i = 0; i < data.plans.size; ++i) {
                Teams.BlockPlan b = data.plans.get(i);
                if (b.x != this.tile.x || b.y != this.tile.y) continue;
                data.plans.removeIndex(i);
                break;
            }
        }
        data.plans.addFirst(new Teams.BlockPlan(this.tile.x, this.tile.y, (short)this.rotation, toAdd, overrideConfig == null ? this.config() : overrideConfig));
    }

    public void afterDestroyed() {
        if (this.block.destroyBullet != null) {
            this.block.destroyBullet.create(this, this.block.destroyBulletSameTeam ? this.team : Team.derelict, this.x, this.y, Mathf.randomSeed(this.id(), 360.0f));
        }
    }

    public void afterPickedUp() {
        if (this.power != null) {
            this.power.graph = new PowerGraph();
            this.power.links.clear();
            if (this.block.consPower != null && !this.block.consPower.buffered) {
                this.power.status = 0.0f;
            }
        }
    }

    @Override
    public void afterRead() {
    }

    @Override
    public void afterReadAll() {
    }

    public void applyBoost(float intensity, float duration) {
        if (intensity >= this.timeScale - 0.001f) {
            this.timeScaleDuration = Math.max(this.timeScaleDuration, duration);
        }
        this.timeScale = Math.max(this.timeScale, intensity);
    }

    public void applyHealSuppression(float amount) {
        this.applyHealSuppression(amount, Pal.sapBullet);
    }

    public void applyHealSuppression(float amount, Color suppressColor) {
        this.healSuppressionTime = Math.max(this.healSuppressionTime, Time.time + amount);
        this.suppressColor = suppressColor;
    }

    public void applySlowdown(float intensity, float duration) {
        if (intensity <= this.timeScale + 0.001f) {
            this.timeScaleDuration = Math.max(this.timeScaleDuration, duration);
        }
        this.timeScale = Math.min(this.timeScale, intensity);
    }

    @Override
    public void beforeWrite() {
    }

    public void buildConfiguration(Table table) {
    }

    public void changeTeam(Team next) {
        Team last;
        if (this.team == next) {
            return;
        }
        if (this.block.forceTeam != null) {
            this.team = this.block.forceTeam;
        }
        if ((last = this.team) == next) {
            return;
        }
        boolean was = this.isValid();
        if (was) {
            Vars.indexer.removeIndex(this.tile);
        }
        this.team = next;
        if (this.power != null) {
            for (int i = 0; i < this.power.links.size; ++i) {
                Building other = Vars.world.build(this.power.links.items[i]);
                if (other == null || other.team == this.team || other.power == null) continue;
                this.power.links.removeIndex(i);
                other.power.links.removeValue(this.pos());
                new PowerGraph().reflow(other);
                --i;
            }
            new PowerGraph().reflow(this);
            this.updatePowerGraph();
        }
        if (was) {
            Vars.indexer.addIndex(this.tile);
            Events.fire(teamChangeEvent.set(last, this));
        }
        this.checkAllowUpdate();
    }

    public void checkAllowUpdate() {
        if (!this.allowUpdate()) {
            this.enabled = false;
        }
    }

    @Override
    public void clampHealth() {
        this.health = Math.min(this.health, this.maxHealth);
        if (Float.isNaN(this.health)) {
            this.health = 0.0f;
        }
    }

    public void configure(Object value) {
        this.block.lastConfig = value;
        Call.tileConfig(Vars.player, this, value);
    }

    public void configureAny(Object value) {
        Call.tileConfig(null, this, value);
    }

    public void configured(Unit builder, Object value) {
        Building build;
        Object conf;
        Class<Object> type;
        Class<Void> clazz = value == null ? Void.TYPE : (type = value.getClass().isAnonymousClass() ? value.getClass().getSuperclass() : value.getClass());
        if (value instanceof Item) {
            type = Item.class;
        }
        if (value instanceof Block) {
            type = Block.class;
        }
        if (value instanceof Liquid) {
            type = Liquid.class;
        }
        if (value instanceof UnitType) {
            type = UnitType.class;
        }
        if (builder != null && builder.isPlayer()) {
            this.updateLastAccess(builder.getPlayer());
        }
        if (this.block.configurations.containsKey(type)) {
            this.block.configurations.get(type).get(this, value);
        } else if (value instanceof Building && (conf = (build = (Building)value).config()) != null && !(conf instanceof Building)) {
            this.configured(builder, conf);
        }
    }

    public void consume() {
        for (Consume cons : this.block.consumers) {
            cons.trigger(this);
        }
    }

    @Override
    public void control(LAccess type, double p1, double p2, double p3, double p4) {
        if (type == LAccess.enabled) {
            this.enabled = !Mathf.zero((float)p1);
        }
    }

    @Override
    public void control(LAccess type, Object p1, double p2, double p3, double p4) {
        if (type == LAccess.config && this.block.logicConfigurable && !(p1 instanceof LogicBlock.LogicBuild)) {
            this.configured(null, p1);
        }
    }

    public void created() {
    }

    public void damage(Bullet bullet, Team source, float damage) {
        this.damage(source, damage);
        Events.fire(bulletDamageEvent.set(this, bullet));
    }

    @Override
    public void damage(float amount, boolean withEffect) {
        float pre = this.hitTime;
        this.damage(amount);
        if (!withEffect) {
            this.hitTime = pre;
        }
    }

    @Override
    public void damage(float damage) {
        if (this.dead()) {
            return;
        }
        float dm = Vars.state.rules.blockHealth(this.team);
        this.lastDamageTime = Time.time;
        damage = Mathf.zero(dm) ? this.health + 1.0f : (damage /= dm);
        if (!Vars.net.client()) {
            this.health -= this.handleDamage(damage);
        }
        this.healthChanged();
        if (this.health <= 0.0f) {
            Call.buildDestroyed(this);
        }
    }

    public void damage(Team source, float damage) {
        this.damage(damage);
    }

    @Override
    public void damageContinuous(float amount) {
        this.damage(amount * Time.delta, this.hitTime <= -1.0f);
    }

    @Override
    public void damageContinuousPierce(float amount) {
        this.damagePierce(amount * Time.delta, this.hitTime <= -11.0f);
    }

    @Override
    public void damagePierce(float amount) {
        this.damagePierce(amount, true);
    }

    @Override
    public void damagePierce(float amount, boolean withEffect) {
        this.damage(amount, withEffect);
    }

    public void deselect() {
        if (!Vars.headless && Vars.control.input.config.getSelected() == this) {
            Vars.control.input.config.hideConfig();
        }
    }

    @Override
    public void display(Table table) {
        table.table(t -> {
            t.left();
            t.add(new Image(this.block.getDisplayIcon(this.tile))).scaling(Scaling.fit).size(32.0f);
            t.labelWrap(this.block.getDisplayName(this.tile)).left().width(190.0f).padLeft(5.0f);
        }).growX().left();
        table.row();
        if (this.team == Vars.player.team()) {
            boolean displayFlow;
            table.table(bars -> {
                bars.defaults().growX().height(18.0f).pad(4.0f);
                this.displayBars((Table)bars);
            }).growX();
            table.row();
            table.table(this::displayConsumption).growX();
            boolean bl = displayFlow = (this.block.category == Category.distribution || this.block.category == Category.liquid) && this.block.displayFlow;
            if (displayFlow) {
                String ps = " " + StatUnit.perSecond.localized();
                ItemModule flowItems = this.flowItems();
                if (flowItems != null) {
                    table.row();
                    table.left();
                    table.table(l -> {
                        Bits current = new Bits();
                        Runnable rebuild = () -> {
                            l.clearChildren();
                            l.left();
                            for (Item item : Vars.content.items()) {
                                if (!flowItems.hasFlowItem(item)) continue;
                                l.image(item.uiIcon).scaling(Scaling.fit).padRight(3.0f);
                                l.label(() -> flowItems.getFlowRate(item) < 0.0f ? "..." : Strings.fixed(flowItems.getFlowRate(item), 1) + ps).color(Color.lightGray);
                                l.row();
                            }
                        };
                        rebuild.run();
                        l.update(() -> {
                            for (Item item : Vars.content.items()) {
                                if (!flowItems.hasFlowItem(item) || current.get(item.id)) continue;
                                current.set(item.id);
                                rebuild.run();
                            }
                        });
                    }).left();
                }
                if (this.liquids != null) {
                    table.row();
                    table.left();
                    table.table(l -> {
                        Bits current = new Bits();
                        Runnable rebuild = () -> {
                            l.clearChildren();
                            l.left();
                            for (Liquid liquid : Vars.content.liquids()) {
                                if (!this.liquids.hasFlowLiquid(liquid)) continue;
                                l.image(liquid.uiIcon).scaling(Scaling.fit).size(32.0f).padRight(3.0f);
                                l.label(() -> this.liquids.getFlowRate(liquid) < 0.0f ? "..." : Strings.fixed(this.liquids.getFlowRate(liquid), 1) + ps).color(Color.lightGray);
                                l.row();
                            }
                        };
                        rebuild.run();
                        l.update(() -> {
                            for (Liquid liquid : Vars.content.liquids()) {
                                if (!this.liquids.hasFlowLiquid(liquid) || current.get(liquid.id)) continue;
                                current.set(liquid.id);
                                rebuild.run();
                            }
                        });
                    }).left();
                }
            }
            if (Vars.net.active() && this.lastAccessed != null) {
                table.row();
                table.add(Core.bundle.format("lastaccessed", this.lastAccessed)).growX().wrap().left();
            }
            table.marginBottom(-5.0f);
        }
    }

    public void displayBars(Table table) {
        for (Func<Building, Bar> bar : this.block.listBars()) {
            Bar result = bar.get(this);
            if (result == null) continue;
            table.add(result).growX();
            table.row();
        }
    }

    public void displayConsumption(Table table) {
        table.left();
        for (Consume cons : this.block.consumers) {
            if (cons.optional && cons.booster) continue;
            cons.build(this, table);
        }
    }

    public void draw() {
        if (this.block.variants == 0 || this.block.variantRegions == null) {
            Draw.rect(this.block.region, this.x, this.y, this.drawrot());
        } else {
            Draw.rect(this.block.variantRegions[Mathf.randomSeed((long)this.tile.pos(), 0, Math.max(0, this.block.variantRegions.length - 1))], this.x, this.y, this.drawrot());
        }
        this.drawTeamTop();
    }

    public void drawConfigure() {
        Draw.color(Pal.accent);
        Lines.stroke(1.0f);
        Lines.square(this.x, this.y, (float)(this.block.size * 8) / 2.0f + 1.0f);
        Draw.reset();
    }

    public void drawCracks() {
        if (!this.block.drawCracks || !this.damaged() || this.block.size > 7) {
            return;
        }
        int id = this.pos();
        TextureRegion region = Vars.renderer.blocks.cracks[this.block.size - 1][Mathf.clamp((int)((1.0f - this.healthf()) * 8.0f), 0, 7)];
        Draw.colorl(0.2f, 0.1f + (1.0f - this.healthf()) * 0.6f);
        Draw.rect(region, this.x, this.y, (float)(id % 4 * 90));
        Draw.color();
    }

    public void drawDisabled() {
        Draw.color(Color.scarlet);
        Draw.alpha(0.8f);
        float size = 6.0f;
        Draw.rect(Icon.cancel.getRegion(), this.x, this.y, size, size);
        Draw.reset();
    }

    public void drawItemSelection(UnlockableContent selection) {
        if (selection != null) {
            float dx = this.x - (float)(this.block.size * 8) / 2.0f;
            float dy = this.y + (float)(this.block.size * 8) / 2.0f;
            float s = 6.0f * selection.fullIcon.ratio();
            float h = 6.0f;
            Draw.mixcol(Color.darkGray, 1.0f);
            Draw.rect(selection.fullIcon, dx, dy - 1.0f, s, h);
            Draw.reset();
            Draw.rect(selection.fullIcon, dx, dy, s, h);
        }
    }

    public void drawLight() {
        Liquid liq;
        Liquid liquid = liq = this.block.hasLiquids && this.block.lightLiquid == null ? this.liquids.current() : this.block.lightLiquid;
        if (this.block.hasLiquids && this.block.drawLiquidLight && liq.lightColor.a > 0.001f) {
            this.visualLiquid = Mathf.lerpDelta(this.visualLiquid, this.liquids.get(liq) >= 0.01f ? 1.0f : 0.0f, 0.06f);
            this.drawLiquidLight(liq, this.visualLiquid);
        }
    }

    public void drawLiquidLight(Liquid liquid, float amount) {
        if (amount > 0.01f) {
            Color color = liquid.lightColor;
            float fract = 1.0f;
            float opacity = color.a * fract;
            if (opacity > 0.001f) {
                Drawf.light(this.x, this.y, (float)this.block.size * 30.0f * fract, color, opacity * amount);
            }
        }
    }

    public void drawSelect() {
        this.block.drawOverlay(this.x, this.y, this.rotation);
    }

    public void drawStatus() {
        if (this.block.enableDrawStatus && this.block.consumers.length > 0) {
            float multiplier = this.block.size > 1 ? 1.0f : 0.64f;
            float brcx = this.x + (float)(this.block.size * 8) / 2.0f - 8.0f * multiplier / 2.0f;
            float brcy = this.y - (float)(this.block.size * 8) / 2.0f + 8.0f * multiplier / 2.0f;
            Draw.z(71.0f);
            Draw.color(Pal.gray);
            Fill.square(brcx, brcy, 2.5f * multiplier, 45.0f);
            Draw.color(this.status().color);
            Fill.square(brcx, brcy, 1.5f * multiplier, 45.0f);
            Draw.color();
        }
    }

    public void drawTeam() {
        Draw.color(this.team.color);
        Draw.rect("block-border", this.x - (float)(this.block.size * 8) / 2.0f + 4.0f, this.y - (float)(this.block.size * 8) / 2.0f + 4.0f);
        Draw.color();
    }

    public void drawTeamTop() {
        if (this.block.teamRegion.found()) {
            if (this.block.teamRegions[this.team.id] == this.block.teamRegion) {
                Draw.color(this.team.color);
            }
            Draw.rect(this.block.teamRegions[this.team.id], this.x, this.y);
            Draw.color();
        }
    }

    public void dropped() {
    }

    public void dumpLiquid(Liquid liquid) {
        this.dumpLiquid(liquid, 2.0f);
    }

    public void dumpLiquid(Liquid liquid, float scaling) {
        this.dumpLiquid(liquid, scaling, -1);
    }

    public void dumpLiquid(Liquid liquid, float scaling, int outputDir) {
        int dump = this.cdump;
        if (this.liquids.get(liquid) <= 1.0E-4f) {
            return;
        }
        if (!Vars.net.client() && Vars.state.isCampaign() && this.team == Vars.state.rules.defaultTeam) {
            liquid.unlock();
        }
        for (int i = 0; i < this.proximity.size; ++i) {
            float fract;
            float ofract;
            this.incrementDump(this.proximity.size);
            Building other = this.proximity.get((i + dump) % this.proximity.size);
            if (outputDir != -1 && (outputDir + this.rotation) % 4 != this.relativeTo(other) || (other = other.getLiquidDestination(this, liquid)) == null || !other.block.hasLiquids || !this.canDumpLiquid(other, liquid) || other.liquids == null || !((ofract = other.liquids.get(liquid) / other.block.liquidCapacity) < (fract = this.liquids.get(liquid) / this.block.liquidCapacity))) continue;
            this.transferLiquid(other, (fract - ofract) * this.block.liquidCapacity / scaling, liquid);
        }
    }

    public void eachEdge(Cons<Tile> cons) {
        for (Point2 edge : this.block.getEdges()) {
            Tile other = Vars.world.tile(this.tile.x + edge.x, this.tile.y + edge.y);
            if (other == null) continue;
            cons.get(other);
        }
    }

    public void getStackOffset(Item item, Vec2 trns) {
    }

    public void handleItem(Building source, Item item) {
        this.items.add(item, 1);
    }

    public void handleLiquid(Building source, Liquid liquid, float amount) {
        this.liquids.add(liquid, amount);
    }

    public void handlePayload(Building source, Payload payload) {
    }

    public void handleStack(Item item, int amount, Teamc source) {
        this.noSleep();
        this.items.add(item, amount);
    }

    public void handleString(Object value) {
    }

    public void handleUnitPayload(Unit unit, Cons<Payload> grabber) {
        Fx.spawn.at(unit);
        if (unit.isPlayer()) {
            unit.getPlayer().clearUnit();
        }
        unit.remove();
        if (Vars.net.client()) {
            unit.id = EntityGroup.nextId();
        } else {
            Core.app.post(() -> {
                unit.id = EntityGroup.nextId();
            });
        }
        grabber.get(new UnitPayload(unit));
        Fx.unitDrop.at(unit);
    }

    @Override
    public void heal() {
        this.dead = false;
        this.health = this.maxHealth;
        this.healthChanged();
    }

    @Override
    public void heal(float amount) {
        this.health += amount;
        this.clampHealth();
        this.healthChanged();
    }

    @Override
    public void healFract(float amount) {
        this.heal(amount * this.maxHealth);
    }

    public void healthChanged() {
        if (Vars.net.server()) {
            Vars.netServer.buildHealthUpdate(this);
        }
        Vars.indexer.notifyHealthChanged(this);
    }

    @Override
    public void hitbox(Rect out) {
        out.setCentered(this.x, this.y, this.block.size * 8, this.block.size * 8);
    }

    public void incrementDump(int prox) {
        if (prox != 0) {
            this.cdump = (this.cdump + 1) % prox;
        }
    }

    public void itemTaken(Item item) {
    }

    @Override
    public void kill() {
        Call.buildDestroyed(this);
    }

    @Override
    public void killed() {
        this.dead = true;
        Events.fire(new EventType.BlockDestroyEvent(this.tile));
        this.onDestroyed();
        if (this.tile != Vars.emptyTile) {
            this.tile.remove();
        }
        this.remove();
        this.afterDestroyed();
    }

    public void noSleep() {
        this.sleepTime = 0.0f;
        if (this.sleeping) {
            this.add();
            this.sleeping = false;
            --sleepingEntities;
        }
    }

    public void offload(Item item) {
        this.produced(item, 1);
        int dump = this.cdump;
        for (int i = 0; i < this.proximity.size; ++i) {
            this.incrementDump(this.proximity.size);
            Building other = this.proximity.get((i + dump) % this.proximity.size);
            if (!other.acceptItem(this, item) || !this.canDump(other, item)) continue;
            other.handleItem(this, item);
            return;
        }
        this.handleItem(this, item);
    }

    public void onCommand(Vec2 target) {
    }

    public void onConfigureClosed() {
    }

    public void onControlSelect(Unit player) {
    }

    public void onDeconstructed(Unit builder) {
        if (this.liquids != null && this.liquids.currentAmount() > 0.0f && (!this.liquids.current().incinerable || this.block.deconstructDropAllLiquid)) {
            float perCell = this.liquids.currentAmount() / (float)(this.block.size * this.block.size) * 2.0f;
            this.tile.getLinkedTiles(other -> Puddles.deposit(other, this.liquids.current(), perCell));
        }
    }

    public void onDestroyed() {
        float explosiveness = this.block.baseExplosiveness;
        float flammability = 0.0f;
        float power = 0.0f;
        if (this.block.hasItems) {
            for (Item item : Vars.content.items()) {
                int amount2 = Math.min(this.items.get(item), this.explosionItemCap());
                explosiveness += item.explosiveness * (float)amount2;
                flammability += item.flammability * (float)amount2;
                power += item.charge * Mathf.pow((float)amount2, 1.1f) * 150.0f;
            }
        }
        if (this.block.hasLiquids) {
            flammability += this.liquids.sum((liquid, amount) -> liquid.flammability * amount / 2.0f);
            explosiveness += this.liquids.sum((liquid, amount) -> liquid.explosiveness * amount / 2.0f);
        }
        if (this.block.consPower != null && this.block.consPower.buffered) {
            power += this.power.status * this.block.consPower.capacity;
        }
        if (this.block.hasLiquids && Vars.state.rules.damageExplosions) {
            this.liquids.each(this::splashLiquid);
        }
        Damage.dynamicExplosion(this.x, this.y, flammability * this.block.flammabilityScale, explosiveness * 3.5f * this.block.explosivenessScale, power, (float)(8 * this.block.size) / 2.0f, Vars.state.rules.damageExplosions, this.block.destroyEffect, this.block.baseShake);
        if (this.block.createRubble && !this.floor().solid && !this.floor().isLiquid) {
            Effect.rubble(this.x, this.y, this.block.size);
        }
        if (!Vars.headless) {
            this.playDestroySound();
            if (explosiveness > 40.0f) {
                (Mathf.chance(0.5) ? Sounds.blockExplodeExplosive : Sounds.blockExplodeExplosiveAlt).at(this.tile, Mathf.random(this.block.destroyPitchMin, this.block.destroyPitchMax), this.block.destroySoundVolume);
            } else if (flammability > 5.0f) {
                Sounds.blockExplodeFlammable.at(this.tile, Mathf.random(this.block.destroyPitchMin, this.block.destroyPitchMax), this.block.destroySoundVolume);
            }
            if (power > 30000.0f) {
                Sounds.blockExplodeElectricBig.at(this.tile, Mathf.random(this.block.destroyPitchMin, this.block.destroyPitchMax), this.block.destroySoundVolume);
            } else if (power > 2000.0f) {
                Sounds.blockExplodeElectric.at(this.tile, Mathf.random(this.block.destroyPitchMin, this.block.destroyPitchMax), this.block.destroySoundVolume);
            }
        }
    }

    public void onNearbyBuildAdded(Building other) {
    }

    public void onProximityAdded() {
        if (this.power != null) {
            this.updatePowerGraph();
        }
    }

    public void onProximityRemoved() {
        if (this.power != null) {
            this.powerGraphRemoved();
        }
    }

    public void onProximityUpdate() {
        this.noSleep();
    }

    public void onRemoved() {
    }

    public void overwrote(Seq<Building> previous) {
    }

    public void payloadDraw() {
        if (this.block.isAir()) {
            return;
        }
        this.draw();
    }

    public void pickedUp() {
    }

    public void playDestroySound() {
        this.block.destroySound.at(this.tile, Mathf.random(this.block.destroyPitchMin, this.block.destroyPitchMax), this.block.destroySoundVolume);
    }

    public void powerGraphRemoved() {
        if (this.power == null) {
            return;
        }
        this.power.graph.remove(this);
        for (int i = 0; i < this.power.links.size; ++i) {
            Tile other = Vars.world.tile(this.power.links.get(i));
            if (other == null || other.build == null || other.build.power == null) continue;
            other.build.power.links.removeValue(this.pos());
        }
        this.power.links.clear();
    }

    public void produced(Item item) {
        this.produced(item, 1);
    }

    public void produced(Item item, int amount) {
        if (Vars.state.rules.sector != null && this.team == Vars.state.rules.defaultTeam) {
            Vars.state.rules.sector.info.handleProduction(item, amount);
            if (!Vars.net.client()) {
                item.unlock();
            }
        }
    }

    public void puddleOn(Puddle puddle) {
    }

    @Override
    public void read(Reads read) {
        this.afterRead();
    }

    public void readAll(Reads read, byte revision) {
        this.readBase(read);
        this.read(read, revision);
    }

    public void readBase(Reads read) {
        this.health = Math.min(read.f(), (float)this.block.health);
        byte rot = read.b();
        this.team = Team.get(read.b());
        this.rotation = rot & 0x7F;
        int moduleBits = this.moduleBitmask();
        boolean legacy = true;
        byte version = 0;
        if ((rot & 0x80) != 0) {
            version = read.b();
            if (version >= 1) {
                byte on = read.b();
                boolean bl = this.enabled = on == 1;
            }
            if (version >= 2) {
                moduleBits = read.ub();
            }
            legacy = false;
        }
        if ((moduleBits & 1) != 0) {
            (this.items == null ? new ItemModule() : this.items).read(read, legacy);
        }
        if ((moduleBits & 2) != 0) {
            (this.power == null ? new PowerModule() : this.power).read(read, legacy);
        }
        if ((moduleBits & 4) != 0) {
            (this.liquids == null ? new LiquidModule() : this.liquids).read(read, legacy);
        }
        if ((moduleBits & 0x10) != 0) {
            this.timeScale = read.f();
            this.timeScaleDuration = read.f();
        }
        if ((moduleBits & 0x20) != 0) {
            this.lastDisabler = Vars.world.build(read.i());
        }
        if (version <= 2) {
            read.bool();
        }
        if (version >= 3) {
            this.efficiency = this.potentialEfficiency = (float)read.ub() / 255.0f;
            this.optionalEfficiency = (float)read.ub() / 255.0f;
        }
        if (version == 4) {
            this.visibleFlags = read.l();
        }
    }

    public void readSync(Reads read, byte revision) {
        this.readAll(read, revision);
    }

    public void recentlyHealed() {
        this.lastHealTime = Time.time;
    }

    @Override
    public void remove() {
        if (!this.added) {
            return;
        }
        Groups.all.removeIndex(this, this.index__all);
        this.index__all = -1;
        Groups.build.removeIndex(this, this.index__build);
        this.index__build = -1;
        this.added = false;
    }

    public void removeFromProximity() {
        this.onProximityRemoved();
        tmpTiles.clear();
        Point2[] nearby = Edges.getEdges(this.block.size);
        for (Point2 point : nearby) {
            Building other = Vars.world.build(this.tile.x + point.x, this.tile.y + point.y);
            if (other == null) continue;
            tmpTiles.add(other);
        }
        for (Building other : tmpTiles) {
            other.proximity.remove(this, true);
            other.onProximityUpdate();
        }
        this.proximity.clear();
    }

    @Override
    public void set(Position pos) {
        this.set(pos.getX(), pos.getY());
    }

    @Override
    public void set(float x, float y) {
        this.x = x;
        this.y = y;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setProp(UnlockableContent content, double value) {
        if (content instanceof Item) {
            Item item = (Item)content;
            if (this.items != null) {
                int amount = (int)value;
                if (this.items.get(item) == amount) return;
                if (this.items.get(item) < amount) {
                    this.handleStack(item, this.acceptStack(item, amount - this.items.get(item), null), null);
                    return;
                }
                if (amount < 0) return;
                this.removeStack(item, this.items.get(item) - amount);
                return;
            }
        }
        if (!(content instanceof Liquid)) return;
        Liquid liquid = (Liquid)content;
        if (this.liquids == null) return;
        float amount = Mathf.clamp((float)value, 0.0f, this.block.liquidCapacity);
        if (!(amount < this.liquids.get(liquid))) {
            if (!this.acceptLiquid(this, liquid)) return;
            if (this.liquids.current() != liquid && !(this.liquids.currentAmount() <= 0.1f)) {
                if (!this.block.consumesLiquid(liquid)) return;
            }
        }
        this.liquids.set(liquid, amount);
    }

    @Override
    public void setProp(LAccess prop, double value) {
        switch (prop) {
            case health: {
                this.health = (float)Mathf.clamp(value, 0.0, (double)this.maxHealth);
                if (this.health <= 0.0f && !this.dead()) {
                    Call.buildDestroyed(this);
                    break;
                }
                this.healthChanged();
                break;
            }
            case team: {
                Team team = Team.get((int)value);
                if (this.team == team) break;
                this.changeTeam(team);
                break;
            }
            case totalPower: {
                if (this.power == null || this.block.consPower == null || !this.block.consPower.buffered) break;
                this.power.status = Mathf.clamp((float)(value / (double)this.block.consPower.capacity));
            }
        }
    }

    @Override
    public void setProp(LAccess prop, Object value) {
        switch (prop) {
            case team: {
                Team team;
                if (!(value instanceof Team) || this.team == (team = (Team)value)) break;
                this.changeTeam(team);
            }
        }
    }

    public void sleep() {
        this.sleepTime += Time.delta;
        if (!this.sleeping && this.sleepTime >= 60.0f) {
            this.remove();
            this.sleeping = true;
            ++sleepingEntities;
        }
    }

    public void splashLiquid(Liquid liquid, float amount) {
        float splash = Mathf.clamp(amount / 4.0f, 0.0f, 10.0f);
        int i = 0;
        while ((float)i < Mathf.clamp(amount / 5.0f, 0.0f, 30.0f)) {
            Time.run((float)i / 2.0f, () -> {
                Tile other = Vars.world.tileWorld(this.x + (float)Mathf.range(this.block.size * 8 / 2), this.y + (float)Mathf.range(this.block.size * 8 / 2));
                if (other != null) {
                    Puddles.deposit(other, liquid, splash);
                }
            });
            ++i;
        }
    }

    public void tapped() {
    }

    public void transferLiquid(Building next, float amount, Liquid liquid) {
        float flow = Math.min(next.block.liquidCapacity - next.liquids.get(liquid), amount);
        if (next.acceptLiquid(this, liquid)) {
            next.handleLiquid(this, liquid, flow);
            this.liquids.remove(liquid, flow);
        }
    }

    @Override
    public void trns(Position pos) {
        this.trns(pos.getX(), pos.getY());
    }

    @Override
    public void trns(float x, float y) {
        this.set(this.x + x, this.y + y);
    }

    public void unitOn(Unit unit) {
    }

    public void unitOnAny(Unit unit) {
    }

    public void unitRemoved(Unit unit) {
    }

    @Override
    public void update() {
        if ((this.timeScaleDuration -= Time.delta) <= 0.0f || !this.block.canOverdrive) {
            this.timeScale = 1.0f;
        }
        if (!Vars.headless && this.block.ambientSound != Sounds.none && this.shouldAmbientSound()) {
            Vars.control.sound.loop(this.block.ambientSound, this, this.block.ambientSoundVolume * this.ambientVolume());
        }
        this.updateConsumption();
        if (this.enabled || !this.block.noUpdateDisabled) {
            this.updateTile();
        }
    }

    public void updateConsumption() {
        if (!this.block.hasConsumers || this.cheating()) {
            this.potentialEfficiency = this.enabled && this.productionValid() ? 1.0f : 0.0f;
            this.optionalEfficiency = this.shouldConsume() ? this.potentialEfficiency : 0.0f;
            this.efficiency = this.optionalEfficiency;
            this.shouldConsumePower = true;
            this.updateEfficiencyMultiplier();
            return;
        }
        if (!this.enabled) {
            this.optionalEfficiency = 0.0f;
            this.efficiency = 0.0f;
            this.potentialEfficiency = 0.0f;
            this.shouldConsumePower = false;
            return;
        }
        boolean update = this.shouldConsume() && this.productionValid();
        float minEfficiency = 1.0f;
        this.optionalEfficiency = 1.0f;
        this.efficiency = 1.0f;
        this.shouldConsumePower = true;
        for (Consume cons : this.block.nonOptionalConsumers) {
            float result = cons.efficiency(this);
            if (cons != this.block.consPower && result <= 1.0E-7f) {
                this.shouldConsumePower = false;
            }
            minEfficiency = Math.min(minEfficiency, result);
        }
        for (Consume cons : this.block.optionalConsumers) {
            this.optionalEfficiency = Math.min(this.optionalEfficiency, cons.efficiency(this));
        }
        this.efficiency = minEfficiency;
        this.optionalEfficiency = Math.min(this.optionalEfficiency, minEfficiency);
        this.potentialEfficiency = this.efficiency;
        if (!update) {
            this.optionalEfficiency = 0.0f;
            this.efficiency = 0.0f;
        }
        this.updateEfficiencyMultiplier();
        if (update && this.efficiency > 0.0f) {
            for (Consume cons : this.block.updateConsumers) {
                cons.update(this);
            }
        }
    }

    public void updateEfficiencyMultiplier() {
        float scale = this.efficiencyScale();
        this.efficiency *= scale;
        this.optionalEfficiency *= scale;
    }

    public void updateFogVisibility() {
        if (!this.wasVisible && !this.inFogTo(Vars.player.team())) {
            this.visibleFlags |= 1L << Vars.player.team().id;
            this.wasVisible = true;
            Vars.renderer.blocks.updateShadow(this);
            Vars.renderer.minimap.update(this.tile);
        }
    }

    public void updateLastAccess(Player player) {
        this.lastAccessed = player.coloredName();
    }

    public void updatePayload(Unit unitHolder, Building buildingHolder) {
        this.update();
    }

    public void updatePowerGraph() {
        for (Building other : this.getPowerConnections(tempBuilds)) {
            if (other.power == null) continue;
            other.power.graph.addGraph(this.power.graph);
        }
    }

    public void updateProximity() {
        tmpTiles.clear();
        this.proximity.clear();
        Point2[] nearby = Edges.getEdges(this.block.size);
        for (Point2 point : nearby) {
            Building other = Vars.world.build(this.tile.x + point.x, this.tile.y + point.y);
            if (other == null || other.team != this.team) continue;
            other.proximity.addUnique(this);
            tmpTiles.add(other);
        }
        for (Building tile : tmpTiles) {
            this.proximity.add(tile);
        }
        this.onProximityAdded();
        this.onProximityUpdate();
        for (Building other : tmpTiles) {
            other.onProximityUpdate();
        }
    }

    public void updateTableAlign(Table table) {
        Vec2 pos = Core.input.mouseScreen(this.x, this.y - (float)(this.block.size * 8) / 2.0f - 1.0f);
        table.setPosition(pos.x, pos.y, 2);
    }

    public void updateTile() {
    }

    public void writeAll(Writes write) {
        this.writeBase(write);
        this.write(write);
    }

    public void writeBase(Writes write) {
        boolean writeVisibility = Vars.state.rules.fog && this.visibleFlags != 0L;
        write.f(this.health);
        write.b(this.rotation | 0x80);
        write.b(this.team.id);
        write.b(writeVisibility ? 4 : 3);
        write.b(this.enabled ? 1 : 0);
        write.b(this.moduleBitmask());
        if (this.items != null) {
            this.items.write(write);
        }
        if (this.power != null) {
            this.power.write(write);
        }
        if (this.liquids != null) {
            this.liquids.write(write);
        }
        if (this.timeScale != 1.0f) {
            write.f(this.timeScale);
            write.f(this.timeScaleDuration);
        }
        if (this.lastDisabler != null && this.lastDisabler.isValid()) {
            write.i(this.lastDisabler.pos());
        }
        write.b((byte)(Mathf.clamp(this.efficiency) * 255.0f));
        write.b((byte)(Mathf.clamp(this.optionalEfficiency) * 255.0f));
        if (writeVisibility) {
            write.l(this.visibleFlags);
        }
    }

    public void writeSync(Writes write) {
        this.writeAll(write);
    }
}

