/*
 * Decompiled with CFR 0.152.
 */
package mindustry.graphics;

import arc.files.Fi;
import arc.util.Log;
import arc.util.OS;
import java.util.Locale;

public class IntelGpuCheck {
    private static boolean wasIntel;
    private static boolean checkedLastLaunch;

    public static void init(String vendor) {
        if (!OS.isWindows) {
            return;
        }
        boolean isIntel = vendor.toLowerCase(Locale.ROOT).contains("intel");
        try {
            Fi file = new Fi(OS.getAppDataDirectoryString("Mindustry")).child("was_intel_gpu");
            if (isIntel) {
                file.writeString("1");
            } else if (file.exists()) {
                file.delete();
            }
        }
        catch (Throwable e) {
            Log.err(e);
        }
    }

    public static boolean wasIntel() {
        if (!OS.isWindows) {
            return false;
        }
        if (checkedLastLaunch) {
            return wasIntel;
        }
        checkedLastLaunch = true;
        try {
            Fi file = new Fi(OS.getAppDataDirectoryString("Mindustry")).child("was_intel_gpu");
            if (file.exists() && file.readString().equals("1")) {
                wasIntel = true;
                return true;
            }
        }
        catch (Throwable e) {
            Log.err("Failed to check whether the last launch used an intel GPU.", e);
        }
        wasIntel = false;
        return false;
    }
}

