/*
 * Decompiled with CFR 0.152.
 */
package mindustry.graphics;

import arc.Core;
import arc.Events;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.math.Angles;
import arc.math.Mathf;
import arc.math.geom.Rect;
import arc.math.geom.Vec2;
import arc.struct.Seq;
import arc.util.Nullable;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.ai.types.LogicAI;
import mindustry.entities.Sized;
import mindustry.game.EventType;
import mindustry.game.Team;
import mindustry.game.Teams;
import mindustry.gen.BlockUnitc;
import mindustry.gen.Building;
import mindustry.gen.Groups;
import mindustry.gen.Player;
import mindustry.gen.Unit;
import mindustry.gen.Unitc;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.graphics.Voronoi;
import mindustry.input.Binding;
import mindustry.input.InputHandler;
import mindustry.world.Tile;
import mindustry.world.blocks.storage.CoreBlock;

public class OverlayRenderer {
    private static final float indicatorLength = 14.0f;
    private static final float spawnerMargin = 88.0f;
    private static final Rect rect = new Rect();
    private float buildFade;
    private float unitFade;
    private Sized lastSelect;
    private Seq<CoreEdge> cedges = new Seq();
    private boolean updatedCores;

    public OverlayRenderer() {
        Events.on(EventType.WorldLoadEvent.class, e -> {
            this.updatedCores = true;
        });
        Events.on(EventType.CoreChangeEvent.class, e -> {
            this.updatedCores = true;
        });
    }

    private void updateCoreEdges() {
        if (!this.updatedCores) {
            return;
        }
        this.updatedCores = false;
        this.cedges.clear();
        Seq<Vec2> pos = new Seq<Vec2>();
        Seq<CoreBlock.CoreBuild> teams = new Seq<CoreBlock.CoreBuild>();
        for (Teams.TeamData data : Vars.state.teams.active) {
            if (!data.team.rules().protectCores) continue;
            for (CoreBlock.CoreBuild b : data.cores) {
                teams.add(b);
                pos.add(new Vec2(b.x, b.y));
            }
        }
        if (pos.isEmpty()) {
            return;
        }
        Seq<Voronoi.GraphEdge> result = Voronoi.generate((Vec2[])pos.toArray(Vec2.class), 0.0f, Vars.world.unitWidth(), 0.0f, Vars.world.unitHeight());
        for (Voronoi.GraphEdge edge : result) {
            this.cedges.add(new CoreEdge(edge.x1, edge.y1, edge.x2, edge.y2, ((CoreBlock.CoreBuild)teams.get((int)edge.site1)).team, ((CoreBlock.CoreBuild)teams.get((int)edge.site2)).team));
        }
    }

    public void drawBottom() {
        InputHandler input = Vars.control.input;
        if (Vars.player.dead()) {
            return;
        }
        if (Vars.player.isBuilder()) {
            Vars.player.unit().drawBuildPlans();
        }
        input.drawBottom();
    }

    public void drawTop() {
        Building build;
        Unit unit2;
        Object region;
        Building build2;
        Unitc u;
        InputHandler input;
        Sized select;
        if (!Vars.player.dead() && Vars.ui.hudfrag.shown) {
            if (Core.settings.getBool("playerindicators")) {
                for (Player player : Groups.player) {
                    if (Vars.player == player || Vars.player.team() != player.team() || rect.setSize(Core.camera.width * 0.9f, Core.camera.height * 0.9f).setCenter(Core.camera.position.x, Core.camera.position.y).contains(player.x, player.y)) continue;
                    Tmp.v1.set(player).sub(Vars.player).setLength(14.0f);
                    Lines.stroke(2.0f, Vars.player.team().color);
                    Lines.lineAngle(Vars.player.x + Tmp.v1.x, Vars.player.y + Tmp.v1.y, Tmp.v1.angle(), 4.0f);
                    Draw.reset();
                }
            }
            if (Core.settings.getBool("indicators") && !Vars.state.rules.fog) {
                Groups.unit.each(unit -> {
                    if (!unit.isLocal() && unit.team != Vars.player.team() && !rect.setSize(Core.camera.width * 0.9f, Core.camera.height * 0.9f).setCenter(Core.camera.position.x, Core.camera.position.y).contains(unit.x, unit.y)) {
                        Tmp.v1.set(unit.x, unit.y).sub(Vars.player).setLength(14.0f);
                        Lines.stroke(1.0f, unit.team().color);
                        Lines.lineAngle(Vars.player.x + Tmp.v1.x, Vars.player.y + Tmp.v1.y, Tmp.v1.angle(), 3.0f);
                        Draw.reset();
                    }
                });
            }
        }
        if ((select = (input = Vars.control.input).selectedUnit()) == null) {
            select = input.selectedControlBuild();
        }
        if (!Core.input.keyDown(Binding.control) || !Vars.state.rules.possessionAllowed) {
            select = null;
        }
        this.unitFade = Mathf.lerpDelta(this.unitFade, Mathf.num(select != null), 0.1f);
        if (select != null) {
            this.lastSelect = select;
        }
        if (select == null) {
            select = this.lastSelect;
        }
        if (select != null && (!(select instanceof Unitc) || (u = (Unitc)select).isAI())) {
            Building building;
            Draw.mixcol(Pal.accent, 1.0f);
            Draw.alpha(this.unitFade);
            if (select instanceof BlockUnitc) {
                BlockUnitc b = (BlockUnitc)select;
                building = b.tile();
            } else {
                Building b;
                building = select instanceof Building ? (b = (Building)select) : null;
            }
            build2 = building;
            Object object = region = build2 != null ? build2.block.fullIcon : Core.atlas.white();
            if (select instanceof BlockUnitc) {
                Draw.rect((TextureRegion)region, select.getX(), select.getY());
            }
            for (int i = 0; i < 4; ++i) {
                float rot = (float)i * 90.0f + 45.0f + -Time.time % 360.0f;
                float length = select.hitSize() * 1.5f + this.unitFade * 2.5f;
                Draw.rect("select-arrow", select.getX() + Angles.trnsx(rot, length), select.getY() + Angles.trnsy(rot, length), length / 1.9f, length / 1.9f, rot - 135.0f);
            }
            Draw.reset();
        }
        if (input.config.isShown()) {
            Building tile = input.config.getSelected();
            tile.drawConfigure();
        }
        if (!Vars.player.dead()) {
            input.drawTop();
        }
        input.drawUnitSelection();
        if (Vars.player.dead()) {
            return;
        }
        this.buildFade = Mathf.lerpDelta(this.buildFade, input.isPlacing() || input.isUsingSchematic() ? 1.0f : 0.0f, 0.06f);
        Draw.reset();
        Lines.stroke(this.buildFade * 2.0f);
        if (this.buildFade > 0.005f) {
            if (Vars.state.rules.polygonCoreProtection) {
                this.updateCoreEdges();
                Draw.color(Pal.accent);
                for (int i = 0; i < 2; ++i) {
                    float offset = i == 0 ? -2.0f : 0.0f;
                    for (CoreEdge edge : this.cedges) {
                        Team displayed = edge.displayed();
                        if (displayed == null) continue;
                        Draw.color(i == 0 ? Color.darkGray : Tmp.c1.set(displayed.color).lerp(Pal.accent, Mathf.absin(Time.time, 10.0f, 0.2f)));
                        Lines.line(edge.x1, edge.y1 + offset, edge.x2, edge.y2 + offset);
                    }
                }
                Draw.color();
            } else {
                Vars.state.teams.eachEnemyCore(Vars.player.team(), core -> {
                    float br = Vars.state.rules.buildRadius(core.team);
                    if (br > 0.0f && Core.camera.bounds(Tmp.r1).overlaps(Tmp.r2.setCentered(core.x, core.y, br * 2.0f))) {
                        Draw.color(Color.darkGray);
                        Lines.circle(core.x, core.y - 2.0f, br);
                        Draw.color(Pal.accent, core.team.color, 0.5f + Mathf.absin(Time.time, 10.0f, 0.5f));
                        Lines.circle(core.x, core.y, br);
                    }
                });
            }
        }
        Lines.stroke(2.0f);
        Draw.color(Color.gray, Color.lightGray, Mathf.absin(Time.time, 8.0f, 1.0f));
        if (Vars.state.hasSpawns()) {
            for (Tile tile : Vars.spawner.getSpawns()) {
                if (!tile.within(Vars.player.x, Vars.player.y, Vars.state.rules.dropZoneRadius + 88.0f)) continue;
                Draw.alpha(Mathf.clamp(1.0f - (Vars.player.dst(tile) - Vars.state.rules.dropZoneRadius) / 88.0f));
                Lines.dashCircle(tile.worldx(), tile.worldy(), Vars.state.rules.dropZoneRadius);
            }
        }
        Draw.reset();
        if (input.block == null && !Core.scene.hasMouse()) {
            Vec2 vec = Core.input.mouseWorld(input.getMouseX(), input.getMouseY());
            build2 = Vars.world.buildWorld(vec.x, vec.y);
            if (build2 != null && build2.team == Vars.player.team()) {
                build2.drawSelect();
                if (!build2.enabled && build2.block.drawDisabled) {
                    build2.drawDisabled();
                }
                if (Core.input.keyDown(Binding.rotatePlaced) && build2.block.rotate && build2.block.quickRotate && build2.interactable(Vars.player.team())) {
                    Vars.control.input.drawArrow(build2.block, build2.tileX(), build2.tileY(), build2.rotation, true);
                    Draw.color(Pal.accent, 0.3f + Mathf.absin(4.0f, 0.2f));
                    Fill.square(build2.x, build2.y, (float)(build2.block.size * 8) / 2.0f);
                    Draw.color();
                }
            }
        }
        input.drawOverSelect();
        region = Vars.ui.hudfrag.blockfrag.hover();
        if (region instanceof Unit && (region = (unit2 = (Unit)region).controller()) instanceof LogicAI) {
            LogicAI ai = (LogicAI)region;
            if (ai.controller != null && ai.controller.isValid() && (Vars.state.isEditor() || !ai.controller.block.privileged)) {
                build = ai.controller;
                Drawf.square(build.x, build.y, (float)(build.block.size * 8) / 2.0f + 2.0f);
                if (!unit2.within(build, unit2.hitSize * 2.0f)) {
                    Drawf.arrow(unit2.x, unit2.y, build.x, build.y, unit2.hitSize * 2.0f, 4.0f);
                }
            }
        }
        if (input.isDroppingItem()) {
            Vec2 v = Core.input.mouseWorld(input.getMouseX(), input.getMouseY());
            float size = 8.0f;
            Draw.rect(Vars.player.unit().item().fullIcon, v.x, v.y, size, size);
            Draw.color(Pal.accent);
            Lines.circle(v.x, v.y, 6.0f + Mathf.absin(Time.time, 5.0f, 1.0f));
            Draw.reset();
            build = Vars.world.buildWorld(v.x, v.y);
            if (input.canDropItem() && build != null && build.interactable(Vars.player.team()) && build.acceptStack(Vars.player.unit().item(), Vars.player.unit().stack.amount, Vars.player.unit()) > 0 && Vars.player.within(build, 220.0f) && input.itemDepositCooldown <= 0.0f) {
                boolean invalid = !build.allowDeposit();
                Lines.stroke(3.0f, Pal.gray);
                Lines.square(build.x, build.y, (float)(build.block.size * 8) / 2.0f + 3.0f + Mathf.absin(Time.time, 5.0f, 1.0f));
                Lines.stroke(1.0f, invalid ? Pal.remove : Pal.place);
                Lines.square(build.x, build.y, (float)(build.block.size * 8) / 2.0f + 2.0f + Mathf.absin(Time.time, 5.0f, 1.0f));
                Draw.reset();
                if (invalid) {
                    build.block.drawPlaceText(Core.bundle.get("bar.onlycoredeposit"), build.tileX(), build.tileY(), false);
                }
            }
        }
    }

    public void checkApplySelection(Unit u) {
        if (this.unitFade > 0.001f && this.lastSelect == u) {
            Color prev = Draw.getMixColor();
            Draw.mixcol(prev.a > 0.001f ? prev.lerp(Pal.accent, this.unitFade) : Pal.accent, Math.max(this.unitFade, prev.a));
        }
    }

    private static class CoreEdge {
        float x1;
        float y1;
        float x2;
        float y2;
        Team t1;
        Team t2;

        public CoreEdge(float x1, float y1, float x2, float y2, Team t1, Team t2) {
            this.x1 = x1;
            this.y1 = y1;
            this.x2 = x2;
            this.y2 = y2;
            this.t1 = t1;
            this.t2 = t2;
        }

        @Nullable
        Team displayed() {
            return this.t1 == this.t2 ? null : (this.t1 == Vars.player.team() ? this.t2 : (this.t2 == Vars.player.team() ? this.t1 : (this.t2.id == 0 ? this.t1 : (this.t1.id < this.t2.id && this.t1.id != 0 ? this.t1 : this.t2))));
        }
    }
}

